/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-23 14:34:59 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `CWP_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6157 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=47600 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=18289 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_ctf_feeds_posts` (
  `record_id` int unsigned NOT NULL AUTO_INCREMENT,
  `id` int unsigned NOT NULL,
  `feed_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`record_id`),
  KEY `feed_id` (`feed_id`(100)),
  KEY `type_term` (`term`(140),`type`(51))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_ctf_posts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `twitter_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_on` datetime DEFAULT NULL,
  `last_requested` date DEFAULT NULL,
  `time_stamp` datetime DEFAULT NULL,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sizes` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `aspect_ratio` decimal(4,2) NOT NULL DEFAULT '0.00',
  `images_done` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_e_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint unsigned DEFAULT NULL,
  `element_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_e_notes_users_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_elfsight_whatsapp_chat_widgets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `time_created` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `time_updated` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `active` int NOT NULL DEFAULT '1',
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_layerslider` (
  `id` int NOT NULL AUTO_INCREMENT,
  `author` int NOT NULL DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int NOT NULL,
  `date_m` int NOT NULL,
  `schedule_start` int NOT NULL DEFAULT '0',
  `schedule_end` int NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `flag_popup` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_layerslider_revisions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `author` int NOT NULL DEFAULT '0',
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=109142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=23438 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=6131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_revslider_backup_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slide_id` int NOT NULL,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  `created` datetime NOT NULL,
  `session` varchar(100) NOT NULL,
  `static` varchar(20) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` longtext NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_css_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` longtext NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_layer_animations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_navigations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_sliders_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_revslider_static_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `CWP_sbi_feed_caches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cache_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cache_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cron_update` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_sbi_feeds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `feed_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `author` bigint unsigned NOT NULL DEFAULT '1',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_sbi_instagram_feed_locator` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) NOT NULL DEFAULT '',
  `post_id` bigint unsigned NOT NULL,
  `html_location` varchar(50) NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `CWP_sbi_instagram_feeds_posts` (
  `record_id` int unsigned NOT NULL AUTO_INCREMENT,
  `id` int unsigned NOT NULL,
  `instagram_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `feed_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `hashtag` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`record_id`),
  KEY `hashtag` (`hashtag`(191)),
  KEY `feed_id` (`feed_id`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_sbi_instagram_posts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `instagram_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `time_stamp` datetime DEFAULT NULL,
  `top_time_stamp` datetime DEFAULT NULL,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sizes` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `aspect_ratio` decimal(4,2) NOT NULL DEFAULT '0.00',
  `images_done` tinyint(1) NOT NULL DEFAULT '0',
  `last_requested` date DEFAULT NULL,
  `mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_sbi_sources` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `account_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `privilege` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `access_token` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expires` datetime NOT NULL,
  `last_updated` datetime NOT NULL,
  `author` bigint unsigned NOT NULL DEFAULT '1',
  `connect_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account_type` (`account_type`(191)),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_transbank_inscriptions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint DEFAULT NULL,
  `token_id` bigint DEFAULT NULL,
  `order_id` bigint DEFAULT NULL,
  `pay_after_inscription` tinyint(1) DEFAULT '0',
  `finished` tinyint(1) NOT NULL DEFAULT '0',
  `response_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorization_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `environment` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commerce_code` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transbank_response` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_tutor_coupon_applications` (
  `coupon_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  KEY `coupon_code` (`coupon_code`),
  KEY `reference_id` (`reference_id`),
  CONSTRAINT `fk_tutor_coupon_application_coupon_code` FOREIGN KEY (`coupon_code`) REFERENCES `CWP_tutor_coupons` (`coupon_code`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `coupon_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `coupon_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'code',
  `coupon_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `coupon_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `coupon_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `discount_type` enum('percentage','flat') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `discount_amount` decimal(13,2) NOT NULL,
  `applies_to` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'all_courses_and_bundles',
  `total_usage_limit` int unsigned DEFAULT NULL,
  `per_user_usage_limit` tinyint unsigned DEFAULT NULL,
  `purchase_requirement` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'no_minimum',
  `purchase_requirement_value` decimal(13,2) DEFAULT NULL,
  `start_date_gmt` datetime NOT NULL,
  `expire_date_gmt` datetime DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_at_gmt` datetime DEFAULT NULL,
  `updated_by` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coupon_code` (`coupon_code`),
  KEY `start_date_gmt` (`start_date_gmt`),
  KEY `expire_date_gmt` (`expire_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `billing_first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_zip_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `billing_city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `billing_email` (`billing_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_earnings` (
  `earning_id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `course_id` bigint DEFAULT NULL,
  `order_id` bigint DEFAULT NULL,
  `order_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `course_price_total` decimal(16,2) DEFAULT NULL,
  `course_price_grand_total` decimal(16,2) DEFAULT NULL,
  `instructor_amount` decimal(16,2) DEFAULT NULL,
  `instructor_rate` decimal(16,2) DEFAULT NULL,
  `admin_amount` decimal(16,2) DEFAULT NULL,
  `admin_rate` decimal(16,2) DEFAULT NULL,
  `commission_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deduct_fees_amount` decimal(16,2) DEFAULT NULL,
  `deduct_fees_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deduct_fees_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `process_by` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`earning_id`),
  KEY `user_id` (`user_id`),
  KEY `course_id` (`course_id`),
  KEY `order_id` (`order_id`),
  KEY `process_by` (`process_by`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_order_itemmeta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `meta_key` (`meta_key`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_order_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `item_id` bigint unsigned NOT NULL,
  `regular_price` decimal(13,2) NOT NULL,
  `sale_price` varchar(13) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `discount_price` varchar(13) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `coupon_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `fk_tutor_order_item_order_id` FOREIGN KEY (`order_id`) REFERENCES `CWP_tutor_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_ordermeta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at_gmt` datetime NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_at_gmt` datetime DEFAULT NULL,
  `updated_by` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `meta_key` (`meta_key`),
  CONSTRAINT `fk_tutor_ordermeta_order_id` FOREIGN KEY (`order_id`) REFERENCES `CWP_tutor_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned DEFAULT '0',
  `transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Transaction id from payment gateway',
  `user_id` bigint unsigned NOT NULL,
  `order_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `subtotal_price` decimal(13,2) NOT NULL,
  `pre_tax_price` decimal(13,2) NOT NULL,
  `total_price` decimal(13,2) NOT NULL,
  `net_payment` decimal(13,2) NOT NULL,
  `coupon_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `coupon_amount` decimal(13,2) DEFAULT NULL,
  `discount_type` enum('percentage','flat') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `discount_amount` decimal(13,2) DEFAULT NULL,
  `discount_reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_rate` decimal(13,2) DEFAULT NULL COMMENT 'Tax percentage',
  `tax_amount` decimal(13,2) DEFAULT NULL,
  `fees` decimal(13,2) DEFAULT NULL,
  `earnings` decimal(13,2) DEFAULT NULL,
  `refund_amount` decimal(13,2) DEFAULT NULL,
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_payloads` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_at_gmt` datetime DEFAULT NULL,
  `updated_by` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `order_type` (`order_type`),
  KEY `payment_status` (`payment_status`),
  KEY `order_status` (`order_status`),
  KEY `transaction_id` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_quiz_attempt_answers` (
  `attempt_answer_id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `quiz_id` bigint DEFAULT NULL,
  `question_id` bigint DEFAULT NULL,
  `quiz_attempt_id` bigint DEFAULT NULL,
  `given_answer` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `question_mark` decimal(8,2) DEFAULT NULL,
  `achieved_mark` decimal(8,2) DEFAULT NULL,
  `minus_mark` decimal(8,2) DEFAULT NULL,
  `is_correct` tinyint DEFAULT NULL,
  PRIMARY KEY (`attempt_answer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_quiz_attempts` (
  `attempt_id` bigint NOT NULL AUTO_INCREMENT,
  `course_id` bigint DEFAULT NULL,
  `quiz_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `total_questions` int DEFAULT NULL,
  `total_answered_questions` int DEFAULT NULL,
  `total_marks` decimal(9,2) DEFAULT NULL,
  `earned_marks` decimal(9,2) DEFAULT NULL,
  `attempt_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `attempt_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attempt_ip` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attempt_started_at` datetime DEFAULT NULL,
  `attempt_ended_at` datetime DEFAULT NULL,
  `is_manually_reviewed` int DEFAULT NULL,
  `manually_reviewed_at` datetime DEFAULT NULL,
  `result` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`attempt_id`),
  KEY `course_id` (`course_id`),
  KEY `quiz_id` (`quiz_id`),
  KEY `user_id` (`user_id`),
  KEY `result` (`result`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_quiz_question_answers` (
  `answer_id` bigint NOT NULL AUTO_INCREMENT,
  `belongs_question_id` bigint DEFAULT NULL,
  `belongs_question_type` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `answer_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `is_correct` tinyint DEFAULT NULL,
  `image_id` bigint DEFAULT NULL,
  `answer_two_gap_match` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `answer_view_format` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `answer_settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `answer_order` int DEFAULT '0',
  PRIMARY KEY (`answer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=243 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_quiz_questions` (
  `question_id` bigint NOT NULL AUTO_INCREMENT,
  `content_id` bigint unsigned DEFAULT NULL,
  `quiz_id` bigint DEFAULT NULL,
  `question_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `question_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `answer_explanation` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `question_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `question_mark` decimal(9,2) DEFAULT NULL,
  `question_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `question_order` int DEFAULT NULL,
  PRIMARY KEY (`question_id`),
  KEY `content_id` (`content_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_tutor_withdraws` (
  `withdraw_id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `method_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`withdraw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=897 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=60219 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `CWP_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=4540 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfconfig` (
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wffilechanges` (
  `filenameHash` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `file` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `md5` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `real_path` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `referer` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `UA` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `action` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `actionDescription` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `actionData` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=8389 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `host` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `path` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `ignoreC` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `shortMsg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `longMsg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=3177 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `wordpress_path` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16959 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '',
  `region` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '',
  `countryName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '',
  `countryCode` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfls_settings` (
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfnotifications` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `links` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `ignoreC` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `shortMsg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `longMsg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `CWP_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=4671 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `msg` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=75782 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `CWP_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=320 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=MyISAM AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `permalink_hash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `breadcrumb_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `primary_focus_keyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `twitter_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `twitter_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `twitter_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `open_graph_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `open_graph_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `open_graph_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `open_graph_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `open_graph_image_meta` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_page_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_article_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `CWP_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `CWP_yoast_prominent_words` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `stem` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `weight` float DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stem` (`stem`),
  KEY `indexable_id` (`indexable_id`),
  KEY `indexable_id_and_stem` (`indexable_id`,`stem`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `CWP_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `CWP_yoast_seo_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT NULL,
  `incoming_link_count` int unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: CWP_actionscheduler_actions */
INSERT INTO `CWP_actionscheduler_actions` VALUES("196", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-03-29 15:50:09", "2023-03-29 15:50:09", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680105009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680105009;}", "7", "1", "2023-03-29 15:51:32", "2023-03-29 11:51:32", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("197", "action_scheduler/migration_hook", "failed", "2023-03-29 15:52:33", "2023-03-29 15:52:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680105153;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680105153;}", "1", "1", "2023-03-29 15:52:37", "2023-03-29 11:52:37", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("229", "action_scheduler/migration_hook", "failed", "2024-04-18 16:12:09", "2024-04-18 16:12:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1713456729;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1713456729;}", "1", "1", "2024-04-18 16:12:32", "2024-04-18 12:12:32", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("4948", "woocommerce_geoip_updater", "complete", "2026-01-03 14:12:13", "2026-01-03 14:12:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767449533;s:18:\"\0*\0first_timestamp\";i:1755776236;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767449533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "12", "1", "2026-01-03 14:16:21", "2026-01-03 10:16:21", "43350", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5045", "woocommerce_cleanup_draft_orders", "complete", "2025-12-23 15:34:39", "2025-12-23 15:34:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766504079;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766504079;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-23 15:34:50", "2025-12-23 11:34:50", "40684", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5046", "woocommerce_scheduled_sales", "complete", "2025-12-23 15:34:39", "2025-12-23 15:34:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766504079;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766504079;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-23 15:34:50", "2025-12-23 11:34:50", "40684", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5062", "wc_admin_daily_wrapper", "complete", "2025-12-24 05:48:54", "2025-12-24 05:48:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766555334;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766555334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-24 05:49:29", "2025-12-24 01:49:29", "40790", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5063", "woocommerce_cleanup_personal_data", "complete", "2025-12-24 05:48:55", "2025-12-24 05:48:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766555335;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766555335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-24 05:49:30", "2025-12-24 01:49:30", "40790", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5064", "woocommerce_cleanup_logs", "complete", "2025-12-24 05:48:55", "2025-12-24 05:48:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766555335;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766555335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-24 05:49:30", "2025-12-24 01:49:30", "40790", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5065", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-24 05:48:55", "2025-12-24 05:48:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766555335;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766555335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-24 05:49:30", "2025-12-24 01:49:30", "40790", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5068", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-24 05:48:55", "2025-12-24 05:48:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766555335;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766555335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-24 05:49:30", "2025-12-24 01:49:30", "40790", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5074", "woocommerce_refresh_order_count_cache", "complete", "2025-12-24 01:45:37", "2025-12-24 01:45:37", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766540737;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766540737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-24 01:46:32", "2025-12-23 21:46:32", "40748", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5075", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-23 14:45:37", "2025-12-23 14:45:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766501137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766501137;}", "12", "1", "2025-12-23 15:16:19", "2025-12-23 11:16:19", "40676", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5076", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-23 16:16:19", "2025-12-23 16:16:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766506579;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766506579;}", "12", "1", "2025-12-23 17:46:34", "2025-12-23 13:46:34", "40698", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5077", "woocommerce_cleanup_draft_orders", "complete", "2025-12-24 15:34:50", "2025-12-24 15:34:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766590490;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766590490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-24 15:35:43", "2025-12-24 11:35:43", "40939", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5078", "woocommerce_scheduled_sales", "complete", "2025-12-24 15:34:50", "2025-12-24 15:34:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766590490;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766590490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-24 15:35:44", "2025-12-24 11:35:44", "40939", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5079", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-23 18:46:34", "2025-12-23 18:46:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766515594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766515594;}", "12", "1", "2025-12-23 19:08:28", "2025-12-23 15:08:28", "40709", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5080", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-23 17:46:34", "2025-12-23 17:46:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766511994;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766511994;}", "8", "1", "2025-12-23 17:50:36", "2025-12-23 13:50:36", "40700", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5081", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-23 20:08:28", "2025-12-23 20:08:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766520508;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766520508;}", "12", "1", "2025-12-23 20:14:40", "2025-12-23 16:14:40", "40717", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5082", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-23 21:14:40", "2025-12-23 21:14:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766524480;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766524480;}", "12", "1", "2025-12-23 21:15:09", "2025-12-23 17:15:09", "40720", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5083", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-23 22:15:09", "2025-12-23 22:15:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766528109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766528109;}", "12", "1", "2025-12-23 22:26:23", "2025-12-23 18:26:23", "40725", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5084", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-23 23:26:23", "2025-12-23 23:26:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766532383;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766532383;}", "12", "1", "2025-12-23 23:32:56", "2025-12-23 19:32:56", "40735", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5085", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 00:32:56", "2025-12-24 00:32:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766536376;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766536376;}", "12", "1", "2025-12-24 01:10:11", "2025-12-23 21:10:11", "40744", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5086", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 02:10:11", "2025-12-24 02:10:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766542211;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766542211;}", "12", "1", "2025-12-24 02:13:42", "2025-12-23 22:13:42", "40752", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5087", "woocommerce_refresh_order_count_cache", "complete", "2025-12-24 13:46:32", "2025-12-24 13:46:32", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766583992;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766583992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-24 13:53:09", "2025-12-24 09:53:09", "40903", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5088", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 03:13:42", "2025-12-24 03:13:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766546022;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766546022;}", "12", "1", "2025-12-24 03:16:49", "2025-12-23 23:16:49", "40759", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5089", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 04:16:49", "2025-12-24 04:16:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766549809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766549809;}", "12", "1", "2025-12-24 04:22:52", "2025-12-24 00:22:52", "40773", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5090", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 05:22:52", "2025-12-24 05:22:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766553772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766553772;}", "12", "1", "2025-12-24 05:29:46", "2025-12-24 01:29:46", "40785", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5091", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-24 04:22:52", "2025-12-24 04:22:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766550172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766550172;}", "8", "1", "2025-12-24 04:35:31", "2025-12-24 00:35:31", "40775", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5092", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 06:29:46", "2025-12-24 06:29:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766557786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766557786;}", "12", "1", "2025-12-24 06:30:13", "2025-12-24 02:30:13", "40804", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5093", "wc_admin_daily_wrapper", "complete", "2025-12-25 05:49:29", "2025-12-25 05:49:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766641769;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766641769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-25 06:36:42", "2025-12-25 02:36:42", "41125", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5094", "woocommerce_cleanup_personal_data", "complete", "2025-12-25 05:49:30", "2025-12-25 05:49:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766641770;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766641770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-25 06:36:43", "2025-12-25 02:36:43", "41125", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5095", "woocommerce_cleanup_logs", "complete", "2025-12-25 05:49:30", "2025-12-25 05:49:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766641770;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766641770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-25 06:36:43", "2025-12-25 02:36:43", "41125", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5096", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-25 05:49:30", "2025-12-25 05:49:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766641770;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766641770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-25 06:36:43", "2025-12-25 02:36:43", "41125", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5098", "generate_category_lookup_table_wrapper", "complete", "2025-12-24 05:49:40", "2025-12-24 05:49:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766555380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766555380;}", "12", "1", "2025-12-24 05:50:32", "2025-12-24 01:50:32", "40792", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5099", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-25 05:49:30", "2025-12-25 05:49:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766641770;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766641770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-25 06:36:43", "2025-12-25 02:36:43", "41125", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5100", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 07:30:13", "2025-12-24 07:30:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766561413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766561413;}", "12", "1", "2025-12-24 07:31:32", "2025-12-24 03:31:32", "40826", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5101", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 08:31:32", "2025-12-24 08:31:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766565092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766565092;}", "12", "1", "2025-12-24 08:38:21", "2025-12-24 04:38:21", "40847", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5102", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 09:38:21", "2025-12-24 09:38:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766569101;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766569101;}", "12", "1", "2025-12-24 09:39:26", "2025-12-24 05:39:26", "40859", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5103", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 10:39:26", "2025-12-24 10:39:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766572766;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766572766;}", "12", "1", "2025-12-24 10:47:52", "2025-12-24 06:47:52", "40864", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5104", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 11:47:52", "2025-12-24 11:47:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766576872;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766576872;}", "12", "1", "2025-12-24 11:51:38", "2025-12-24 07:51:38", "40878", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5105", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 12:51:38", "2025-12-24 12:51:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766580698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766580698;}", "12", "1", "2025-12-24 12:51:41", "2025-12-24 08:51:41", "40887", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5106", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 13:51:41", "2025-12-24 13:51:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766584301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766584301;}", "12", "1", "2025-12-24 13:53:09", "2025-12-24 09:53:09", "40903", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5107", "woocommerce_refresh_order_count_cache", "complete", "2025-12-25 01:53:09", "2025-12-25 01:53:09", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766627589;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766627589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-25 01:59:54", "2025-12-24 21:59:54", "41093", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5108", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 14:53:09", "2025-12-24 14:53:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766587989;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766587989;}", "12", "1", "2025-12-24 14:59:43", "2025-12-24 10:59:43", "40928", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5109", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 15:59:43", "2025-12-24 15:59:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766591983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766591983;}", "12", "1", "2025-12-24 16:02:22", "2025-12-24 12:02:22", "40947", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5110", "woocommerce_cleanup_draft_orders", "complete", "2025-12-25 15:35:43", "2025-12-25 15:35:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766676943;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766676943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-25 15:36:51", "2025-12-25 11:36:51", "41186", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5111", "woocommerce_scheduled_sales", "complete", "2025-12-25 15:35:44", "2025-12-25 15:35:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766676944;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766676944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-25 15:36:51", "2025-12-25 11:36:51", "41186", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5112", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 17:02:22", "2025-12-24 17:02:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766595742;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766595742;}", "12", "1", "2025-12-24 17:02:47", "2025-12-24 13:02:47", "40962", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5113", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-24 16:09:59", "2025-12-24 16:09:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766592599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766592599;}", "8", "1", "2025-12-24 16:14:23", "2025-12-24 12:14:23", "40953", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5114", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 18:02:47", "2025-12-24 18:02:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766599367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766599367;}", "12", "1", "2025-12-24 18:04:15", "2025-12-24 14:04:15", "40988", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5115", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 19:04:15", "2025-12-24 19:04:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766603055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766603055;}", "12", "1", "2025-12-24 19:05:04", "2025-12-24 15:05:04", "41001", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5116", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 20:05:04", "2025-12-24 20:05:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766606704;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766606704;}", "12", "1", "2025-12-24 20:09:14", "2025-12-24 16:09:14", "41022", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5117", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 21:09:14", "2025-12-24 21:09:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766610554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766610554;}", "12", "1", "2025-12-24 21:12:56", "2025-12-24 17:12:56", "41037", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5118", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 22:12:56", "2025-12-24 22:12:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766614376;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766614376;}", "12", "1", "2025-12-24 22:13:33", "2025-12-24 18:13:33", "41044", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5119", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-24 23:13:33", "2025-12-24 23:13:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766618013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766618013;}", "12", "1", "2025-12-24 23:23:22", "2025-12-24 19:23:22", "41052", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5120", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 00:23:22", "2025-12-25 00:23:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766622202;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766622202;}", "12", "1", "2025-12-25 00:23:28", "2025-12-24 20:23:28", "41077", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5121", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 01:23:28", "2025-12-25 01:23:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766625808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766625808;}", "12", "1", "2025-12-25 01:31:16", "2025-12-24 21:31:16", "41085", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5122", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 02:31:16", "2025-12-25 02:31:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766629876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766629876;}", "12", "1", "2025-12-25 02:48:42", "2025-12-24 22:48:42", "41105", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5123", "woocommerce_refresh_order_count_cache", "complete", "2025-12-25 13:59:54", "2025-12-25 13:59:54", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766671194;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766671194;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-25 14:01:34", "2025-12-25 10:01:34", "41174", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5124", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 03:48:42", "2025-12-25 03:48:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766634522;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766634522;}", "12", "1", "2025-12-25 04:18:39", "2025-12-25 00:18:39", "41115", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5125", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 05:18:39", "2025-12-25 05:18:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766639919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766639919;}", "12", "1", "2025-12-25 05:21:19", "2025-12-25 01:21:19", "41122", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5126", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-25 04:18:39", "2025-12-25 04:18:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766636319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766636319;}", "8", "1", "2025-12-25 04:48:15", "2025-12-25 00:48:15", "41117", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5127", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 06:21:19", "2025-12-25 06:21:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766643679;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766643679;}", "12", "1", "2025-12-25 06:36:43", "2025-12-25 02:36:43", "41125", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5128", "wc_admin_daily_wrapper", "complete", "2025-12-26 06:36:42", "2025-12-26 06:36:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766731002;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766731002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-26 07:54:05", "2025-12-26 03:54:05", "41241", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5129", "woocommerce_cleanup_personal_data", "complete", "2025-12-26 06:36:43", "2025-12-26 06:36:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766731003;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766731003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-26 07:54:06", "2025-12-26 03:54:06", "41241", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5130", "woocommerce_cleanup_logs", "complete", "2025-12-26 06:36:43", "2025-12-26 06:36:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766731003;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766731003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-26 07:54:07", "2025-12-26 03:54:07", "41241", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5131", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-26 06:36:43", "2025-12-26 06:36:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766731003;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766731003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-26 07:54:07", "2025-12-26 03:54:07", "41241", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5132", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 07:36:43", "2025-12-25 07:36:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766648203;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766648203;}", "12", "1", "2025-12-25 07:38:04", "2025-12-25 03:38:04", "41135", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5134", "generate_category_lookup_table_wrapper", "complete", "2025-12-25 06:36:53", "2025-12-25 06:36:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766644613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766644613;}", "12", "1", "2025-12-25 06:42:46", "2025-12-25 02:42:46", "41128", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5135", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-26 06:36:43", "2025-12-26 06:36:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766731003;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766731003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-26 07:54:07", "2025-12-26 03:54:07", "41241", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5136", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 08:38:04", "2025-12-25 08:38:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766651884;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766651884;}", "12", "1", "2025-12-25 08:38:17", "2025-12-25 04:38:17", "41137", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5137", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 09:38:17", "2025-12-25 09:38:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766655497;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766655497;}", "12", "1", "2025-12-25 09:42:03", "2025-12-25 05:42:03", "41146", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5138", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 10:42:03", "2025-12-25 10:42:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766659323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766659323;}", "12", "1", "2025-12-25 10:42:37", "2025-12-25 06:42:37", "41150", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5139", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 11:42:37", "2025-12-25 11:42:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766662957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766662957;}", "12", "1", "2025-12-25 11:48:45", "2025-12-25 07:48:45", "41159", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5140", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 12:48:45", "2025-12-25 12:48:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766666925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766666925;}", "12", "1", "2025-12-25 13:04:00", "2025-12-25 09:04:00", "41167", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5141", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 14:04:00", "2025-12-25 14:04:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766671440;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766671440;}", "12", "1", "2025-12-25 14:05:11", "2025-12-25 10:05:11", "41176", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5142", "woocommerce_refresh_order_count_cache", "complete", "2025-12-26 02:01:34", "2025-12-26 02:01:34", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766714494;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766714494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-26 02:17:15", "2025-12-25 22:17:15", "41232", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5143", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 15:05:11", "2025-12-25 15:05:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766675111;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766675111;}", "12", "1", "2025-12-25 15:11:28", "2025-12-25 11:11:28", "41183", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5144", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 16:11:28", "2025-12-25 16:11:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766679088;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766679088;}", "12", "1", "2025-12-25 16:23:04", "2025-12-25 12:23:04", "41191", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5145", "woocommerce_cleanup_draft_orders", "complete", "2025-12-26 15:36:51", "2025-12-26 15:36:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766763411;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766763411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-26 16:13:34", "2025-12-26 12:13:34", "41260", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5146", "woocommerce_scheduled_sales", "complete", "2025-12-26 15:36:51", "2025-12-26 15:36:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766763411;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766763411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-26 16:13:34", "2025-12-26 12:13:34", "41260", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5147", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 17:23:04", "2025-12-25 17:23:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766683384;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766683384;}", "12", "1", "2025-12-25 17:27:58", "2025-12-25 13:27:58", "41204", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5148", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-25 16:23:04", "2025-12-25 16:23:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766679784;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766679784;}", "8", "1", "2025-12-25 16:32:28", "2025-12-25 12:32:28", "41193", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5149", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 18:27:58", "2025-12-25 18:27:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766687278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766687278;}", "12", "1", "2025-12-25 18:48:41", "2025-12-25 14:48:41", "41210", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5150", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 19:48:41", "2025-12-25 19:48:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766692121;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766692121;}", "12", "1", "2025-12-25 20:11:03", "2025-12-25 16:11:03", "41216", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5151", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 21:11:03", "2025-12-25 21:11:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766697063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766697063;}", "12", "1", "2025-12-25 21:17:09", "2025-12-25 17:17:09", "41219", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5152", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 22:17:09", "2025-12-25 22:17:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766701029;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766701029;}", "12", "1", "2025-12-25 22:20:51", "2025-12-25 18:20:51", "41224", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5153", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-25 23:20:51", "2025-12-25 23:20:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766704851;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766704851;}", "12", "1", "2025-12-26 02:17:15", "2025-12-25 22:17:15", "41232", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5154", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 03:17:15", "2025-12-26 03:17:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766719035;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766719035;}", "12", "1", "2025-12-26 05:00:18", "2025-12-26 01:00:18", "41235", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5155", "woocommerce_refresh_order_count_cache", "complete", "2025-12-26 14:17:15", "2025-12-26 14:17:15", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766758635;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766758635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-26 15:19:12", "2025-12-26 11:19:12", "41258", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5156", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 06:00:18", "2025-12-26 06:00:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766728818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766728818;}", "12", "1", "2025-12-26 06:28:42", "2025-12-26 02:28:42", "41239", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5157", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-26 05:00:18", "2025-12-26 05:00:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766725218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766725218;}", "8", "1", "2025-12-26 05:07:32", "2025-12-26 01:07:32", "41237", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5158", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 07:28:42", "2025-12-26 07:28:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766734122;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766734122;}", "12", "1", "2025-12-26 07:54:07", "2025-12-26 03:54:07", "41241", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5159", "wc_admin_daily_wrapper", "complete", "2025-12-27 07:54:05", "2025-12-27 07:54:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766822045;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766822045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-27 07:54:09", "2025-12-27 03:54:09", "41474", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5160", "woocommerce_cleanup_personal_data", "complete", "2025-12-27 07:54:06", "2025-12-27 07:54:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766822046;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766822046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-27 07:54:10", "2025-12-27 03:54:10", "41474", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5161", "woocommerce_cleanup_logs", "complete", "2025-12-27 07:54:07", "2025-12-27 07:54:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766822047;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766822047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-27 07:54:10", "2025-12-27 03:54:10", "41474", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5162", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-27 07:54:07", "2025-12-27 07:54:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766822047;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766822047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-27 07:54:10", "2025-12-27 03:54:10", "41474", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5163", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 08:54:07", "2025-12-26 08:54:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766739247;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766739247;}", "12", "1", "2025-12-26 09:53:22", "2025-12-26 05:53:22", "41249", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5165", "generate_category_lookup_table_wrapper", "complete", "2025-12-26 07:54:17", "2025-12-26 07:54:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766735657;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766735657;}", "12", "1", "2025-12-26 08:30:02", "2025-12-26 04:30:02", "41243", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5166", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-27 07:54:07", "2025-12-27 07:54:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766822047;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766822047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-27 07:54:10", "2025-12-27 03:54:10", "41474", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5167", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 10:53:22", "2025-12-26 10:53:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766746402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766746402;}", "12", "1", "2025-12-26 12:01:56", "2025-12-26 08:01:56", "41256", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5168", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 13:01:56", "2025-12-26 13:01:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766754116;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766754116;}", "12", "1", "2025-12-26 15:19:12", "2025-12-26 11:19:12", "41258", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5169", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 16:19:12", "2025-12-26 16:19:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766765952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766765952;}", "12", "1", "2025-12-26 17:14:10", "2025-12-26 13:14:10", "41262", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5170", "woocommerce_refresh_order_count_cache", "complete", "2025-12-27 03:19:12", "2025-12-27 03:19:12", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766805552;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766805552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-27 03:48:36", "2025-12-26 23:48:36", "41337", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5171", "woocommerce_cleanup_draft_orders", "complete", "2025-12-27 16:13:34", "2025-12-27 16:13:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766852014;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766852014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-27 16:41:22", "2025-12-27 12:41:22", "41514", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5172", "woocommerce_scheduled_sales", "complete", "2025-12-27 16:13:34", "2025-12-27 16:13:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766852014;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766852014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-27 16:41:22", "2025-12-27 12:41:22", "41514", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5173", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-26 16:13:34", "2025-12-26 16:13:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766765614;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766765614;}", "8", "1", "2025-12-26 17:14:10", "2025-12-26 13:14:10", "41262", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5174", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 18:14:10", "2025-12-26 18:14:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766772850;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766772850;}", "12", "1", "2025-12-26 18:21:33", "2025-12-26 14:21:33", "41269", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5175", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 19:21:33", "2025-12-26 19:21:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766776893;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766776893;}", "12", "1", "2025-12-26 19:24:06", "2025-12-26 15:24:06", "41276", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5176", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 20:24:06", "2025-12-26 20:24:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766780646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766780646;}", "12", "1", "2025-12-26 20:43:32", "2025-12-26 16:43:32", "41285", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5177", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 21:43:32", "2025-12-26 21:43:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766785412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766785412;}", "12", "1", "2025-12-26 21:48:57", "2025-12-26 17:48:57", "41299", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5178", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-26 22:48:57", "2025-12-26 22:48:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766789337;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766789337;}", "12", "1", "2025-12-26 23:23:05", "2025-12-26 19:23:05", "41308", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5179", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 00:23:05", "2025-12-27 00:23:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766794985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766794985;}", "12", "1", "2025-12-27 00:26:33", "2025-12-26 20:26:33", "41317", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5180", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 01:26:33", "2025-12-27 01:26:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766798793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766798793;}", "12", "1", "2025-12-27 01:27:24", "2025-12-26 21:27:24", "41323", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5181", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 02:27:24", "2025-12-27 02:27:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766802444;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766802444;}", "12", "1", "2025-12-27 02:46:02", "2025-12-26 22:46:02", "41333", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5182", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 03:46:02", "2025-12-27 03:46:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766807162;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766807162;}", "12", "1", "2025-12-27 03:48:36", "2025-12-26 23:48:36", "41337", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5183", "woocommerce_refresh_order_count_cache", "complete", "2025-12-27 15:48:36", "2025-12-27 15:48:36", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766850516;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766850516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-27 15:57:06", "2025-12-27 11:57:06", "41512", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5184", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 04:48:36", "2025-12-27 04:48:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766810916;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766810916;}", "12", "1", "2025-12-27 04:49:20", "2025-12-27 00:49:20", "41380", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5185", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-27 04:10:11", "2025-12-27 04:10:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766808611;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766808611;}", "8", "1", "2025-12-27 04:11:17", "2025-12-27 00:11:17", "41350", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5186", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 05:49:20", "2025-12-27 05:49:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766814560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766814560;}", "12", "1", "2025-12-27 05:51:38", "2025-12-27 01:51:38", "41433", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5187", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 06:51:38", "2025-12-27 06:51:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766818298;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766818298;}", "12", "1", "2025-12-27 06:58:33", "2025-12-27 02:58:33", "41469", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5188", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 07:58:33", "2025-12-27 07:58:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766822313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766822313;}", "12", "1", "2025-12-27 08:16:45", "2025-12-27 04:16:45", "41478", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5189", "wc_admin_daily_wrapper", "complete", "2025-12-28 07:54:09", "2025-12-28 07:54:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766908449;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766908449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-28 08:45:47", "2025-12-28 04:45:47", "41570", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5190", "woocommerce_cleanup_personal_data", "complete", "2025-12-28 07:54:10", "2025-12-28 07:54:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766908450;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766908450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-28 08:45:48", "2025-12-28 04:45:48", "41570", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5191", "woocommerce_cleanup_logs", "complete", "2025-12-28 07:54:10", "2025-12-28 07:54:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766908450;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766908450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-28 08:45:49", "2025-12-28 04:45:49", "41570", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5192", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-28 07:54:10", "2025-12-28 07:54:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766908450;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766908450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-28 08:45:49", "2025-12-28 04:45:49", "41570", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5194", "generate_category_lookup_table_wrapper", "complete", "2025-12-27 07:54:20", "2025-12-27 07:54:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766822060;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766822060;}", "12", "1", "2025-12-27 07:57:58", "2025-12-27 03:57:58", "41476", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5195", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-28 07:54:10", "2025-12-28 07:54:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766908450;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766908450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-28 08:45:49", "2025-12-28 04:45:49", "41570", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5196", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 09:16:45", "2025-12-27 09:16:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766827005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766827005;}", "12", "1", "2025-12-27 09:28:51", "2025-12-27 05:28:51", "41488", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5197", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 10:28:51", "2025-12-27 10:28:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766831331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766831331;}", "12", "1", "2025-12-27 10:56:08", "2025-12-27 06:56:08", "41498", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5198", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 11:56:08", "2025-12-27 11:56:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766836568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766836568;}", "12", "1", "2025-12-27 12:41:34", "2025-12-27 08:41:34", "41504", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5199", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 13:41:34", "2025-12-27 13:41:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766842894;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766842894;}", "12", "1", "2025-12-27 14:02:18", "2025-12-27 10:02:18", "41507", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5200", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 15:02:18", "2025-12-27 15:02:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766847738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766847738;}", "12", "1", "2025-12-27 15:10:19", "2025-12-27 11:10:19", "41509", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5201", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 16:10:19", "2025-12-27 16:10:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766851819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766851819;}", "12", "1", "2025-12-27 16:41:22", "2025-12-27 12:41:22", "41514", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5202", "woocommerce_refresh_order_count_cache", "complete", "2025-12-28 03:57:06", "2025-12-28 03:57:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766894226;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766894226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-28 04:23:12", "2025-12-28 00:23:12", "41554", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5203", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 17:41:22", "2025-12-27 17:41:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766857282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766857282;}", "12", "1", "2025-12-27 17:42:31", "2025-12-27 13:42:31", "41518", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5204", "woocommerce_cleanup_draft_orders", "complete", "2025-12-28 16:41:22", "2025-12-28 16:41:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766940082;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766940082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-28 16:45:01", "2025-12-28 12:45:01", "41756", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5205", "woocommerce_scheduled_sales", "complete", "2025-12-28 16:41:22", "2025-12-28 16:41:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766940082;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766940082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-28 16:45:01", "2025-12-28 12:45:01", "41756", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5206", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-27 16:41:22", "2025-12-27 16:41:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766853682;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766853682;}", "8", "1", "2025-12-27 17:16:29", "2025-12-27 13:16:29", "41516", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5207", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 18:42:31", "2025-12-27 18:42:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766860951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766860951;}", "12", "1", "2025-12-27 19:04:28", "2025-12-27 15:04:28", "41520", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5208", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 20:04:28", "2025-12-27 20:04:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766865868;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766865868;}", "12", "1", "2025-12-27 20:54:41", "2025-12-27 16:54:41", "41529", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5209", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 21:54:41", "2025-12-27 21:54:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766872481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766872481;}", "12", "1", "2025-12-27 22:35:28", "2025-12-27 18:35:28", "41536", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5210", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-27 23:35:28", "2025-12-27 23:35:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766878528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766878528;}", "12", "1", "2025-12-28 00:30:19", "2025-12-27 20:30:19", "41541", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5211", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 01:30:19", "2025-12-28 01:30:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766885419;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766885419;}", "12", "1", "2025-12-28 01:53:02", "2025-12-27 21:53:02", "41546", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5212", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 02:53:02", "2025-12-28 02:53:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766890382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766890382;}", "12", "1", "2025-12-28 02:54:01", "2025-12-27 22:54:01", "41551", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5213", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 03:54:01", "2025-12-28 03:54:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766894041;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766894041;}", "12", "1", "2025-12-28 04:23:12", "2025-12-28 00:23:12", "41554", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5214", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 05:23:12", "2025-12-28 05:23:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766899392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766899392;}", "12", "1", "2025-12-28 05:46:57", "2025-12-28 01:46:57", "41559", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5215", "woocommerce_refresh_order_count_cache", "complete", "2025-12-28 16:23:12", "2025-12-28 16:23:12", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766938992;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766938992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-28 16:23:55", "2025-12-28 12:23:55", "41746", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5216", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-28 04:23:13", "2025-12-28 04:23:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766895793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766895793;}", "8", "1", "2025-12-28 04:45:12", "2025-12-28 00:45:12", "41556", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5217", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 06:46:57", "2025-12-28 06:46:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766904417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766904417;}", "12", "1", "2025-12-28 07:01:44", "2025-12-28 03:01:44", "41566", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5218", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 08:01:44", "2025-12-28 08:01:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766908904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766908904;}", "12", "1", "2025-12-28 08:45:49", "2025-12-28 04:45:49", "41570", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5219", "wc_admin_daily_wrapper", "complete", "2025-12-29 08:45:47", "2025-12-29 08:45:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766997947;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766997947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-29 08:46:37", "2025-12-29 04:46:37", "42018", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5220", "woocommerce_cleanup_personal_data", "complete", "2025-12-29 08:45:48", "2025-12-29 08:45:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766997948;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766997948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-29 08:46:38", "2025-12-29 04:46:38", "42018", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5221", "woocommerce_cleanup_logs", "complete", "2025-12-29 08:45:49", "2025-12-29 08:45:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766997949;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766997949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-29 08:46:38", "2025-12-29 04:46:38", "42018", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5222", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-29 08:45:49", "2025-12-29 08:45:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766997949;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766997949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-29 08:46:38", "2025-12-29 04:46:38", "42018", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5223", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 09:45:49", "2025-12-28 09:45:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766915149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766915149;}", "12", "1", "2025-12-28 09:48:08", "2025-12-28 05:48:08", "41596", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5225", "generate_category_lookup_table_wrapper", "complete", "2025-12-28 08:45:59", "2025-12-28 08:45:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766911559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766911559;}", "12", "1", "2025-12-28 08:46:50", "2025-12-28 04:46:50", "41573", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5226", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-29 08:45:49", "2025-12-29 08:45:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766997949;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766997949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-29 08:46:38", "2025-12-29 04:46:38", "42018", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5227", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 10:48:08", "2025-12-28 10:48:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766918888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766918888;}", "12", "1", "2025-12-28 10:52:03", "2025-12-28 06:52:03", "41628", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5228", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 11:52:03", "2025-12-28 11:52:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766922723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766922723;}", "12", "1", "2025-12-28 11:54:09", "2025-12-28 07:54:09", "41653", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5229", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 12:54:09", "2025-12-28 12:54:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766926449;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766926449;}", "12", "1", "2025-12-28 12:54:15", "2025-12-28 08:54:15", "41675", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5230", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 13:54:15", "2025-12-28 13:54:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766930055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766930055;}", "12", "1", "2025-12-28 13:58:21", "2025-12-28 09:58:21", "41699", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5231", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 14:58:21", "2025-12-28 14:58:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766933901;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766933901;}", "12", "1", "2025-12-28 15:04:32", "2025-12-28 11:04:32", "41721", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5232", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 16:04:32", "2025-12-28 16:04:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766937872;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766937872;}", "12", "1", "2025-12-28 16:05:12", "2025-12-28 12:05:12", "41736", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5233", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 17:05:12", "2025-12-28 17:05:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766941512;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766941512;}", "12", "1", "2025-12-28 17:10:43", "2025-12-28 13:10:43", "41763", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5234", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-28 16:10:27", "2025-12-28 16:10:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766938227;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766938227;}", "8", "1", "2025-12-28 16:12:10", "2025-12-28 12:12:10", "41740", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5235", "woocommerce_refresh_order_count_cache", "complete", "2025-12-29 04:23:55", "2025-12-29 04:23:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766982235;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766982235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-29 04:27:28", "2025-12-29 00:27:28", "41953", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5236", "woocommerce_cleanup_draft_orders", "complete", "2025-12-29 16:45:01", "2025-12-29 16:45:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767026701;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767026701;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-29 16:45:18", "2025-12-29 12:45:18", "42091", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5237", "woocommerce_scheduled_sales", "complete", "2025-12-29 16:45:01", "2025-12-29 16:45:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767026701;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767026701;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-29 16:45:18", "2025-12-29 12:45:18", "42091", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5238", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 18:10:43", "2025-12-28 18:10:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766945443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766945443;}", "12", "1", "2025-12-28 18:12:54", "2025-12-28 14:12:54", "41782", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5239", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 19:12:54", "2025-12-28 19:12:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766949174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766949174;}", "12", "1", "2025-12-28 19:21:15", "2025-12-28 15:21:15", "41803", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5240", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 20:21:15", "2025-12-28 20:21:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766953275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766953275;}", "12", "1", "2025-12-28 20:29:43", "2025-12-28 16:29:43", "41825", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5241", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 21:29:43", "2025-12-28 21:29:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766957383;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766957383;}", "12", "1", "2025-12-28 21:38:19", "2025-12-28 17:38:19", "41843", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5242", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 22:38:19", "2025-12-28 22:38:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766961499;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766961499;}", "12", "1", "2025-12-28 22:38:27", "2025-12-28 18:38:27", "41859", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5243", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-28 23:38:27", "2025-12-28 23:38:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766965107;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766965107;}", "12", "1", "2025-12-28 23:43:54", "2025-12-28 19:43:54", "41876", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5244", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 00:43:54", "2025-12-29 00:43:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766969034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766969034;}", "12", "1", "2025-12-29 00:45:48", "2025-12-28 20:45:48", "41886", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5245", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 01:45:48", "2025-12-29 01:45:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766972748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766972748;}", "12", "1", "2025-12-29 01:49:48", "2025-12-28 21:49:48", "41911", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5246", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 02:49:48", "2025-12-29 02:49:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766976588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766976588;}", "12", "1", "2025-12-29 02:50:10", "2025-12-28 22:50:10", "41931", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5247", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 03:50:10", "2025-12-29 03:50:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766980210;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766980210;}", "12", "1", "2025-12-29 04:04:31", "2025-12-29 00:04:31", "41950", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5248", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 05:04:31", "2025-12-29 05:04:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766984671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766984671;}", "12", "1", "2025-12-29 05:21:39", "2025-12-29 01:21:39", "41971", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5249", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-29 04:27:28", "2025-12-29 04:27:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766982448;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766982448;}", "8", "1", "2025-12-29 04:27:28", "2025-12-29 00:27:28", "41953", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5250", "woocommerce_refresh_order_count_cache", "complete", "2025-12-29 16:27:28", "2025-12-29 16:27:28", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767025648;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767025648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-29 16:31:51", "2025-12-29 12:31:51", "42087", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5251", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 06:21:39", "2025-12-29 06:21:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766989299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766989299;}", "12", "1", "2025-12-29 06:29:56", "2025-12-29 02:29:56", "41981", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5252", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 07:29:56", "2025-12-29 07:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766993396;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766993396;}", "12", "1", "2025-12-29 07:40:46", "2025-12-29 03:40:46", "41993", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5253", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 08:40:46", "2025-12-29 08:40:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766997646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766997646;}", "12", "1", "2025-12-29 08:42:11", "2025-12-29 04:42:11", "42015", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5254", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 09:42:11", "2025-12-29 09:42:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767001331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767001331;}", "12", "1", "2025-12-29 09:42:45", "2025-12-29 05:42:45", "42026", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5255", "wc_admin_daily_wrapper", "complete", "2025-12-30 08:46:37", "2025-12-30 08:46:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767084397;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767084397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-30 08:56:04", "2025-12-30 04:56:04", "42180", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5256", "woocommerce_cleanup_personal_data", "complete", "2025-12-30 08:46:38", "2025-12-30 08:46:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767084398;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767084398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-30 08:56:05", "2025-12-30 04:56:05", "42180", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5257", "woocommerce_cleanup_logs", "complete", "2025-12-30 08:46:38", "2025-12-30 08:46:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767084398;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767084398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-30 08:56:05", "2025-12-30 04:56:05", "42180", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5258", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-30 08:46:38", "2025-12-30 08:46:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767084398;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767084398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-30 08:56:05", "2025-12-30 04:56:05", "42180", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5260", "generate_category_lookup_table_wrapper", "complete", "2025-12-29 08:46:48", "2025-12-29 08:46:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766998008;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766998008;}", "12", "1", "2025-12-29 09:03:02", "2025-12-29 05:03:02", "42020", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5261", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-30 08:46:38", "2025-12-30 08:46:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767084398;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767084398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-30 08:56:05", "2025-12-30 04:56:05", "42180", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5262", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 10:42:45", "2025-12-29 10:42:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767004965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767004965;}", "12", "1", "2025-12-29 10:42:49", "2025-12-29 06:42:49", "42045", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5263", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 11:42:49", "2025-12-29 11:42:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767008569;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767008569;}", "12", "1", "2025-12-29 12:07:32", "2025-12-29 08:07:32", "42057", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5264", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 13:07:32", "2025-12-29 13:07:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767013652;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767013652;}", "12", "1", "2025-12-29 13:10:11", "2025-12-29 09:10:11", "42064", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5265", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 14:10:11", "2025-12-29 14:10:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767017411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767017411;}", "12", "1", "2025-12-29 15:09:03", "2025-12-29 11:09:03", "42067", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5266", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 16:09:03", "2025-12-29 16:09:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767024543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767024543;}", "12", "1", "2025-12-29 16:11:05", "2025-12-29 12:11:05", "42073", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5267", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 17:11:05", "2025-12-29 17:11:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767028265;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767028265;}", "12", "1", "2025-12-29 17:37:03", "2025-12-29 13:37:03", "42096", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5268", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-29 16:11:05", "2025-12-29 16:11:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767024665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767024665;}", "8", "1", "2025-12-29 16:11:50", "2025-12-29 12:11:50", "42075", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5269", "woocommerce_refresh_order_count_cache", "complete", "2025-12-30 04:31:51", "2025-12-30 04:31:51", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767069111;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767069111;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-30 04:34:16", "2025-12-30 00:34:16", "42152", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5270", "woocommerce_cleanup_draft_orders", "complete", "2025-12-30 16:45:18", "2025-12-30 16:45:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767113118;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767113118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-30 16:49:28", "2025-12-30 12:49:28", "42243", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5271", "woocommerce_scheduled_sales", "complete", "2025-12-30 16:45:18", "2025-12-30 16:45:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767113118;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767113118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-30 16:49:28", "2025-12-30 12:49:28", "42243", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5272", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 18:37:03", "2025-12-29 18:37:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767033423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767033423;}", "12", "1", "2025-12-29 18:41:53", "2025-12-29 14:41:53", "42101", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5273", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 19:41:53", "2025-12-29 19:41:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767037313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767037313;}", "12", "1", "2025-12-29 19:42:24", "2025-12-29 15:42:24", "42107", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5274", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 20:42:24", "2025-12-29 20:42:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767040944;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767040944;}", "12", "1", "2025-12-29 20:47:29", "2025-12-29 16:47:29", "42111", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5275", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 21:47:29", "2025-12-29 21:47:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767044849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767044849;}", "12", "1", "2025-12-29 22:24:30", "2025-12-29 18:24:30", "42116", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5276", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-29 23:24:30", "2025-12-29 23:24:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767050670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767050670;}", "12", "1", "2025-12-29 23:43:23", "2025-12-29 19:43:23", "42124", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5277", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 00:43:23", "2025-12-30 00:43:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767055403;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767055403;}", "12", "1", "2025-12-30 00:58:24", "2025-12-29 20:58:24", "42132", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5278", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 01:58:24", "2025-12-30 01:58:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767059904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767059904;}", "12", "1", "2025-12-30 02:03:37", "2025-12-29 22:03:37", "42137", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5279", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 03:03:37", "2025-12-30 03:03:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767063817;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767063817;}", "12", "1", "2025-12-30 03:18:27", "2025-12-29 23:18:27", "42144", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5280", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 04:18:27", "2025-12-30 04:18:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767068307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767068307;}", "12", "1", "2025-12-30 04:34:16", "2025-12-30 00:34:16", "42152", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5281", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-30 04:09:45", "2025-12-30 04:09:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767067785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767067785;}", "8", "1", "2025-12-30 04:34:15", "2025-12-30 00:34:15", "42152", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5282", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 05:34:16", "2025-12-30 05:34:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767072856;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767072856;}", "12", "1", "2025-12-30 05:52:53", "2025-12-30 01:52:53", "42158", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5283", "woocommerce_refresh_order_count_cache", "complete", "2025-12-30 16:34:16", "2025-12-30 16:34:16", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767112456;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767112456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-30 16:36:05", "2025-12-30 12:36:05", "42240", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5284", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 06:52:53", "2025-12-30 06:52:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767077573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767077573;}", "12", "1", "2025-12-30 06:55:10", "2025-12-30 02:55:10", "42163", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5285", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 07:55:10", "2025-12-30 07:55:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767081310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767081310;}", "12", "1", "2025-12-30 08:05:38", "2025-12-30 04:05:38", "42172", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5286", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 09:05:38", "2025-12-30 09:05:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767085538;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767085538;}", "12", "1", "2025-12-30 09:06:33", "2025-12-30 05:06:33", "42184", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5287", "wc_admin_daily_wrapper", "complete", "2025-12-31 08:56:04", "2025-12-31 08:56:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767171364;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767171364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-31 09:17:50", "2025-12-31 05:17:50", "42478", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5288", "woocommerce_cleanup_personal_data", "complete", "2025-12-31 08:56:05", "2025-12-31 08:56:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767171365;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767171365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-31 09:17:51", "2025-12-31 05:17:51", "42478", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5289", "woocommerce_cleanup_logs", "complete", "2025-12-31 08:56:05", "2025-12-31 08:56:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767171365;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767171365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-31 09:17:51", "2025-12-31 05:17:51", "42478", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5290", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-12-31 08:56:05", "2025-12-31 08:56:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767171365;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767171365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-31 09:17:51", "2025-12-31 05:17:51", "42478", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5292", "generate_category_lookup_table_wrapper", "complete", "2025-12-30 08:56:15", "2025-12-30 08:56:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767084975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767084975;}", "12", "1", "2025-12-30 08:58:47", "2025-12-30 04:58:47", "42182", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5293", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-31 08:56:05", "2025-12-31 08:56:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767171365;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767171365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-31 09:17:51", "2025-12-31 05:17:51", "42478", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5294", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 10:06:33", "2025-12-30 10:06:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767089193;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767089193;}", "12", "1", "2025-12-30 10:19:07", "2025-12-30 06:19:07", "42194", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5295", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 11:19:07", "2025-12-30 11:19:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767093547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767093547;}", "12", "1", "2025-12-30 11:25:47", "2025-12-30 07:25:47", "42201", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5296", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 12:25:47", "2025-12-30 12:25:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767097547;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767097547;}", "12", "1", "2025-12-30 12:28:50", "2025-12-30 08:28:50", "42210", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5297", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 13:28:50", "2025-12-30 13:28:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767101330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767101330;}", "12", "1", "2025-12-30 13:30:17", "2025-12-30 09:30:17", "42216", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5298", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 14:30:17", "2025-12-30 14:30:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767105017;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767105017;}", "12", "1", "2025-12-30 14:43:35", "2025-12-30 10:43:35", "42221", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5299", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 15:43:35", "2025-12-30 15:43:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767109415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767109415;}", "12", "1", "2025-12-30 15:47:18", "2025-12-30 11:47:18", "42234", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5300", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 16:47:18", "2025-12-30 16:47:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767113238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767113238;}", "12", "1", "2025-12-30 16:49:28", "2025-12-30 12:49:28", "42243", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5301", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-30 16:14:49", "2025-12-30 16:14:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767111289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767111289;}", "8", "1", "2025-12-30 16:31:24", "2025-12-30 12:31:24", "42238", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5302", "woocommerce_refresh_order_count_cache", "complete", "2025-12-31 04:36:05", "2025-12-31 04:36:05", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767155765;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767155765;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-31 04:41:42", "2025-12-31 00:41:42", "42448", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5303", "woocommerce_cleanup_draft_orders", "complete", "2025-12-31 16:49:28", "2025-12-31 16:49:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767199768;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767199768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-12-31 17:05:30", "2025-12-31 13:05:30", "42531", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5304", "woocommerce_scheduled_sales", "complete", "2025-12-31 16:49:28", "2025-12-31 16:49:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767199768;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767199768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-12-31 17:05:30", "2025-12-31 13:05:30", "42531", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5305", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 17:49:28", "2025-12-30 17:49:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767116968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767116968;}", "12", "1", "2025-12-30 17:57:56", "2025-12-30 13:57:56", "42251", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5306", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 18:57:56", "2025-12-30 18:57:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767121076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767121076;}", "12", "1", "2025-12-30 18:58:27", "2025-12-30 14:58:27", "42283", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5307", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 19:58:27", "2025-12-30 19:58:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767124707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767124707;}", "12", "1", "2025-12-30 20:00:01", "2025-12-30 16:00:01", "42338", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5308", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 21:00:01", "2025-12-30 21:00:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767128401;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767128401;}", "12", "1", "2025-12-30 21:16:36", "2025-12-30 17:16:36", "42386", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5309", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 22:16:36", "2025-12-30 22:16:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767132996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767132996;}", "12", "1", "2025-12-30 22:22:00", "2025-12-30 18:22:00", "42403", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5310", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-30 23:22:00", "2025-12-30 23:22:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767136920;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767136920;}", "12", "1", "2025-12-30 23:33:58", "2025-12-30 19:33:58", "42411", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5311", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 00:33:58", "2025-12-31 00:33:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767141238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767141238;}", "12", "1", "2025-12-31 00:34:25", "2025-12-30 20:34:25", "42417", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5312", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 01:34:25", "2025-12-31 01:34:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767144865;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767144865;}", "12", "1", "2025-12-31 01:55:23", "2025-12-30 21:55:23", "42428", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5313", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 02:55:23", "2025-12-31 02:55:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767149723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767149723;}", "12", "1", "2025-12-31 03:07:09", "2025-12-30 23:07:09", "42434", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5314", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 04:07:09", "2025-12-31 04:07:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767154029;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767154029;}", "12", "1", "2025-12-31 04:08:19", "2025-12-31 00:08:19", "42442", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5315", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 05:08:19", "2025-12-31 05:08:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767157699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767157699;}", "12", "1", "2025-12-31 05:09:52", "2025-12-31 01:09:52", "42450", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5316", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-31 04:13:51", "2025-12-31 04:13:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767154431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767154431;}", "8", "1", "2025-12-31 04:26:42", "2025-12-31 00:26:42", "42445", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5317", "woocommerce_refresh_order_count_cache", "complete", "2025-12-31 16:41:42", "2025-12-31 16:41:42", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767199302;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767199302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-12-31 17:05:30", "2025-12-31 13:05:30", "42531", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5318", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 06:09:52", "2025-12-31 06:09:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767161392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767161392;}", "12", "1", "2025-12-31 06:22:42", "2025-12-31 02:22:42", "42456", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5319", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 07:22:42", "2025-12-31 07:22:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767165762;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767165762;}", "12", "1", "2025-12-31 07:28:34", "2025-12-31 03:28:34", "42465", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5320", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 08:28:34", "2025-12-31 08:28:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767169714;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767169714;}", "12", "1", "2025-12-31 08:39:41", "2025-12-31 04:39:41", "42473", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5321", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 09:39:41", "2025-12-31 09:39:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767173981;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767173981;}", "12", "1", "2025-12-31 09:45:05", "2025-12-31 05:45:05", "42480", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5322", "wc_admin_daily_wrapper", "complete", "2026-01-01 09:17:50", "2026-01-01 09:17:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767259070;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767259070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-01 09:34:14", "2026-01-01 05:34:14", "42734", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5323", "woocommerce_cleanup_personal_data", "complete", "2026-01-01 09:17:51", "2026-01-01 09:17:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767259071;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767259071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-01 09:34:15", "2026-01-01 05:34:15", "42734", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5324", "woocommerce_cleanup_logs", "complete", "2026-01-01 09:17:51", "2026-01-01 09:17:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767259071;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767259071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-01 09:34:15", "2026-01-01 05:34:15", "42734", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5325", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-01 09:17:51", "2026-01-01 09:17:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767259071;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767259071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-01 09:34:15", "2026-01-01 05:34:15", "42734", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5327", "generate_category_lookup_table_wrapper", "complete", "2025-12-31 09:18:01", "2025-12-31 09:18:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767172681;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767172681;}", "12", "1", "2025-12-31 09:45:05", "2025-12-31 05:45:05", "42480", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5328", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-01 09:17:51", "2026-01-01 09:17:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767259071;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767259071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-01 09:34:15", "2026-01-01 05:34:15", "42734", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5329", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 10:45:05", "2025-12-31 10:45:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767177905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767177905;}", "12", "1", "2025-12-31 10:52:34", "2025-12-31 06:52:34", "42494", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5330", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 11:52:34", "2025-12-31 11:52:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767181954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767181954;}", "12", "1", "2025-12-31 12:02:28", "2025-12-31 08:02:28", "42501", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5331", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 13:02:28", "2025-12-31 13:02:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767186148;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767186148;}", "12", "1", "2025-12-31 13:10:29", "2025-12-31 09:10:29", "42505", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5332", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 14:10:29", "2025-12-31 14:10:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767190229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767190229;}", "12", "1", "2025-12-31 14:20:21", "2025-12-31 10:20:21", "42514", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5333", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 15:20:21", "2025-12-31 15:20:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767194421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767194421;}", "12", "1", "2025-12-31 15:20:49", "2025-12-31 11:20:49", "42520", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5334", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 16:20:49", "2025-12-31 16:20:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767198049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767198049;}", "12", "1", "2025-12-31 16:38:10", "2025-12-31 12:38:10", "42529", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5335", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-12-31 16:10:45", "2025-12-31 16:10:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767197445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767197445;}", "8", "1", "2025-12-31 16:16:14", "2025-12-31 12:16:14", "42527", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5336", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 17:38:10", "2025-12-31 17:38:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767202690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767202690;}", "12", "1", "2025-12-31 18:00:35", "2025-12-31 14:00:35", "42538", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5337", "woocommerce_refresh_order_count_cache", "complete", "2026-01-01 05:05:30", "2026-01-01 05:05:30", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767243930;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767243930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-01 05:05:55", "2026-01-01 01:05:55", "42709", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5338", "woocommerce_cleanup_draft_orders", "complete", "2026-01-01 17:05:30", "2026-01-01 17:05:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767287130;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767287130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-01 17:10:42", "2026-01-01 13:10:42", "42782", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5339", "woocommerce_scheduled_sales", "complete", "2026-01-01 17:05:30", "2026-01-01 17:05:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767287130;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767287130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-01 17:10:42", "2026-01-01 13:10:42", "42782", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5340", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 19:00:35", "2025-12-31 19:00:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767207635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767207635;}", "12", "1", "2025-12-31 19:05:36", "2025-12-31 15:05:36", "42547", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5341", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 20:05:36", "2025-12-31 20:05:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767211536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767211536;}", "12", "1", "2025-12-31 20:17:33", "2025-12-31 16:17:33", "42556", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5342", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 21:17:33", "2025-12-31 21:17:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767215853;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767215853;}", "12", "1", "2025-12-31 21:37:05", "2025-12-31 17:37:05", "42562", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5343", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 22:37:05", "2025-12-31 22:37:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767220625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767220625;}", "12", "1", "2025-12-31 22:50:40", "2025-12-31 18:50:40", "42571", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5344", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 23:50:40", "2025-12-31 23:50:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767225040;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767225040;}", "12", "1", "2025-12-31 23:58:32", "2025-12-31 19:58:32", "42580", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5345", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 00:58:32", "2026-01-01 00:58:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767229112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767229112;}", "12", "1", "2026-01-01 01:08:19", "2025-12-31 21:08:19", "42588", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5346", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 02:08:19", "2026-01-01 02:08:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767233299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767233299;}", "12", "1", "2026-01-01 02:11:15", "2025-12-31 22:11:15", "42608", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5347", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 03:11:15", "2026-01-01 03:11:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767237075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767237075;}", "12", "1", "2026-01-01 03:12:00", "2025-12-31 23:12:00", "42658", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5348", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 04:12:00", "2026-01-01 04:12:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767240720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767240720;}", "12", "1", "2026-01-01 04:13:40", "2026-01-01 00:13:40", "42706", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5349", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-01 04:10:48", "2026-01-01 04:10:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767240648;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767240648;}", "8", "1", "2026-01-01 04:10:48", "2026-01-01 00:10:48", "42704", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5350", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 05:13:40", "2026-01-01 05:13:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767244420;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767244420;}", "12", "1", "2026-01-01 05:33:24", "2026-01-01 01:33:24", "42713", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5351", "woocommerce_refresh_order_count_cache", "complete", "2026-01-01 17:05:55", "2026-01-01 17:05:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767287155;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767287155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-01 17:10:42", "2026-01-01 13:10:42", "42782", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5352", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 06:33:24", "2026-01-01 06:33:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767249204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767249204;}", "12", "1", "2026-01-01 06:56:12", "2026-01-01 02:56:12", "42719", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5353", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 07:56:12", "2026-01-01 07:56:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767254172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767254172;}", "12", "1", "2026-01-01 08:06:20", "2026-01-01 04:06:20", "42723", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5354", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 09:06:20", "2026-01-01 09:06:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767258380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767258380;}", "12", "1", "2026-01-01 09:07:30", "2026-01-01 05:07:30", "42731", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5355", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 10:07:30", "2026-01-01 10:07:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767262050;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767262050;}", "12", "1", "2026-01-01 10:33:32", "2026-01-01 06:33:32", "42739", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5356", "wc_admin_daily_wrapper", "complete", "2026-01-02 09:34:14", "2026-01-02 09:34:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767346454;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767346454;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-02 09:45:09", "2026-01-02 05:45:09", "42934", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5357", "woocommerce_cleanup_personal_data", "complete", "2026-01-02 09:34:15", "2026-01-02 09:34:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767346455;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767346455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-02 09:45:09", "2026-01-02 05:45:09", "42934", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5358", "woocommerce_cleanup_logs", "complete", "2026-01-02 09:34:15", "2026-01-02 09:34:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767346455;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767346455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-02 09:45:10", "2026-01-02 05:45:10", "42934", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5359", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-02 09:34:15", "2026-01-02 09:34:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767346455;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767346455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-02 09:45:10", "2026-01-02 05:45:10", "42934", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5361", "generate_category_lookup_table_wrapper", "complete", "2026-01-01 09:34:25", "2026-01-01 09:34:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767260065;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767260065;}", "12", "1", "2026-01-01 09:39:31", "2026-01-01 05:39:31", "42736", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5362", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-02 09:34:15", "2026-01-02 09:34:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767346455;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767346455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-02 09:45:10", "2026-01-02 05:45:10", "42934", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5363", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 11:33:32", "2026-01-01 11:33:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767267212;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767267212;}", "12", "1", "2026-01-01 11:44:51", "2026-01-01 07:44:51", "42751", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5364", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 12:44:51", "2026-01-01 12:44:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767271491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767271491;}", "12", "1", "2026-01-01 12:47:49", "2026-01-01 08:47:49", "42756", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5365", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 13:47:49", "2026-01-01 13:47:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767275269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767275269;}", "12", "1", "2026-01-01 14:08:23", "2026-01-01 10:08:23", "42764", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5366", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 15:08:23", "2026-01-01 15:08:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767280103;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767280103;}", "12", "1", "2026-01-01 15:28:32", "2026-01-01 11:28:32", "42771", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5367", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 16:28:32", "2026-01-01 16:28:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767284912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767284912;}", "12", "1", "2026-01-01 16:49:17", "2026-01-01 12:49:17", "42778", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5368", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-01 16:22:26", "2026-01-01 16:22:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767284546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767284546;}", "8", "1", "2026-01-01 16:22:26", "2026-01-01 12:22:26", "42775", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5369", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 17:49:17", "2026-01-01 17:49:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767289757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767289757;}", "12", "1", "2026-01-01 17:49:50", "2026-01-01 13:49:50", "42787", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5370", "woocommerce_cleanup_draft_orders", "complete", "2026-01-02 17:10:42", "2026-01-02 17:10:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767373842;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767373842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-02 17:16:07", "2026-01-02 13:16:07", "43005", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5371", "woocommerce_scheduled_sales", "complete", "2026-01-02 17:10:42", "2026-01-02 17:10:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767373842;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767373842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-02 17:16:07", "2026-01-02 13:16:07", "43005", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5372", "woocommerce_refresh_order_count_cache", "complete", "2026-01-02 05:10:42", "2026-01-02 05:10:42", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767330642;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767330642;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-02 05:23:07", "2026-01-02 01:23:07", "42898", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5373", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 18:49:50", "2026-01-01 18:49:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767293390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767293390;}", "12", "1", "2026-01-01 19:04:11", "2026-01-01 15:04:11", "42794", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5374", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 20:04:11", "2026-01-01 20:04:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767297851;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767297851;}", "12", "1", "2026-01-01 20:17:21", "2026-01-01 16:17:21", "42800", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5375", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 21:17:21", "2026-01-01 21:17:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767302241;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767302241;}", "12", "1", "2026-01-01 21:19:27", "2026-01-01 17:19:27", "42809", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5376", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 22:19:27", "2026-01-01 22:19:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767305967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767305967;}", "12", "1", "2026-01-01 22:33:26", "2026-01-01 18:33:26", "42814", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5377", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-01 23:33:26", "2026-01-01 23:33:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767310406;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767310406;}", "12", "1", "2026-01-01 23:34:10", "2026-01-01 19:34:10", "42819", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5378", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 00:34:10", "2026-01-02 00:34:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767314050;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767314050;}", "12", "1", "2026-01-02 00:34:12", "2026-01-01 20:34:12", "42828", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5379", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 01:34:12", "2026-01-02 01:34:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767317652;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767317652;}", "12", "1", "2026-01-02 01:50:37", "2026-01-01 21:50:37", "42846", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5380", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 02:50:37", "2026-01-02 02:50:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767322237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767322237;}", "12", "1", "2026-01-02 02:51:59", "2026-01-01 22:51:59", "42866", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5381", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 03:51:59", "2026-01-02 03:51:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767325919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767325919;}", "12", "1", "2026-01-02 03:54:01", "2026-01-01 23:54:01", "42884", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5382", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 04:54:01", "2026-01-02 04:54:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767329641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767329641;}", "12", "1", "2026-01-02 04:55:07", "2026-01-02 00:55:07", "42892", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5383", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-02 04:34:51", "2026-01-02 04:34:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767328491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767328491;}", "8", "1", "2026-01-02 04:49:37", "2026-01-02 00:49:37", "42889", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5384", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 05:55:07", "2026-01-02 05:55:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767333307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767333307;}", "12", "1", "2026-01-02 05:56:25", "2026-01-02 01:56:25", "42903", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5385", "woocommerce_refresh_order_count_cache", "complete", "2026-01-02 17:23:07", "2026-01-02 17:23:07", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767374587;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767374587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-02 17:27:46", "2026-01-02 13:27:46", "43007", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5386", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 06:56:25", "2026-01-02 06:56:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767336985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767336985;}", "12", "1", "2026-01-02 06:59:56", "2026-01-02 02:59:56", "42910", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5387", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 07:59:56", "2026-01-02 07:59:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767340796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767340796;}", "12", "1", "2026-01-02 08:12:15", "2026-01-02 04:12:15", "42920", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5388", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 09:12:15", "2026-01-02 09:12:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767345135;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767345135;}", "12", "1", "2026-01-02 09:13:49", "2026-01-02 05:13:49", "42931", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5389", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 10:13:49", "2026-01-02 10:13:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767348829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767348829;}", "12", "1", "2026-01-02 10:22:28", "2026-01-02 06:22:28", "42948", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5390", "wc_admin_daily_wrapper", "complete", "2026-01-03 09:45:09", "2026-01-03 09:45:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767433509;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767433509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-03 09:45:14", "2026-01-03 05:45:14", "43265", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5391", "woocommerce_cleanup_personal_data", "complete", "2026-01-03 09:45:09", "2026-01-03 09:45:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767433509;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767433509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-03 09:45:15", "2026-01-03 05:45:15", "43265", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5392", "woocommerce_cleanup_logs", "complete", "2026-01-03 09:45:10", "2026-01-03 09:45:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767433510;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767433510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-03 09:45:15", "2026-01-03 05:45:15", "43265", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5393", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-03 09:45:10", "2026-01-03 09:45:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767433510;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767433510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-03 09:45:15", "2026-01-03 05:45:15", "43265", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5395", "generate_category_lookup_table_wrapper", "complete", "2026-01-02 09:45:20", "2026-01-02 09:45:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767347120;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767347120;}", "12", "1", "2026-01-02 09:45:53", "2026-01-02 05:45:53", "42936", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5396", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-03 09:45:10", "2026-01-03 09:45:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767433510;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767433510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-03 09:45:15", "2026-01-03 05:45:15", "43265", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5397", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 11:22:28", "2026-01-02 11:22:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767352948;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767352948;}", "12", "1", "2026-01-02 11:35:41", "2026-01-02 07:35:41", "42956", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5398", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 12:35:41", "2026-01-02 12:35:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767357341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767357341;}", "12", "1", "2026-01-02 12:40:42", "2026-01-02 08:40:42", "42962", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5399", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 13:40:41", "2026-01-02 13:40:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767361241;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767361241;}", "12", "1", "2026-01-02 13:41:52", "2026-01-02 09:41:52", "42969", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5400", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 14:41:52", "2026-01-02 14:41:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767364912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767364912;}", "12", "1", "2026-01-02 14:53:05", "2026-01-02 10:53:05", "42980", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5401", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 15:53:05", "2026-01-02 15:53:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767369185;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767369185;}", "12", "1", "2026-01-02 15:54:54", "2026-01-02 11:54:54", "42992", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5402", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 16:54:54", "2026-01-02 16:54:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767372894;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767372894;}", "12", "1", "2026-01-02 16:57:41", "2026-01-02 12:57:41", "43003", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5403", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-02 16:21:07", "2026-01-02 16:21:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767370867;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767370867;}", "8", "1", "2026-01-02 16:27:35", "2026-01-02 12:27:35", "42999", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5404", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 17:57:41", "2026-01-02 17:57:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767376661;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767376661;}", "12", "1", "2026-01-02 17:58:17", "2026-01-02 13:58:17", "43010", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5405", "woocommerce_cleanup_draft_orders", "complete", "2026-01-03 17:16:07", "2026-01-03 17:16:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767460567;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767460567;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-03 17:18:15", "2026-01-03 13:18:15", "43406", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5406", "woocommerce_scheduled_sales", "complete", "2026-01-03 17:16:07", "2026-01-03 17:16:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767460567;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767460567;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-03 17:18:15", "2026-01-03 13:18:15", "43406", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5407", "woocommerce_refresh_order_count_cache", "complete", "2026-01-03 05:27:46", "2026-01-03 05:27:46", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767418066;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767418066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-03 05:28:01", "2026-01-03 01:28:01", "43168", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5408", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 18:58:17", "2026-01-02 18:58:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767380297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767380297;}", "12", "1", "2026-01-02 18:58:31", "2026-01-02 14:58:31", "43016", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5409", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 19:58:31", "2026-01-02 19:58:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767383911;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767383911;}", "12", "1", "2026-01-02 19:58:45", "2026-01-02 15:58:45", "43020", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5410", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 20:58:45", "2026-01-02 20:58:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767387525;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767387525;}", "12", "1", "2026-01-02 21:00:24", "2026-01-02 17:00:24", "43024", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5411", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 22:00:24", "2026-01-02 22:00:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767391224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767391224;}", "12", "1", "2026-01-02 22:01:41", "2026-01-02 18:01:41", "43032", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5412", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-02 23:01:41", "2026-01-02 23:01:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767394901;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767394901;}", "12", "1", "2026-01-02 23:02:47", "2026-01-02 19:02:47", "43042", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5413", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 00:02:47", "2026-01-03 00:02:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767398567;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767398567;}", "12", "1", "2026-01-03 00:04:21", "2026-01-02 20:04:21", "43058", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5414", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 01:04:21", "2026-01-03 01:04:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767402261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767402261;}", "12", "1", "2026-01-03 01:05:55", "2026-01-02 21:05:55", "43071", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5415", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 02:05:55", "2026-01-03 02:05:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767405955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767405955;}", "12", "1", "2026-01-03 02:07:26", "2026-01-02 22:07:26", "43084", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5416", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 03:07:26", "2026-01-03 03:07:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767409646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767409646;}", "12", "1", "2026-01-03 03:08:18", "2026-01-02 23:08:18", "43094", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5417", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 04:08:18", "2026-01-03 04:08:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767413298;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767413298;}", "12", "1", "2026-01-03 04:09:12", "2026-01-03 00:09:12", "43108", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5418", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 05:09:12", "2026-01-03 05:09:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767416952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767416952;}", "12", "1", "2026-01-03 05:10:25", "2026-01-03 01:10:25", "43151", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5419", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-03 04:19:43", "2026-01-03 04:19:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767413983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767413983;}", "8", "1", "2026-01-03 04:19:43", "2026-01-03 00:19:43", "43110", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5420", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 06:10:25", "2026-01-03 06:10:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767420625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767420625;}", "12", "1", "2026-01-03 06:10:27", "2026-01-03 02:10:27", "43203", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5421", "woocommerce_refresh_order_count_cache", "complete", "2026-01-03 17:28:01", "2026-01-03 17:28:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767461281;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767461281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-03 17:28:44", "2026-01-03 13:28:44", "43410", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5422", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 07:10:27", "2026-01-03 07:10:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767424227;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767424227;}", "12", "1", "2026-01-03 07:12:28", "2026-01-03 03:12:28", "43236", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5423", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 08:12:28", "2026-01-03 08:12:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767427948;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767427948;}", "12", "1", "2026-01-03 08:13:37", "2026-01-03 04:13:37", "43247", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5424", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 09:13:37", "2026-01-03 09:13:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767431617;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767431617;}", "12", "1", "2026-01-03 09:14:34", "2026-01-03 05:14:34", "43257", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5425", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 10:14:34", "2026-01-03 10:14:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767435274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767435274;}", "12", "1", "2026-01-03 10:16:30", "2026-01-03 06:16:30", "43280", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5426", "wc_admin_daily_wrapper", "complete", "2026-01-04 09:45:14", "2026-01-04 09:45:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519914;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-04 09:48:26", "2026-01-04 05:48:26", "43526", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5427", "woocommerce_cleanup_personal_data", "complete", "2026-01-04 09:45:15", "2026-01-04 09:45:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519915;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-04 09:48:27", "2026-01-04 05:48:27", "43526", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5428", "woocommerce_cleanup_logs", "complete", "2026-01-04 09:45:15", "2026-01-04 09:45:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519915;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-04 09:48:27", "2026-01-04 05:48:27", "43526", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5429", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-04 09:45:15", "2026-01-04 09:45:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519915;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-04 09:48:27", "2026-01-04 05:48:27", "43526", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5431", "generate_category_lookup_table_wrapper", "complete", "2026-01-03 09:45:25", "2026-01-03 09:45:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767433525;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767433525;}", "12", "1", "2026-01-03 09:45:57", "2026-01-03 05:45:57", "43267", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5432", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-04 09:45:15", "2026-01-04 09:45:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767519915;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767519915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-04 09:48:27", "2026-01-04 05:48:27", "43526", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5433", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 11:16:30", "2026-01-03 11:16:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767438990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767438990;}", "12", "1", "2026-01-03 11:17:54", "2026-01-03 07:17:54", "43299", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5434", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 12:17:54", "2026-01-03 12:17:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767442674;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767442674;}", "12", "1", "2026-01-03 12:27:09", "2026-01-03 08:27:09", "43324", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5435", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 13:27:09", "2026-01-03 13:27:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767446829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767446829;}", "12", "1", "2026-01-03 13:31:51", "2026-01-03 09:31:51", "43339", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5436", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 14:31:51", "2026-01-03 14:31:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767450711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767450711;}", "12", "1", "2026-01-03 14:36:53", "2026-01-03 10:36:53", "43356", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5437", "woocommerce_geoip_updater", "complete", "2026-01-18 14:16:21", "2026-01-18 14:16:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768745781;s:18:\"\0*\0first_timestamp\";i:1755776236;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768745781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "12", "1", "2026-01-18 14:17:32", "2026-01-18 10:17:32", "46805", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5438", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 15:36:53", "2026-01-03 15:36:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767454613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767454613;}", "12", "1", "2026-01-03 15:37:34", "2026-01-03 11:37:34", "43376", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5439", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 16:37:34", "2026-01-03 16:37:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767458254;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767458254;}", "12", "1", "2026-01-03 16:38:38", "2026-01-03 12:38:38", "43394", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5440", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-03 16:11:11", "2026-01-03 16:11:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767456671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767456671;}", "8", "1", "2026-01-03 16:18:51", "2026-01-03 12:18:51", "43386", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5441", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 17:38:38", "2026-01-03 17:38:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767461918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767461918;}", "12", "1", "2026-01-03 17:40:45", "2026-01-03 13:40:45", "43415", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5442", "woocommerce_cleanup_draft_orders", "complete", "2026-01-04 17:18:15", "2026-01-04 17:18:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767547095;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767547095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-04 17:31:46", "2026-01-04 13:31:46", "43594", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5443", "woocommerce_scheduled_sales", "complete", "2026-01-04 17:18:15", "2026-01-04 17:18:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767547095;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767547095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-04 17:31:46", "2026-01-04 13:31:46", "43594", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5444", "woocommerce_refresh_order_count_cache", "complete", "2026-01-04 05:28:44", "2026-01-04 05:28:44", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767504524;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767504524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-04 05:37:36", "2026-01-04 01:37:36", "43495", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5445", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 18:40:45", "2026-01-03 18:40:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767465645;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767465645;}", "12", "1", "2026-01-03 18:46:21", "2026-01-03 14:46:21", "43428", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5446", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 19:46:21", "2026-01-03 19:46:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767469581;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767469581;}", "12", "1", "2026-01-03 19:47:31", "2026-01-03 15:47:31", "43440", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5447", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 20:47:31", "2026-01-03 20:47:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767473251;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767473251;}", "12", "1", "2026-01-03 20:49:44", "2026-01-03 16:49:44", "43450", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5448", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 21:49:44", "2026-01-03 21:49:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767476984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767476984;}", "12", "1", "2026-01-03 22:08:44", "2026-01-03 18:08:44", "43457", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5449", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-03 23:08:44", "2026-01-03 23:08:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767481724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767481724;}", "12", "1", "2026-01-03 23:11:00", "2026-01-03 19:11:00", "43463", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5450", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 00:11:00", "2026-01-04 00:11:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767485460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767485460;}", "12", "1", "2026-01-04 00:13:23", "2026-01-03 20:13:23", "43467", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5451", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 01:13:23", "2026-01-04 01:13:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767489203;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767489203;}", "12", "1", "2026-01-04 01:16:20", "2026-01-03 21:16:20", "43474", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5452", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 02:16:20", "2026-01-04 02:16:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767492980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767492980;}", "12", "1", "2026-01-04 02:18:39", "2026-01-03 22:18:39", "43479", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5453", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 03:18:39", "2026-01-04 03:18:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767496719;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767496719;}", "12", "1", "2026-01-04 03:20:51", "2026-01-03 23:20:51", "43483", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5454", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 04:20:51", "2026-01-04 04:20:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767500451;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767500451;}", "12", "1", "2026-01-04 04:23:16", "2026-01-04 00:23:16", "43487", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5455", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 05:23:16", "2026-01-04 05:23:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767504196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767504196;}", "12", "1", "2026-01-04 05:25:08", "2026-01-04 01:25:08", "43493", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5456", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-04 04:23:16", "2026-01-04 04:23:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767500596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767500596;}", "8", "1", "2026-01-04 04:54:06", "2026-01-04 00:54:06", "43489", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5457", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 06:25:08", "2026-01-04 06:25:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767507908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767507908;}", "12", "1", "2026-01-04 06:27:01", "2026-01-04 02:27:01", "43498", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5458", "woocommerce_refresh_order_count_cache", "complete", "2026-01-04 17:37:36", "2026-01-04 17:37:36", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767548256;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767548256;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-04 17:37:49", "2026-01-04 13:37:49", "43600", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5459", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 07:27:01", "2026-01-04 07:27:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767511621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767511621;}", "12", "1", "2026-01-04 07:29:05", "2026-01-04 03:29:05", "43502", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5460", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 08:29:05", "2026-01-04 08:29:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767515345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767515345;}", "12", "1", "2026-01-04 08:31:06", "2026-01-04 04:31:06", "43517", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5461", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 09:31:06", "2026-01-04 09:31:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767519066;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767519066;}", "12", "1", "2026-01-04 09:32:53", "2026-01-04 05:32:53", "43524", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5462", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 10:32:53", "2026-01-04 10:32:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767522773;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767522773;}", "12", "1", "2026-01-04 10:34:51", "2026-01-04 06:34:51", "43542", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5463", "wc_admin_daily_wrapper", "complete", "2026-01-05 09:48:26", "2026-01-05 09:48:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606506;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-05 09:53:52", "2026-01-05 05:53:52", "43807", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5464", "woocommerce_cleanup_personal_data", "complete", "2026-01-05 09:48:27", "2026-01-05 09:48:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606507;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-05 09:53:53", "2026-01-05 05:53:53", "43807", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5465", "woocommerce_cleanup_logs", "complete", "2026-01-05 09:48:27", "2026-01-05 09:48:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606507;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-05 09:53:53", "2026-01-05 05:53:53", "43807", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5466", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-05 09:48:27", "2026-01-05 09:48:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606507;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-05 09:53:53", "2026-01-05 05:53:53", "43807", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5468", "generate_category_lookup_table_wrapper", "complete", "2026-01-04 09:48:37", "2026-01-04 09:48:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767520117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767520117;}", "12", "1", "2026-01-04 09:57:59", "2026-01-04 05:57:59", "43528", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5469", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-05 09:48:27", "2026-01-05 09:48:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767606507;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767606507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-05 09:53:53", "2026-01-05 05:53:53", "43807", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5470", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 11:34:51", "2026-01-04 11:34:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767526491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767526491;}", "12", "1", "2026-01-04 11:36:13", "2026-01-04 07:36:13", "43547", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5471", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 12:36:13", "2026-01-04 12:36:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767530173;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767530173;}", "12", "1", "2026-01-04 12:37:32", "2026-01-04 08:37:32", "43553", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5472", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 13:37:32", "2026-01-04 13:37:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767533852;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767533852;}", "12", "1", "2026-01-04 13:39:19", "2026-01-04 09:39:19", "43561", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5473", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 14:39:19", "2026-01-04 14:39:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767537559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767537559;}", "12", "1", "2026-01-04 14:40:46", "2026-01-04 10:40:46", "43567", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5474", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 15:40:46", "2026-01-04 15:40:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767541246;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767541246;}", "12", "1", "2026-01-04 15:42:34", "2026-01-04 11:42:34", "43574", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5475", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 16:42:34", "2026-01-04 16:42:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767544954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767544954;}", "12", "1", "2026-01-04 16:44:22", "2026-01-04 12:44:22", "43587", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5476", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-04 16:13:27", "2026-01-04 16:13:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767543207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767543207;}", "8", "1", "2026-01-04 16:27:06", "2026-01-04 12:27:06", "43585", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5477", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 17:44:22", "2026-01-04 17:44:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767548662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767548662;}", "12", "1", "2026-01-04 17:45:54", "2026-01-04 13:45:54", "43607", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5478", "woocommerce_cleanup_draft_orders", "complete", "2026-01-05 17:31:46", "2026-01-05 17:31:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767634306;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767634306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-05 17:39:34", "2026-01-05 13:39:34", "43902", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5479", "woocommerce_scheduled_sales", "complete", "2026-01-05 17:31:46", "2026-01-05 17:31:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767634306;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767634306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-05 17:39:34", "2026-01-05 13:39:34", "43902", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5480", "woocommerce_refresh_order_count_cache", "complete", "2026-01-05 05:37:49", "2026-01-05 05:37:49", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767591469;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767591469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-05 05:47:39", "2026-01-05 01:47:39", "43781", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5481", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 18:45:54", "2026-01-04 18:45:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767552354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767552354;}", "12", "1", "2026-01-04 18:47:18", "2026-01-04 14:47:18", "43613", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5482", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 19:47:18", "2026-01-04 19:47:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767556038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767556038;}", "12", "1", "2026-01-04 19:49:09", "2026-01-04 15:49:09", "43626", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5483", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 20:49:09", "2026-01-04 20:49:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767559749;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767559749;}", "12", "1", "2026-01-04 20:49:50", "2026-01-04 16:49:50", "43635", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5484", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 21:49:50", "2026-01-04 21:49:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767563390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767563390;}", "12", "1", "2026-01-04 21:50:14", "2026-01-04 17:50:14", "43674", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5485", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 22:50:14", "2026-01-04 22:50:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767567014;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767567014;}", "12", "1", "2026-01-04 22:50:57", "2026-01-04 18:50:57", "43718", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5486", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-04 23:50:57", "2026-01-04 23:50:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767570657;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767570657;}", "12", "1", "2026-01-04 23:54:59", "2026-01-04 19:54:59", "43748", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5487", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 00:54:59", "2026-01-05 00:54:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767574499;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767574499;}", "12", "1", "2026-01-05 00:55:04", "2026-01-04 20:55:04", "43753", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5488", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 01:55:04", "2026-01-05 01:55:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767578104;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767578104;}", "12", "1", "2026-01-05 01:57:46", "2026-01-04 21:57:46", "43761", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5489", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 02:57:46", "2026-01-05 02:57:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767581866;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767581866;}", "12", "1", "2026-01-05 02:59:03", "2026-01-04 22:59:03", "43768", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5490", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 03:59:03", "2026-01-05 03:59:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767585543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767585543;}", "12", "1", "2026-01-05 03:59:28", "2026-01-04 23:59:28", "43773", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5491", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 04:59:28", "2026-01-05 04:59:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767589168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767589168;}", "12", "1", "2026-01-05 05:00:06", "2026-01-05 01:00:06", "43778", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5492", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-05 04:29:55", "2026-01-05 04:29:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767587395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767587395;}", "8", "1", "2026-01-05 04:49:51", "2026-01-05 00:49:51", "43776", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5493", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 06:00:06", "2026-01-05 06:00:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767592806;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767592806;}", "12", "1", "2026-01-05 06:00:43", "2026-01-05 02:00:43", "43783", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5494", "woocommerce_refresh_order_count_cache", "complete", "2026-01-05 17:47:39", "2026-01-05 17:47:39", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767635259;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767635259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-05 17:56:33", "2026-01-05 13:56:33", "43905", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5495", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 07:00:43", "2026-01-05 07:00:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767596443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767596443;}", "12", "1", "2026-01-05 07:01:05", "2026-01-05 03:01:05", "43790", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5496", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 08:01:05", "2026-01-05 08:01:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767600065;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767600065;}", "12", "1", "2026-01-05 08:01:31", "2026-01-05 04:01:31", "43797", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5497", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 09:01:31", "2026-01-05 09:01:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767603691;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767603691;}", "12", "1", "2026-01-05 09:12:14", "2026-01-05 05:12:14", "43803", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5498", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 10:12:14", "2026-01-05 10:12:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767607934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767607934;}", "12", "1", "2026-01-05 10:14:25", "2026-01-05 06:14:25", "43812", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5499", "wc_admin_daily_wrapper", "complete", "2026-01-06 09:53:52", "2026-01-06 09:53:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767693232;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767693232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-06 09:55:34", "2026-01-06 05:55:34", "44096", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5500", "woocommerce_cleanup_personal_data", "complete", "2026-01-06 09:53:53", "2026-01-06 09:53:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767693233;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767693233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-06 09:55:35", "2026-01-06 05:55:35", "44096", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5501", "woocommerce_cleanup_logs", "complete", "2026-01-06 09:53:53", "2026-01-06 09:53:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767693233;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767693233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-06 09:55:35", "2026-01-06 05:55:35", "44096", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5502", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-06 09:53:53", "2026-01-06 09:53:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767693233;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767693233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-06 09:55:35", "2026-01-06 05:55:35", "44096", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5504", "generate_category_lookup_table_wrapper", "complete", "2026-01-05 09:54:03", "2026-01-05 09:54:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767606843;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767606843;}", "12", "1", "2026-01-05 10:01:53", "2026-01-05 06:01:53", "43809", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5505", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-06 09:53:53", "2026-01-06 09:53:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767693233;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767693233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-06 09:55:35", "2026-01-06 05:55:35", "44096", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5506", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 11:14:25", "2026-01-05 11:14:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767611665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767611665;}", "12", "1", "2026-01-05 11:19:08", "2026-01-05 07:19:08", "43827", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5507", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 12:19:08", "2026-01-05 12:19:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767615548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767615548;}", "12", "1", "2026-01-05 12:23:06", "2026-01-05 08:23:06", "43835", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5508", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 13:23:06", "2026-01-05 13:23:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767619386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767619386;}", "12", "1", "2026-01-05 13:28:14", "2026-01-05 09:28:14", "43841", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5509", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 14:28:14", "2026-01-05 14:28:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767623294;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767623294;}", "12", "1", "2026-01-05 14:35:28", "2026-01-05 10:35:28", "43853", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5510", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 15:35:28", "2026-01-05 15:35:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767627328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767627328;}", "12", "1", "2026-01-05 15:36:45", "2026-01-05 11:36:45", "43861", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5511", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 16:36:45", "2026-01-05 16:36:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767631005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767631005;}", "12", "1", "2026-01-05 16:38:09", "2026-01-05 12:38:09", "43893", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5512", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-05 16:09:46", "2026-01-05 16:09:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767629386;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767629386;}", "8", "1", "2026-01-05 16:09:51", "2026-01-05 12:09:51", "43884", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5513", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 17:38:09", "2026-01-05 17:38:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767634689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767634689;}", "12", "1", "2026-01-05 17:39:34", "2026-01-05 13:39:34", "43902", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5514", "woocommerce_cleanup_draft_orders", "complete", "2026-01-06 17:39:34", "2026-01-06 17:39:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767721174;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767721174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-06 17:45:34", "2026-01-06 13:45:34", "44167", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5515", "woocommerce_scheduled_sales", "complete", "2026-01-06 17:39:34", "2026-01-06 17:39:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767721174;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767721174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-06 17:45:34", "2026-01-06 13:45:34", "44167", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5516", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 18:39:34", "2026-01-05 18:39:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767638374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767638374;}", "12", "1", "2026-01-05 18:40:49", "2026-01-05 14:40:49", "43910", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5517", "woocommerce_refresh_order_count_cache", "complete", "2026-01-06 05:56:33", "2026-01-06 05:56:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767678993;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767678993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-06 06:19:44", "2026-01-06 02:19:44", "44071", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5518", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 19:40:49", "2026-01-05 19:40:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767642049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767642049;}", "12", "1", "2026-01-05 19:42:15", "2026-01-05 15:42:15", "43914", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5519", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 20:42:15", "2026-01-05 20:42:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767645735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767645735;}", "12", "1", "2026-01-05 20:44:19", "2026-01-05 16:44:19", "43918", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5520", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 21:44:19", "2026-01-05 21:44:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767649459;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767649459;}", "12", "1", "2026-01-05 21:46:47", "2026-01-05 17:46:47", "43921", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5521", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 22:46:47", "2026-01-05 22:46:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767653207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767653207;}", "12", "1", "2026-01-05 22:48:32", "2026-01-05 18:48:32", "43925", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5522", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-05 23:48:32", "2026-01-05 23:48:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767656912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767656912;}", "12", "1", "2026-01-05 23:50:25", "2026-01-05 19:50:25", "43929", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5523", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 00:50:25", "2026-01-06 00:50:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767660625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767660625;}", "12", "1", "2026-01-06 00:50:41", "2026-01-05 20:50:41", "43936", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5524", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 01:50:41", "2026-01-06 01:50:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767664241;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767664241;}", "12", "1", "2026-01-06 01:54:06", "2026-01-05 21:54:06", "43945", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5525", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 02:54:06", "2026-01-06 02:54:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767668046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767668046;}", "12", "1", "2026-01-06 02:54:12", "2026-01-05 22:54:12", "43986", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5526", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 03:54:12", "2026-01-06 03:54:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767671652;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767671652;}", "12", "1", "2026-01-06 03:56:16", "2026-01-05 23:56:16", "44041", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5527", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 04:56:16", "2026-01-06 04:56:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767675376;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767675376;}", "12", "1", "2026-01-06 04:57:58", "2026-01-06 00:57:58", "44064", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5528", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-06 04:10:17", "2026-01-06 04:10:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767672617;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767672617;}", "8", "1", "2026-01-06 04:11:18", "2026-01-06 00:11:18", "44054", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5529", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 05:57:58", "2026-01-06 05:57:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767679078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767679078;}", "12", "1", "2026-01-06 06:19:44", "2026-01-06 02:19:44", "44071", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5530", "woocommerce_refresh_order_count_cache", "complete", "2026-01-06 18:19:44", "2026-01-06 18:19:44", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767723584;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767723584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-06 18:35:38", "2026-01-06 14:35:38", "44173", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5531", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 07:19:44", "2026-01-06 07:19:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767683984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767683984;}", "12", "1", "2026-01-06 07:37:51", "2026-01-06 03:37:51", "44076", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5532", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 08:37:51", "2026-01-06 08:37:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767688671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767688671;}", "12", "1", "2026-01-06 08:48:39", "2026-01-06 04:48:39", "44087", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5533", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 09:48:39", "2026-01-06 09:48:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767692919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767692919;}", "12", "1", "2026-01-06 09:49:43", "2026-01-06 05:49:43", "44091", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5534", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 10:49:43", "2026-01-06 10:49:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767696583;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767696583;}", "12", "1", "2026-01-06 10:59:25", "2026-01-06 06:59:25", "44115", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5535", "wc_admin_daily_wrapper", "complete", "2026-01-07 09:55:34", "2026-01-07 09:55:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767779734;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767779734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-07 09:56:23", "2026-01-07 05:56:23", "44260", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5536", "woocommerce_cleanup_personal_data", "complete", "2026-01-07 09:55:35", "2026-01-07 09:55:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767779735;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767779735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-07 09:56:24", "2026-01-07 05:56:24", "44260", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5537", "woocommerce_cleanup_logs", "complete", "2026-01-07 09:55:35", "2026-01-07 09:55:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767779735;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767779735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-07 09:56:24", "2026-01-07 05:56:24", "44260", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5538", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-07 09:55:35", "2026-01-07 09:55:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767779735;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767779735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-07 09:56:24", "2026-01-07 05:56:24", "44260", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5540", "generate_category_lookup_table_wrapper", "complete", "2026-01-06 09:55:45", "2026-01-06 09:55:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767693345;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767693345;}", "12", "1", "2026-01-06 09:56:10", "2026-01-06 05:56:10", "44098", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5541", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-07 09:55:35", "2026-01-07 09:55:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767779735;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767779735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-07 09:56:24", "2026-01-07 05:56:24", "44260", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5542", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 11:59:25", "2026-01-06 11:59:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767700765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767700765;}", "12", "1", "2026-01-06 12:20:47", "2026-01-06 08:20:47", "44127", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5543", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 13:20:47", "2026-01-06 13:20:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767705647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767705647;}", "12", "1", "2026-01-06 13:26:51", "2026-01-06 09:26:51", "44134", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5544", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 14:26:51", "2026-01-06 14:26:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767709611;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767709611;}", "12", "1", "2026-01-06 14:28:35", "2026-01-06 10:28:35", "44139", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5545", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 15:28:35", "2026-01-06 15:28:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767713315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767713315;}", "12", "1", "2026-01-06 15:30:21", "2026-01-06 11:30:21", "44150", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5546", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 16:30:21", "2026-01-06 16:30:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767717021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767717021;}", "12", "1", "2026-01-06 16:31:58", "2026-01-06 12:31:58", "44157", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5547", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-06 16:15:01", "2026-01-06 16:15:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767716101;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767716101;}", "8", "1", "2026-01-06 16:21:16", "2026-01-06 12:21:16", "44155", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5548", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 17:31:58", "2026-01-06 17:31:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767720718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767720718;}", "12", "1", "2026-01-06 17:33:42", "2026-01-06 13:33:42", "44165", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5549", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 18:33:42", "2026-01-06 18:33:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767724422;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767724422;}", "12", "1", "2026-01-06 18:35:38", "2026-01-06 14:35:38", "44173", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5550", "woocommerce_cleanup_draft_orders", "complete", "2026-01-07 17:45:34", "2026-01-07 17:45:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767807934;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767807934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-07 17:53:26", "2026-01-07 13:53:26", "44315", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5551", "woocommerce_scheduled_sales", "complete", "2026-01-07 17:45:34", "2026-01-07 17:45:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767807934;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767807934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-07 17:53:26", "2026-01-07 13:53:26", "44315", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5552", "woocommerce_refresh_order_count_cache", "complete", "2026-01-07 06:35:38", "2026-01-07 06:35:38", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767767738;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767767738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-07 06:55:09", "2026-01-07 02:55:09", "44237", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5553", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 19:35:38", "2026-01-06 19:35:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767728138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767728138;}", "12", "1", "2026-01-06 19:36:59", "2026-01-06 15:36:59", "44176", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5554", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 20:36:59", "2026-01-06 20:36:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767731819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767731819;}", "12", "1", "2026-01-06 20:38:24", "2026-01-06 16:38:24", "44180", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5555", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 21:38:24", "2026-01-06 21:38:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767735504;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767735504;}", "12", "1", "2026-01-06 21:39:54", "2026-01-06 17:39:54", "44186", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5556", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 22:39:54", "2026-01-06 22:39:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767739194;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767739194;}", "12", "1", "2026-01-06 22:40:53", "2026-01-06 18:40:53", "44192", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5557", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 23:40:53", "2026-01-06 23:40:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767742853;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767742853;}", "12", "1", "2026-01-06 23:42:07", "2026-01-06 19:42:07", "44198", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5558", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 00:42:07", "2026-01-07 00:42:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767746527;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767746527;}", "12", "1", "2026-01-07 00:44:02", "2026-01-06 20:44:02", "44201", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5559", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 01:44:02", "2026-01-07 01:44:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767750242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767750242;}", "12", "1", "2026-01-07 01:45:53", "2026-01-06 21:45:53", "44205", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5560", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 02:45:53", "2026-01-07 02:45:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767753953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767753953;}", "12", "1", "2026-01-07 02:48:16", "2026-01-06 22:48:16", "44213", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5561", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 03:48:16", "2026-01-07 03:48:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767757696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767757696;}", "12", "1", "2026-01-07 03:50:39", "2026-01-06 23:50:39", "44218", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5562", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 04:50:39", "2026-01-07 04:50:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767761439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767761439;}", "12", "1", "2026-01-07 04:51:55", "2026-01-07 00:51:55", "44224", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5563", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-07 04:21:19", "2026-01-07 04:21:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767759679;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767759679;}", "8", "1", "2026-01-07 04:51:55", "2026-01-07 00:51:55", "44224", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5564", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 05:51:55", "2026-01-07 05:51:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767765115;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767765115;}", "12", "1", "2026-01-07 05:53:19", "2026-01-07 01:53:19", "44232", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5565", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 06:53:19", "2026-01-07 06:53:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767768799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767768799;}", "12", "1", "2026-01-07 06:55:09", "2026-01-07 02:55:09", "44237", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5566", "woocommerce_refresh_order_count_cache", "complete", "2026-01-07 18:55:09", "2026-01-07 18:55:09", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767812109;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767812109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-07 19:16:13", "2026-01-07 15:16:13", "44322", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5567", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 07:55:09", "2026-01-07 07:55:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767772509;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767772509;}", "12", "1", "2026-01-07 07:56:36", "2026-01-07 03:56:36", "44248", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5568", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 08:56:36", "2026-01-07 08:56:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767776196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767776196;}", "12", "1", "2026-01-07 08:58:05", "2026-01-07 04:58:05", "44255", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5569", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 09:58:05", "2026-01-07 09:58:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767779885;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767779885;}", "12", "1", "2026-01-07 10:00:35", "2026-01-07 06:00:35", "44262", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5570", "wc_admin_daily_wrapper", "complete", "2026-01-08 09:56:23", "2026-01-08 09:56:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767866183;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767866183;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-08 10:03:06", "2026-01-08 06:03:06", "44422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5571", "woocommerce_cleanup_personal_data", "complete", "2026-01-08 09:56:24", "2026-01-08 09:56:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767866184;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767866184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-08 10:03:07", "2026-01-08 06:03:07", "44422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5572", "woocommerce_cleanup_logs", "complete", "2026-01-08 09:56:24", "2026-01-08 09:56:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767866184;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767866184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-08 10:03:07", "2026-01-08 06:03:07", "44422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5573", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-08 09:56:24", "2026-01-08 09:56:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767866184;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767866184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-08 10:03:07", "2026-01-08 06:03:07", "44422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5574", "woocommerce_cleanup_sessions", "complete", "2026-01-08 10:00:00", "2026-01-08 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767866400;s:18:\"\0*\0first_timestamp\";i:1767866400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767866400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-08 10:03:07", "2026-01-08 06:03:07", "44422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5575", "generate_category_lookup_table_wrapper", "complete", "2026-01-07 09:56:34", "2026-01-07 09:56:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767779794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767779794;}", "12", "1", "2026-01-07 10:00:35", "2026-01-07 06:00:35", "44262", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5576", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-08 09:56:24", "2026-01-08 09:56:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767866184;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767866184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-08 10:03:07", "2026-01-08 06:03:07", "44422", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5577", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 11:00:35", "2026-01-07 11:00:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767783635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767783635;}", "12", "1", "2026-01-07 11:02:33", "2026-01-07 07:02:33", "44278", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5578", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 12:02:33", "2026-01-07 12:02:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767787353;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767787353;}", "12", "1", "2026-01-07 12:04:43", "2026-01-07 08:04:43", "44282", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5579", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 13:04:43", "2026-01-07 13:04:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767791083;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767791083;}", "12", "1", "2026-01-07 13:06:30", "2026-01-07 09:06:30", "44291", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5580", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 14:06:30", "2026-01-07 14:06:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767794790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767794790;}", "12", "1", "2026-01-07 14:07:54", "2026-01-07 10:07:54", "44296", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5581", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 15:07:54", "2026-01-07 15:07:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767798474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767798474;}", "12", "1", "2026-01-07 15:09:24", "2026-01-07 11:09:24", "44302", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5582", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 16:09:24", "2026-01-07 16:09:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767802164;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767802164;}", "12", "1", "2026-01-07 16:12:04", "2026-01-07 12:12:04", "44307", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5583", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 17:12:04", "2026-01-07 17:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767805924;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767805924;}", "12", "1", "2026-01-07 17:20:04", "2026-01-07 13:20:04", "44311", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5584", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-07 16:12:04", "2026-01-07 16:12:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767802324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767802324;}", "8", "1", "2026-01-07 16:42:51", "2026-01-07 12:42:51", "44309", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5585", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 18:20:04", "2026-01-07 18:20:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767810004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767810004;}", "12", "1", "2026-01-07 18:28:04", "2026-01-07 14:28:04", "44319", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5586", "woocommerce_cleanup_draft_orders", "complete", "2026-01-08 17:53:26", "2026-01-08 17:53:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767894806;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767894806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-08 18:02:05", "2026-01-08 14:02:05", "44484", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5587", "woocommerce_scheduled_sales", "complete", "2026-01-08 17:53:26", "2026-01-08 17:53:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767894806;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767894806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-08 18:02:06", "2026-01-08 14:02:06", "44484", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5588", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 19:28:04", "2026-01-07 19:28:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767814084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767814084;}", "12", "1", "2026-01-07 19:44:35", "2026-01-07 15:44:35", "44330", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5589", "woocommerce_refresh_order_count_cache", "complete", "2026-01-08 07:16:13", "2026-01-08 07:16:13", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767856573;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767856573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-08 07:28:49", "2026-01-08 03:28:49", "44400", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5590", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 20:44:35", "2026-01-07 20:44:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767818675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767818675;}", "12", "1", "2026-01-07 20:48:02", "2026-01-07 16:48:02", "44344", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5591", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 21:48:02", "2026-01-07 21:48:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767822482;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767822482;}", "12", "1", "2026-01-07 21:48:46", "2026-01-07 17:48:46", "44351", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5592", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 22:48:46", "2026-01-07 22:48:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767826126;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767826126;}", "12", "1", "2026-01-07 22:49:13", "2026-01-07 18:49:13", "44354", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5593", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-07 23:49:13", "2026-01-07 23:49:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767829753;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767829753;}", "12", "1", "2026-01-07 23:50:40", "2026-01-07 19:50:40", "44360", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5594", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 00:50:40", "2026-01-08 00:50:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767833440;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767833440;}", "12", "1", "2026-01-08 00:51:21", "2026-01-07 20:51:21", "44366", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5595", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 01:51:21", "2026-01-08 01:51:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767837081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767837081;}", "12", "1", "2026-01-08 01:52:38", "2026-01-07 21:52:38", "44370", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5596", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 02:52:38", "2026-01-08 02:52:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767840758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767840758;}", "12", "1", "2026-01-08 02:53:33", "2026-01-07 22:53:33", "44376", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5597", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 03:53:33", "2026-01-08 03:53:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767844413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767844413;}", "12", "1", "2026-01-08 03:54:14", "2026-01-07 23:54:14", "44380", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5598", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 04:54:14", "2026-01-08 04:54:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767848054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767848054;}", "12", "1", "2026-01-08 04:55:10", "2026-01-08 00:55:10", "44387", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5599", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-08 04:24:40", "2026-01-08 04:24:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767846280;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767846280;}", "8", "1", "2026-01-08 04:35:52", "2026-01-08 00:35:52", "44385", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5600", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 05:55:10", "2026-01-08 05:55:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767851710;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767851710;}", "12", "1", "2026-01-08 05:56:29", "2026-01-08 01:56:29", "44394", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5601", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 06:56:29", "2026-01-08 06:56:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767855389;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767855389;}", "12", "1", "2026-01-08 06:57:50", "2026-01-08 02:57:50", "44398", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5602", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 07:57:50", "2026-01-08 07:57:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767859070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767859070;}", "12", "1", "2026-01-08 07:59:30", "2026-01-08 03:59:30", "44402", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5603", "woocommerce_refresh_order_count_cache", "complete", "2026-01-08 19:28:49", "2026-01-08 19:28:49", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767900529;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767900529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-08 19:48:41", "2026-01-08 15:48:41", "44497", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5604", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 08:59:30", "2026-01-08 08:59:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767862770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767862770;}", "12", "1", "2026-01-08 09:01:13", "2026-01-08 05:01:13", "44408", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5605", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 10:01:13", "2026-01-08 10:01:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767866473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767866473;}", "12", "1", "2026-01-08 10:03:07", "2026-01-08 06:03:07", "44422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5606", "wc_admin_daily_wrapper", "complete", "2026-01-09 10:03:06", "2026-01-09 10:03:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767952986;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767952986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-09 10:10:03", "2026-01-09 06:10:03", "44687", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5607", "woocommerce_cleanup_personal_data", "complete", "2026-01-09 10:03:07", "2026-01-09 10:03:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767952987;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767952987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-09 10:10:04", "2026-01-09 06:10:04", "44687", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5608", "woocommerce_cleanup_logs", "complete", "2026-01-09 10:03:07", "2026-01-09 10:03:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767952987;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767952987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-09 10:10:04", "2026-01-09 06:10:04", "44687", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5609", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-09 10:03:07", "2026-01-09 10:03:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767952987;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767952987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-09 10:10:04", "2026-01-09 06:10:04", "44687", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5611", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 11:03:07", "2026-01-08 11:03:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767870187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767870187;}", "12", "1", "2026-01-08 11:04:22", "2026-01-08 07:04:22", "44429", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5612", "woocommerce_cleanup_sessions", "complete", "2026-01-09 10:00:00", "2026-01-09 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767952800;s:18:\"\0*\0first_timestamp\";i:1767952800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767952800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-09 10:00:30", "2026-01-09 06:00:30", "44685", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5613", "generate_category_lookup_table_wrapper", "complete", "2026-01-08 10:03:17", "2026-01-08 10:03:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767866597;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767866597;}", "12", "1", "2026-01-08 10:08:12", "2026-01-08 06:08:12", "44424", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5614", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-09 10:03:07", "2026-01-09 10:03:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767952987;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767952987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-09 10:10:04", "2026-01-09 06:10:04", "44687", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5615", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 12:04:22", "2026-01-08 12:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767873862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767873862;}", "12", "1", "2026-01-08 12:05:51", "2026-01-08 08:05:51", "44437", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5616", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 13:05:51", "2026-01-08 13:05:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767877551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767877551;}", "12", "1", "2026-01-08 13:07:14", "2026-01-08 09:07:14", "44444", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5617", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 14:07:14", "2026-01-08 14:07:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767881234;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767881234;}", "12", "1", "2026-01-08 14:08:43", "2026-01-08 10:08:43", "44451", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5618", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 15:08:43", "2026-01-08 15:08:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767884923;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767884923;}", "12", "1", "2026-01-08 15:10:22", "2026-01-08 11:10:22", "44457", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5619", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 16:10:22", "2026-01-08 16:10:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767888622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767888622;}", "12", "1", "2026-01-08 16:11:17", "2026-01-08 12:11:17", "44472", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5620", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-08 16:10:07", "2026-01-08 16:10:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767888607;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767888607;}", "8", "1", "2026-01-08 16:11:17", "2026-01-08 12:11:17", "44472", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5621", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 17:11:17", "2026-01-08 17:11:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767892277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767892277;}", "12", "1", "2026-01-08 17:14:34", "2026-01-08 13:14:34", "44481", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5622", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 18:14:34", "2026-01-08 18:14:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767896074;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767896074;}", "12", "1", "2026-01-08 18:15:58", "2026-01-08 14:15:58", "44488", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5623", "woocommerce_cleanup_draft_orders", "complete", "2026-01-09 18:02:05", "2026-01-09 18:02:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767981725;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767981725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-09 18:10:32", "2026-01-09 14:10:32", "44754", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5624", "woocommerce_scheduled_sales", "complete", "2026-01-09 18:02:06", "2026-01-09 18:02:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767981726;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767981726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-09 18:10:32", "2026-01-09 14:10:32", "44754", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5625", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 19:15:58", "2026-01-08 19:15:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767899758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767899758;}", "12", "1", "2026-01-08 19:16:37", "2026-01-08 15:16:37", "44493", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5626", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 20:16:37", "2026-01-08 20:16:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767903397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767903397;}", "12", "1", "2026-01-08 20:20:28", "2026-01-08 16:20:28", "44500", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5627", "woocommerce_refresh_order_count_cache", "complete", "2026-01-09 07:48:41", "2026-01-09 07:48:41", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767944921;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767944921;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-09 08:07:18", "2026-01-09 04:07:18", "44660", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5628", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 21:20:28", "2026-01-08 21:20:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767907228;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767907228;}", "12", "1", "2026-01-08 21:22:25", "2026-01-08 17:22:25", "44509", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5629", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 22:22:25", "2026-01-08 22:22:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767910945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767910945;}", "12", "1", "2026-01-08 22:24:52", "2026-01-08 18:24:52", "44552", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5630", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-08 23:24:52", "2026-01-08 23:24:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767914692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767914692;}", "12", "1", "2026-01-08 23:26:00", "2026-01-08 19:26:00", "44597", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5631", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 00:26:00", "2026-01-09 00:26:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767918360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767918360;}", "12", "1", "2026-01-09 00:29:36", "2026-01-08 20:29:36", "44620", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5632", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 01:29:36", "2026-01-09 01:29:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767922176;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767922176;}", "12", "1", "2026-01-09 01:31:10", "2026-01-08 21:31:10", "44626", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5633", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 02:31:10", "2026-01-09 02:31:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767925870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767925870;}", "12", "1", "2026-01-09 02:32:08", "2026-01-08 22:32:08", "44630", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5634", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 03:32:08", "2026-01-09 03:32:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767929528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767929528;}", "12", "1", "2026-01-09 03:33:06", "2026-01-08 23:33:06", "44636", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5635", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 04:33:06", "2026-01-09 04:33:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767933186;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767933186;}", "12", "1", "2026-01-09 04:35:26", "2026-01-09 00:35:26", "44640", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5636", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 05:35:26", "2026-01-09 05:35:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767936926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767936926;}", "12", "1", "2026-01-09 05:36:38", "2026-01-09 01:36:38", "44649", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5637", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-09 04:35:26", "2026-01-09 04:35:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767933326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767933326;}", "8", "1", "2026-01-09 04:49:33", "2026-01-09 00:49:33", "44642", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5638", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 06:36:38", "2026-01-09 06:36:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767940598;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767940598;}", "12", "1", "2026-01-09 06:36:45", "2026-01-09 02:36:45", "44652", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5639", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 07:36:45", "2026-01-09 07:36:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767944205;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767944205;}", "12", "1", "2026-01-09 07:37:02", "2026-01-09 03:37:02", "44657", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5640", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 08:37:02", "2026-01-09 08:37:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767947822;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767947822;}", "12", "1", "2026-01-09 08:37:38", "2026-01-09 04:37:38", "44664", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5641", "woocommerce_refresh_order_count_cache", "complete", "2026-01-09 20:07:18", "2026-01-09 20:07:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767989238;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767989238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-09 20:13:06", "2026-01-09 16:13:06", "44768", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5642", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 09:37:38", "2026-01-09 09:37:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767951458;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767951458;}", "12", "1", "2026-01-09 09:38:58", "2026-01-09 05:38:58", "44671", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5643", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 10:38:58", "2026-01-09 10:38:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767955138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767955138;}", "12", "1", "2026-01-09 10:41:11", "2026-01-09 06:41:11", "44693", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5645", "wc_admin_daily_wrapper", "complete", "2026-01-10 10:10:03", "2026-01-10 10:10:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768039803;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768039803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-10 10:12:52", "2026-01-10 06:12:52", "44851", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5646", "woocommerce_cleanup_personal_data", "complete", "2026-01-10 10:10:04", "2026-01-10 10:10:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768039804;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768039804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-10 10:12:53", "2026-01-10 06:12:53", "44851", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5647", "woocommerce_cleanup_logs", "complete", "2026-01-10 10:10:04", "2026-01-10 10:10:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768039804;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768039804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-10 10:12:54", "2026-01-10 06:12:54", "44851", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5648", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-10 10:10:04", "2026-01-10 10:10:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768039804;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768039804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-10 10:12:54", "2026-01-10 06:12:54", "44851", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5649", "woocommerce_cleanup_sessions", "complete", "2026-01-10 10:00:00", "2026-01-10 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768039200;s:18:\"\0*\0first_timestamp\";i:1768039200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768039200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-10 10:06:42", "2026-01-10 06:06:42", "44846", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5650", "generate_category_lookup_table_wrapper", "complete", "2026-01-09 10:10:14", "2026-01-09 10:10:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767953414;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767953414;}", "12", "1", "2026-01-09 10:11:02", "2026-01-09 06:11:02", "44689", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5651", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-10 10:10:04", "2026-01-10 10:10:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768039804;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768039804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-10 10:12:54", "2026-01-10 06:12:54", "44851", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5652", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 11:41:11", "2026-01-09 11:41:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767958871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767958871;}", "12", "1", "2026-01-09 11:42:32", "2026-01-09 07:42:32", "44697", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5653", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 12:42:32", "2026-01-09 12:42:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767962552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767962552;}", "12", "1", "2026-01-09 12:44:08", "2026-01-09 08:44:08", "44709", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5654", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 13:44:08", "2026-01-09 13:44:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767966248;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767966248;}", "12", "1", "2026-01-09 13:45:57", "2026-01-09 09:45:57", "44718", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5655", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 14:45:57", "2026-01-09 14:45:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767969957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767969957;}", "12", "1", "2026-01-09 14:47:57", "2026-01-09 10:47:57", "44721", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5656", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 15:47:57", "2026-01-09 15:47:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767973677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767973677;}", "12", "1", "2026-01-09 15:49:19", "2026-01-09 11:49:19", "44736", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5657", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 16:49:19", "2026-01-09 16:49:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767977359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767977359;}", "12", "1", "2026-01-09 16:51:49", "2026-01-09 12:51:49", "44744", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5658", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-09 16:10:56", "2026-01-09 16:10:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767975056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767975056;}", "8", "1", "2026-01-09 16:12:33", "2026-01-09 12:12:33", "44739", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5659", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 17:51:49", "2026-01-09 17:51:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767981109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767981109;}", "12", "1", "2026-01-09 17:53:10", "2026-01-09 13:53:10", "44751", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5660", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 18:53:10", "2026-01-09 18:53:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767984790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767984790;}", "12", "1", "2026-01-09 18:56:34", "2026-01-09 14:56:34", "44758", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5661", "woocommerce_cleanup_draft_orders", "complete", "2026-01-10 18:10:32", "2026-01-10 18:10:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768068632;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768068632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-10 18:12:52", "2026-01-10 14:12:52", "44914", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5662", "woocommerce_scheduled_sales", "complete", "2026-01-10 18:10:32", "2026-01-10 18:10:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768068632;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768068632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-10 18:12:52", "2026-01-10 14:12:52", "44914", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5663", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 19:56:34", "2026-01-09 19:56:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767988594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767988594;}", "12", "1", "2026-01-09 19:58:55", "2026-01-09 15:58:55", "44766", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5664", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 20:58:55", "2026-01-09 20:58:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767992335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767992335;}", "12", "1", "2026-01-09 21:01:16", "2026-01-09 17:01:16", "44774", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5665", "woocommerce_refresh_order_count_cache", "complete", "2026-01-10 08:13:06", "2026-01-10 08:13:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768032786;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768032786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-10 08:24:03", "2026-01-10 04:24:03", "44835", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5666", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 22:01:16", "2026-01-09 22:01:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767996076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767996076;}", "12", "1", "2026-01-09 22:04:11", "2026-01-09 18:04:11", "44777", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5667", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-09 23:04:11", "2026-01-09 23:04:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767999851;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767999851;}", "12", "1", "2026-01-09 23:06:09", "2026-01-09 19:06:09", "44782", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5668", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 00:06:09", "2026-01-10 00:06:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768003569;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768003569;}", "12", "1", "2026-01-10 00:08:12", "2026-01-09 20:08:12", "44791", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5669", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 01:08:12", "2026-01-10 01:08:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768007292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768007292;}", "12", "1", "2026-01-10 01:10:39", "2026-01-09 21:10:39", "44797", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5670", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 02:10:39", "2026-01-10 02:10:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768011039;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768011039;}", "12", "1", "2026-01-10 02:12:51", "2026-01-09 22:12:51", "44806", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5671", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 03:12:51", "2026-01-10 03:12:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768014771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768014771;}", "12", "1", "2026-01-10 03:14:41", "2026-01-09 23:14:41", "44811", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5672", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 04:14:41", "2026-01-10 04:14:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768018481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768018481;}", "12", "1", "2026-01-10 04:16:17", "2026-01-10 00:16:17", "44815", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5673", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 05:16:17", "2026-01-10 05:16:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768022177;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768022177;}", "12", "1", "2026-01-10 05:18:19", "2026-01-10 01:18:19", "44821", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5674", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-10 04:16:17", "2026-01-10 04:16:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768018577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768018577;}", "8", "1", "2026-01-10 04:21:47", "2026-01-10 00:21:47", "44817", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5675", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 06:18:19", "2026-01-10 06:18:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768025899;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768025899;}", "12", "1", "2026-01-10 06:20:22", "2026-01-10 02:20:22", "44824", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5676", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 07:20:22", "2026-01-10 07:20:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768029622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768029622;}", "12", "1", "2026-01-10 07:22:10", "2026-01-10 03:22:10", "44830", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5677", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 08:22:10", "2026-01-10 08:22:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768033330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768033330;}", "12", "1", "2026-01-10 08:24:03", "2026-01-10 04:24:03", "44835", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5678", "woocommerce_refresh_order_count_cache", "complete", "2026-01-10 20:24:03", "2026-01-10 20:24:03", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768076643;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768076643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-10 20:35:07", "2026-01-10 16:35:07", "44929", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5679", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 09:24:03", "2026-01-10 09:24:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768037043;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768037043;}", "12", "1", "2026-01-10 09:25:53", "2026-01-10 05:25:53", "44842", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5680", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 10:25:53", "2026-01-10 10:25:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768040753;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768040753;}", "12", "1", "2026-01-10 10:28:36", "2026-01-10 06:28:36", "44859", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5682", "wc_admin_daily_wrapper", "complete", "2026-01-11 10:12:52", "2026-01-11 10:12:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768126372;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768126372;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-11 10:42:49", "2026-01-11 06:42:49", "45170", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5683", "woocommerce_cleanup_personal_data", "complete", "2026-01-11 10:12:53", "2026-01-11 10:12:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768126373;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768126373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-11 10:42:50", "2026-01-11 06:42:50", "45170", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5684", "woocommerce_cleanup_logs", "complete", "2026-01-11 10:12:54", "2026-01-11 10:12:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768126374;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768126374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-11 10:42:51", "2026-01-11 06:42:51", "45170", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5685", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-11 10:12:54", "2026-01-11 10:12:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768126374;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768126374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-11 10:42:51", "2026-01-11 06:42:51", "45170", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5686", "woocommerce_cleanup_sessions", "complete", "2026-01-11 10:00:00", "2026-01-11 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768125600;s:18:\"\0*\0first_timestamp\";i:1768125600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768125600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-11 10:01:06", "2026-01-11 06:01:06", "45159", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5687", "generate_category_lookup_table_wrapper", "complete", "2026-01-10 10:13:04", "2026-01-10 10:13:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768039984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768039984;}", "12", "1", "2026-01-10 10:14:50", "2026-01-10 06:14:50", "44853", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5688", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-11 10:12:54", "2026-01-11 10:12:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768126374;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768126374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-11 10:42:51", "2026-01-11 06:42:51", "45170", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5689", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 11:28:36", "2026-01-10 11:28:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768044516;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768044516;}", "12", "1", "2026-01-10 11:28:38", "2026-01-10 07:28:38", "44865", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5690", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 12:28:38", "2026-01-10 12:28:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768048118;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768048118;}", "12", "1", "2026-01-10 12:33:05", "2026-01-10 08:33:05", "44872", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5691", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 13:33:05", "2026-01-10 13:33:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768051985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768051985;}", "12", "1", "2026-01-10 13:35:02", "2026-01-10 09:35:02", "44879", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5692", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 14:35:02", "2026-01-10 14:35:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768055702;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768055702;}", "12", "1", "2026-01-10 14:37:24", "2026-01-10 10:37:24", "44883", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5693", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 15:37:24", "2026-01-10 15:37:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768059444;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768059444;}", "12", "1", "2026-01-10 15:39:01", "2026-01-10 11:39:01", "44891", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5694", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 16:39:01", "2026-01-10 16:39:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768063141;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768063141;}", "12", "1", "2026-01-10 16:40:22", "2026-01-10 12:40:22", "44898", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5695", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-10 16:30:56", "2026-01-10 16:30:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768062656;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768062656;}", "8", "1", "2026-01-10 16:30:56", "2026-01-10 12:30:56", "44896", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5696", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 17:40:22", "2026-01-10 17:40:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768066822;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768066822;}", "12", "1", "2026-01-10 17:42:06", "2026-01-10 13:42:06", "44909", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5697", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 18:42:06", "2026-01-10 18:42:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768070526;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768070526;}", "12", "1", "2026-01-10 18:43:35", "2026-01-10 14:43:35", "44916", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5698", "woocommerce_cleanup_draft_orders", "complete", "2026-01-11 18:12:52", "2026-01-11 18:12:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768155172;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768155172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-11 18:27:47", "2026-01-11 14:27:47", "45212", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5699", "woocommerce_scheduled_sales", "complete", "2026-01-11 18:12:52", "2026-01-11 18:12:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768155172;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768155172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-11 18:27:47", "2026-01-11 14:27:47", "45212", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5700", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 19:43:35", "2026-01-10 19:43:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768074215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768074215;}", "12", "1", "2026-01-10 19:45:13", "2026-01-10 15:45:13", "44923", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5701", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 20:45:13", "2026-01-10 20:45:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768077913;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768077913;}", "12", "1", "2026-01-10 20:47:02", "2026-01-10 16:47:02", "44931", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5702", "woocommerce_refresh_order_count_cache", "complete", "2026-01-11 08:35:07", "2026-01-11 08:35:07", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768120507;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768120507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-11 08:39:15", "2026-01-11 04:39:15", "45147", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5703", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 21:47:02", "2026-01-10 21:47:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768081622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768081622;}", "12", "1", "2026-01-10 21:49:12", "2026-01-10 17:49:12", "44937", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5704", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 22:49:12", "2026-01-10 22:49:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768085352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768085352;}", "12", "1", "2026-01-10 22:50:42", "2026-01-10 18:50:42", "44942", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5705", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-10 23:50:42", "2026-01-10 23:50:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768089042;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768089042;}", "12", "1", "2026-01-10 23:52:49", "2026-01-10 19:52:49", "44952", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5706", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 00:52:49", "2026-01-11 00:52:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768092769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768092769;}", "12", "1", "2026-01-11 00:52:49", "2026-01-10 20:52:49", "44989", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5707", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 01:52:49", "2026-01-11 01:52:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768096369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768096369;}", "12", "1", "2026-01-11 01:53:03", "2026-01-10 21:53:03", "45050", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5708", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 02:53:03", "2026-01-11 02:53:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768099983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768099983;}", "12", "1", "2026-01-11 02:56:45", "2026-01-10 22:56:45", "45105", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5709", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 03:56:45", "2026-01-11 03:56:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768103805;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768103805;}", "12", "1", "2026-01-11 04:00:18", "2026-01-11 00:00:18", "45116", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5710", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 05:00:18", "2026-01-11 05:00:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768107618;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768107618;}", "12", "1", "2026-01-11 05:02:07", "2026-01-11 01:02:07", "45123", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5711", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-11 04:14:13", "2026-01-11 04:14:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768104853;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768104853;}", "8", "1", "2026-01-11 04:24:04", "2026-01-11 00:24:04", "45120", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5712", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 06:02:07", "2026-01-11 06:02:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768111327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768111327;}", "12", "1", "2026-01-11 06:04:12", "2026-01-11 02:04:12", "45131", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5713", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 07:04:12", "2026-01-11 07:04:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768115052;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768115052;}", "12", "1", "2026-01-11 07:06:14", "2026-01-11 03:06:14", "45137", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5714", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 08:06:14", "2026-01-11 08:06:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768118774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768118774;}", "12", "1", "2026-01-11 08:08:18", "2026-01-11 04:08:18", "45144", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5715", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 09:08:18", "2026-01-11 09:08:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768122498;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768122498;}", "12", "1", "2026-01-11 09:10:04", "2026-01-11 05:10:04", "45150", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5716", "woocommerce_refresh_order_count_cache", "complete", "2026-01-11 20:39:15", "2026-01-11 20:39:15", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768163955;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768163955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-11 20:43:18", "2026-01-11 16:43:18", "45223", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5717", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 10:10:04", "2026-01-11 10:10:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768126204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768126204;}", "12", "1", "2026-01-11 10:11:58", "2026-01-11 06:11:58", "45168", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5719", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 11:11:58", "2026-01-11 11:11:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768129918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768129918;}", "12", "1", "2026-01-11 11:13:59", "2026-01-11 07:13:59", "45174", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5720", "wc_admin_daily_wrapper", "complete", "2026-01-12 10:42:49", "2026-01-12 10:42:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768214569;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768214569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-12 10:44:26", "2026-01-12 06:44:26", "45321", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5721", "woocommerce_cleanup_personal_data", "complete", "2026-01-12 10:42:50", "2026-01-12 10:42:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768214570;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768214570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-12 10:44:27", "2026-01-12 06:44:27", "45321", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5722", "woocommerce_cleanup_logs", "complete", "2026-01-12 10:42:51", "2026-01-12 10:42:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768214571;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768214571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-12 10:44:27", "2026-01-12 06:44:27", "45321", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5723", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-12 10:42:51", "2026-01-12 10:42:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768214571;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768214571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-12 10:44:27", "2026-01-12 06:44:27", "45321", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5724", "woocommerce_cleanup_sessions", "complete", "2026-01-12 10:00:00", "2026-01-12 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768212000;s:18:\"\0*\0first_timestamp\";i:1768212000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768212000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-12 10:06:03", "2026-01-12 06:06:03", "45316", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5725", "generate_category_lookup_table_wrapper", "complete", "2026-01-11 10:43:01", "2026-01-11 10:43:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768128181;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768128181;}", "12", "1", "2026-01-11 10:52:29", "2026-01-11 06:52:29", "45172", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5726", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-12 10:42:51", "2026-01-12 10:42:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768214571;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768214571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-12 10:44:27", "2026-01-12 06:44:27", "45321", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5727", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 12:13:59", "2026-01-11 12:13:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768133639;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768133639;}", "12", "1", "2026-01-11 12:16:10", "2026-01-11 08:16:10", "45177", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5728", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 13:16:10", "2026-01-11 13:16:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768137370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768137370;}", "12", "1", "2026-01-11 13:17:49", "2026-01-11 09:17:49", "45180", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5729", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 14:17:49", "2026-01-11 14:17:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768141069;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768141069;}", "12", "1", "2026-01-11 14:19:33", "2026-01-11 10:19:33", "45190", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5730", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 15:19:33", "2026-01-11 15:19:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768144773;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768144773;}", "12", "1", "2026-01-11 15:21:31", "2026-01-11 11:21:31", "45194", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5731", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 16:21:31", "2026-01-11 16:21:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768148491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768148491;}", "12", "1", "2026-01-11 16:23:16", "2026-01-11 12:23:16", "45200", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5732", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-11 16:11:02", "2026-01-11 16:11:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768147862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768147862;}", "8", "1", "2026-01-11 16:23:16", "2026-01-11 12:23:16", "45200", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5733", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 17:23:16", "2026-01-11 17:23:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768152196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768152196;}", "12", "1", "2026-01-11 17:25:31", "2026-01-11 13:25:31", "45207", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5734", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 18:25:31", "2026-01-11 18:25:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768155931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768155931;}", "12", "1", "2026-01-11 18:27:47", "2026-01-11 14:27:47", "45212", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5735", "woocommerce_cleanup_draft_orders", "complete", "2026-01-12 18:27:47", "2026-01-12 18:27:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768242467;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768242467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-12 18:29:02", "2026-01-12 14:29:02", "45371", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5736", "woocommerce_scheduled_sales", "complete", "2026-01-12 18:27:47", "2026-01-12 18:27:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768242467;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768242467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-12 18:29:02", "2026-01-12 14:29:02", "45371", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5737", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 19:27:47", "2026-01-11 19:27:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768159667;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768159667;}", "12", "1", "2026-01-11 19:30:08", "2026-01-11 15:30:08", "45215", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5738", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 20:30:08", "2026-01-11 20:30:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768163408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768163408;}", "12", "1", "2026-01-11 20:32:43", "2026-01-11 16:32:43", "45221", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5739", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 21:32:43", "2026-01-11 21:32:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768167163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768167163;}", "12", "1", "2026-01-11 21:35:05", "2026-01-11 17:35:05", "45228", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5740", "woocommerce_refresh_order_count_cache", "complete", "2026-01-12 08:43:18", "2026-01-12 08:43:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768207398;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768207398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-12 08:47:01", "2026-01-12 04:47:01", "45298", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5741", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 22:35:05", "2026-01-11 22:35:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768170905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768170905;}", "12", "1", "2026-01-11 22:37:52", "2026-01-11 18:37:52", "45232", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5742", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-11 23:37:52", "2026-01-11 23:37:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768174672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768174672;}", "12", "1", "2026-01-11 23:40:08", "2026-01-11 19:40:08", "45239", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5743", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 00:40:08", "2026-01-12 00:40:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768178408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768178408;}", "12", "1", "2026-01-12 00:42:42", "2026-01-11 20:42:42", "45243", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5744", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 01:42:42", "2026-01-12 01:42:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768182162;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768182162;}", "12", "1", "2026-01-12 01:45:16", "2026-01-11 21:45:16", "45251", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5745", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 02:45:16", "2026-01-12 02:45:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768185916;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768185916;}", "12", "1", "2026-01-12 02:47:52", "2026-01-11 22:47:52", "45257", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5746", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 03:47:52", "2026-01-12 03:47:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768189672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768189672;}", "12", "1", "2026-01-12 03:50:11", "2026-01-11 23:50:11", "45264", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5747", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 04:50:11", "2026-01-12 04:50:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768193411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768193411;}", "12", "1", "2026-01-12 04:52:25", "2026-01-12 00:52:25", "45272", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5748", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-12 04:21:17", "2026-01-12 04:21:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768191677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768191677;}", "8", "1", "2026-01-12 04:33:30", "2026-01-12 00:33:30", "45268", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5749", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 05:52:25", "2026-01-12 05:52:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768197145;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768197145;}", "12", "1", "2026-01-12 05:54:53", "2026-01-12 01:54:53", "45278", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5750", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 06:54:53", "2026-01-12 06:54:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768200893;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768200893;}", "12", "1", "2026-01-12 06:57:35", "2026-01-12 02:57:35", "45287", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5751", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 07:57:35", "2026-01-12 07:57:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768204655;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768204655;}", "12", "1", "2026-01-12 08:00:09", "2026-01-12 04:00:09", "45294", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5752", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 09:00:09", "2026-01-12 09:00:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768208409;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768208409;}", "12", "1", "2026-01-12 09:02:55", "2026-01-12 05:02:55", "45300", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5753", "woocommerce_refresh_order_count_cache", "complete", "2026-01-12 20:47:01", "2026-01-12 20:47:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768250821;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768250821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-12 21:05:49", "2026-01-12 17:05:49", "45386", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5754", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 10:02:55", "2026-01-12 10:02:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768212175;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768212175;}", "12", "1", "2026-01-12 10:06:03", "2026-01-12 06:06:03", "45316", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5756", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 11:06:03", "2026-01-12 11:06:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768215963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768215963;}", "12", "1", "2026-01-12 11:09:28", "2026-01-12 07:09:28", "45325", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5757", "wc_admin_daily_wrapper", "complete", "2026-01-13 10:44:26", "2026-01-13 10:44:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768301066;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768301066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-13 10:48:24", "2026-01-13 06:48:24", "45606", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5758", "woocommerce_cleanup_personal_data", "complete", "2026-01-13 10:44:27", "2026-01-13 10:44:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768301067;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768301067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-13 10:48:25", "2026-01-13 06:48:25", "45606", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5759", "woocommerce_cleanup_logs", "complete", "2026-01-13 10:44:27", "2026-01-13 10:44:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768301067;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768301067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-13 10:48:25", "2026-01-13 06:48:25", "45606", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5760", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-13 10:44:27", "2026-01-13 10:44:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768301067;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768301067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-13 10:48:25", "2026-01-13 06:48:25", "45606", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5761", "woocommerce_cleanup_sessions", "complete", "2026-01-13 10:00:00", "2026-01-13 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768298400;s:18:\"\0*\0first_timestamp\";i:1768298400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768298400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-13 10:00:34", "2026-01-13 06:00:34", "45595", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5762", "generate_category_lookup_table_wrapper", "complete", "2026-01-12 10:44:37", "2026-01-12 10:44:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768214677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768214677;}", "12", "1", "2026-01-12 11:01:44", "2026-01-12 07:01:44", "45323", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5763", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-13 10:44:27", "2026-01-13 10:44:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768301067;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768301067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-13 10:48:25", "2026-01-13 06:48:25", "45606", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5764", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 12:09:28", "2026-01-12 12:09:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768219768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768219768;}", "12", "1", "2026-01-12 12:12:19", "2026-01-12 08:12:19", "45329", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5765", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 13:12:19", "2026-01-12 13:12:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768223539;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768223539;}", "12", "1", "2026-01-12 13:12:52", "2026-01-12 09:12:52", "45333", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5766", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 14:12:52", "2026-01-12 14:12:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768227172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768227172;}", "12", "1", "2026-01-12 14:18:32", "2026-01-12 10:18:32", "45342", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5767", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 15:18:32", "2026-01-12 15:18:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768231112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768231112;}", "12", "1", "2026-01-12 15:22:29", "2026-01-12 11:22:29", "45351", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5768", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 16:22:29", "2026-01-12 16:22:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768234949;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768234949;}", "12", "1", "2026-01-12 16:26:29", "2026-01-12 12:26:29", "45357", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5769", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 17:26:29", "2026-01-12 17:26:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768238789;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768238789;}", "12", "1", "2026-01-12 17:29:33", "2026-01-12 13:29:33", "45362", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5770", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-12 16:26:29", "2026-01-12 16:26:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768235189;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768235189;}", "8", "1", "2026-01-12 16:58:05", "2026-01-12 12:58:05", "45359", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5771", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 18:29:33", "2026-01-12 18:29:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768242573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768242573;}", "12", "1", "2026-01-12 18:32:39", "2026-01-12 14:32:39", "45373", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5772", "woocommerce_cleanup_draft_orders", "complete", "2026-01-13 18:29:02", "2026-01-13 18:29:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768328942;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768328942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-13 18:45:18", "2026-01-13 14:45:18", "45677", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5773", "woocommerce_scheduled_sales", "complete", "2026-01-13 18:29:02", "2026-01-13 18:29:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768328942;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768328942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-13 18:45:18", "2026-01-13 14:45:18", "45677", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5774", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 19:32:39", "2026-01-12 19:32:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768246359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768246359;}", "12", "1", "2026-01-12 19:35:23", "2026-01-12 15:35:23", "45378", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5775", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 20:35:23", "2026-01-12 20:35:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768250123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768250123;}", "12", "1", "2026-01-12 20:37:55", "2026-01-12 16:37:55", "45382", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5776", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 21:37:55", "2026-01-12 21:37:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768253875;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768253875;}", "12", "1", "2026-01-12 21:40:31", "2026-01-12 17:40:31", "45393", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5777", "woocommerce_refresh_order_count_cache", "complete", "2026-01-13 09:05:49", "2026-01-13 09:05:49", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768295149;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768295149;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-13 09:31:27", "2026-01-13 05:31:27", "45580", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5778", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 22:40:31", "2026-01-12 22:40:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768257631;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768257631;}", "12", "1", "2026-01-12 22:42:52", "2026-01-12 18:42:52", "45398", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5779", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-12 23:42:52", "2026-01-12 23:42:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768261372;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768261372;}", "12", "1", "2026-01-12 23:43:08", "2026-01-12 19:43:08", "45406", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5780", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 00:43:08", "2026-01-13 00:43:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768264988;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768264988;}", "12", "1", "2026-01-13 00:49:02", "2026-01-12 20:49:02", "45413", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5781", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 01:49:02", "2026-01-13 01:49:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768268942;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768268942;}", "12", "1", "2026-01-13 01:52:17", "2026-01-12 21:52:17", "45421", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5782", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 02:52:17", "2026-01-13 02:52:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768272737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768272737;}", "12", "1", "2026-01-13 02:54:56", "2026-01-12 22:54:56", "45427", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5783", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 03:54:56", "2026-01-13 03:54:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768276496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768276496;}", "12", "1", "2026-01-13 03:56:52", "2026-01-12 23:56:52", "45436", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5784", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 04:56:52", "2026-01-13 04:56:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768280212;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768280212;}", "12", "1", "2026-01-13 04:56:54", "2026-01-13 00:56:54", "45476", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5785", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-13 04:09:49", "2026-01-13 04:09:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768277389;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768277389;}", "8", "1", "2026-01-13 04:13:01", "2026-01-13 00:13:01", "45442", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5786", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 05:56:54", "2026-01-13 05:56:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768283814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768283814;}", "12", "1", "2026-01-13 05:57:51", "2026-01-13 01:57:51", "45525", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5787", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 06:57:51", "2026-01-13 06:57:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768287471;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768287471;}", "12", "1", "2026-01-13 07:03:38", "2026-01-13 03:03:38", "45566", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5788", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 08:03:38", "2026-01-13 08:03:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768291418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768291418;}", "12", "1", "2026-01-13 08:06:32", "2026-01-13 04:06:32", "45576", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5789", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 09:06:32", "2026-01-13 09:06:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768295192;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768295192;}", "12", "1", "2026-01-13 09:31:27", "2026-01-13 05:31:27", "45580", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5790", "woocommerce_refresh_order_count_cache", "complete", "2026-01-13 21:31:27", "2026-01-13 21:31:27", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768339887;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768339887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-13 21:59:30", "2026-01-13 17:59:30", "45695", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5791", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 10:31:27", "2026-01-13 10:31:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768300287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768300287;}", "12", "1", "2026-01-13 10:32:46", "2026-01-13 06:32:46", "45602", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5793", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 11:32:46", "2026-01-13 11:32:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768303966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768303966;}", "12", "1", "2026-01-13 11:36:51", "2026-01-13 07:36:51", "45616", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5794", "wc_admin_daily_wrapper", "complete", "2026-01-14 10:48:24", "2026-01-14 10:48:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768387704;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768387704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-14 11:02:27", "2026-01-14 07:02:27", "45895", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5795", "woocommerce_cleanup_personal_data", "complete", "2026-01-14 10:48:25", "2026-01-14 10:48:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768387705;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768387705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-14 11:02:28", "2026-01-14 07:02:28", "45895", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5796", "woocommerce_cleanup_logs", "complete", "2026-01-14 10:48:25", "2026-01-14 10:48:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768387705;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768387705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-14 11:02:28", "2026-01-14 07:02:28", "45895", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5797", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-14 10:48:25", "2026-01-14 10:48:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768387705;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768387705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-14 11:02:28", "2026-01-14 07:02:28", "45895", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5798", "woocommerce_cleanup_sessions", "complete", "2026-01-14 10:00:00", "2026-01-14 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768384800;s:18:\"\0*\0first_timestamp\";i:1768384800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768384800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-14 10:06:10", "2026-01-14 06:06:10", "45889", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5799", "generate_category_lookup_table_wrapper", "complete", "2026-01-13 10:48:35", "2026-01-13 10:48:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768301315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768301315;}", "12", "1", "2026-01-13 10:55:44", "2026-01-13 06:55:44", "45608", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5800", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-14 10:48:25", "2026-01-14 10:48:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768387705;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768387705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-14 11:02:28", "2026-01-14 07:02:28", "45895", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5801", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 12:36:51", "2026-01-13 12:36:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768307811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768307811;}", "12", "1", "2026-01-13 12:38:31", "2026-01-13 08:38:31", "45627", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5802", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 13:38:31", "2026-01-13 13:38:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768311511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768311511;}", "12", "1", "2026-01-13 13:41:01", "2026-01-13 09:41:01", "45635", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5803", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 14:41:01", "2026-01-13 14:41:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768315261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768315261;}", "12", "1", "2026-01-13 14:44:25", "2026-01-13 10:44:25", "45642", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5804", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 15:44:25", "2026-01-13 15:44:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768319065;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768319065;}", "12", "1", "2026-01-13 15:46:26", "2026-01-13 11:46:26", "45650", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5805", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 16:46:26", "2026-01-13 16:46:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768322786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768322786;}", "12", "1", "2026-01-13 16:48:34", "2026-01-13 12:48:34", "45660", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5806", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-13 16:17:20", "2026-01-13 16:17:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768321040;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768321040;}", "8", "1", "2026-01-13 16:21:31", "2026-01-13 12:21:31", "45655", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5807", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 17:48:34", "2026-01-13 17:48:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768326514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768326514;}", "12", "1", "2026-01-13 17:51:10", "2026-01-13 13:51:10", "45670", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5808", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 18:51:10", "2026-01-13 18:51:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768330270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768330270;}", "12", "1", "2026-01-13 18:53:49", "2026-01-13 14:53:49", "45680", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5809", "woocommerce_cleanup_draft_orders", "complete", "2026-01-14 18:45:18", "2026-01-14 18:45:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768416318;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768416318;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-14 18:50:22", "2026-01-14 14:50:22", "45949", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5810", "woocommerce_scheduled_sales", "complete", "2026-01-14 18:45:18", "2026-01-14 18:45:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768416318;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768416318;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-14 18:50:22", "2026-01-14 14:50:22", "45949", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5811", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 19:53:49", "2026-01-13 19:53:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768334029;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768334029;}", "12", "1", "2026-01-13 19:56:33", "2026-01-13 15:56:33", "45684", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5812", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 20:56:33", "2026-01-13 20:56:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768337793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768337793;}", "12", "1", "2026-01-13 20:59:14", "2026-01-13 16:59:14", "45689", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5813", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 21:59:14", "2026-01-13 21:59:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768341554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768341554;}", "12", "1", "2026-01-13 21:59:30", "2026-01-13 17:59:30", "45695", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5814", "woocommerce_refresh_order_count_cache", "complete", "2026-01-14 09:59:30", "2026-01-14 09:59:30", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768384770;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768384770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-14 10:06:10", "2026-01-14 06:06:10", "45889", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5815", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 22:59:30", "2026-01-13 22:59:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768345170;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768345170;}", "12", "1", "2026-01-13 23:01:13", "2026-01-13 19:01:13", "45702", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5816", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 00:01:13", "2026-01-14 00:01:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768348873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768348873;}", "12", "1", "2026-01-14 00:08:43", "2026-01-13 20:08:43", "45712", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5817", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 01:08:43", "2026-01-14 01:08:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768352923;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768352923;}", "12", "1", "2026-01-14 01:08:44", "2026-01-13 21:08:44", "45718", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5818", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 02:08:44", "2026-01-14 02:08:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768356524;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768356524;}", "12", "1", "2026-01-14 02:22:09", "2026-01-13 22:22:09", "45727", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5819", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 03:22:09", "2026-01-14 03:22:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768360929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768360929;}", "12", "1", "2026-01-14 03:33:49", "2026-01-13 23:33:49", "45736", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5820", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 04:33:49", "2026-01-14 04:33:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768365229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768365229;}", "12", "1", "2026-01-14 04:47:08", "2026-01-14 00:47:08", "45747", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5821", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-14 04:12:01", "2026-01-14 04:12:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768363921;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768363921;}", "8", "1", "2026-01-14 04:21:03", "2026-01-14 00:21:03", "45743", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5822", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 05:47:08", "2026-01-14 05:47:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768369628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768369628;}", "12", "1", "2026-01-14 05:47:32", "2026-01-14 01:47:32", "45773", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5823", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 06:47:32", "2026-01-14 06:47:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768373252;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768373252;}", "12", "1", "2026-01-14 06:49:24", "2026-01-14 02:49:24", "45824", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5824", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 07:49:24", "2026-01-14 07:49:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768376964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768376964;}", "12", "1", "2026-01-14 07:50:16", "2026-01-14 03:50:16", "45860", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5825", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 08:50:16", "2026-01-14 08:50:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768380616;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768380616;}", "12", "1", "2026-01-14 09:10:21", "2026-01-14 05:10:21", "45872", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5826", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 10:10:21", "2026-01-14 10:10:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768385421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768385421;}", "12", "1", "2026-01-14 10:28:55", "2026-01-14 06:28:55", "45892", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5827", "woocommerce_refresh_order_count_cache", "complete", "2026-01-14 22:06:10", "2026-01-14 22:06:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768428370;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768428370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-14 22:23:51", "2026-01-14 18:23:51", "45970", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5829", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 11:28:55", "2026-01-14 11:28:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768390135;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768390135;}", "12", "1", "2026-01-14 11:30:47", "2026-01-14 07:30:47", "45899", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5830", "wc_admin_daily_wrapper", "complete", "2026-01-15 11:02:27", "2026-01-15 11:02:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768474947;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768474947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-15 11:02:54", "2026-01-15 07:02:54", "46138", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5831", "woocommerce_cleanup_personal_data", "complete", "2026-01-15 11:02:28", "2026-01-15 11:02:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768474948;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768474948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-15 11:02:55", "2026-01-15 07:02:55", "46138", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5832", "woocommerce_cleanup_logs", "complete", "2026-01-15 11:02:28", "2026-01-15 11:02:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768474948;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768474948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-15 11:02:55", "2026-01-15 07:02:55", "46138", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5833", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-15 11:02:28", "2026-01-15 11:02:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768474948;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768474948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-15 11:02:55", "2026-01-15 07:02:55", "46138", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5834", "woocommerce_cleanup_sessions", "complete", "2026-01-15 10:00:00", "2026-01-15 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768471200;s:18:\"\0*\0first_timestamp\";i:1768471200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768471200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-15 10:01:35", "2026-01-15 06:01:35", "46075", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5835", "generate_category_lookup_table_wrapper", "complete", "2026-01-14 11:02:38", "2026-01-14 11:02:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768388558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768388558;}", "12", "1", "2026-01-14 11:15:04", "2026-01-14 07:15:04", "45897", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5836", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-15 11:02:28", "2026-01-15 11:02:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768474948;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768474948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-15 11:02:55", "2026-01-15 07:02:55", "46138", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5837", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 12:30:47", "2026-01-14 12:30:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768393847;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768393847;}", "12", "1", "2026-01-14 12:55:42", "2026-01-14 08:55:42", "45907", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5838", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 13:55:42", "2026-01-14 13:55:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768398942;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768398942;}", "12", "1", "2026-01-14 14:12:44", "2026-01-14 10:12:44", "45919", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5839", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 15:12:44", "2026-01-14 15:12:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768403564;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768403564;}", "12", "1", "2026-01-14 15:15:34", "2026-01-14 11:15:34", "45926", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5840", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 16:15:34", "2026-01-14 16:15:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768407334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768407334;}", "12", "1", "2026-01-14 16:37:47", "2026-01-14 12:37:47", "45936", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5841", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-14 16:14:13", "2026-01-14 16:14:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768407253;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768407253;}", "8", "1", "2026-01-14 16:14:13", "2026-01-14 12:14:13", "45934", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5842", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 17:37:47", "2026-01-14 17:37:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768412267;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768412267;}", "12", "1", "2026-01-14 17:39:22", "2026-01-14 13:39:22", "45941", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5843", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 18:39:22", "2026-01-14 18:39:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768415962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768415962;}", "12", "1", "2026-01-14 18:50:22", "2026-01-14 14:50:22", "45949", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5844", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 19:50:22", "2026-01-14 19:50:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768420222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768420222;}", "12", "1", "2026-01-14 19:56:40", "2026-01-14 15:56:40", "45959", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5845", "woocommerce_cleanup_draft_orders", "complete", "2026-01-15 18:50:22", "2026-01-15 18:50:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768503022;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768503022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-15 18:50:28", "2026-01-15 14:50:28", "46264", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5846", "woocommerce_scheduled_sales", "complete", "2026-01-15 18:50:22", "2026-01-15 18:50:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768503022;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768503022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-15 18:50:28", "2026-01-15 14:50:28", "46264", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5847", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 20:56:40", "2026-01-14 20:56:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768424200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768424200;}", "12", "1", "2026-01-14 20:58:22", "2026-01-14 16:58:22", "45964", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5848", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 21:58:22", "2026-01-14 21:58:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768427902;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768427902;}", "12", "1", "2026-01-14 22:23:51", "2026-01-14 18:23:51", "45970", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5849", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 23:23:51", "2026-01-14 23:23:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768433031;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768433031;}", "12", "1", "2026-01-14 23:49:53", "2026-01-14 19:49:53", "45975", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5850", "woocommerce_refresh_order_count_cache", "complete", "2026-01-15 10:23:51", "2026-01-15 10:23:51", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768472631;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768472631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-15 10:23:51", "2026-01-15 06:23:51", "46098", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5851", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 00:49:53", "2026-01-15 00:49:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768438193;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768438193;}", "12", "1", "2026-01-15 01:16:30", "2026-01-14 21:16:30", "45982", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5852", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 02:16:30", "2026-01-15 02:16:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768443390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768443390;}", "12", "1", "2026-01-15 02:38:25", "2026-01-14 22:38:25", "45989", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5853", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 03:38:25", "2026-01-15 03:38:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768448305;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768448305;}", "12", "1", "2026-01-15 03:38:48", "2026-01-14 23:38:48", "45993", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5854", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 04:38:48", "2026-01-15 04:38:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768451928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768451928;}", "12", "1", "2026-01-15 04:40:09", "2026-01-15 00:40:09", "46005", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5855", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-15 04:09:59", "2026-01-15 04:09:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768450199;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768450199;}", "8", "1", "2026-01-15 04:09:59", "2026-01-15 00:09:59", "46000", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5856", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 05:40:09", "2026-01-15 05:40:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768455609;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768455609;}", "12", "1", "2026-01-15 05:53:09", "2026-01-15 01:53:09", "46016", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5857", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 06:53:09", "2026-01-15 06:53:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768459989;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768459989;}", "12", "1", "2026-01-15 07:00:42", "2026-01-15 03:00:42", "46023", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5858", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 08:00:42", "2026-01-15 08:00:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768464042;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768464042;}", "12", "1", "2026-01-15 08:08:42", "2026-01-15 04:08:42", "46031", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5859", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 09:08:42", "2026-01-15 09:08:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768468122;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768468122;}", "12", "1", "2026-01-15 09:23:54", "2026-01-15 05:23:54", "46043", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5860", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 10:23:54", "2026-01-15 10:23:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768472634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768472634;}", "12", "1", "2026-01-15 10:24:50", "2026-01-15 06:24:50", "46100", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5862", "woocommerce_refresh_order_count_cache", "complete", "2026-01-15 22:23:51", "2026-01-15 22:23:51", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768515831;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768515831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-15 22:38:08", "2026-01-15 18:38:08", "46289", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5863", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 11:24:50", "2026-01-15 11:24:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768476290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768476290;}", "12", "1", "2026-01-15 11:24:50", "2026-01-15 07:24:50", "46161", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5864", "wc_admin_daily_wrapper", "complete", "2026-01-16 11:02:54", "2026-01-16 11:02:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768561374;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768561374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-16 11:10:51", "2026-01-16 07:10:51", "46401", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5865", "woocommerce_cleanup_personal_data", "complete", "2026-01-16 11:02:55", "2026-01-16 11:02:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768561375;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768561375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-16 11:10:52", "2026-01-16 07:10:52", "46401", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5866", "woocommerce_cleanup_logs", "complete", "2026-01-16 11:02:55", "2026-01-16 11:02:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768561375;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768561375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-16 11:10:52", "2026-01-16 07:10:52", "46401", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5867", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-16 11:02:55", "2026-01-16 11:02:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768561375;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768561375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-16 11:10:52", "2026-01-16 07:10:52", "46401", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5868", "woocommerce_cleanup_sessions", "complete", "2026-01-16 10:00:00", "2026-01-16 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768557600;s:18:\"\0*\0first_timestamp\";i:1768557600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768557600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-16 10:11:03", "2026-01-16 06:11:03", "46390", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5869", "generate_category_lookup_table_wrapper", "complete", "2026-01-15 11:03:05", "2026-01-15 11:03:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768474985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768474985;}", "12", "1", "2026-01-15 11:03:50", "2026-01-15 07:03:50", "46140", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5870", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-16 11:02:55", "2026-01-16 11:02:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768561375;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768561375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-16 11:10:52", "2026-01-16 07:10:52", "46401", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5871", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 12:24:50", "2026-01-15 12:24:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768479890;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768479890;}", "12", "1", "2026-01-15 12:27:28", "2026-01-15 08:27:28", "46206", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5872", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 13:27:28", "2026-01-15 13:27:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768483648;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768483648;}", "12", "1", "2026-01-15 13:37:44", "2026-01-15 09:37:44", "46218", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5873", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 14:37:44", "2026-01-15 14:37:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768487864;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768487864;}", "12", "1", "2026-01-15 14:46:51", "2026-01-15 10:46:51", "46230", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5874", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 15:46:51", "2026-01-15 15:46:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768492011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768492011;}", "12", "1", "2026-01-15 16:00:53", "2026-01-15 12:00:53", "46239", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5875", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 17:00:53", "2026-01-15 17:00:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768496453;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768496453;}", "12", "1", "2026-01-15 17:27:08", "2026-01-15 13:27:08", "46250", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5876", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-15 16:13:33", "2026-01-15 16:13:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768493613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768493613;}", "8", "1", "2026-01-15 16:27:12", "2026-01-15 12:27:12", "46243", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5877", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 18:27:08", "2026-01-15 18:27:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768501628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768501628;}", "12", "1", "2026-01-15 18:39:32", "2026-01-15 14:39:32", "46261", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5878", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 19:39:32", "2026-01-15 19:39:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768505972;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768505972;}", "12", "1", "2026-01-15 19:47:02", "2026-01-15 15:47:02", "46271", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5879", "woocommerce_cleanup_draft_orders", "complete", "2026-01-16 18:50:28", "2026-01-16 18:50:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768589428;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768589428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-16 19:12:37", "2026-01-16 15:12:37", "46465", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5880", "woocommerce_scheduled_sales", "complete", "2026-01-16 18:50:28", "2026-01-16 18:50:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768589428;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768589428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-16 19:12:37", "2026-01-16 15:12:37", "46465", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5881", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 20:47:02", "2026-01-15 20:47:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768510022;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768510022;}", "12", "1", "2026-01-15 21:03:04", "2026-01-15 17:03:04", "46280", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5882", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 22:03:04", "2026-01-15 22:03:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768514584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768514584;}", "12", "1", "2026-01-15 22:11:45", "2026-01-15 18:11:45", "46286", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5883", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 23:11:45", "2026-01-15 23:11:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768518705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768518705;}", "12", "1", "2026-01-15 23:37:54", "2026-01-15 19:37:54", "46294", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5884", "woocommerce_refresh_order_count_cache", "complete", "2026-01-16 10:38:08", "2026-01-16 10:38:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768559888;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768559888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-16 10:39:18", "2026-01-16 06:39:18", "46395", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5885", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 00:37:54", "2026-01-16 00:37:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768523874;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768523874;}", "12", "1", "2026-01-16 00:51:40", "2026-01-15 20:51:40", "46305", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5886", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 01:51:40", "2026-01-16 01:51:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768528300;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768528300;}", "12", "1", "2026-01-16 01:58:15", "2026-01-15 21:58:15", "46312", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5887", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 02:58:15", "2026-01-16 02:58:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768532295;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768532295;}", "12", "1", "2026-01-16 03:23:35", "2026-01-15 23:23:35", "46324", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5888", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 04:23:35", "2026-01-16 04:23:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768537415;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768537415;}", "12", "1", "2026-01-16 04:26:14", "2026-01-16 00:26:14", "46338", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5889", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-16 04:14:39", "2026-01-16 04:14:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768536879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768536879;}", "8", "1", "2026-01-16 04:21:05", "2026-01-16 00:21:05", "46336", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5890", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 05:26:14", "2026-01-16 05:26:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768541174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768541174;}", "12", "1", "2026-01-16 05:35:10", "2026-01-16 01:35:10", "46346", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5891", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 06:35:10", "2026-01-16 06:35:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768545310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768545310;}", "12", "1", "2026-01-16 06:40:14", "2026-01-16 02:40:14", "46356", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5892", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 07:40:14", "2026-01-16 07:40:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768549214;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768549214;}", "12", "1", "2026-01-16 07:40:49", "2026-01-16 03:40:49", "46370", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5893", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 08:40:49", "2026-01-16 08:40:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768552849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768552849;}", "12", "1", "2026-01-16 08:44:39", "2026-01-16 04:44:39", "46377", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5894", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 09:44:39", "2026-01-16 09:44:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768556679;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768556679;}", "12", "1", "2026-01-16 09:49:32", "2026-01-16 05:49:32", "46386", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5895", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 10:49:32", "2026-01-16 10:49:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768560572;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768560572;}", "12", "1", "2026-01-16 10:49:58", "2026-01-16 06:49:58", "46398", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5897", "woocommerce_refresh_order_count_cache", "complete", "2026-01-16 22:39:18", "2026-01-16 22:39:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768603158;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768603158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-16 22:39:19", "2026-01-16 18:39:19", "46495", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5898", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 11:49:58", "2026-01-16 11:49:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768564198;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768564198;}", "12", "1", "2026-01-16 11:50:17", "2026-01-16 07:50:17", "46407", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5899", "wc_admin_daily_wrapper", "complete", "2026-01-17 11:10:51", "2026-01-17 11:10:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768648251;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768648251;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-17 11:11:00", "2026-01-17 07:11:00", "46597", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5900", "woocommerce_cleanup_personal_data", "complete", "2026-01-17 11:10:52", "2026-01-17 11:10:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768648252;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768648252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-17 11:11:01", "2026-01-17 07:11:01", "46597", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5901", "woocommerce_cleanup_logs", "complete", "2026-01-17 11:10:52", "2026-01-17 11:10:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768648252;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768648252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-17 11:11:01", "2026-01-17 07:11:01", "46597", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5902", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-17 11:10:52", "2026-01-17 11:10:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768648252;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768648252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-17 11:11:01", "2026-01-17 07:11:01", "46597", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5903", "woocommerce_cleanup_sessions", "complete", "2026-01-17 10:00:00", "2026-01-17 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768644000;s:18:\"\0*\0first_timestamp\";i:1768644000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768644000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-17 10:12:45", "2026-01-17 06:12:45", "46583", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5904", "generate_category_lookup_table_wrapper", "complete", "2026-01-16 11:11:02", "2026-01-16 11:11:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768561862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768561862;}", "12", "1", "2026-01-16 11:17:38", "2026-01-16 07:17:38", "46403", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5905", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-17 11:10:52", "2026-01-17 11:10:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768648252;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768648252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-17 11:11:01", "2026-01-17 07:11:01", "46597", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5906", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 12:50:17", "2026-01-16 12:50:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768567817;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768567817;}", "12", "1", "2026-01-16 12:50:39", "2026-01-16 08:50:39", "46415", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5907", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 13:50:39", "2026-01-16 13:50:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768571439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768571439;}", "12", "1", "2026-01-16 13:52:27", "2026-01-16 09:52:27", "46422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5908", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 14:52:27", "2026-01-16 14:52:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768575147;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768575147;}", "12", "1", "2026-01-16 15:00:14", "2026-01-16 11:00:14", "46432", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5909", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 16:00:14", "2026-01-16 16:00:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768579214;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768579214;}", "12", "1", "2026-01-16 16:18:50", "2026-01-16 12:18:50", "46443", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5910", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 17:18:50", "2026-01-16 17:18:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768583930;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768583930;}", "12", "1", "2026-01-16 17:20:03", "2026-01-16 13:20:03", "46452", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5911", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-16 16:18:50", "2026-01-16 16:18:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768580330;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768580330;}", "8", "1", "2026-01-16 16:23:49", "2026-01-16 12:23:49", "46445", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5912", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 18:20:03", "2026-01-16 18:20:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768587603;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768587603;}", "12", "1", "2026-01-16 18:34:19", "2026-01-16 14:34:19", "46460", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5913", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 19:34:19", "2026-01-16 19:34:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768592059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768592059;}", "12", "1", "2026-01-16 19:40:53", "2026-01-16 15:40:53", "46468", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5914", "woocommerce_cleanup_draft_orders", "complete", "2026-01-17 19:12:37", "2026-01-17 19:12:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768677157;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768677157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-17 19:15:38", "2026-01-17 15:15:38", "46675", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5915", "woocommerce_scheduled_sales", "complete", "2026-01-17 19:12:37", "2026-01-17 19:12:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768677157;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768677157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-17 19:15:38", "2026-01-17 15:15:38", "46675", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5916", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 20:40:53", "2026-01-16 20:40:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768596053;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768596053;}", "12", "1", "2026-01-16 20:48:03", "2026-01-16 16:48:03", "46478", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5917", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 21:48:03", "2026-01-16 21:48:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768600083;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768600083;}", "12", "1", "2026-01-16 21:53:16", "2026-01-16 17:53:16", "46487", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5918", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 22:53:16", "2026-01-16 22:53:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768603996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768603996;}", "12", "1", "2026-01-16 22:58:15", "2026-01-16 18:58:15", "46497", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5919", "woocommerce_refresh_order_count_cache", "complete", "2026-01-17 10:39:19", "2026-01-17 10:39:19", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768646359;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768646359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-17 10:41:57", "2026-01-17 06:41:57", "46588", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5920", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 23:58:15", "2026-01-16 23:58:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768607895;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768607895;}", "12", "1", "2026-01-16 23:58:59", "2026-01-16 19:58:59", "46507", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5921", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 00:58:59", "2026-01-17 00:58:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768611539;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768611539;}", "12", "1", "2026-01-17 01:10:48", "2026-01-16 21:10:48", "46519", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5922", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 02:10:48", "2026-01-17 02:10:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768615848;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768615848;}", "12", "1", "2026-01-17 02:19:27", "2026-01-16 22:19:27", "46529", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5923", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 03:19:27", "2026-01-17 03:19:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768619967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768619967;}", "12", "1", "2026-01-17 03:45:25", "2026-01-16 23:45:25", "46540", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5924", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 04:45:25", "2026-01-17 04:45:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768625125;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768625125;}", "12", "1", "2026-01-17 04:55:22", "2026-01-17 00:55:22", "46550", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5925", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-17 04:10:17", "2026-01-17 04:10:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768623017;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768623017;}", "8", "1", "2026-01-17 04:13:40", "2026-01-17 00:13:40", "46545", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5926", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 05:55:22", "2026-01-17 05:55:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768629322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768629322;}", "12", "1", "2026-01-17 05:55:44", "2026-01-17 01:55:44", "46558", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5927", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 06:55:44", "2026-01-17 06:55:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768632944;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768632944;}", "12", "1", "2026-01-17 06:59:31", "2026-01-17 02:59:31", "46563", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5928", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 07:59:31", "2026-01-17 07:59:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768636771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768636771;}", "12", "1", "2026-01-17 08:00:41", "2026-01-17 04:00:41", "46570", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5929", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 09:00:41", "2026-01-17 09:00:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768640441;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768640441;}", "12", "1", "2026-01-17 09:18:52", "2026-01-17 05:18:52", "46576", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5930", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 10:18:52", "2026-01-17 10:18:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768645132;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768645132;}", "12", "1", "2026-01-17 10:23:04", "2026-01-17 06:23:04", "46586", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5932", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 11:23:04", "2026-01-17 11:23:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768648984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768648984;}", "12", "1", "2026-01-17 11:38:23", "2026-01-17 07:38:23", "46602", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5933", "woocommerce_refresh_order_count_cache", "complete", "2026-01-17 22:41:57", "2026-01-17 22:41:57", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768689717;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768689717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-17 22:45:00", "2026-01-17 18:45:00", "46709", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5934", "wc_admin_daily_wrapper", "complete", "2026-01-18 11:11:00", "2026-01-18 11:11:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768734660;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768734660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-18 11:31:32", "2026-01-18 07:31:32", "46793", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5935", "woocommerce_cleanup_personal_data", "complete", "2026-01-18 11:11:01", "2026-01-18 11:11:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768734661;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768734661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-18 11:31:33", "2026-01-18 07:31:33", "46793", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5936", "woocommerce_cleanup_logs", "complete", "2026-01-18 11:11:01", "2026-01-18 11:11:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768734661;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768734661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-18 11:31:33", "2026-01-18 07:31:33", "46793", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5937", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-18 11:11:01", "2026-01-18 11:11:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768734661;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768734661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-18 11:31:34", "2026-01-18 07:31:34", "46793", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5938", "woocommerce_cleanup_sessions", "complete", "2026-01-18 10:00:00", "2026-01-18 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768730400;s:18:\"\0*\0first_timestamp\";i:1768730400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768730400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-18 10:04:05", "2026-01-18 06:04:05", "46786", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5939", "generate_category_lookup_table_wrapper", "complete", "2026-01-17 11:11:11", "2026-01-17 11:11:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768648271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768648271;}", "12", "1", "2026-01-17 11:12:47", "2026-01-17 07:12:47", "46599", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5940", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-18 11:11:01", "2026-01-18 11:11:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768734661;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768734661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-18 11:31:34", "2026-01-18 07:31:34", "46793", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5941", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 12:38:23", "2026-01-17 12:38:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768653503;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768653503;}", "12", "1", "2026-01-17 12:42:58", "2026-01-17 08:42:58", "46611", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5942", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 13:42:58", "2026-01-17 13:42:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768657378;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768657378;}", "12", "1", "2026-01-17 13:44:31", "2026-01-17 09:44:31", "46624", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5943", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 14:44:31", "2026-01-17 14:44:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768661071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768661071;}", "12", "1", "2026-01-17 15:03:26", "2026-01-17 11:03:26", "46634", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5944", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 16:03:26", "2026-01-17 16:03:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768665806;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768665806;}", "12", "1", "2026-01-17 16:09:22", "2026-01-17 12:09:22", "46642", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5945", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 17:09:22", "2026-01-17 17:09:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768669762;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768669762;}", "12", "1", "2026-01-17 17:16:03", "2026-01-17 13:16:03", "46654", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5946", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-17 16:13:03", "2026-01-17 16:13:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768666383;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768666383;}", "8", "1", "2026-01-17 16:13:03", "2026-01-17 12:13:03", "46644", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5947", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 18:16:03", "2026-01-17 18:16:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768673763;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768673763;}", "12", "1", "2026-01-17 18:17:08", "2026-01-17 14:17:08", "46664", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5948", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 19:17:08", "2026-01-17 19:17:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768677428;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768677428;}", "12", "1", "2026-01-17 19:22:01", "2026-01-17 15:22:01", "46677", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5949", "woocommerce_cleanup_draft_orders", "complete", "2026-01-18 19:15:38", "2026-01-18 19:15:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768763738;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768763738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-18 19:31:46", "2026-01-18 15:31:46", "46834", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5950", "woocommerce_scheduled_sales", "complete", "2026-01-18 19:15:38", "2026-01-18 19:15:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768763738;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768763738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-18 19:31:46", "2026-01-18 15:31:46", "46834", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5951", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 20:22:01", "2026-01-17 20:22:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768681321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768681321;}", "12", "1", "2026-01-17 20:36:28", "2026-01-17 16:36:28", "46689", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5952", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 21:36:28", "2026-01-17 21:36:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768685788;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768685788;}", "12", "1", "2026-01-17 21:46:37", "2026-01-17 17:46:37", "46702", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5953", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 22:46:37", "2026-01-17 22:46:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768689997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768689997;}", "12", "1", "2026-01-17 22:57:24", "2026-01-17 18:57:24", "46711", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5954", "woocommerce_refresh_order_count_cache", "complete", "2026-01-18 10:45:00", "2026-01-18 10:45:00", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768733100;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768733100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-18 11:31:31", "2026-01-18 07:31:31", "46793", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5955", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 23:57:24", "2026-01-17 23:57:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768694244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768694244;}", "12", "1", "2026-01-18 00:14:03", "2026-01-17 20:14:03", "46718", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5956", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 01:14:03", "2026-01-18 01:14:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768698843;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768698843;}", "12", "1", "2026-01-18 01:15:00", "2026-01-17 21:15:00", "46728", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5957", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 02:15:00", "2026-01-18 02:15:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768702500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768702500;}", "12", "1", "2026-01-18 02:19:21", "2026-01-17 22:19:21", "46737", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5958", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 03:19:21", "2026-01-18 03:19:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768706361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768706361;}", "12", "1", "2026-01-18 03:38:16", "2026-01-17 23:38:16", "46744", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5959", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 04:38:16", "2026-01-18 04:38:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768711096;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768711096;}", "12", "1", "2026-01-18 04:46:00", "2026-01-18 00:46:00", "46751", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5960", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-18 04:21:22", "2026-01-18 04:21:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768710082;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768710082;}", "8", "1", "2026-01-18 04:21:49", "2026-01-18 00:21:49", "46748", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5961", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 05:46:00", "2026-01-18 05:46:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768715160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768715160;}", "12", "1", "2026-01-18 05:55:35", "2026-01-18 01:55:35", "46757", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5962", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 06:55:35", "2026-01-18 06:55:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768719335;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768719335;}", "12", "1", "2026-01-18 07:07:18", "2026-01-18 03:07:18", "46763", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5963", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 08:07:18", "2026-01-18 08:07:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768723638;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768723638;}", "12", "1", "2026-01-18 08:10:01", "2026-01-18 04:10:01", "46768", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5964", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 09:10:01", "2026-01-18 09:10:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768727401;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768727401;}", "12", "1", "2026-01-18 09:12:22", "2026-01-18 05:12:22", "46780", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5965", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 10:12:22", "2026-01-18 10:12:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768731142;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768731142;}", "12", "1", "2026-01-18 10:17:33", "2026-01-18 06:17:33", "46788", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5967", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 11:17:33", "2026-01-18 11:17:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768735053;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768735053;}", "12", "1", "2026-01-18 11:31:34", "2026-01-18 07:31:34", "46793", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5968", "woocommerce_refresh_order_count_cache", "complete", "2026-01-18 23:31:31", "2026-01-18 23:31:31", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768779091;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768779091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-18 23:36:38", "2026-01-18 19:36:38", "46860", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5969", "wc_admin_daily_wrapper", "complete", "2026-01-19 11:31:32", "2026-01-19 11:31:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768822292;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768822292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-19 11:44:04", "2026-01-19 07:44:04", "46911", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5970", "woocommerce_cleanup_personal_data", "complete", "2026-01-19 11:31:33", "2026-01-19 11:31:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768822293;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768822293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-19 11:44:05", "2026-01-19 07:44:05", "46911", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5971", "woocommerce_cleanup_logs", "complete", "2026-01-19 11:31:33", "2026-01-19 11:31:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768822293;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768822293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-19 11:44:05", "2026-01-19 07:44:05", "46911", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5972", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-19 11:31:34", "2026-01-19 11:31:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768822294;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768822294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-19 11:44:05", "2026-01-19 07:44:05", "46911", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5973", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 12:31:34", "2026-01-18 12:31:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768739494;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768739494;}", "12", "1", "2026-01-18 13:01:09", "2026-01-18 09:01:09", "46797", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5974", "woocommerce_cleanup_sessions", "complete", "2026-01-19 10:00:00", "2026-01-19 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768816800;s:18:\"\0*\0first_timestamp\";i:1768816800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768816800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-19 10:41:31", "2026-01-19 06:41:31", "46907", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5975", "generate_category_lookup_table_wrapper", "complete", "2026-01-18 11:31:44", "2026-01-18 11:31:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768735904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768735904;}", "12", "1", "2026-01-18 11:54:49", "2026-01-18 07:54:49", "46795", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5976", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-19 11:31:34", "2026-01-19 11:31:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768822294;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768822294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-19 11:44:05", "2026-01-19 07:44:05", "46911", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5977", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 14:01:09", "2026-01-18 14:01:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768744869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768744869;}", "12", "1", "2026-01-18 14:12:03", "2026-01-18 10:12:03", "46802", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5978", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 15:12:03", "2026-01-18 15:12:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768749123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768749123;}", "12", "1", "2026-01-18 15:44:01", "2026-01-18 11:44:01", "46808", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5979", "woocommerce_geoip_updater", "pending", "2026-02-02 14:17:32", "2026-02-02 14:17:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770041852;s:18:\"\0*\0first_timestamp\";i:1755776236;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770041852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5980", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 16:44:01", "2026-01-18 16:44:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768754641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768754641;}", "12", "1", "2026-01-18 17:03:59", "2026-01-18 13:03:59", "46821", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5981", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-18 16:09:58", "2026-01-18 16:09:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768752598;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768752598;}", "8", "1", "2026-01-18 16:14:32", "2026-01-18 12:14:32", "46814", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5982", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 18:03:59", "2026-01-18 18:03:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768759439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768759439;}", "12", "1", "2026-01-18 18:06:58", "2026-01-18 14:06:58", "46826", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5983", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 19:06:58", "2026-01-18 19:06:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768763218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768763218;}", "12", "1", "2026-01-18 19:31:46", "2026-01-18 15:31:46", "46834", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5984", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 20:31:46", "2026-01-18 20:31:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768768306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768768306;}", "12", "1", "2026-01-18 20:35:40", "2026-01-18 16:35:40", "46839", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5985", "woocommerce_cleanup_draft_orders", "complete", "2026-01-19 19:31:46", "2026-01-19 19:31:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768851106;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768851106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-19 19:47:06", "2026-01-19 15:47:06", "46959", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5986", "woocommerce_scheduled_sales", "complete", "2026-01-19 19:31:46", "2026-01-19 19:31:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768851106;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768851106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-19 19:47:06", "2026-01-19 15:47:06", "46959", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5987", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 21:35:40", "2026-01-18 21:35:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768772140;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768772140;}", "12", "1", "2026-01-18 21:50:25", "2026-01-18 17:50:25", "46847", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5988", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-18 22:50:25", "2026-01-18 22:50:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768776625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768776625;}", "12", "1", "2026-01-18 23:21:58", "2026-01-18 19:21:58", "46855", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5989", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 00:21:58", "2026-01-19 00:21:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768782118;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768782118;}", "12", "1", "2026-01-19 00:32:22", "2026-01-18 20:32:22", "46864", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5990", "woocommerce_refresh_order_count_cache", "complete", "2026-01-19 11:36:38", "2026-01-19 11:36:38", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768822598;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768822598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-19 11:44:05", "2026-01-19 07:44:05", "46911", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5991", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 01:32:22", "2026-01-19 01:32:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768786342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768786342;}", "12", "1", "2026-01-19 02:17:36", "2026-01-18 22:17:36", "46867", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5992", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 03:17:36", "2026-01-19 03:17:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768792656;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768792656;}", "12", "1", "2026-01-19 03:32:52", "2026-01-18 23:32:52", "46872", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5993", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 04:32:52", "2026-01-19 04:32:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768797172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768797172;}", "12", "1", "2026-01-19 04:39:06", "2026-01-19 00:39:06", "46879", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5994", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-19 04:20:37", "2026-01-19 04:20:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768796437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768796437;}", "8", "1", "2026-01-19 04:39:06", "2026-01-19 00:39:06", "46879", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5995", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 05:39:06", "2026-01-19 05:39:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768801146;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768801146;}", "12", "1", "2026-01-19 05:46:31", "2026-01-19 01:46:31", "46886", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5996", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 06:46:31", "2026-01-19 06:46:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768805191;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768805191;}", "12", "1", "2026-01-19 06:51:35", "2026-01-19 02:51:35", "46895", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5997", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 07:51:35", "2026-01-19 07:51:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768809095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768809095;}", "12", "1", "2026-01-19 08:19:55", "2026-01-19 04:19:55", "46901", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5998", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 09:19:55", "2026-01-19 09:19:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768814395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768814395;}", "12", "1", "2026-01-19 09:57:19", "2026-01-19 05:57:19", "46905", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("5999", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 10:57:19", "2026-01-19 10:57:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768820239;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768820239;}", "12", "1", "2026-01-19 11:22:45", "2026-01-19 07:22:45", "46909", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6001", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 12:22:45", "2026-01-19 12:22:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768825365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768825365;}", "12", "1", "2026-01-19 12:51:49", "2026-01-19 08:51:49", "46915", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6002", "wc_admin_daily_wrapper", "complete", "2026-01-20 11:44:04", "2026-01-20 11:44:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768909444;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768909444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-20 12:29:45", "2026-01-20 08:29:45", "47050", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6003", "woocommerce_cleanup_personal_data", "complete", "2026-01-20 11:44:05", "2026-01-20 11:44:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768909445;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768909445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-20 12:29:46", "2026-01-20 08:29:46", "47050", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6004", "woocommerce_cleanup_logs", "complete", "2026-01-20 11:44:05", "2026-01-20 11:44:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768909445;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768909445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-20 12:29:46", "2026-01-20 08:29:46", "47050", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6005", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-20 11:44:05", "2026-01-20 11:44:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768909445;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768909445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-20 12:29:46", "2026-01-20 08:29:46", "47050", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6006", "woocommerce_refresh_order_count_cache", "complete", "2026-01-19 23:44:05", "2026-01-19 23:44:05", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768866245;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768866245;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-19 23:44:26", "2026-01-19 19:44:26", "46996", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6007", "woocommerce_cleanup_sessions", "complete", "2026-01-20 10:00:00", "2026-01-20 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768903200;s:18:\"\0*\0first_timestamp\";i:1768903200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768903200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-20 10:03:37", "2026-01-20 06:03:37", "47045", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6008", "generate_category_lookup_table_wrapper", "complete", "2026-01-19 11:44:15", "2026-01-19 11:44:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768823055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768823055;}", "12", "1", "2026-01-19 12:16:10", "2026-01-19 08:16:10", "46913", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6009", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-20 11:44:05", "2026-01-20 11:44:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768909445;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768909445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-20 12:29:46", "2026-01-20 08:29:46", "47050", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6010", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 13:51:49", "2026-01-19 13:51:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768830709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768830709;}", "12", "1", "2026-01-19 13:57:57", "2026-01-19 09:57:57", "46923", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6011", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 14:57:57", "2026-01-19 14:57:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768834677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768834677;}", "12", "1", "2026-01-19 15:03:52", "2026-01-19 11:03:52", "46933", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6012", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 16:03:52", "2026-01-19 16:03:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768838632;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768838632;}", "12", "1", "2026-01-19 16:09:12", "2026-01-19 12:09:12", "46938", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6013", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 17:09:12", "2026-01-19 17:09:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768842552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768842552;}", "12", "1", "2026-01-19 17:28:41", "2026-01-19 13:28:41", "46945", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6014", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-19 16:18:30", "2026-01-19 16:18:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768839510;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768839510;}", "8", "1", "2026-01-19 16:18:30", "2026-01-19 12:18:30", "46940", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6015", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 18:28:41", "2026-01-19 18:28:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768847321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768847321;}", "12", "1", "2026-01-19 18:48:10", "2026-01-19 14:48:10", "46951", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6016", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 19:48:09", "2026-01-19 19:48:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768852089;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768852089;}", "12", "1", "2026-01-19 19:52:56", "2026-01-19 15:52:56", "46961", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6017", "woocommerce_cleanup_draft_orders", "complete", "2026-01-20 19:47:06", "2026-01-20 19:47:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768938426;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768938426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-20 19:48:07", "2026-01-20 15:48:07", "47098", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6018", "woocommerce_scheduled_sales", "complete", "2026-01-20 19:47:06", "2026-01-20 19:47:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768938426;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768938426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-20 19:48:07", "2026-01-20 15:48:07", "47098", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6019", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 20:52:56", "2026-01-19 20:52:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768855976;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768855976;}", "12", "1", "2026-01-19 21:04:56", "2026-01-19 17:04:56", "46968", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6020", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 22:04:56", "2026-01-19 22:04:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768860296;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768860296;}", "12", "1", "2026-01-19 22:28:39", "2026-01-19 18:28:39", "46978", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6021", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 23:28:39", "2026-01-19 23:28:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768865319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768865319;}", "12", "1", "2026-01-19 23:29:40", "2026-01-19 19:29:40", "46991", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6022", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 00:29:40", "2026-01-20 00:29:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768868980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768868980;}", "12", "1", "2026-01-20 00:50:23", "2026-01-19 20:50:23", "47001", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6023", "woocommerce_refresh_order_count_cache", "complete", "2026-01-20 11:44:26", "2026-01-20 11:44:26", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768909466;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768909466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-20 12:29:46", "2026-01-20 08:29:46", "47050", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6024", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 01:50:23", "2026-01-20 01:50:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768873823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768873823;}", "12", "1", "2026-01-20 02:43:49", "2026-01-19 22:43:49", "47009", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6025", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 03:43:49", "2026-01-20 03:43:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768880629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768880629;}", "12", "1", "2026-01-20 03:57:29", "2026-01-19 23:57:29", "47013", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6026", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 04:57:29", "2026-01-20 04:57:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768885049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768885049;}", "12", "1", "2026-01-20 05:13:16", "2026-01-20 01:13:16", "47019", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6027", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-20 04:22:32", "2026-01-20 04:22:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768882952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768882952;}", "8", "1", "2026-01-20 04:22:32", "2026-01-20 00:22:32", "47016", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6028", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 06:13:16", "2026-01-20 06:13:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768889596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768889596;}", "12", "1", "2026-01-20 06:16:56", "2026-01-20 02:16:56", "47026", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6029", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 07:16:56", "2026-01-20 07:16:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768893416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768893416;}", "12", "1", "2026-01-20 07:40:22", "2026-01-20 03:40:22", "47030", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6030", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 08:40:22", "2026-01-20 08:40:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768898422;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768898422;}", "12", "1", "2026-01-20 08:44:06", "2026-01-20 04:44:06", "47034", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6031", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 09:44:06", "2026-01-20 09:44:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768902246;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768902246;}", "12", "1", "2026-01-20 10:03:37", "2026-01-20 06:03:37", "47045", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6032", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 11:03:37", "2026-01-20 11:03:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768907017;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768907017;}", "12", "1", "2026-01-20 11:14:13", "2026-01-20 07:14:13", "47048", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6034", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 12:14:13", "2026-01-20 12:14:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768911253;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768911253;}", "12", "1", "2026-01-20 12:29:46", "2026-01-20 08:29:46", "47050", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6035", "wc_admin_daily_wrapper", "complete", "2026-01-21 12:29:45", "2026-01-21 12:29:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768998585;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768998585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-21 12:40:12", "2026-01-21 08:40:12", "47185", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6036", "woocommerce_cleanup_personal_data", "complete", "2026-01-21 12:29:46", "2026-01-21 12:29:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768998586;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768998586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-21 12:40:14", "2026-01-21 08:40:14", "47185", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6037", "woocommerce_cleanup_logs", "complete", "2026-01-21 12:29:46", "2026-01-21 12:29:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768998586;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768998586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-21 12:40:14", "2026-01-21 08:40:14", "47185", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6038", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-21 12:29:46", "2026-01-21 12:29:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768998586;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768998586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-21 12:40:14", "2026-01-21 08:40:14", "47185", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6039", "woocommerce_refresh_order_count_cache", "complete", "2026-01-21 00:29:46", "2026-01-21 00:29:46", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768955386;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768955386;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-21 00:48:32", "2026-01-20 20:48:32", "47121", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6040", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 13:29:46", "2026-01-20 13:29:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768915786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768915786;}", "12", "1", "2026-01-20 13:41:25", "2026-01-20 09:41:25", "47056", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6041", "woocommerce_cleanup_sessions", "complete", "2026-01-21 10:00:00", "2026-01-21 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768989600;s:18:\"\0*\0first_timestamp\";i:1768989600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768989600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-21 10:39:25", "2026-01-21 06:39:25", "47173", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6042", "generate_category_lookup_table_wrapper", "complete", "2026-01-20 12:29:56", "2026-01-20 12:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768912196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768912196;}", "12", "1", "2026-01-20 13:06:41", "2026-01-20 09:06:41", "47052", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6043", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-21 12:29:46", "2026-01-21 12:29:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768998586;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768998586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-21 12:40:14", "2026-01-21 08:40:14", "47185", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6044", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 14:41:25", "2026-01-20 14:41:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768920085;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768920085;}", "12", "1", "2026-01-20 15:04:31", "2026-01-20 11:04:31", "47061", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6045", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 16:04:31", "2026-01-20 16:04:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768925071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768925071;}", "12", "1", "2026-01-20 16:18:05", "2026-01-20 12:18:05", "47067", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6046", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 17:18:05", "2026-01-20 17:18:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768929485;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768929485;}", "12", "1", "2026-01-20 17:23:44", "2026-01-20 13:23:44", "47080", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6047", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-20 16:18:05", "2026-01-20 16:18:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768925885;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768925885;}", "8", "1", "2026-01-20 16:24:12", "2026-01-20 12:24:12", "47069", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6048", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 18:23:44", "2026-01-20 18:23:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768933424;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768933424;}", "12", "1", "2026-01-20 18:31:36", "2026-01-20 14:31:36", "47087", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6049", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 19:31:36", "2026-01-20 19:31:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768937496;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768937496;}", "12", "1", "2026-01-20 19:48:07", "2026-01-20 15:48:07", "47098", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6050", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 20:48:07", "2026-01-20 20:48:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768942087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768942087;}", "12", "1", "2026-01-20 21:06:03", "2026-01-20 17:06:03", "47102", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6051", "woocommerce_cleanup_draft_orders", "complete", "2026-01-21 19:48:07", "2026-01-21 19:48:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769024887;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769024887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-21 19:57:03", "2026-01-21 15:57:03", "47236", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6052", "woocommerce_scheduled_sales", "complete", "2026-01-21 19:48:07", "2026-01-21 19:48:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769024887;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769024887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-21 19:57:03", "2026-01-21 15:57:03", "47236", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6053", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 22:06:03", "2026-01-20 22:06:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768946763;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768946763;}", "12", "1", "2026-01-20 22:15:25", "2026-01-20 18:15:25", "47111", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6054", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 23:15:25", "2026-01-20 23:15:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768950925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768950925;}", "12", "1", "2026-01-20 23:21:33", "2026-01-20 19:21:33", "47118", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6055", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 00:21:33", "2026-01-21 00:21:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768954893;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768954893;}", "12", "1", "2026-01-21 00:48:32", "2026-01-20 20:48:32", "47121", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6056", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 01:48:32", "2026-01-21 01:48:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768960112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768960112;}", "12", "1", "2026-01-21 02:22:27", "2026-01-20 22:22:27", "47127", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6057", "woocommerce_refresh_order_count_cache", "complete", "2026-01-21 12:48:32", "2026-01-21 12:48:32", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768999712;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768999712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-21 13:02:35", "2026-01-21 09:02:35", "47191", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6058", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 03:22:27", "2026-01-21 03:22:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768965747;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768965747;}", "12", "1", "2026-01-21 03:24:34", "2026-01-20 23:24:34", "47133", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6059", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 04:24:34", "2026-01-21 04:24:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768969474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768969474;}", "12", "1", "2026-01-21 04:31:07", "2026-01-21 00:31:07", "47136", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6060", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 05:31:07", "2026-01-21 05:31:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768973467;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768973467;}", "12", "1", "2026-01-21 05:50:07", "2026-01-21 01:50:07", "47148", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6061", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-21 04:31:07", "2026-01-21 04:31:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768969867;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768969867;}", "8", "1", "2026-01-21 04:36:31", "2026-01-21 00:36:31", "47138", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6062", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 06:50:07", "2026-01-21 06:50:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768978207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768978207;}", "12", "1", "2026-01-21 06:59:23", "2026-01-21 02:59:23", "47156", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6063", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 07:59:23", "2026-01-21 07:59:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768982363;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768982363;}", "12", "1", "2026-01-21 08:05:58", "2026-01-21 04:05:58", "47163", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6064", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 09:05:58", "2026-01-21 09:05:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768986358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768986358;}", "12", "1", "2026-01-21 09:22:37", "2026-01-21 05:22:37", "47171", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6065", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 10:22:37", "2026-01-21 10:22:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768990957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768990957;}", "12", "1", "2026-01-21 10:39:25", "2026-01-21 06:39:25", "47173", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6067", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 11:39:25", "2026-01-21 11:39:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768995565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768995565;}", "12", "1", "2026-01-21 11:46:32", "2026-01-21 07:46:32", "47182", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6068", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 12:46:32", "2026-01-21 12:46:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768999592;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768999592;}", "12", "1", "2026-01-21 13:02:35", "2026-01-21 09:02:35", "47191", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6069", "wc_admin_daily_wrapper", "complete", "2026-01-22 12:40:13", "2026-01-22 12:40:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769085613;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769085613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-22 12:42:24", "2026-01-22 08:42:24", "47360", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6070", "woocommerce_cleanup_personal_data", "complete", "2026-01-22 12:40:14", "2026-01-22 12:40:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769085614;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769085614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-22 12:42:25", "2026-01-22 08:42:25", "47360", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6071", "woocommerce_cleanup_logs", "complete", "2026-01-22 12:40:14", "2026-01-22 12:40:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769085614;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769085614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-22 12:42:25", "2026-01-22 08:42:25", "47360", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6072", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-22 12:40:14", "2026-01-22 12:40:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769085614;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769085614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-22 12:42:25", "2026-01-22 08:42:25", "47360", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6073", "woocommerce_cleanup_sessions", "complete", "2026-01-22 10:00:00", "2026-01-22 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769076000;s:18:\"\0*\0first_timestamp\";i:1769076000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769076000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-22 10:22:45", "2026-01-22 06:22:45", "47339", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6074", "generate_category_lookup_table_wrapper", "complete", "2026-01-21 12:40:24", "2026-01-21 12:40:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768999224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768999224;}", "12", "1", "2026-01-21 12:41:47", "2026-01-21 08:41:47", "47187", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6075", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-22 12:40:14", "2026-01-22 12:40:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769085614;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769085614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-22 12:42:25", "2026-01-22 08:42:25", "47360", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6076", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 14:02:35", "2026-01-21 14:02:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769004155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769004155;}", "12", "1", "2026-01-21 14:20:13", "2026-01-21 10:20:13", "47196", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6077", "woocommerce_refresh_order_count_cache", "complete", "2026-01-22 01:02:35", "2026-01-22 01:02:35", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769043755;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769043755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-22 01:04:06", "2026-01-21 21:04:06", "47269", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6078", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 15:20:13", "2026-01-21 15:20:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769008813;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769008813;}", "12", "1", "2026-01-21 15:21:03", "2026-01-21 11:21:03", "47206", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6079", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 16:21:03", "2026-01-21 16:21:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769012463;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769012463;}", "12", "1", "2026-01-21 16:29:00", "2026-01-21 12:29:00", "47216", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6080", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-21 16:20:39", "2026-01-21 16:20:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769012439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769012439;}", "8", "1", "2026-01-21 16:20:53", "2026-01-21 12:20:53", "47214", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6081", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 17:29:00", "2026-01-21 17:29:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769016540;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769016540;}", "12", "1", "2026-01-21 17:42:46", "2026-01-21 13:42:46", "47224", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6082", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 18:42:46", "2026-01-21 18:42:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769020966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769020966;}", "12", "1", "2026-01-21 18:55:18", "2026-01-21 14:55:18", "47231", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6083", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 19:55:18", "2026-01-21 19:55:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769025318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769025318;}", "12", "1", "2026-01-21 19:57:03", "2026-01-21 15:57:03", "47236", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6084", "woocommerce_cleanup_draft_orders", "complete", "2026-01-22 19:57:03", "2026-01-22 19:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769111823;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769111823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-01-22 20:17:08", "2026-01-22 16:17:08", "47404", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6085", "woocommerce_scheduled_sales", "complete", "2026-01-22 19:57:03", "2026-01-22 19:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769111823;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769111823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-22 20:17:08", "2026-01-22 16:17:08", "47404", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6086", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 20:57:03", "2026-01-21 20:57:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769029023;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769029023;}", "12", "1", "2026-01-21 21:20:53", "2026-01-21 17:20:53", "47244", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6087", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 22:20:53", "2026-01-21 22:20:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769034053;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769034053;}", "12", "1", "2026-01-21 22:25:13", "2026-01-21 18:25:13", "47250", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6088", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 23:25:13", "2026-01-21 23:25:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769037913;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769037913;}", "12", "1", "2026-01-21 23:33:31", "2026-01-21 19:33:31", "47259", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6089", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 00:33:31", "2026-01-22 00:33:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769042011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769042011;}", "12", "1", "2026-01-22 00:36:08", "2026-01-21 20:36:08", "47263", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6090", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 01:36:08", "2026-01-22 01:36:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769045768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769045768;}", "12", "1", "2026-01-22 01:38:22", "2026-01-21 21:38:22", "47276", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6091", "woocommerce_refresh_order_count_cache", "complete", "2026-01-22 13:04:06", "2026-01-22 13:04:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769087046;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769087046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-22 13:05:42", "2026-01-22 09:05:42", "47367", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6092", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 02:38:22", "2026-01-22 02:38:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769049502;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769049502;}", "12", "1", "2026-01-22 02:43:31", "2026-01-21 22:43:31", "47280", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6093", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 03:43:31", "2026-01-22 03:43:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769053411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769053411;}", "12", "1", "2026-01-22 03:49:47", "2026-01-21 23:49:47", "47291", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6094", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 04:49:47", "2026-01-22 04:49:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769057387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769057387;}", "12", "1", "2026-01-22 04:58:50", "2026-01-22 00:58:50", "47301", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6095", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-22 04:09:59", "2026-01-22 04:09:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769054999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769054999;}", "8", "1", "2026-01-22 04:12:09", "2026-01-22 00:12:09", "47298", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6096", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 05:58:50", "2026-01-22 05:58:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769061530;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769061530;}", "12", "1", "2026-01-22 06:04:49", "2026-01-22 02:04:49", "47308", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6097", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 07:04:49", "2026-01-22 07:04:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769065489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769065489;}", "12", "1", "2026-01-22 07:06:22", "2026-01-22 03:06:22", "47317", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6098", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 08:06:22", "2026-01-22 08:06:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769069182;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769069182;}", "12", "1", "2026-01-22 08:32:30", "2026-01-22 04:32:30", "47328", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6099", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 09:32:30", "2026-01-22 09:32:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769074350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769074350;}", "12", "1", "2026-01-22 09:35:24", "2026-01-22 05:35:24", "47335", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6100", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 10:35:24", "2026-01-22 10:35:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769078124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769078124;}", "12", "1", "2026-01-22 10:48:22", "2026-01-22 06:48:22", "47344", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6102", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 11:48:22", "2026-01-22 11:48:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769082502;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769082502;}", "12", "1", "2026-01-22 11:48:46", "2026-01-22 07:48:46", "47352", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6103", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 12:48:46", "2026-01-22 12:48:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769086126;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769086126;}", "12", "1", "2026-01-22 12:52:29", "2026-01-22 08:52:29", "47364", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6104", "wc_admin_daily_wrapper", "complete", "2026-01-23 12:42:24", "2026-01-23 12:42:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769172144;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769172144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-23 12:43:38", "2026-01-23 08:43:38", "47523", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6105", "woocommerce_cleanup_personal_data", "complete", "2026-01-23 12:42:25", "2026-01-23 12:42:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769172145;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769172145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-23 12:43:39", "2026-01-23 08:43:39", "47523", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6106", "woocommerce_cleanup_logs", "complete", "2026-01-23 12:42:25", "2026-01-23 12:42:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769172145;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769172145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-23 12:43:39", "2026-01-23 08:43:39", "47523", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6107", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-23 12:42:25", "2026-01-23 12:42:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769172145;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769172145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2026-01-23 12:43:39", "2026-01-23 08:43:39", "47523", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6108", "woocommerce_cleanup_sessions", "complete", "2026-01-23 10:00:00", "2026-01-23 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769162400;s:18:\"\0*\0first_timestamp\";i:1769162400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769162400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2026-01-23 10:03:07", "2026-01-23 06:03:07", "47506", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6109", "generate_category_lookup_table_wrapper", "complete", "2026-01-22 12:42:35", "2026-01-22 12:42:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769085755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769085755;}", "12", "1", "2026-01-22 12:45:38", "2026-01-22 08:45:38", "47362", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6110", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-23 12:42:25", "2026-01-23 12:42:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769172145;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769172145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-23 12:43:39", "2026-01-23 08:43:39", "47523", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6111", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 13:52:29", "2026-01-22 13:52:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769089949;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769089949;}", "12", "1", "2026-01-22 14:12:05", "2026-01-22 10:12:05", "47372", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6112", "woocommerce_refresh_order_count_cache", "complete", "2026-01-23 01:05:42", "2026-01-23 01:05:42", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769130342;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769130342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-23 01:09:08", "2026-01-22 21:09:08", "47443", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6113", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 15:12:05", "2026-01-22 15:12:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769094725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769094725;}", "12", "1", "2026-01-22 15:13:38", "2026-01-22 11:13:38", "47384", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6114", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 16:13:38", "2026-01-22 16:13:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769098418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769098418;}", "12", "1", "2026-01-22 16:23:51", "2026-01-22 12:23:51", "47390", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6115", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 17:23:51", "2026-01-22 17:23:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769102631;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769102631;}", "12", "1", "2026-01-22 17:45:12", "2026-01-22 13:45:12", "47396", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6116", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-22 16:23:51", "2026-01-22 16:23:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769099031;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769099031;}", "8", "1", "2026-01-22 16:34:12", "2026-01-22 12:34:12", "47392", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6117", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 18:45:12", "2026-01-22 18:45:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769107512;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769107512;}", "12", "1", "2026-01-22 19:11:17", "2026-01-22 15:11:17", "47401", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6118", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 20:11:17", "2026-01-22 20:11:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769112677;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769112677;}", "12", "1", "2026-01-22 20:17:08", "2026-01-22 16:17:08", "47404", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6119", "woocommerce_cleanup_draft_orders", "pending", "2026-01-23 20:17:08", "2026-01-23 20:17:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769199428;s:18:\"\0*\0first_timestamp\";i:1658432426;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769199428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6120", "woocommerce_scheduled_sales", "pending", "2026-01-23 20:17:08", "2026-01-23 20:17:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769199428;s:18:\"\0*\0first_timestamp\";i:1755835200;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769199428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6121", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 21:17:08", "2026-01-22 21:17:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769116628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769116628;}", "12", "1", "2026-01-22 21:27:06", "2026-01-22 17:27:06", "47412", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6122", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 22:27:06", "2026-01-22 22:27:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769120826;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769120826;}", "12", "1", "2026-01-22 22:43:37", "2026-01-22 18:43:37", "47422", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6123", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 23:43:37", "2026-01-22 23:43:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769125417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769125417;}", "12", "1", "2026-01-23 00:19:46", "2026-01-22 20:19:46", "47434", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6124", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 01:19:46", "2026-01-23 01:19:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769131186;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769131186;}", "12", "1", "2026-01-23 01:35:24", "2026-01-22 21:35:24", "47446", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6125", "woocommerce_refresh_order_count_cache", "complete", "2026-01-23 13:09:08", "2026-01-23 13:09:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769173748;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769173748;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2026-01-23 13:11:17", "2026-01-23 09:11:17", "47544", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6126", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 02:35:24", "2026-01-23 02:35:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769135724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769135724;}", "12", "1", "2026-01-23 02:57:25", "2026-01-22 22:57:25", "47453", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6127", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 03:57:25", "2026-01-23 03:57:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769140645;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769140645;}", "12", "1", "2026-01-23 04:00:02", "2026-01-23 00:00:02", "47455", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6128", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 05:00:02", "2026-01-23 05:00:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769144402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769144402;}", "12", "1", "2026-01-23 05:18:45", "2026-01-23 01:18:45", "47463", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6129", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2026-01-23 04:16:50", "2026-01-23 04:16:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769141810;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769141810;}", "8", "1", "2026-01-23 04:17:50", "2026-01-23 00:17:50", "47458", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6130", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 06:18:45", "2026-01-23 06:18:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769149125;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769149125;}", "12", "1", "2026-01-23 06:24:39", "2026-01-23 02:24:39", "47476", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6131", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 07:24:39", "2026-01-23 07:24:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769153079;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769153079;}", "12", "1", "2026-01-23 07:25:27", "2026-01-23 03:25:27", "47486", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6132", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 08:25:27", "2026-01-23 08:25:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769156727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769156727;}", "12", "1", "2026-01-23 08:34:14", "2026-01-23 04:34:14", "47491", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6133", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 09:34:14", "2026-01-23 09:34:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769160854;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769160854;}", "12", "1", "2026-01-23 09:36:25", "2026-01-23 05:36:25", "47500", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6134", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 10:36:25", "2026-01-23 10:36:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769164585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769164585;}", "12", "1", "2026-01-23 10:36:35", "2026-01-23 06:36:35", "47510", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6136", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 11:36:35", "2026-01-23 11:36:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769168195;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769168195;}", "12", "1", "2026-01-23 11:47:45", "2026-01-23 07:47:45", "47518", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6137", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 12:47:45", "2026-01-23 12:47:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769172465;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769172465;}", "12", "1", "2026-01-23 12:49:57", "2026-01-23 08:49:57", "47529", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6138", "wc_admin_daily_wrapper", "pending", "2026-01-24 12:43:38", "2026-01-24 12:43:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769258618;s:18:\"\0*\0first_timestamp\";i:1755776176;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769258618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6139", "woocommerce_cleanup_personal_data", "pending", "2026-01-24 12:43:39", "2026-01-24 12:43:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769258619;s:18:\"\0*\0first_timestamp\";i:1755776186;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769258619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6140", "woocommerce_cleanup_logs", "pending", "2026-01-24 12:43:39", "2026-01-24 12:43:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769258619;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769258619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6141", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2026-01-24 12:43:39", "2026-01-24 12:43:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769258619;s:18:\"\0*\0first_timestamp\";i:1755786976;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769258619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6142", "woocommerce_cleanup_sessions", "pending", "2026-01-24 10:00:00", "2026-01-24 10:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769248800;s:18:\"\0*\0first_timestamp\";i:1769248800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769248800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6143", "generate_category_lookup_table_wrapper", "complete", "2026-01-23 12:43:49", "2026-01-23 12:43:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769172229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769172229;}", "12", "1", "2026-01-23 12:44:44", "2026-01-23 08:44:44", "47525", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6144", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-01-24 12:43:39", "2026-01-24 12:43:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769258619;s:18:\"\0*\0first_timestamp\";i:1755164704;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769258619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6145", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 13:49:57", "2026-01-23 13:49:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769176197;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769176197;}", "12", "1", "2026-01-23 13:50:12", "2026-01-23 09:50:12", "47564", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6146", "woocommerce_refresh_order_count_cache", "pending", "2026-01-24 01:11:17", "2026-01-24 01:11:17", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769217077;s:18:\"\0*\0first_timestamp\";i:1749533432;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769217077;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6147", "woocommerce_cancel_unpaid_orders", "pending", "2026-01-23 14:50:12", "2026-01-23 14:50:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769179812;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769179812;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6148", "fetch_patterns", "complete", "2026-01-23 14:18:29", "2026-01-23 14:18:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769177909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769177909;}", "8", "1", "2026-01-23 14:18:36", "2026-01-23 10:18:36", "47578", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6149", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2026-01-23 14:18:34", "2026-01-23 14:18:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769177914;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769177914;}", "2", "1", "2026-01-23 14:18:36", "2026-01-23 10:18:36", "47578", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6150", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2026-01-23 14:18:36", "2026-01-23 14:18:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769177916;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769177916;}", "7", "1", "2026-01-23 14:18:38", "2026-01-23 10:18:38", "47578", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6151", "woocommerce_run_update_callback", "complete", "2026-01-23 14:31:59", "2026-01-23 14:31:59", "{\"update_callback\":\"wc_update_1040_add_idx_date_paid_status_parent\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178719;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178719;}", "2", "1", "2026-01-23 14:32:19", "2026-01-23 10:32:19", "47592", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6152", "woocommerce_run_update_callback", "complete", "2026-01-23 14:32:00", "2026-01-23 14:32:00", "{\"update_callback\":\"wc_update_1040_cleanup_legacy_ptk_patterns_fetching\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178720;}", "2", "1", "2026-01-23 14:32:20", "2026-01-23 10:32:20", "47592", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6153", "woocommerce_update_db_to_current_version", "complete", "2026-01-23 14:32:01", "2026-01-23 14:32:01", "{\"version\":\"10.4.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178721;}", "2", "1", "2026-01-23 14:32:20", "2026-01-23 10:32:20", "47592", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6154", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2026-01-23 14:32:00", "2026-01-23 14:32:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178720;}", "2", "1", "2026-01-23 14:32:20", "2026-01-23 10:32:20", "47592", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6155", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2026-01-23 14:31:59", "2026-01-23 14:31:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178719;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178719;}", "7", "1", "2026-01-23 14:32:20", "2026-01-23 10:32:20", "47592", NULL, "10");
INSERT INTO `CWP_actionscheduler_actions` VALUES("6156", "action_scheduler/migration_hook", "complete", "2026-01-23 14:33:19", "2026-01-23 14:33:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178799;}", "1", "1", "2026-01-23 14:33:20", "2026-01-23 10:33:20", "47596", NULL, "10");

/* INSERT TABLE DATA: CWP_actionscheduler_groups */
INSERT INTO `CWP_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `CWP_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `CWP_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `CWP_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `CWP_actionscheduler_groups` VALUES("5", "wc_update_product_default_cat");
INSERT INTO `CWP_actionscheduler_groups` VALUES("6", "yith-wcbm-db-updates");
INSERT INTO `CWP_actionscheduler_groups` VALUES("7", "woocommerce-remote-inbox-engine");
INSERT INTO `CWP_actionscheduler_groups` VALUES("8", "");
INSERT INTO `CWP_actionscheduler_groups` VALUES("9", "wc_delete_related_product_transients_group");
INSERT INTO `CWP_actionscheduler_groups` VALUES("10", "count");
INSERT INTO `CWP_actionscheduler_groups` VALUES("11", "ActionScheduler");
INSERT INTO `CWP_actionscheduler_groups` VALUES("12", "woocommerce");

/* INSERT TABLE DATA: CWP_actionscheduler_logs */
INSERT INTO `CWP_actionscheduler_logs` VALUES("516", "196", "acción creada", "2023-03-29 15:50:09", "2023-03-29 15:50:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("517", "196", "acción empezada vía WP Cron", "2023-03-29 15:51:32", "2023-03-29 15:51:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("518", "196", "acción fallida vía WP Cron: La acción programada para woocommerce_run_on_woocommerce_admin_updated no se ejecutará ya que no se han registrado llamadas.", "2023-03-29 15:51:32", "2023-03-29 15:51:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("521", "197", "acción creada", "2023-03-29 15:51:33", "2023-03-29 15:51:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("522", "197", "acción empezada vía WP Cron", "2023-03-29 15:52:37", "2023-03-29 15:52:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("523", "197", "acción fallida vía WP Cron: La acción programada para action_scheduler/migration_hook no se ejecutará ya que no se han registrado llamadas.", "2023-03-29 15:52:37", "2023-03-29 15:52:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("617", "229", "acción creada", "2024-04-18 16:11:09", "2024-04-18 16:11:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("618", "229", "acción empezada vía WP Cron", "2024-04-18 16:12:32", "2024-04-18 16:12:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("619", "229", "acción fallida vía WP Cron: La acción programada para action_scheduler/migration_hook no se ejecutará ya que no se han registrado llamadas.", "2024-04-18 16:12:32", "2024-04-18 16:12:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("14699", "4948", "acción creada", "2025-12-19 14:12:13", "2025-12-19 14:12:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("14987", "5045", "acción creada", "2025-12-22 15:34:39", "2025-12-22 15:34:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("14990", "5046", "acción creada", "2025-12-22 15:34:39", "2025-12-22 15:34:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15038", "5062", "acción creada", "2025-12-23 05:48:54", "2025-12-23 05:48:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15041", "5063", "acción creada", "2025-12-23 05:48:55", "2025-12-23 05:48:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15044", "5064", "acción creada", "2025-12-23 05:48:55", "2025-12-23 05:48:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15047", "5065", "acción creada", "2025-12-23 05:48:55", "2025-12-23 05:48:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15053", "5068", "acción creada", "2025-12-23 05:48:55", "2025-12-23 05:48:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15073", "5074", "acción creada", "2025-12-23 13:45:37", "2025-12-23 13:45:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15075", "5075", "acción creada", "2025-12-23 13:45:37", "2025-12-23 13:45:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15077", "5075", "acción empezada vía WP Cron", "2025-12-23 15:16:19", "2025-12-23 15:16:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15078", "5076", "acción creada", "2025-12-23 15:16:19", "2025-12-23 15:16:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15079", "5075", "acción completa vía WP Cron", "2025-12-23 15:16:19", "2025-12-23 15:16:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15080", "5045", "acción empezada vía WP Cron", "2025-12-23 15:34:50", "2025-12-23 15:34:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15081", "5045", "acción completa vía WP Cron", "2025-12-23 15:34:50", "2025-12-23 15:34:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15082", "5077", "acción creada", "2025-12-23 15:34:50", "2025-12-23 15:34:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15083", "5046", "acción empezada vía WP Cron", "2025-12-23 15:34:50", "2025-12-23 15:34:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15084", "5046", "acción completa vía WP Cron", "2025-12-23 15:34:50", "2025-12-23 15:34:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15085", "5078", "acción creada", "2025-12-23 15:34:50", "2025-12-23 15:34:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15086", "5076", "acción empezada vía WP Cron", "2025-12-23 17:46:34", "2025-12-23 17:46:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15087", "5079", "acción creada", "2025-12-23 17:46:34", "2025-12-23 17:46:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15088", "5076", "acción completa vía WP Cron", "2025-12-23 17:46:34", "2025-12-23 17:46:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15089", "5080", "acción creada", "2025-12-23 17:46:34", "2025-12-23 17:46:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15090", "5080", "acción empezada vía WP Cron", "2025-12-23 17:50:35", "2025-12-23 17:50:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15091", "5080", "acción completa vía WP Cron", "2025-12-23 17:50:36", "2025-12-23 17:50:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15092", "5079", "acción empezada vía WP Cron", "2025-12-23 19:08:28", "2025-12-23 19:08:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15093", "5081", "acción creada", "2025-12-23 19:08:28", "2025-12-23 19:08:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15094", "5079", "acción completa vía WP Cron", "2025-12-23 19:08:28", "2025-12-23 19:08:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15095", "5081", "acción empezada vía WP Cron", "2025-12-23 20:14:40", "2025-12-23 20:14:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15096", "5082", "acción creada", "2025-12-23 20:14:40", "2025-12-23 20:14:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15097", "5081", "acción completa vía WP Cron", "2025-12-23 20:14:40", "2025-12-23 20:14:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15098", "5082", "acción empezada vía WP Cron", "2025-12-23 21:15:09", "2025-12-23 21:15:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15099", "5083", "acción creada", "2025-12-23 21:15:09", "2025-12-23 21:15:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15100", "5082", "acción completa vía WP Cron", "2025-12-23 21:15:09", "2025-12-23 21:15:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15101", "5083", "acción empezada vía WP Cron", "2025-12-23 22:26:23", "2025-12-23 22:26:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15102", "5084", "acción creada", "2025-12-23 22:26:23", "2025-12-23 22:26:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15103", "5083", "acción completa vía WP Cron", "2025-12-23 22:26:23", "2025-12-23 22:26:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15104", "5084", "acción empezada vía WP Cron", "2025-12-23 23:32:56", "2025-12-23 23:32:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15105", "5085", "acción creada", "2025-12-23 23:32:56", "2025-12-23 23:32:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15106", "5084", "acción completa vía WP Cron", "2025-12-23 23:32:56", "2025-12-23 23:32:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15107", "5085", "acción empezada vía WP Cron", "2025-12-24 01:10:11", "2025-12-24 01:10:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15108", "5086", "acción creada", "2025-12-24 01:10:11", "2025-12-24 01:10:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15109", "5085", "acción completa vía WP Cron", "2025-12-24 01:10:11", "2025-12-24 01:10:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15110", "5074", "acción empezada vía WP Cron", "2025-12-24 01:46:32", "2025-12-24 01:46:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15111", "5074", "acción completa vía WP Cron", "2025-12-24 01:46:32", "2025-12-24 01:46:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15112", "5087", "acción creada", "2025-12-24 01:46:32", "2025-12-24 01:46:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15113", "5086", "acción empezada vía WP Cron", "2025-12-24 02:13:42", "2025-12-24 02:13:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15114", "5088", "acción creada", "2025-12-24 02:13:42", "2025-12-24 02:13:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15115", "5086", "acción completa vía WP Cron", "2025-12-24 02:13:42", "2025-12-24 02:13:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15116", "5088", "acción empezada vía WP Cron", "2025-12-24 03:16:49", "2025-12-24 03:16:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15117", "5089", "acción creada", "2025-12-24 03:16:49", "2025-12-24 03:16:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15118", "5088", "acción completa vía WP Cron", "2025-12-24 03:16:49", "2025-12-24 03:16:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15119", "5089", "acción empezada vía WP Cron", "2025-12-24 04:22:52", "2025-12-24 04:22:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15120", "5090", "acción creada", "2025-12-24 04:22:52", "2025-12-24 04:22:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15121", "5089", "acción completa vía WP Cron", "2025-12-24 04:22:52", "2025-12-24 04:22:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15122", "5091", "acción creada", "2025-12-24 04:22:52", "2025-12-24 04:22:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15123", "5091", "acción empezada vía WP Cron", "2025-12-24 04:35:31", "2025-12-24 04:35:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15124", "5091", "acción completa vía WP Cron", "2025-12-24 04:35:31", "2025-12-24 04:35:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15125", "5090", "acción empezada vía WP Cron", "2025-12-24 05:29:46", "2025-12-24 05:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15126", "5092", "acción creada", "2025-12-24 05:29:46", "2025-12-24 05:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15127", "5090", "acción completa vía WP Cron", "2025-12-24 05:29:46", "2025-12-24 05:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15128", "5062", "acción empezada vía Async Request", "2025-12-24 05:49:28", "2025-12-24 05:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15129", "5062", "acción completa vía Async Request", "2025-12-24 05:49:29", "2025-12-24 05:49:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15130", "5093", "acción creada", "2025-12-24 05:49:29", "2025-12-24 05:49:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15131", "5063", "acción empezada vía Async Request", "2025-12-24 05:49:29", "2025-12-24 05:49:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15132", "5063", "acción completa vía Async Request", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15133", "5094", "acción creada", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15134", "5064", "acción empezada vía Async Request", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15135", "5064", "acción completa vía Async Request", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15136", "5095", "acción creada", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15137", "5065", "acción empezada vía Async Request", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15138", "5065", "acción completa vía Async Request", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15139", "5096", "acción creada", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15140", "5068", "acción empezada vía Async Request", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15143", "5098", "acción creada", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15144", "5068", "acción completa vía Async Request", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15145", "5099", "acción creada", "2025-12-24 05:49:30", "2025-12-24 05:49:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15146", "5098", "acción empezada vía WP Cron", "2025-12-24 05:50:32", "2025-12-24 05:50:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15147", "5098", "acción completa vía WP Cron", "2025-12-24 05:50:32", "2025-12-24 05:50:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15148", "5092", "acción empezada vía WP Cron", "2025-12-24 06:30:13", "2025-12-24 06:30:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15149", "5100", "acción creada", "2025-12-24 06:30:13", "2025-12-24 06:30:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15150", "5092", "acción completa vía WP Cron", "2025-12-24 06:30:13", "2025-12-24 06:30:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15151", "5100", "acción empezada vía WP Cron", "2025-12-24 07:31:32", "2025-12-24 07:31:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15152", "5101", "acción creada", "2025-12-24 07:31:32", "2025-12-24 07:31:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15153", "5100", "acción completa vía WP Cron", "2025-12-24 07:31:32", "2025-12-24 07:31:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15154", "5101", "acción empezada vía WP Cron", "2025-12-24 08:38:21", "2025-12-24 08:38:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15155", "5102", "acción creada", "2025-12-24 08:38:21", "2025-12-24 08:38:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15156", "5101", "acción completa vía WP Cron", "2025-12-24 08:38:21", "2025-12-24 08:38:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15157", "5102", "acción empezada vía WP Cron", "2025-12-24 09:39:26", "2025-12-24 09:39:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15158", "5103", "acción creada", "2025-12-24 09:39:26", "2025-12-24 09:39:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15159", "5102", "acción completa vía WP Cron", "2025-12-24 09:39:26", "2025-12-24 09:39:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15160", "5103", "acción empezada vía WP Cron", "2025-12-24 10:47:52", "2025-12-24 10:47:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15161", "5104", "acción creada", "2025-12-24 10:47:52", "2025-12-24 10:47:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15162", "5103", "acción completa vía WP Cron", "2025-12-24 10:47:52", "2025-12-24 10:47:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15163", "5104", "acción empezada vía WP Cron", "2025-12-24 11:51:38", "2025-12-24 11:51:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15164", "5105", "acción creada", "2025-12-24 11:51:38", "2025-12-24 11:51:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15165", "5104", "acción completa vía WP Cron", "2025-12-24 11:51:38", "2025-12-24 11:51:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15166", "5105", "acción empezada vía WP Cron", "2025-12-24 12:51:41", "2025-12-24 12:51:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15167", "5106", "acción creada", "2025-12-24 12:51:41", "2025-12-24 12:51:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15168", "5105", "acción completa vía WP Cron", "2025-12-24 12:51:41", "2025-12-24 12:51:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15169", "5087", "acción empezada vía WP Cron", "2025-12-24 13:53:09", "2025-12-24 13:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15170", "5087", "acción completa vía WP Cron", "2025-12-24 13:53:09", "2025-12-24 13:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15171", "5107", "acción creada", "2025-12-24 13:53:09", "2025-12-24 13:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15172", "5106", "acción empezada vía WP Cron", "2025-12-24 13:53:09", "2025-12-24 13:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15173", "5108", "acción creada", "2025-12-24 13:53:09", "2025-12-24 13:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15174", "5106", "acción completa vía WP Cron", "2025-12-24 13:53:09", "2025-12-24 13:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15175", "5108", "acción empezada vía WP Cron", "2025-12-24 14:59:43", "2025-12-24 14:59:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15176", "5109", "acción creada", "2025-12-24 14:59:43", "2025-12-24 14:59:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15177", "5108", "acción completa vía WP Cron", "2025-12-24 14:59:43", "2025-12-24 14:59:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15178", "5077", "acción empezada vía WP Cron", "2025-12-24 15:35:43", "2025-12-24 15:35:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15179", "5077", "acción completa vía WP Cron", "2025-12-24 15:35:43", "2025-12-24 15:35:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15180", "5110", "acción creada", "2025-12-24 15:35:43", "2025-12-24 15:35:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15181", "5078", "acción empezada vía WP Cron", "2025-12-24 15:35:43", "2025-12-24 15:35:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15182", "5078", "acción completa vía WP Cron", "2025-12-24 15:35:44", "2025-12-24 15:35:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15183", "5111", "acción creada", "2025-12-24 15:35:44", "2025-12-24 15:35:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15184", "5109", "acción empezada vía WP Cron", "2025-12-24 16:02:22", "2025-12-24 16:02:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15185", "5112", "acción creada", "2025-12-24 16:02:22", "2025-12-24 16:02:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15186", "5109", "acción completa vía WP Cron", "2025-12-24 16:02:22", "2025-12-24 16:02:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15187", "5113", "acción creada", "2025-12-24 16:09:59", "2025-12-24 16:09:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15188", "5113", "acción empezada vía WP Cron", "2025-12-24 16:14:23", "2025-12-24 16:14:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15189", "5113", "acción completa vía WP Cron", "2025-12-24 16:14:23", "2025-12-24 16:14:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15190", "5112", "acción empezada vía WP Cron", "2025-12-24 17:02:47", "2025-12-24 17:02:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15191", "5114", "acción creada", "2025-12-24 17:02:47", "2025-12-24 17:02:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15192", "5112", "acción completa vía WP Cron", "2025-12-24 17:02:47", "2025-12-24 17:02:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15193", "5114", "acción empezada vía WP Cron", "2025-12-24 18:04:15", "2025-12-24 18:04:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15194", "5115", "acción creada", "2025-12-24 18:04:15", "2025-12-24 18:04:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15195", "5114", "acción completa vía WP Cron", "2025-12-24 18:04:15", "2025-12-24 18:04:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15196", "5115", "acción empezada vía WP Cron", "2025-12-24 19:05:04", "2025-12-24 19:05:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15197", "5116", "acción creada", "2025-12-24 19:05:04", "2025-12-24 19:05:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15198", "5115", "acción completa vía WP Cron", "2025-12-24 19:05:04", "2025-12-24 19:05:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15199", "5116", "acción empezada vía WP Cron", "2025-12-24 20:09:14", "2025-12-24 20:09:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15200", "5117", "acción creada", "2025-12-24 20:09:14", "2025-12-24 20:09:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15201", "5116", "acción completa vía WP Cron", "2025-12-24 20:09:14", "2025-12-24 20:09:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15202", "5117", "acción empezada vía WP Cron", "2025-12-24 21:12:56", "2025-12-24 21:12:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15203", "5118", "acción creada", "2025-12-24 21:12:56", "2025-12-24 21:12:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15204", "5117", "acción completa vía WP Cron", "2025-12-24 21:12:56", "2025-12-24 21:12:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15205", "5118", "acción empezada vía WP Cron", "2025-12-24 22:13:33", "2025-12-24 22:13:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15206", "5119", "acción creada", "2025-12-24 22:13:33", "2025-12-24 22:13:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15207", "5118", "acción completa vía WP Cron", "2025-12-24 22:13:33", "2025-12-24 22:13:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15208", "5119", "acción empezada vía WP Cron", "2025-12-24 23:23:22", "2025-12-24 23:23:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15209", "5120", "acción creada", "2025-12-24 23:23:22", "2025-12-24 23:23:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15210", "5119", "acción completa vía WP Cron", "2025-12-24 23:23:22", "2025-12-24 23:23:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15211", "5120", "acción empezada vía WP Cron", "2025-12-25 00:23:28", "2025-12-25 00:23:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15212", "5121", "acción creada", "2025-12-25 00:23:28", "2025-12-25 00:23:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15213", "5120", "acción completa vía WP Cron", "2025-12-25 00:23:28", "2025-12-25 00:23:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15214", "5121", "acción empezada vía WP Cron", "2025-12-25 01:31:16", "2025-12-25 01:31:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15215", "5122", "acción creada", "2025-12-25 01:31:16", "2025-12-25 01:31:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15216", "5121", "acción completa vía WP Cron", "2025-12-25 01:31:16", "2025-12-25 01:31:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15217", "5107", "acción empezada vía WP Cron", "2025-12-25 01:59:54", "2025-12-25 01:59:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15218", "5107", "acción completa vía WP Cron", "2025-12-25 01:59:54", "2025-12-25 01:59:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15219", "5123", "acción creada", "2025-12-25 01:59:54", "2025-12-25 01:59:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15220", "5122", "acción empezada vía WP Cron", "2025-12-25 02:48:42", "2025-12-25 02:48:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15221", "5124", "acción creada", "2025-12-25 02:48:42", "2025-12-25 02:48:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15222", "5122", "acción completa vía WP Cron", "2025-12-25 02:48:42", "2025-12-25 02:48:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15223", "5124", "acción empezada vía WP Cron", "2025-12-25 04:18:39", "2025-12-25 04:18:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15224", "5125", "acción creada", "2025-12-25 04:18:39", "2025-12-25 04:18:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15225", "5124", "acción completa vía WP Cron", "2025-12-25 04:18:39", "2025-12-25 04:18:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15226", "5126", "acción creada", "2025-12-25 04:18:39", "2025-12-25 04:18:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15227", "5126", "acción empezada vía WP Cron", "2025-12-25 04:48:15", "2025-12-25 04:48:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15228", "5126", "acción completa vía WP Cron", "2025-12-25 04:48:15", "2025-12-25 04:48:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15229", "5125", "acción empezada vía WP Cron", "2025-12-25 05:21:19", "2025-12-25 05:21:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15230", "5127", "acción creada", "2025-12-25 05:21:19", "2025-12-25 05:21:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15231", "5125", "acción completa vía WP Cron", "2025-12-25 05:21:19", "2025-12-25 05:21:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15232", "5093", "acción empezada vía WP Cron", "2025-12-25 06:36:41", "2025-12-25 06:36:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15233", "5093", "acción completa vía WP Cron", "2025-12-25 06:36:42", "2025-12-25 06:36:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15234", "5128", "acción creada", "2025-12-25 06:36:42", "2025-12-25 06:36:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15235", "5094", "acción empezada vía WP Cron", "2025-12-25 06:36:42", "2025-12-25 06:36:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15236", "5094", "acción completa vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15237", "5129", "acción creada", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15238", "5095", "acción empezada vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15239", "5095", "acción completa vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15240", "5130", "acción creada", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15241", "5096", "acción empezada vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15242", "5096", "acción completa vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15243", "5131", "acción creada", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15244", "5127", "acción empezada vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15245", "5132", "acción creada", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15246", "5127", "acción completa vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15247", "5099", "acción empezada vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15250", "5134", "acción creada", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15251", "5099", "acción completa vía WP Cron", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15252", "5135", "acción creada", "2025-12-25 06:36:43", "2025-12-25 06:36:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15253", "5134", "acción empezada vía WP Cron", "2025-12-25 06:42:46", "2025-12-25 06:42:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15254", "5134", "acción completa vía WP Cron", "2025-12-25 06:42:46", "2025-12-25 06:42:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15255", "5132", "acción empezada vía WP Cron", "2025-12-25 07:38:04", "2025-12-25 07:38:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15256", "5136", "acción creada", "2025-12-25 07:38:04", "2025-12-25 07:38:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15257", "5132", "acción completa vía WP Cron", "2025-12-25 07:38:04", "2025-12-25 07:38:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15258", "5136", "acción empezada vía WP Cron", "2025-12-25 08:38:17", "2025-12-25 08:38:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15259", "5137", "acción creada", "2025-12-25 08:38:17", "2025-12-25 08:38:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15260", "5136", "acción completa vía WP Cron", "2025-12-25 08:38:17", "2025-12-25 08:38:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15261", "5137", "acción empezada vía WP Cron", "2025-12-25 09:42:03", "2025-12-25 09:42:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15262", "5138", "acción creada", "2025-12-25 09:42:03", "2025-12-25 09:42:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15263", "5137", "acción completa vía WP Cron", "2025-12-25 09:42:03", "2025-12-25 09:42:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15264", "5138", "acción empezada vía WP Cron", "2025-12-25 10:42:37", "2025-12-25 10:42:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15265", "5139", "acción creada", "2025-12-25 10:42:37", "2025-12-25 10:42:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15266", "5138", "acción completa vía WP Cron", "2025-12-25 10:42:37", "2025-12-25 10:42:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15267", "5139", "acción empezada vía WP Cron", "2025-12-25 11:48:45", "2025-12-25 11:48:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15268", "5140", "acción creada", "2025-12-25 11:48:45", "2025-12-25 11:48:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15269", "5139", "acción completa vía WP Cron", "2025-12-25 11:48:45", "2025-12-25 11:48:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15270", "5140", "acción empezada vía WP Cron", "2025-12-25 13:04:00", "2025-12-25 13:04:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15271", "5141", "acción creada", "2025-12-25 13:04:00", "2025-12-25 13:04:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15272", "5140", "acción completa vía WP Cron", "2025-12-25 13:04:00", "2025-12-25 13:04:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15273", "5123", "acción empezada vía WP Cron", "2025-12-25 14:01:34", "2025-12-25 14:01:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15274", "5123", "acción completa vía WP Cron", "2025-12-25 14:01:34", "2025-12-25 14:01:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15275", "5142", "acción creada", "2025-12-25 14:01:34", "2025-12-25 14:01:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15276", "5141", "acción empezada vía WP Cron", "2025-12-25 14:05:11", "2025-12-25 14:05:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15277", "5143", "acción creada", "2025-12-25 14:05:11", "2025-12-25 14:05:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15278", "5141", "acción completa vía WP Cron", "2025-12-25 14:05:11", "2025-12-25 14:05:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15279", "5143", "acción empezada vía WP Cron", "2025-12-25 15:11:28", "2025-12-25 15:11:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15280", "5144", "acción creada", "2025-12-25 15:11:28", "2025-12-25 15:11:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15281", "5143", "acción completa vía WP Cron", "2025-12-25 15:11:28", "2025-12-25 15:11:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15282", "5110", "acción empezada vía WP Cron", "2025-12-25 15:36:51", "2025-12-25 15:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15283", "5110", "acción completa vía WP Cron", "2025-12-25 15:36:51", "2025-12-25 15:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15284", "5145", "acción creada", "2025-12-25 15:36:51", "2025-12-25 15:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15285", "5111", "acción empezada vía WP Cron", "2025-12-25 15:36:51", "2025-12-25 15:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15286", "5111", "acción completa vía WP Cron", "2025-12-25 15:36:51", "2025-12-25 15:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15287", "5146", "acción creada", "2025-12-25 15:36:51", "2025-12-25 15:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15288", "5144", "acción empezada vía WP Cron", "2025-12-25 16:23:04", "2025-12-25 16:23:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15289", "5147", "acción creada", "2025-12-25 16:23:04", "2025-12-25 16:23:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15290", "5144", "acción completa vía WP Cron", "2025-12-25 16:23:04", "2025-12-25 16:23:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15291", "5148", "acción creada", "2025-12-25 16:23:04", "2025-12-25 16:23:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15292", "5148", "acción empezada vía WP Cron", "2025-12-25 16:32:28", "2025-12-25 16:32:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15293", "5148", "acción completa vía WP Cron", "2025-12-25 16:32:28", "2025-12-25 16:32:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15294", "5147", "acción empezada vía WP Cron", "2025-12-25 17:27:58", "2025-12-25 17:27:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15295", "5149", "acción creada", "2025-12-25 17:27:58", "2025-12-25 17:27:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15296", "5147", "acción completa vía WP Cron", "2025-12-25 17:27:58", "2025-12-25 17:27:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15297", "5149", "acción empezada vía WP Cron", "2025-12-25 18:48:41", "2025-12-25 18:48:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15298", "5150", "acción creada", "2025-12-25 18:48:41", "2025-12-25 18:48:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15299", "5149", "acción completa vía WP Cron", "2025-12-25 18:48:41", "2025-12-25 18:48:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15300", "5150", "acción empezada vía WP Cron", "2025-12-25 20:11:03", "2025-12-25 20:11:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15301", "5151", "acción creada", "2025-12-25 20:11:03", "2025-12-25 20:11:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15302", "5150", "acción completa vía WP Cron", "2025-12-25 20:11:03", "2025-12-25 20:11:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15303", "5151", "acción empezada vía WP Cron", "2025-12-25 21:17:09", "2025-12-25 21:17:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15304", "5152", "acción creada", "2025-12-25 21:17:09", "2025-12-25 21:17:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15305", "5151", "acción completa vía WP Cron", "2025-12-25 21:17:09", "2025-12-25 21:17:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15306", "5152", "acción empezada vía WP Cron", "2025-12-25 22:20:51", "2025-12-25 22:20:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15307", "5153", "acción creada", "2025-12-25 22:20:51", "2025-12-25 22:20:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15308", "5152", "acción completa vía WP Cron", "2025-12-25 22:20:51", "2025-12-25 22:20:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15309", "5153", "acción empezada vía WP Cron", "2025-12-26 02:17:15", "2025-12-26 02:17:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15310", "5154", "acción creada", "2025-12-26 02:17:15", "2025-12-26 02:17:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15311", "5153", "acción completa vía WP Cron", "2025-12-26 02:17:15", "2025-12-26 02:17:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15312", "5142", "acción empezada vía WP Cron", "2025-12-26 02:17:15", "2025-12-26 02:17:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15313", "5142", "acción completa vía WP Cron", "2025-12-26 02:17:15", "2025-12-26 02:17:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15314", "5155", "acción creada", "2025-12-26 02:17:15", "2025-12-26 02:17:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15315", "5154", "acción empezada vía WP Cron", "2025-12-26 05:00:18", "2025-12-26 05:00:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15316", "5156", "acción creada", "2025-12-26 05:00:18", "2025-12-26 05:00:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15317", "5154", "acción completa vía WP Cron", "2025-12-26 05:00:18", "2025-12-26 05:00:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15318", "5157", "acción creada", "2025-12-26 05:00:18", "2025-12-26 05:00:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15319", "5157", "acción empezada vía WP Cron", "2025-12-26 05:07:32", "2025-12-26 05:07:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15320", "5157", "acción completa vía WP Cron", "2025-12-26 05:07:32", "2025-12-26 05:07:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15321", "5156", "acción empezada vía WP Cron", "2025-12-26 06:28:42", "2025-12-26 06:28:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15322", "5158", "acción creada", "2025-12-26 06:28:42", "2025-12-26 06:28:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15323", "5156", "acción completa vía WP Cron", "2025-12-26 06:28:42", "2025-12-26 06:28:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15324", "5128", "acción empezada vía WP Cron", "2025-12-26 07:54:03", "2025-12-26 07:54:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15325", "5128", "acción completa vía WP Cron", "2025-12-26 07:54:05", "2025-12-26 07:54:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15326", "5159", "acción creada", "2025-12-26 07:54:05", "2025-12-26 07:54:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15327", "5129", "acción empezada vía WP Cron", "2025-12-26 07:54:05", "2025-12-26 07:54:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15328", "5129", "acción completa vía WP Cron", "2025-12-26 07:54:06", "2025-12-26 07:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15329", "5160", "acción creada", "2025-12-26 07:54:06", "2025-12-26 07:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15330", "5130", "acción empezada vía WP Cron", "2025-12-26 07:54:06", "2025-12-26 07:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15331", "5130", "acción completa vía WP Cron", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15332", "5161", "acción creada", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15333", "5131", "acción empezada vía WP Cron", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15334", "5131", "acción completa vía WP Cron", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15335", "5162", "acción creada", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15336", "5158", "acción empezada vía WP Cron", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15337", "5163", "acción creada", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15338", "5158", "acción completa vía WP Cron", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15339", "5135", "acción empezada vía WP Cron", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15342", "5165", "acción creada", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15343", "5135", "acción completa vía WP Cron", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15344", "5166", "acción creada", "2025-12-26 07:54:07", "2025-12-26 07:54:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15345", "5165", "acción empezada vía WP Cron", "2025-12-26 08:30:02", "2025-12-26 08:30:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15346", "5165", "acción completa vía WP Cron", "2025-12-26 08:30:02", "2025-12-26 08:30:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15347", "5163", "acción empezada vía WP Cron", "2025-12-26 09:53:22", "2025-12-26 09:53:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15348", "5167", "acción creada", "2025-12-26 09:53:22", "2025-12-26 09:53:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15349", "5163", "acción completa vía WP Cron", "2025-12-26 09:53:22", "2025-12-26 09:53:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15350", "5167", "acción empezada vía WP Cron", "2025-12-26 12:01:56", "2025-12-26 12:01:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15351", "5168", "acción creada", "2025-12-26 12:01:56", "2025-12-26 12:01:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15352", "5167", "acción completa vía WP Cron", "2025-12-26 12:01:56", "2025-12-26 12:01:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15353", "5168", "acción empezada vía WP Cron", "2025-12-26 15:19:12", "2025-12-26 15:19:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15354", "5169", "acción creada", "2025-12-26 15:19:12", "2025-12-26 15:19:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15355", "5168", "acción completa vía WP Cron", "2025-12-26 15:19:12", "2025-12-26 15:19:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15356", "5155", "acción empezada vía WP Cron", "2025-12-26 15:19:12", "2025-12-26 15:19:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15357", "5155", "acción completa vía WP Cron", "2025-12-26 15:19:12", "2025-12-26 15:19:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15358", "5170", "acción creada", "2025-12-26 15:19:12", "2025-12-26 15:19:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15359", "5145", "acción empezada vía WP Cron", "2025-12-26 16:13:34", "2025-12-26 16:13:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15360", "5145", "acción completa vía WP Cron", "2025-12-26 16:13:34", "2025-12-26 16:13:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15361", "5171", "acción creada", "2025-12-26 16:13:34", "2025-12-26 16:13:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15362", "5146", "acción empezada vía WP Cron", "2025-12-26 16:13:34", "2025-12-26 16:13:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15363", "5146", "acción completa vía WP Cron", "2025-12-26 16:13:34", "2025-12-26 16:13:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15364", "5172", "acción creada", "2025-12-26 16:13:34", "2025-12-26 16:13:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15365", "5173", "acción creada", "2025-12-26 16:13:34", "2025-12-26 16:13:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15366", "5173", "acción empezada vía WP Cron", "2025-12-26 17:14:10", "2025-12-26 17:14:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15367", "5173", "acción completa vía WP Cron", "2025-12-26 17:14:10", "2025-12-26 17:14:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15368", "5169", "acción empezada vía WP Cron", "2025-12-26 17:14:10", "2025-12-26 17:14:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15369", "5174", "acción creada", "2025-12-26 17:14:10", "2025-12-26 17:14:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15370", "5169", "acción completa vía WP Cron", "2025-12-26 17:14:10", "2025-12-26 17:14:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15371", "5174", "acción empezada vía WP Cron", "2025-12-26 18:21:33", "2025-12-26 18:21:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15372", "5175", "acción creada", "2025-12-26 18:21:33", "2025-12-26 18:21:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15373", "5174", "acción completa vía WP Cron", "2025-12-26 18:21:33", "2025-12-26 18:21:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15374", "5175", "acción empezada vía WP Cron", "2025-12-26 19:24:06", "2025-12-26 19:24:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15375", "5176", "acción creada", "2025-12-26 19:24:06", "2025-12-26 19:24:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15376", "5175", "acción completa vía WP Cron", "2025-12-26 19:24:06", "2025-12-26 19:24:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15377", "5176", "acción empezada vía WP Cron", "2025-12-26 20:43:32", "2025-12-26 20:43:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15378", "5177", "acción creada", "2025-12-26 20:43:32", "2025-12-26 20:43:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15379", "5176", "acción completa vía WP Cron", "2025-12-26 20:43:32", "2025-12-26 20:43:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15380", "5177", "acción empezada vía WP Cron", "2025-12-26 21:48:57", "2025-12-26 21:48:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15381", "5178", "acción creada", "2025-12-26 21:48:57", "2025-12-26 21:48:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15382", "5177", "acción completa vía WP Cron", "2025-12-26 21:48:57", "2025-12-26 21:48:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15383", "5178", "acción empezada vía WP Cron", "2025-12-26 23:23:05", "2025-12-26 23:23:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15384", "5179", "acción creada", "2025-12-26 23:23:05", "2025-12-26 23:23:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15385", "5178", "acción completa vía WP Cron", "2025-12-26 23:23:05", "2025-12-26 23:23:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15386", "5179", "acción empezada vía WP Cron", "2025-12-27 00:26:33", "2025-12-27 00:26:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15387", "5180", "acción creada", "2025-12-27 00:26:33", "2025-12-27 00:26:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15388", "5179", "acción completa vía WP Cron", "2025-12-27 00:26:33", "2025-12-27 00:26:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15389", "5180", "acción empezada vía WP Cron", "2025-12-27 01:27:24", "2025-12-27 01:27:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15390", "5181", "acción creada", "2025-12-27 01:27:24", "2025-12-27 01:27:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15391", "5180", "acción completa vía WP Cron", "2025-12-27 01:27:24", "2025-12-27 01:27:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15392", "5181", "acción empezada vía WP Cron", "2025-12-27 02:46:02", "2025-12-27 02:46:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15393", "5182", "acción creada", "2025-12-27 02:46:02", "2025-12-27 02:46:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15394", "5181", "acción completa vía WP Cron", "2025-12-27 02:46:02", "2025-12-27 02:46:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15395", "5170", "acción empezada vía WP Cron", "2025-12-27 03:48:36", "2025-12-27 03:48:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15396", "5170", "acción completa vía WP Cron", "2025-12-27 03:48:36", "2025-12-27 03:48:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15397", "5183", "acción creada", "2025-12-27 03:48:36", "2025-12-27 03:48:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15398", "5182", "acción empezada vía WP Cron", "2025-12-27 03:48:36", "2025-12-27 03:48:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15399", "5184", "acción creada", "2025-12-27 03:48:36", "2025-12-27 03:48:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15400", "5182", "acción completa vía WP Cron", "2025-12-27 03:48:36", "2025-12-27 03:48:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15401", "5185", "acción creada", "2025-12-27 04:10:11", "2025-12-27 04:10:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15402", "5185", "acción empezada vía WP Cron", "2025-12-27 04:11:16", "2025-12-27 04:11:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15403", "5185", "acción completa vía WP Cron", "2025-12-27 04:11:17", "2025-12-27 04:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15404", "5184", "acción empezada vía WP Cron", "2025-12-27 04:49:20", "2025-12-27 04:49:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15405", "5186", "acción creada", "2025-12-27 04:49:20", "2025-12-27 04:49:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15406", "5184", "acción completa vía WP Cron", "2025-12-27 04:49:20", "2025-12-27 04:49:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15407", "5186", "acción empezada vía WP Cron", "2025-12-27 05:51:38", "2025-12-27 05:51:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15408", "5187", "acción creada", "2025-12-27 05:51:38", "2025-12-27 05:51:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15409", "5186", "acción completa vía WP Cron", "2025-12-27 05:51:38", "2025-12-27 05:51:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15410", "5187", "acción empezada vía WP Cron", "2025-12-27 06:58:33", "2025-12-27 06:58:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15411", "5188", "acción creada", "2025-12-27 06:58:33", "2025-12-27 06:58:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15412", "5187", "acción completa vía WP Cron", "2025-12-27 06:58:33", "2025-12-27 06:58:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15413", "5159", "acción empezada vía WP Cron", "2025-12-27 07:54:08", "2025-12-27 07:54:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15414", "5159", "acción completa vía WP Cron", "2025-12-27 07:54:09", "2025-12-27 07:54:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15415", "5189", "acción creada", "2025-12-27 07:54:09", "2025-12-27 07:54:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15416", "5160", "acción empezada vía WP Cron", "2025-12-27 07:54:09", "2025-12-27 07:54:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15417", "5160", "acción completa vía WP Cron", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15418", "5190", "acción creada", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15419", "5161", "acción empezada vía WP Cron", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15420", "5161", "acción completa vía WP Cron", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15421", "5191", "acción creada", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15422", "5162", "acción empezada vía WP Cron", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15423", "5162", "acción completa vía WP Cron", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15424", "5192", "acción creada", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15425", "5166", "acción empezada vía WP Cron", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15428", "5194", "acción creada", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15429", "5166", "acción completa vía WP Cron", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15430", "5195", "acción creada", "2025-12-27 07:54:10", "2025-12-27 07:54:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15431", "5194", "acción empezada vía WP Cron", "2025-12-27 07:57:58", "2025-12-27 07:57:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15432", "5194", "acción completa vía WP Cron", "2025-12-27 07:57:58", "2025-12-27 07:57:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15433", "5188", "acción empezada vía WP Cron", "2025-12-27 08:16:45", "2025-12-27 08:16:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15434", "5196", "acción creada", "2025-12-27 08:16:45", "2025-12-27 08:16:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15435", "5188", "acción completa vía WP Cron", "2025-12-27 08:16:45", "2025-12-27 08:16:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15436", "5196", "acción empezada vía WP Cron", "2025-12-27 09:28:51", "2025-12-27 09:28:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15437", "5197", "acción creada", "2025-12-27 09:28:51", "2025-12-27 09:28:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15438", "5196", "acción completa vía WP Cron", "2025-12-27 09:28:51", "2025-12-27 09:28:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15439", "5197", "acción empezada vía WP Cron", "2025-12-27 10:56:08", "2025-12-27 10:56:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15440", "5198", "acción creada", "2025-12-27 10:56:08", "2025-12-27 10:56:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15441", "5197", "acción completa vía WP Cron", "2025-12-27 10:56:08", "2025-12-27 10:56:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15442", "5198", "acción empezada vía WP Cron", "2025-12-27 12:41:34", "2025-12-27 12:41:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15443", "5199", "acción creada", "2025-12-27 12:41:34", "2025-12-27 12:41:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15444", "5198", "acción completa vía WP Cron", "2025-12-27 12:41:34", "2025-12-27 12:41:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15445", "5199", "acción empezada vía WP Cron", "2025-12-27 14:02:18", "2025-12-27 14:02:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15446", "5200", "acción creada", "2025-12-27 14:02:18", "2025-12-27 14:02:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15447", "5199", "acción completa vía WP Cron", "2025-12-27 14:02:18", "2025-12-27 14:02:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15448", "5200", "acción empezada vía WP Cron", "2025-12-27 15:10:19", "2025-12-27 15:10:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15449", "5201", "acción creada", "2025-12-27 15:10:19", "2025-12-27 15:10:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15450", "5200", "acción completa vía WP Cron", "2025-12-27 15:10:19", "2025-12-27 15:10:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15451", "5183", "acción empezada vía WP Cron", "2025-12-27 15:57:05", "2025-12-27 15:57:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15452", "5183", "acción completa vía WP Cron", "2025-12-27 15:57:06", "2025-12-27 15:57:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15453", "5202", "acción creada", "2025-12-27 15:57:06", "2025-12-27 15:57:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15454", "5201", "acción empezada vía WP Cron", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15455", "5203", "acción creada", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15456", "5201", "acción completa vía WP Cron", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15457", "5171", "acción empezada vía WP Cron", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15458", "5171", "acción completa vía WP Cron", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15459", "5204", "acción creada", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15460", "5172", "acción empezada vía WP Cron", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15461", "5172", "acción completa vía WP Cron", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15462", "5205", "acción creada", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15463", "5206", "acción creada", "2025-12-27 16:41:22", "2025-12-27 16:41:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15464", "5206", "acción empezada vía WP Cron", "2025-12-27 17:16:29", "2025-12-27 17:16:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15465", "5206", "acción completa vía WP Cron", "2025-12-27 17:16:29", "2025-12-27 17:16:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15466", "5203", "acción empezada vía WP Cron", "2025-12-27 17:42:31", "2025-12-27 17:42:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15467", "5207", "acción creada", "2025-12-27 17:42:31", "2025-12-27 17:42:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15468", "5203", "acción completa vía WP Cron", "2025-12-27 17:42:31", "2025-12-27 17:42:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15469", "5207", "acción empezada vía WP Cron", "2025-12-27 19:04:28", "2025-12-27 19:04:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15470", "5208", "acción creada", "2025-12-27 19:04:28", "2025-12-27 19:04:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15471", "5207", "acción completa vía WP Cron", "2025-12-27 19:04:28", "2025-12-27 19:04:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15472", "5208", "acción empezada vía WP Cron", "2025-12-27 20:54:41", "2025-12-27 20:54:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15473", "5209", "acción creada", "2025-12-27 20:54:41", "2025-12-27 20:54:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15474", "5208", "acción completa vía WP Cron", "2025-12-27 20:54:41", "2025-12-27 20:54:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15475", "5209", "acción empezada vía WP Cron", "2025-12-27 22:35:28", "2025-12-27 22:35:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15476", "5210", "acción creada", "2025-12-27 22:35:28", "2025-12-27 22:35:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15477", "5209", "acción completa vía WP Cron", "2025-12-27 22:35:28", "2025-12-27 22:35:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15478", "5210", "acción empezada vía WP Cron", "2025-12-28 00:30:19", "2025-12-28 00:30:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15479", "5211", "acción creada", "2025-12-28 00:30:19", "2025-12-28 00:30:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15480", "5210", "acción completa vía WP Cron", "2025-12-28 00:30:19", "2025-12-28 00:30:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15481", "5211", "acción empezada vía WP Cron", "2025-12-28 01:53:02", "2025-12-28 01:53:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15482", "5212", "acción creada", "2025-12-28 01:53:02", "2025-12-28 01:53:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15483", "5211", "acción completa vía WP Cron", "2025-12-28 01:53:02", "2025-12-28 01:53:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15484", "5212", "acción empezada vía WP Cron", "2025-12-28 02:54:01", "2025-12-28 02:54:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15485", "5213", "acción creada", "2025-12-28 02:54:01", "2025-12-28 02:54:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15486", "5212", "acción completa vía WP Cron", "2025-12-28 02:54:01", "2025-12-28 02:54:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15487", "5213", "acción empezada vía WP Cron", "2025-12-28 04:23:12", "2025-12-28 04:23:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15488", "5214", "acción creada", "2025-12-28 04:23:12", "2025-12-28 04:23:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15489", "5213", "acción completa vía WP Cron", "2025-12-28 04:23:12", "2025-12-28 04:23:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15490", "5202", "acción empezada vía WP Cron", "2025-12-28 04:23:12", "2025-12-28 04:23:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15491", "5202", "acción completa vía WP Cron", "2025-12-28 04:23:12", "2025-12-28 04:23:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15492", "5215", "acción creada", "2025-12-28 04:23:12", "2025-12-28 04:23:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15493", "5216", "acción creada", "2025-12-28 04:23:13", "2025-12-28 04:23:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15494", "5216", "acción empezada vía WP Cron", "2025-12-28 04:45:12", "2025-12-28 04:45:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15495", "5216", "acción completa vía WP Cron", "2025-12-28 04:45:12", "2025-12-28 04:45:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15496", "5214", "acción empezada vía WP Cron", "2025-12-28 05:46:57", "2025-12-28 05:46:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15497", "5217", "acción creada", "2025-12-28 05:46:57", "2025-12-28 05:46:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15498", "5214", "acción completa vía WP Cron", "2025-12-28 05:46:57", "2025-12-28 05:46:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15499", "5217", "acción empezada vía WP Cron", "2025-12-28 07:01:44", "2025-12-28 07:01:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15500", "5218", "acción creada", "2025-12-28 07:01:44", "2025-12-28 07:01:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15501", "5217", "acción completa vía WP Cron", "2025-12-28 07:01:44", "2025-12-28 07:01:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15502", "5189", "acción empezada vía WP Cron", "2025-12-28 08:45:46", "2025-12-28 08:45:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15503", "5189", "acción completa vía WP Cron", "2025-12-28 08:45:47", "2025-12-28 08:45:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15504", "5219", "acción creada", "2025-12-28 08:45:47", "2025-12-28 08:45:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15505", "5190", "acción empezada vía WP Cron", "2025-12-28 08:45:47", "2025-12-28 08:45:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15506", "5190", "acción completa vía WP Cron", "2025-12-28 08:45:48", "2025-12-28 08:45:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15507", "5220", "acción creada", "2025-12-28 08:45:48", "2025-12-28 08:45:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15508", "5191", "acción empezada vía WP Cron", "2025-12-28 08:45:48", "2025-12-28 08:45:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15509", "5191", "acción completa vía WP Cron", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15510", "5221", "acción creada", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15511", "5192", "acción empezada vía WP Cron", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15512", "5192", "acción completa vía WP Cron", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15513", "5222", "acción creada", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15514", "5218", "acción empezada vía WP Cron", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15515", "5223", "acción creada", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15516", "5218", "acción completa vía WP Cron", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15517", "5195", "acción empezada vía WP Cron", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15520", "5225", "acción creada", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15521", "5195", "acción completa vía WP Cron", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15522", "5226", "acción creada", "2025-12-28 08:45:49", "2025-12-28 08:45:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15523", "5225", "acción empezada vía WP Cron", "2025-12-28 08:46:50", "2025-12-28 08:46:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15524", "5225", "acción completa vía WP Cron", "2025-12-28 08:46:50", "2025-12-28 08:46:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15525", "5223", "acción empezada vía WP Cron", "2025-12-28 09:48:08", "2025-12-28 09:48:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15526", "5227", "acción creada", "2025-12-28 09:48:08", "2025-12-28 09:48:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15527", "5223", "acción completa vía WP Cron", "2025-12-28 09:48:08", "2025-12-28 09:48:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15528", "5227", "acción empezada vía WP Cron", "2025-12-28 10:52:03", "2025-12-28 10:52:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15529", "5228", "acción creada", "2025-12-28 10:52:03", "2025-12-28 10:52:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15530", "5227", "acción completa vía WP Cron", "2025-12-28 10:52:03", "2025-12-28 10:52:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15531", "5228", "acción empezada vía WP Cron", "2025-12-28 11:54:08", "2025-12-28 11:54:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15532", "5229", "acción creada", "2025-12-28 11:54:09", "2025-12-28 11:54:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15533", "5228", "acción completa vía WP Cron", "2025-12-28 11:54:09", "2025-12-28 11:54:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15534", "5229", "acción empezada vía WP Cron", "2025-12-28 12:54:15", "2025-12-28 12:54:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15535", "5230", "acción creada", "2025-12-28 12:54:15", "2025-12-28 12:54:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15536", "5229", "acción completa vía WP Cron", "2025-12-28 12:54:15", "2025-12-28 12:54:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15537", "5230", "acción empezada vía WP Cron", "2025-12-28 13:58:21", "2025-12-28 13:58:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15538", "5231", "acción creada", "2025-12-28 13:58:21", "2025-12-28 13:58:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15539", "5230", "acción completa vía WP Cron", "2025-12-28 13:58:21", "2025-12-28 13:58:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15540", "5231", "acción empezada vía WP Cron", "2025-12-28 15:04:32", "2025-12-28 15:04:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15541", "5232", "acción creada", "2025-12-28 15:04:32", "2025-12-28 15:04:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15542", "5231", "acción completa vía WP Cron", "2025-12-28 15:04:32", "2025-12-28 15:04:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15543", "5232", "acción empezada vía WP Cron", "2025-12-28 16:05:12", "2025-12-28 16:05:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15544", "5233", "acción creada", "2025-12-28 16:05:12", "2025-12-28 16:05:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15545", "5232", "acción completa vía WP Cron", "2025-12-28 16:05:12", "2025-12-28 16:05:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15546", "5234", "acción creada", "2025-12-28 16:10:27", "2025-12-28 16:10:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15547", "5234", "acción empezada vía WP Cron", "2025-12-28 16:12:10", "2025-12-28 16:12:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15548", "5234", "acción completa vía WP Cron", "2025-12-28 16:12:10", "2025-12-28 16:12:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15549", "5215", "acción empezada vía WP Cron", "2025-12-28 16:23:55", "2025-12-28 16:23:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15550", "5215", "acción completa vía WP Cron", "2025-12-28 16:23:55", "2025-12-28 16:23:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15551", "5235", "acción creada", "2025-12-28 16:23:55", "2025-12-28 16:23:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15552", "5204", "acción empezada vía WP Cron", "2025-12-28 16:45:01", "2025-12-28 16:45:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15553", "5204", "acción completa vía WP Cron", "2025-12-28 16:45:01", "2025-12-28 16:45:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15554", "5236", "acción creada", "2025-12-28 16:45:01", "2025-12-28 16:45:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15555", "5205", "acción empezada vía WP Cron", "2025-12-28 16:45:01", "2025-12-28 16:45:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15556", "5205", "acción completa vía WP Cron", "2025-12-28 16:45:01", "2025-12-28 16:45:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15557", "5237", "acción creada", "2025-12-28 16:45:01", "2025-12-28 16:45:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15558", "5233", "acción empezada vía WP Cron", "2025-12-28 17:10:43", "2025-12-28 17:10:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15559", "5238", "acción creada", "2025-12-28 17:10:43", "2025-12-28 17:10:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15560", "5233", "acción completa vía WP Cron", "2025-12-28 17:10:43", "2025-12-28 17:10:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15561", "5238", "acción empezada vía WP Cron", "2025-12-28 18:12:54", "2025-12-28 18:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15562", "5239", "acción creada", "2025-12-28 18:12:54", "2025-12-28 18:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15563", "5238", "acción completa vía WP Cron", "2025-12-28 18:12:54", "2025-12-28 18:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15564", "5239", "acción empezada vía WP Cron", "2025-12-28 19:21:15", "2025-12-28 19:21:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15565", "5240", "acción creada", "2025-12-28 19:21:15", "2025-12-28 19:21:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15566", "5239", "acción completa vía WP Cron", "2025-12-28 19:21:15", "2025-12-28 19:21:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15567", "5240", "acción empezada vía WP Cron", "2025-12-28 20:29:43", "2025-12-28 20:29:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15568", "5241", "acción creada", "2025-12-28 20:29:43", "2025-12-28 20:29:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15569", "5240", "acción completa vía WP Cron", "2025-12-28 20:29:43", "2025-12-28 20:29:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15570", "5241", "acción empezada vía WP Cron", "2025-12-28 21:38:19", "2025-12-28 21:38:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15571", "5242", "acción creada", "2025-12-28 21:38:19", "2025-12-28 21:38:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15572", "5241", "acción completa vía WP Cron", "2025-12-28 21:38:19", "2025-12-28 21:38:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15573", "5242", "acción empezada vía WP Cron", "2025-12-28 22:38:27", "2025-12-28 22:38:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15574", "5243", "acción creada", "2025-12-28 22:38:27", "2025-12-28 22:38:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15575", "5242", "acción completa vía WP Cron", "2025-12-28 22:38:27", "2025-12-28 22:38:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15576", "5243", "acción empezada vía WP Cron", "2025-12-28 23:43:54", "2025-12-28 23:43:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15577", "5244", "acción creada", "2025-12-28 23:43:54", "2025-12-28 23:43:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15578", "5243", "acción completa vía WP Cron", "2025-12-28 23:43:54", "2025-12-28 23:43:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15579", "5244", "acción empezada vía WP Cron", "2025-12-29 00:45:48", "2025-12-29 00:45:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15580", "5245", "acción creada", "2025-12-29 00:45:48", "2025-12-29 00:45:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15581", "5244", "acción completa vía WP Cron", "2025-12-29 00:45:48", "2025-12-29 00:45:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15582", "5245", "acción empezada vía WP Cron", "2025-12-29 01:49:48", "2025-12-29 01:49:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15583", "5246", "acción creada", "2025-12-29 01:49:48", "2025-12-29 01:49:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15584", "5245", "acción completa vía WP Cron", "2025-12-29 01:49:48", "2025-12-29 01:49:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15585", "5246", "acción empezada vía WP Cron", "2025-12-29 02:50:10", "2025-12-29 02:50:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15586", "5247", "acción creada", "2025-12-29 02:50:10", "2025-12-29 02:50:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15587", "5246", "acción completa vía WP Cron", "2025-12-29 02:50:10", "2025-12-29 02:50:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15588", "5247", "acción empezada vía WP Cron", "2025-12-29 04:04:31", "2025-12-29 04:04:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15589", "5248", "acción creada", "2025-12-29 04:04:31", "2025-12-29 04:04:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15590", "5247", "acción completa vía WP Cron", "2025-12-29 04:04:31", "2025-12-29 04:04:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15591", "5249", "acción creada", "2025-12-29 04:27:28", "2025-12-29 04:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15592", "5235", "acción empezada vía WP Cron", "2025-12-29 04:27:28", "2025-12-29 04:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15593", "5235", "acción completa vía WP Cron", "2025-12-29 04:27:28", "2025-12-29 04:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15594", "5250", "acción creada", "2025-12-29 04:27:28", "2025-12-29 04:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15595", "5249", "acción empezada vía WP Cron", "2025-12-29 04:27:28", "2025-12-29 04:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15596", "5249", "acción completa vía WP Cron", "2025-12-29 04:27:28", "2025-12-29 04:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15597", "5248", "acción empezada vía WP Cron", "2025-12-29 05:21:39", "2025-12-29 05:21:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15598", "5251", "acción creada", "2025-12-29 05:21:39", "2025-12-29 05:21:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15599", "5248", "acción completa vía WP Cron", "2025-12-29 05:21:39", "2025-12-29 05:21:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15600", "5251", "acción empezada vía WP Cron", "2025-12-29 06:29:56", "2025-12-29 06:29:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15601", "5252", "acción creada", "2025-12-29 06:29:56", "2025-12-29 06:29:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15602", "5251", "acción completa vía WP Cron", "2025-12-29 06:29:56", "2025-12-29 06:29:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15603", "5252", "acción empezada vía WP Cron", "2025-12-29 07:40:46", "2025-12-29 07:40:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15604", "5253", "acción creada", "2025-12-29 07:40:46", "2025-12-29 07:40:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15605", "5252", "acción completa vía WP Cron", "2025-12-29 07:40:46", "2025-12-29 07:40:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15606", "5253", "acción empezada vía WP Cron", "2025-12-29 08:42:11", "2025-12-29 08:42:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15607", "5254", "acción creada", "2025-12-29 08:42:11", "2025-12-29 08:42:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15608", "5253", "acción completa vía WP Cron", "2025-12-29 08:42:11", "2025-12-29 08:42:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15609", "5219", "acción empezada vía WP Cron", "2025-12-29 08:46:36", "2025-12-29 08:46:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15610", "5219", "acción completa vía WP Cron", "2025-12-29 08:46:37", "2025-12-29 08:46:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15611", "5255", "acción creada", "2025-12-29 08:46:37", "2025-12-29 08:46:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15612", "5220", "acción empezada vía WP Cron", "2025-12-29 08:46:37", "2025-12-29 08:46:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15613", "5220", "acción completa vía WP Cron", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15614", "5256", "acción creada", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15615", "5221", "acción empezada vía WP Cron", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15616", "5221", "acción completa vía WP Cron", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15617", "5257", "acción creada", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15618", "5222", "acción empezada vía WP Cron", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15619", "5222", "acción completa vía WP Cron", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15620", "5258", "acción creada", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15621", "5226", "acción empezada vía WP Cron", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15624", "5260", "acción creada", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15625", "5226", "acción completa vía WP Cron", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15626", "5261", "acción creada", "2025-12-29 08:46:38", "2025-12-29 08:46:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15627", "5260", "acción empezada vía WP Cron", "2025-12-29 09:03:02", "2025-12-29 09:03:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15628", "5260", "acción completa vía WP Cron", "2025-12-29 09:03:02", "2025-12-29 09:03:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15629", "5254", "acción empezada vía WP Cron", "2025-12-29 09:42:45", "2025-12-29 09:42:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15630", "5262", "acción creada", "2025-12-29 09:42:45", "2025-12-29 09:42:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15631", "5254", "acción completa vía WP Cron", "2025-12-29 09:42:45", "2025-12-29 09:42:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15632", "5262", "acción empezada vía WP Cron", "2025-12-29 10:42:49", "2025-12-29 10:42:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15633", "5263", "acción creada", "2025-12-29 10:42:49", "2025-12-29 10:42:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15634", "5262", "acción completa vía WP Cron", "2025-12-29 10:42:49", "2025-12-29 10:42:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15635", "5263", "acción empezada vía WP Cron", "2025-12-29 12:07:32", "2025-12-29 12:07:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15636", "5264", "acción creada", "2025-12-29 12:07:32", "2025-12-29 12:07:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15637", "5263", "acción completa vía WP Cron", "2025-12-29 12:07:32", "2025-12-29 12:07:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15638", "5264", "acción empezada vía WP Cron", "2025-12-29 13:10:11", "2025-12-29 13:10:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15639", "5265", "acción creada", "2025-12-29 13:10:11", "2025-12-29 13:10:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15640", "5264", "acción completa vía WP Cron", "2025-12-29 13:10:11", "2025-12-29 13:10:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15641", "5265", "acción empezada vía WP Cron", "2025-12-29 15:09:03", "2025-12-29 15:09:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15642", "5266", "acción creada", "2025-12-29 15:09:03", "2025-12-29 15:09:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15643", "5265", "acción completa vía WP Cron", "2025-12-29 15:09:03", "2025-12-29 15:09:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15644", "5266", "acción empezada vía WP Cron", "2025-12-29 16:11:05", "2025-12-29 16:11:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15645", "5267", "acción creada", "2025-12-29 16:11:05", "2025-12-29 16:11:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15646", "5266", "acción completa vía WP Cron", "2025-12-29 16:11:05", "2025-12-29 16:11:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15647", "5268", "acción creada", "2025-12-29 16:11:05", "2025-12-29 16:11:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15648", "5268", "acción empezada vía WP Cron", "2025-12-29 16:11:50", "2025-12-29 16:11:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15649", "5268", "acción completa vía WP Cron", "2025-12-29 16:11:50", "2025-12-29 16:11:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15650", "5250", "acción empezada vía WP Cron", "2025-12-29 16:31:51", "2025-12-29 16:31:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15651", "5250", "acción completa vía WP Cron", "2025-12-29 16:31:51", "2025-12-29 16:31:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15652", "5269", "acción creada", "2025-12-29 16:31:51", "2025-12-29 16:31:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15653", "5236", "acción empezada vía WP Cron", "2025-12-29 16:45:18", "2025-12-29 16:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15654", "5236", "acción completa vía WP Cron", "2025-12-29 16:45:18", "2025-12-29 16:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15655", "5270", "acción creada", "2025-12-29 16:45:18", "2025-12-29 16:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15656", "5237", "acción empezada vía WP Cron", "2025-12-29 16:45:18", "2025-12-29 16:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15657", "5237", "acción completa vía WP Cron", "2025-12-29 16:45:18", "2025-12-29 16:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15658", "5271", "acción creada", "2025-12-29 16:45:18", "2025-12-29 16:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15659", "5267", "acción empezada vía WP Cron", "2025-12-29 17:37:03", "2025-12-29 17:37:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15660", "5272", "acción creada", "2025-12-29 17:37:03", "2025-12-29 17:37:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15661", "5267", "acción completa vía WP Cron", "2025-12-29 17:37:03", "2025-12-29 17:37:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15662", "5272", "acción empezada vía WP Cron", "2025-12-29 18:41:53", "2025-12-29 18:41:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15663", "5273", "acción creada", "2025-12-29 18:41:53", "2025-12-29 18:41:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15664", "5272", "acción completa vía WP Cron", "2025-12-29 18:41:53", "2025-12-29 18:41:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15665", "5273", "acción empezada vía WP Cron", "2025-12-29 19:42:24", "2025-12-29 19:42:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15666", "5274", "acción creada", "2025-12-29 19:42:24", "2025-12-29 19:42:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15667", "5273", "acción completa vía WP Cron", "2025-12-29 19:42:24", "2025-12-29 19:42:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15668", "5274", "acción empezada vía WP Cron", "2025-12-29 20:47:29", "2025-12-29 20:47:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15669", "5275", "acción creada", "2025-12-29 20:47:29", "2025-12-29 20:47:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15670", "5274", "acción completa vía WP Cron", "2025-12-29 20:47:29", "2025-12-29 20:47:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15671", "5275", "acción empezada vía WP Cron", "2025-12-29 22:24:30", "2025-12-29 22:24:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15672", "5276", "acción creada", "2025-12-29 22:24:30", "2025-12-29 22:24:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15673", "5275", "acción completa vía WP Cron", "2025-12-29 22:24:30", "2025-12-29 22:24:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15674", "5276", "acción empezada vía WP Cron", "2025-12-29 23:43:23", "2025-12-29 23:43:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15675", "5277", "acción creada", "2025-12-29 23:43:23", "2025-12-29 23:43:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15676", "5276", "acción completa vía WP Cron", "2025-12-29 23:43:23", "2025-12-29 23:43:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15677", "5277", "acción empezada vía WP Cron", "2025-12-30 00:58:24", "2025-12-30 00:58:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15678", "5278", "acción creada", "2025-12-30 00:58:24", "2025-12-30 00:58:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15679", "5277", "acción completa vía WP Cron", "2025-12-30 00:58:24", "2025-12-30 00:58:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15680", "5278", "acción empezada vía WP Cron", "2025-12-30 02:03:37", "2025-12-30 02:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15681", "5279", "acción creada", "2025-12-30 02:03:37", "2025-12-30 02:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15682", "5278", "acción completa vía WP Cron", "2025-12-30 02:03:37", "2025-12-30 02:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15683", "5279", "acción empezada vía WP Cron", "2025-12-30 03:18:27", "2025-12-30 03:18:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15684", "5280", "acción creada", "2025-12-30 03:18:27", "2025-12-30 03:18:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15685", "5279", "acción completa vía WP Cron", "2025-12-30 03:18:27", "2025-12-30 03:18:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15686", "5281", "acción creada", "2025-12-30 04:09:45", "2025-12-30 04:09:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15687", "5281", "acción empezada vía WP Cron", "2025-12-30 04:34:15", "2025-12-30 04:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15688", "5281", "acción completa vía WP Cron", "2025-12-30 04:34:15", "2025-12-30 04:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15689", "5280", "acción empezada vía WP Cron", "2025-12-30 04:34:16", "2025-12-30 04:34:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15690", "5282", "acción creada", "2025-12-30 04:34:16", "2025-12-30 04:34:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15691", "5280", "acción completa vía WP Cron", "2025-12-30 04:34:16", "2025-12-30 04:34:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15692", "5269", "acción empezada vía WP Cron", "2025-12-30 04:34:16", "2025-12-30 04:34:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15693", "5269", "acción completa vía WP Cron", "2025-12-30 04:34:16", "2025-12-30 04:34:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15694", "5283", "acción creada", "2025-12-30 04:34:16", "2025-12-30 04:34:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15695", "5282", "acción empezada vía WP Cron", "2025-12-30 05:52:53", "2025-12-30 05:52:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15696", "5284", "acción creada", "2025-12-30 05:52:53", "2025-12-30 05:52:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15697", "5282", "acción completa vía WP Cron", "2025-12-30 05:52:53", "2025-12-30 05:52:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15698", "5284", "acción empezada vía WP Cron", "2025-12-30 06:55:10", "2025-12-30 06:55:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15699", "5285", "acción creada", "2025-12-30 06:55:10", "2025-12-30 06:55:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15700", "5284", "acción completa vía WP Cron", "2025-12-30 06:55:10", "2025-12-30 06:55:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15701", "5285", "acción empezada vía WP Cron", "2025-12-30 08:05:38", "2025-12-30 08:05:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15702", "5286", "acción creada", "2025-12-30 08:05:38", "2025-12-30 08:05:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15703", "5285", "acción completa vía WP Cron", "2025-12-30 08:05:38", "2025-12-30 08:05:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15704", "5255", "acción empezada vía WP Cron", "2025-12-30 08:56:03", "2025-12-30 08:56:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15705", "5255", "acción completa vía WP Cron", "2025-12-30 08:56:04", "2025-12-30 08:56:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15706", "5287", "acción creada", "2025-12-30 08:56:04", "2025-12-30 08:56:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15707", "5256", "acción empezada vía WP Cron", "2025-12-30 08:56:04", "2025-12-30 08:56:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15708", "5256", "acción completa vía WP Cron", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15709", "5288", "acción creada", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15710", "5257", "acción empezada vía WP Cron", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15711", "5257", "acción completa vía WP Cron", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15712", "5289", "acción creada", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15713", "5258", "acción empezada vía WP Cron", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15714", "5258", "acción completa vía WP Cron", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15715", "5290", "acción creada", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15716", "5261", "acción empezada vía WP Cron", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15719", "5292", "acción creada", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15720", "5261", "acción completa vía WP Cron", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15721", "5293", "acción creada", "2025-12-30 08:56:05", "2025-12-30 08:56:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15722", "5292", "acción empezada vía WP Cron", "2025-12-30 08:58:47", "2025-12-30 08:58:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15723", "5292", "acción completa vía WP Cron", "2025-12-30 08:58:47", "2025-12-30 08:58:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15724", "5286", "acción empezada vía WP Cron", "2025-12-30 09:06:33", "2025-12-30 09:06:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15725", "5294", "acción creada", "2025-12-30 09:06:33", "2025-12-30 09:06:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15726", "5286", "acción completa vía WP Cron", "2025-12-30 09:06:33", "2025-12-30 09:06:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15727", "5294", "acción empezada vía WP Cron", "2025-12-30 10:19:07", "2025-12-30 10:19:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15728", "5295", "acción creada", "2025-12-30 10:19:07", "2025-12-30 10:19:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15729", "5294", "acción completa vía WP Cron", "2025-12-30 10:19:07", "2025-12-30 10:19:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15730", "5295", "acción empezada vía WP Cron", "2025-12-30 11:25:47", "2025-12-30 11:25:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15731", "5296", "acción creada", "2025-12-30 11:25:47", "2025-12-30 11:25:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15732", "5295", "acción completa vía WP Cron", "2025-12-30 11:25:47", "2025-12-30 11:25:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15733", "5296", "acción empezada vía WP Cron", "2025-12-30 12:28:50", "2025-12-30 12:28:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15734", "5297", "acción creada", "2025-12-30 12:28:50", "2025-12-30 12:28:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15735", "5296", "acción completa vía WP Cron", "2025-12-30 12:28:50", "2025-12-30 12:28:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15736", "5297", "acción empezada vía WP Cron", "2025-12-30 13:30:17", "2025-12-30 13:30:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15737", "5298", "acción creada", "2025-12-30 13:30:17", "2025-12-30 13:30:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15738", "5297", "acción completa vía WP Cron", "2025-12-30 13:30:17", "2025-12-30 13:30:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15739", "5298", "acción empezada vía WP Cron", "2025-12-30 14:43:35", "2025-12-30 14:43:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15740", "5299", "acción creada", "2025-12-30 14:43:35", "2025-12-30 14:43:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15741", "5298", "acción completa vía WP Cron", "2025-12-30 14:43:35", "2025-12-30 14:43:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15742", "5299", "acción empezada vía WP Cron", "2025-12-30 15:47:18", "2025-12-30 15:47:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15743", "5300", "acción creada", "2025-12-30 15:47:18", "2025-12-30 15:47:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15744", "5299", "acción completa vía WP Cron", "2025-12-30 15:47:18", "2025-12-30 15:47:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15745", "5301", "acción creada", "2025-12-30 16:14:49", "2025-12-30 16:14:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15746", "5301", "acción empezada vía WP Cron", "2025-12-30 16:31:24", "2025-12-30 16:31:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15747", "5301", "acción completa vía WP Cron", "2025-12-30 16:31:24", "2025-12-30 16:31:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15748", "5283", "acción empezada vía WP Cron", "2025-12-30 16:36:05", "2025-12-30 16:36:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15749", "5283", "acción completa vía WP Cron", "2025-12-30 16:36:05", "2025-12-30 16:36:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15750", "5302", "acción creada", "2025-12-30 16:36:05", "2025-12-30 16:36:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15751", "5270", "acción empezada vía WP Cron", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15752", "5270", "acción completa vía WP Cron", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15753", "5303", "acción creada", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15754", "5271", "acción empezada vía WP Cron", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15755", "5271", "acción completa vía WP Cron", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15756", "5304", "acción creada", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15757", "5300", "acción empezada vía WP Cron", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15758", "5305", "acción creada", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15759", "5300", "acción completa vía WP Cron", "2025-12-30 16:49:28", "2025-12-30 16:49:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15760", "5305", "acción empezada vía WP Cron", "2025-12-30 17:57:56", "2025-12-30 17:57:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15761", "5306", "acción creada", "2025-12-30 17:57:56", "2025-12-30 17:57:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15762", "5305", "acción completa vía WP Cron", "2025-12-30 17:57:56", "2025-12-30 17:57:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15763", "5306", "acción empezada vía WP Cron", "2025-12-30 18:58:27", "2025-12-30 18:58:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15764", "5307", "acción creada", "2025-12-30 18:58:27", "2025-12-30 18:58:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15765", "5306", "acción completa vía WP Cron", "2025-12-30 18:58:27", "2025-12-30 18:58:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15766", "5307", "acción empezada vía WP Cron", "2025-12-30 20:00:01", "2025-12-30 20:00:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15767", "5308", "acción creada", "2025-12-30 20:00:01", "2025-12-30 20:00:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15768", "5307", "acción completa vía WP Cron", "2025-12-30 20:00:01", "2025-12-30 20:00:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15769", "5308", "acción empezada vía WP Cron", "2025-12-30 21:16:36", "2025-12-30 21:16:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15770", "5309", "acción creada", "2025-12-30 21:16:36", "2025-12-30 21:16:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15771", "5308", "acción completa vía WP Cron", "2025-12-30 21:16:36", "2025-12-30 21:16:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15772", "5309", "acción empezada vía WP Cron", "2025-12-30 22:22:00", "2025-12-30 22:22:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15773", "5310", "acción creada", "2025-12-30 22:22:00", "2025-12-30 22:22:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15774", "5309", "acción completa vía WP Cron", "2025-12-30 22:22:00", "2025-12-30 22:22:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15775", "5310", "acción empezada vía WP Cron", "2025-12-30 23:33:58", "2025-12-30 23:33:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15776", "5311", "acción creada", "2025-12-30 23:33:58", "2025-12-30 23:33:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15777", "5310", "acción completa vía WP Cron", "2025-12-30 23:33:58", "2025-12-30 23:33:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15778", "5311", "acción empezada vía WP Cron", "2025-12-31 00:34:25", "2025-12-31 00:34:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15779", "5312", "acción creada", "2025-12-31 00:34:25", "2025-12-31 00:34:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15780", "5311", "acción completa vía WP Cron", "2025-12-31 00:34:25", "2025-12-31 00:34:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15781", "5312", "acción empezada vía WP Cron", "2025-12-31 01:55:23", "2025-12-31 01:55:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15782", "5313", "acción creada", "2025-12-31 01:55:23", "2025-12-31 01:55:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15783", "5312", "acción completa vía WP Cron", "2025-12-31 01:55:23", "2025-12-31 01:55:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15784", "5313", "acción empezada vía WP Cron", "2025-12-31 03:07:09", "2025-12-31 03:07:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15785", "5314", "acción creada", "2025-12-31 03:07:09", "2025-12-31 03:07:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15786", "5313", "acción completa vía WP Cron", "2025-12-31 03:07:09", "2025-12-31 03:07:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15787", "5314", "acción empezada vía WP Cron", "2025-12-31 04:08:19", "2025-12-31 04:08:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15788", "5315", "acción creada", "2025-12-31 04:08:19", "2025-12-31 04:08:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15789", "5314", "acción completa vía WP Cron", "2025-12-31 04:08:19", "2025-12-31 04:08:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15790", "5316", "acción creada", "2025-12-31 04:13:51", "2025-12-31 04:13:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15791", "5316", "acción empezada vía WP Cron", "2025-12-31 04:26:42", "2025-12-31 04:26:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15792", "5316", "acción completa vía WP Cron", "2025-12-31 04:26:42", "2025-12-31 04:26:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15793", "5302", "acción empezada vía WP Cron", "2025-12-31 04:41:42", "2025-12-31 04:41:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15794", "5302", "acción completa vía WP Cron", "2025-12-31 04:41:42", "2025-12-31 04:41:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15795", "5317", "acción creada", "2025-12-31 04:41:42", "2025-12-31 04:41:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15796", "5315", "acción empezada vía WP Cron", "2025-12-31 05:09:52", "2025-12-31 05:09:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15797", "5318", "acción creada", "2025-12-31 05:09:52", "2025-12-31 05:09:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15798", "5315", "acción completa vía WP Cron", "2025-12-31 05:09:52", "2025-12-31 05:09:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15799", "5318", "acción empezada vía WP Cron", "2025-12-31 06:22:42", "2025-12-31 06:22:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15800", "5319", "acción creada", "2025-12-31 06:22:42", "2025-12-31 06:22:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15801", "5318", "acción completa vía WP Cron", "2025-12-31 06:22:42", "2025-12-31 06:22:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15802", "5319", "acción empezada vía WP Cron", "2025-12-31 07:28:34", "2025-12-31 07:28:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15803", "5320", "acción creada", "2025-12-31 07:28:34", "2025-12-31 07:28:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15804", "5319", "acción completa vía WP Cron", "2025-12-31 07:28:34", "2025-12-31 07:28:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15805", "5320", "acción empezada vía WP Cron", "2025-12-31 08:39:41", "2025-12-31 08:39:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15806", "5321", "acción creada", "2025-12-31 08:39:41", "2025-12-31 08:39:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15807", "5320", "acción completa vía WP Cron", "2025-12-31 08:39:41", "2025-12-31 08:39:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15808", "5287", "acción empezada vía WP Cron", "2025-12-31 09:17:49", "2025-12-31 09:17:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15809", "5287", "acción completa vía WP Cron", "2025-12-31 09:17:50", "2025-12-31 09:17:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15810", "5322", "acción creada", "2025-12-31 09:17:50", "2025-12-31 09:17:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15811", "5288", "acción empezada vía WP Cron", "2025-12-31 09:17:50", "2025-12-31 09:17:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15812", "5288", "acción completa vía WP Cron", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15813", "5323", "acción creada", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15814", "5289", "acción empezada vía WP Cron", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15815", "5289", "acción completa vía WP Cron", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15816", "5324", "acción creada", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15817", "5290", "acción empezada vía WP Cron", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15818", "5290", "acción completa vía WP Cron", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15819", "5325", "acción creada", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15820", "5293", "acción empezada vía WP Cron", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15823", "5327", "acción creada", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15824", "5293", "acción completa vía WP Cron", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15825", "5328", "acción creada", "2025-12-31 09:17:51", "2025-12-31 09:17:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15826", "5327", "acción empezada vía WP Cron", "2025-12-31 09:45:05", "2025-12-31 09:45:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15827", "5327", "acción completa vía WP Cron", "2025-12-31 09:45:05", "2025-12-31 09:45:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15828", "5321", "acción empezada vía WP Cron", "2025-12-31 09:45:05", "2025-12-31 09:45:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15829", "5329", "acción creada", "2025-12-31 09:45:05", "2025-12-31 09:45:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15830", "5321", "acción completa vía WP Cron", "2025-12-31 09:45:05", "2025-12-31 09:45:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15831", "5329", "acción empezada vía WP Cron", "2025-12-31 10:52:34", "2025-12-31 10:52:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15832", "5330", "acción creada", "2025-12-31 10:52:34", "2025-12-31 10:52:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15833", "5329", "acción completa vía WP Cron", "2025-12-31 10:52:34", "2025-12-31 10:52:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15834", "5330", "acción empezada vía WP Cron", "2025-12-31 12:02:28", "2025-12-31 12:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15835", "5331", "acción creada", "2025-12-31 12:02:28", "2025-12-31 12:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15836", "5330", "acción completa vía WP Cron", "2025-12-31 12:02:28", "2025-12-31 12:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15837", "5331", "acción empezada vía WP Cron", "2025-12-31 13:10:29", "2025-12-31 13:10:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15838", "5332", "acción creada", "2025-12-31 13:10:29", "2025-12-31 13:10:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15839", "5331", "acción completa vía WP Cron", "2025-12-31 13:10:29", "2025-12-31 13:10:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15840", "5332", "acción empezada vía WP Cron", "2025-12-31 14:20:21", "2025-12-31 14:20:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15841", "5333", "acción creada", "2025-12-31 14:20:21", "2025-12-31 14:20:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15842", "5332", "acción completa vía WP Cron", "2025-12-31 14:20:21", "2025-12-31 14:20:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15843", "5333", "acción empezada vía WP Cron", "2025-12-31 15:20:49", "2025-12-31 15:20:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15844", "5334", "acción creada", "2025-12-31 15:20:49", "2025-12-31 15:20:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15845", "5333", "acción completa vía WP Cron", "2025-12-31 15:20:49", "2025-12-31 15:20:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15846", "5335", "acción creada", "2025-12-31 16:10:45", "2025-12-31 16:10:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15847", "5335", "acción empezada vía WP Cron", "2025-12-31 16:16:14", "2025-12-31 16:16:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15848", "5335", "acción completa vía WP Cron", "2025-12-31 16:16:14", "2025-12-31 16:16:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15849", "5334", "acción empezada vía WP Cron", "2025-12-31 16:38:10", "2025-12-31 16:38:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15850", "5336", "acción creada", "2025-12-31 16:38:10", "2025-12-31 16:38:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15851", "5334", "acción completa vía WP Cron", "2025-12-31 16:38:10", "2025-12-31 16:38:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15852", "5317", "acción empezada vía WP Cron", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15853", "5317", "acción completa vía WP Cron", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15854", "5337", "acción creada", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15855", "5303", "acción empezada vía WP Cron", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15856", "5303", "acción completa vía WP Cron", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15857", "5338", "acción creada", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15858", "5304", "acción empezada vía WP Cron", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15859", "5304", "acción completa vía WP Cron", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15860", "5339", "acción creada", "2025-12-31 17:05:30", "2025-12-31 17:05:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15861", "5336", "acción empezada vía WP Cron", "2025-12-31 18:00:35", "2025-12-31 18:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15862", "5340", "acción creada", "2025-12-31 18:00:35", "2025-12-31 18:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15863", "5336", "acción completa vía WP Cron", "2025-12-31 18:00:35", "2025-12-31 18:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15864", "5340", "acción empezada vía WP Cron", "2025-12-31 19:05:35", "2025-12-31 19:05:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15865", "5341", "acción creada", "2025-12-31 19:05:36", "2025-12-31 19:05:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15866", "5340", "acción completa vía WP Cron", "2025-12-31 19:05:36", "2025-12-31 19:05:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15867", "5341", "acción empezada vía WP Cron", "2025-12-31 20:17:33", "2025-12-31 20:17:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15868", "5342", "acción creada", "2025-12-31 20:17:33", "2025-12-31 20:17:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15869", "5341", "acción completa vía WP Cron", "2025-12-31 20:17:33", "2025-12-31 20:17:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15870", "5342", "acción empezada vía WP Cron", "2025-12-31 21:37:05", "2025-12-31 21:37:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15871", "5343", "acción creada", "2025-12-31 21:37:05", "2025-12-31 21:37:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15872", "5342", "acción completa vía WP Cron", "2025-12-31 21:37:05", "2025-12-31 21:37:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15873", "5343", "acción empezada vía WP Cron", "2025-12-31 22:50:40", "2025-12-31 22:50:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15874", "5344", "acción creada", "2025-12-31 22:50:40", "2025-12-31 22:50:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15875", "5343", "acción completa vía WP Cron", "2025-12-31 22:50:40", "2025-12-31 22:50:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15876", "5344", "acción empezada vía WP Cron", "2025-12-31 23:58:32", "2025-12-31 23:58:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15877", "5345", "acción creada", "2025-12-31 23:58:32", "2025-12-31 23:58:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15878", "5344", "acción completa vía WP Cron", "2025-12-31 23:58:32", "2025-12-31 23:58:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15879", "5345", "acción empezada vía WP Cron", "2026-01-01 01:08:19", "2026-01-01 01:08:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15880", "5346", "acción creada", "2026-01-01 01:08:19", "2026-01-01 01:08:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15881", "5345", "acción completa vía WP Cron", "2026-01-01 01:08:19", "2026-01-01 01:08:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15882", "5346", "acción empezada vía WP Cron", "2026-01-01 02:11:15", "2026-01-01 02:11:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15883", "5347", "acción creada", "2026-01-01 02:11:15", "2026-01-01 02:11:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15884", "5346", "acción completa vía WP Cron", "2026-01-01 02:11:15", "2026-01-01 02:11:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15885", "5347", "acción empezada vía WP Cron", "2026-01-01 03:12:00", "2026-01-01 03:12:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15886", "5348", "acción creada", "2026-01-01 03:12:00", "2026-01-01 03:12:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15887", "5347", "acción completa vía WP Cron", "2026-01-01 03:12:00", "2026-01-01 03:12:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15888", "5349", "acción creada", "2026-01-01 04:10:48", "2026-01-01 04:10:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15889", "5349", "acción empezada vía WP Cron", "2026-01-01 04:10:48", "2026-01-01 04:10:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15890", "5349", "acción completa vía WP Cron", "2026-01-01 04:10:48", "2026-01-01 04:10:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15891", "5348", "acción empezada vía WP Cron", "2026-01-01 04:13:40", "2026-01-01 04:13:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15892", "5350", "acción creada", "2026-01-01 04:13:40", "2026-01-01 04:13:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15893", "5348", "acción completa vía WP Cron", "2026-01-01 04:13:40", "2026-01-01 04:13:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15894", "5337", "acción empezada vía WP Cron", "2026-01-01 05:05:55", "2026-01-01 05:05:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15895", "5337", "acción completa vía WP Cron", "2026-01-01 05:05:55", "2026-01-01 05:05:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15896", "5351", "acción creada", "2026-01-01 05:05:55", "2026-01-01 05:05:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15897", "5350", "acción empezada vía WP Cron", "2026-01-01 05:33:24", "2026-01-01 05:33:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15898", "5352", "acción creada", "2026-01-01 05:33:24", "2026-01-01 05:33:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15899", "5350", "acción completa vía WP Cron", "2026-01-01 05:33:24", "2026-01-01 05:33:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15900", "5352", "acción empezada vía WP Cron", "2026-01-01 06:56:12", "2026-01-01 06:56:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15901", "5353", "acción creada", "2026-01-01 06:56:12", "2026-01-01 06:56:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15902", "5352", "acción completa vía WP Cron", "2026-01-01 06:56:12", "2026-01-01 06:56:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15903", "5353", "acción empezada vía WP Cron", "2026-01-01 08:06:20", "2026-01-01 08:06:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15904", "5354", "acción creada", "2026-01-01 08:06:20", "2026-01-01 08:06:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15905", "5353", "acción completa vía WP Cron", "2026-01-01 08:06:20", "2026-01-01 08:06:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15906", "5354", "acción empezada vía WP Cron", "2026-01-01 09:07:30", "2026-01-01 09:07:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15907", "5355", "acción creada", "2026-01-01 09:07:30", "2026-01-01 09:07:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15908", "5354", "acción completa vía WP Cron", "2026-01-01 09:07:30", "2026-01-01 09:07:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15909", "5322", "acción empezada vía WP Cron", "2026-01-01 09:34:13", "2026-01-01 09:34:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15910", "5322", "acción completa vía WP Cron", "2026-01-01 09:34:14", "2026-01-01 09:34:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15911", "5356", "acción creada", "2026-01-01 09:34:14", "2026-01-01 09:34:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15912", "5323", "acción empezada vía WP Cron", "2026-01-01 09:34:14", "2026-01-01 09:34:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15913", "5323", "acción completa vía WP Cron", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15914", "5357", "acción creada", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15915", "5324", "acción empezada vía WP Cron", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15916", "5324", "acción completa vía WP Cron", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15917", "5358", "acción creada", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15918", "5325", "acción empezada vía WP Cron", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15919", "5325", "acción completa vía WP Cron", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15920", "5359", "acción creada", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15921", "5328", "acción empezada vía WP Cron", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15924", "5361", "acción creada", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15925", "5328", "acción completa vía WP Cron", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15926", "5362", "acción creada", "2026-01-01 09:34:15", "2026-01-01 09:34:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15927", "5361", "acción empezada vía WP Cron", "2026-01-01 09:39:31", "2026-01-01 09:39:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15928", "5361", "acción completa vía WP Cron", "2026-01-01 09:39:31", "2026-01-01 09:39:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15929", "5355", "acción empezada vía WP Cron", "2026-01-01 10:33:32", "2026-01-01 10:33:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15930", "5363", "acción creada", "2026-01-01 10:33:32", "2026-01-01 10:33:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15931", "5355", "acción completa vía WP Cron", "2026-01-01 10:33:32", "2026-01-01 10:33:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15932", "5363", "acción empezada vía WP Cron", "2026-01-01 11:44:51", "2026-01-01 11:44:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15933", "5364", "acción creada", "2026-01-01 11:44:51", "2026-01-01 11:44:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15934", "5363", "acción completa vía WP Cron", "2026-01-01 11:44:51", "2026-01-01 11:44:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15935", "5364", "acción empezada vía WP Cron", "2026-01-01 12:47:49", "2026-01-01 12:47:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15936", "5365", "acción creada", "2026-01-01 12:47:49", "2026-01-01 12:47:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15937", "5364", "acción completa vía WP Cron", "2026-01-01 12:47:49", "2026-01-01 12:47:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15938", "5365", "acción empezada vía WP Cron", "2026-01-01 14:08:23", "2026-01-01 14:08:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15939", "5366", "acción creada", "2026-01-01 14:08:23", "2026-01-01 14:08:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15940", "5365", "acción completa vía WP Cron", "2026-01-01 14:08:23", "2026-01-01 14:08:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15941", "5366", "acción empezada vía WP Cron", "2026-01-01 15:28:32", "2026-01-01 15:28:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15942", "5367", "acción creada", "2026-01-01 15:28:32", "2026-01-01 15:28:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15943", "5366", "acción completa vía WP Cron", "2026-01-01 15:28:32", "2026-01-01 15:28:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15944", "5368", "acción creada", "2026-01-01 16:22:26", "2026-01-01 16:22:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15945", "5368", "acción empezada vía WP Cron", "2026-01-01 16:22:26", "2026-01-01 16:22:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15946", "5368", "acción completa vía WP Cron", "2026-01-01 16:22:26", "2026-01-01 16:22:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15947", "5367", "acción empezada vía WP Cron", "2026-01-01 16:49:17", "2026-01-01 16:49:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15948", "5369", "acción creada", "2026-01-01 16:49:17", "2026-01-01 16:49:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15949", "5367", "acción completa vía WP Cron", "2026-01-01 16:49:17", "2026-01-01 16:49:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15950", "5338", "acción empezada vía WP Cron", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15951", "5338", "acción completa vía WP Cron", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15952", "5370", "acción creada", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15953", "5339", "acción empezada vía WP Cron", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15954", "5339", "acción completa vía WP Cron", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15955", "5371", "acción creada", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15956", "5351", "acción empezada vía WP Cron", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15957", "5351", "acción completa vía WP Cron", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15958", "5372", "acción creada", "2026-01-01 17:10:42", "2026-01-01 17:10:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15959", "5369", "acción empezada vía WP Cron", "2026-01-01 17:49:50", "2026-01-01 17:49:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15960", "5373", "acción creada", "2026-01-01 17:49:50", "2026-01-01 17:49:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15961", "5369", "acción completa vía WP Cron", "2026-01-01 17:49:50", "2026-01-01 17:49:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15962", "5373", "acción empezada vía WP Cron", "2026-01-01 19:04:11", "2026-01-01 19:04:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15963", "5374", "acción creada", "2026-01-01 19:04:11", "2026-01-01 19:04:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15964", "5373", "acción completa vía WP Cron", "2026-01-01 19:04:11", "2026-01-01 19:04:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15965", "5374", "acción empezada vía WP Cron", "2026-01-01 20:17:21", "2026-01-01 20:17:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15966", "5375", "acción creada", "2026-01-01 20:17:21", "2026-01-01 20:17:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15967", "5374", "acción completa vía WP Cron", "2026-01-01 20:17:21", "2026-01-01 20:17:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15968", "5375", "acción empezada vía WP Cron", "2026-01-01 21:19:27", "2026-01-01 21:19:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15969", "5376", "acción creada", "2026-01-01 21:19:27", "2026-01-01 21:19:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15970", "5375", "acción completa vía WP Cron", "2026-01-01 21:19:27", "2026-01-01 21:19:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15971", "5376", "acción empezada vía WP Cron", "2026-01-01 22:33:26", "2026-01-01 22:33:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15972", "5377", "acción creada", "2026-01-01 22:33:26", "2026-01-01 22:33:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15973", "5376", "acción completa vía WP Cron", "2026-01-01 22:33:26", "2026-01-01 22:33:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15974", "5377", "acción empezada vía WP Cron", "2026-01-01 23:34:10", "2026-01-01 23:34:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15975", "5378", "acción creada", "2026-01-01 23:34:10", "2026-01-01 23:34:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15976", "5377", "acción completa vía WP Cron", "2026-01-01 23:34:10", "2026-01-01 23:34:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15977", "5378", "acción empezada vía WP Cron", "2026-01-02 00:34:12", "2026-01-02 00:34:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15978", "5379", "acción creada", "2026-01-02 00:34:12", "2026-01-02 00:34:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15979", "5378", "acción completa vía WP Cron", "2026-01-02 00:34:12", "2026-01-02 00:34:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15980", "5379", "acción empezada vía WP Cron", "2026-01-02 01:50:37", "2026-01-02 01:50:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15981", "5380", "acción creada", "2026-01-02 01:50:37", "2026-01-02 01:50:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15982", "5379", "acción completa vía WP Cron", "2026-01-02 01:50:37", "2026-01-02 01:50:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15983", "5380", "acción empezada vía WP Cron", "2026-01-02 02:51:59", "2026-01-02 02:51:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15984", "5381", "acción creada", "2026-01-02 02:51:59", "2026-01-02 02:51:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15985", "5380", "acción completa vía WP Cron", "2026-01-02 02:51:59", "2026-01-02 02:51:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15986", "5381", "acción empezada vía WP Cron", "2026-01-02 03:54:01", "2026-01-02 03:54:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15987", "5382", "acción creada", "2026-01-02 03:54:01", "2026-01-02 03:54:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15988", "5381", "acción completa vía WP Cron", "2026-01-02 03:54:01", "2026-01-02 03:54:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15989", "5383", "acción creada", "2026-01-02 04:34:51", "2026-01-02 04:34:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15990", "5383", "acción empezada vía WP Cron", "2026-01-02 04:49:37", "2026-01-02 04:49:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15991", "5383", "acción completa vía WP Cron", "2026-01-02 04:49:37", "2026-01-02 04:49:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15992", "5382", "acción empezada vía WP Cron", "2026-01-02 04:55:07", "2026-01-02 04:55:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15993", "5384", "acción creada", "2026-01-02 04:55:07", "2026-01-02 04:55:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15994", "5382", "acción completa vía WP Cron", "2026-01-02 04:55:07", "2026-01-02 04:55:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15995", "5372", "acción empezada vía WP Cron", "2026-01-02 05:23:07", "2026-01-02 05:23:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15996", "5372", "acción completa vía WP Cron", "2026-01-02 05:23:07", "2026-01-02 05:23:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15997", "5385", "acción creada", "2026-01-02 05:23:07", "2026-01-02 05:23:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15998", "5384", "acción empezada vía WP Cron", "2026-01-02 05:56:25", "2026-01-02 05:56:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("15999", "5386", "acción creada", "2026-01-02 05:56:25", "2026-01-02 05:56:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16000", "5384", "acción completa vía WP Cron", "2026-01-02 05:56:25", "2026-01-02 05:56:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16001", "5386", "acción empezada vía WP Cron", "2026-01-02 06:59:56", "2026-01-02 06:59:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16002", "5387", "acción creada", "2026-01-02 06:59:56", "2026-01-02 06:59:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16003", "5386", "acción completa vía WP Cron", "2026-01-02 06:59:56", "2026-01-02 06:59:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16004", "5387", "acción empezada vía WP Cron", "2026-01-02 08:12:15", "2026-01-02 08:12:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16005", "5388", "acción creada", "2026-01-02 08:12:15", "2026-01-02 08:12:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16006", "5387", "acción completa vía WP Cron", "2026-01-02 08:12:15", "2026-01-02 08:12:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16007", "5388", "acción empezada vía WP Cron", "2026-01-02 09:13:49", "2026-01-02 09:13:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16008", "5389", "acción creada", "2026-01-02 09:13:49", "2026-01-02 09:13:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16009", "5388", "acción completa vía WP Cron", "2026-01-02 09:13:49", "2026-01-02 09:13:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16010", "5356", "acción empezada vía WP Cron", "2026-01-02 09:45:07", "2026-01-02 09:45:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16011", "5356", "acción completa vía WP Cron", "2026-01-02 09:45:09", "2026-01-02 09:45:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16012", "5390", "acción creada", "2026-01-02 09:45:09", "2026-01-02 09:45:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16013", "5357", "acción empezada vía WP Cron", "2026-01-02 09:45:09", "2026-01-02 09:45:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16014", "5357", "acción completa vía WP Cron", "2026-01-02 09:45:09", "2026-01-02 09:45:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16015", "5391", "acción creada", "2026-01-02 09:45:09", "2026-01-02 09:45:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16016", "5358", "acción empezada vía WP Cron", "2026-01-02 09:45:09", "2026-01-02 09:45:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16017", "5358", "acción completa vía WP Cron", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16018", "5392", "acción creada", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16019", "5359", "acción empezada vía WP Cron", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16020", "5359", "acción completa vía WP Cron", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16021", "5393", "acción creada", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16022", "5362", "acción empezada vía WP Cron", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16025", "5395", "acción creada", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16026", "5362", "acción completa vía WP Cron", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16027", "5396", "acción creada", "2026-01-02 09:45:10", "2026-01-02 09:45:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16028", "5395", "acción empezada vía WP Cron", "2026-01-02 09:45:53", "2026-01-02 09:45:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16029", "5395", "acción completa vía WP Cron", "2026-01-02 09:45:53", "2026-01-02 09:45:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16030", "5389", "acción empezada vía WP Cron", "2026-01-02 10:22:28", "2026-01-02 10:22:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16031", "5397", "acción creada", "2026-01-02 10:22:28", "2026-01-02 10:22:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16032", "5389", "acción completa vía WP Cron", "2026-01-02 10:22:28", "2026-01-02 10:22:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16033", "5397", "acción empezada vía WP Cron", "2026-01-02 11:35:41", "2026-01-02 11:35:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16034", "5398", "acción creada", "2026-01-02 11:35:41", "2026-01-02 11:35:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16035", "5397", "acción completa vía WP Cron", "2026-01-02 11:35:41", "2026-01-02 11:35:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16036", "5398", "acción empezada vía WP Cron", "2026-01-02 12:40:41", "2026-01-02 12:40:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16037", "5399", "acción creada", "2026-01-02 12:40:41", "2026-01-02 12:40:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16038", "5398", "acción completa vía WP Cron", "2026-01-02 12:40:42", "2026-01-02 12:40:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16039", "5399", "acción empezada vía WP Cron", "2026-01-02 13:41:52", "2026-01-02 13:41:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16040", "5400", "acción creada", "2026-01-02 13:41:52", "2026-01-02 13:41:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16041", "5399", "acción completa vía WP Cron", "2026-01-02 13:41:52", "2026-01-02 13:41:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16042", "5400", "acción empezada vía WP Cron", "2026-01-02 14:53:05", "2026-01-02 14:53:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16043", "5401", "acción creada", "2026-01-02 14:53:05", "2026-01-02 14:53:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16044", "5400", "acción completa vía WP Cron", "2026-01-02 14:53:05", "2026-01-02 14:53:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16045", "5401", "acción empezada vía WP Cron", "2026-01-02 15:54:54", "2026-01-02 15:54:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16046", "5402", "acción creada", "2026-01-02 15:54:54", "2026-01-02 15:54:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16047", "5401", "acción completa vía WP Cron", "2026-01-02 15:54:54", "2026-01-02 15:54:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16048", "5403", "acción creada", "2026-01-02 16:21:07", "2026-01-02 16:21:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16049", "5403", "acción empezada vía WP Cron", "2026-01-02 16:27:35", "2026-01-02 16:27:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16050", "5403", "acción completa vía WP Cron", "2026-01-02 16:27:35", "2026-01-02 16:27:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16051", "5402", "acción empezada vía WP Cron", "2026-01-02 16:57:41", "2026-01-02 16:57:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16052", "5404", "acción creada", "2026-01-02 16:57:41", "2026-01-02 16:57:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16053", "5402", "acción completa vía WP Cron", "2026-01-02 16:57:41", "2026-01-02 16:57:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16054", "5370", "acción empezada vía WP Cron", "2026-01-02 17:16:07", "2026-01-02 17:16:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16055", "5370", "acción completa vía WP Cron", "2026-01-02 17:16:07", "2026-01-02 17:16:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16056", "5405", "acción creada", "2026-01-02 17:16:07", "2026-01-02 17:16:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16057", "5371", "acción empezada vía WP Cron", "2026-01-02 17:16:07", "2026-01-02 17:16:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16058", "5371", "acción completa vía WP Cron", "2026-01-02 17:16:07", "2026-01-02 17:16:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16059", "5406", "acción creada", "2026-01-02 17:16:07", "2026-01-02 17:16:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16060", "5385", "acción empezada vía WP Cron", "2026-01-02 17:27:46", "2026-01-02 17:27:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16061", "5385", "acción completa vía WP Cron", "2026-01-02 17:27:46", "2026-01-02 17:27:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16062", "5407", "acción creada", "2026-01-02 17:27:46", "2026-01-02 17:27:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16063", "5404", "acción empezada vía WP Cron", "2026-01-02 17:58:17", "2026-01-02 17:58:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16064", "5408", "acción creada", "2026-01-02 17:58:17", "2026-01-02 17:58:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16065", "5404", "acción completa vía WP Cron", "2026-01-02 17:58:17", "2026-01-02 17:58:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16066", "5408", "acción empezada vía WP Cron", "2026-01-02 18:58:31", "2026-01-02 18:58:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16067", "5409", "acción creada", "2026-01-02 18:58:31", "2026-01-02 18:58:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16068", "5408", "acción completa vía WP Cron", "2026-01-02 18:58:31", "2026-01-02 18:58:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16069", "5409", "acción empezada vía WP Cron", "2026-01-02 19:58:45", "2026-01-02 19:58:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16070", "5410", "acción creada", "2026-01-02 19:58:45", "2026-01-02 19:58:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16071", "5409", "acción completa vía WP Cron", "2026-01-02 19:58:45", "2026-01-02 19:58:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16072", "5410", "acción empezada vía WP Cron", "2026-01-02 21:00:24", "2026-01-02 21:00:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16073", "5411", "acción creada", "2026-01-02 21:00:24", "2026-01-02 21:00:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16074", "5410", "acción completa vía WP Cron", "2026-01-02 21:00:24", "2026-01-02 21:00:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16075", "5411", "acción empezada vía WP Cron", "2026-01-02 22:01:41", "2026-01-02 22:01:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16076", "5412", "acción creada", "2026-01-02 22:01:41", "2026-01-02 22:01:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16077", "5411", "acción completa vía WP Cron", "2026-01-02 22:01:41", "2026-01-02 22:01:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16078", "5412", "acción empezada vía WP Cron", "2026-01-02 23:02:47", "2026-01-02 23:02:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16079", "5413", "acción creada", "2026-01-02 23:02:47", "2026-01-02 23:02:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16080", "5412", "acción completa vía WP Cron", "2026-01-02 23:02:47", "2026-01-02 23:02:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16081", "5413", "acción empezada vía WP Cron", "2026-01-03 00:04:21", "2026-01-03 00:04:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16082", "5414", "acción creada", "2026-01-03 00:04:21", "2026-01-03 00:04:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16083", "5413", "acción completa vía WP Cron", "2026-01-03 00:04:21", "2026-01-03 00:04:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16084", "5414", "acción empezada vía WP Cron", "2026-01-03 01:05:55", "2026-01-03 01:05:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16085", "5415", "acción creada", "2026-01-03 01:05:55", "2026-01-03 01:05:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16086", "5414", "acción completa vía WP Cron", "2026-01-03 01:05:55", "2026-01-03 01:05:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16087", "5415", "acción empezada vía WP Cron", "2026-01-03 02:07:26", "2026-01-03 02:07:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16088", "5416", "acción creada", "2026-01-03 02:07:26", "2026-01-03 02:07:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16089", "5415", "acción completa vía WP Cron", "2026-01-03 02:07:26", "2026-01-03 02:07:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16090", "5416", "acción empezada vía WP Cron", "2026-01-03 03:08:18", "2026-01-03 03:08:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16091", "5417", "acción creada", "2026-01-03 03:08:18", "2026-01-03 03:08:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16092", "5416", "acción completa vía WP Cron", "2026-01-03 03:08:18", "2026-01-03 03:08:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16093", "5417", "acción empezada vía WP Cron", "2026-01-03 04:09:12", "2026-01-03 04:09:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16094", "5418", "acción creada", "2026-01-03 04:09:12", "2026-01-03 04:09:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16095", "5417", "acción completa vía WP Cron", "2026-01-03 04:09:12", "2026-01-03 04:09:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16096", "5419", "acción creada", "2026-01-03 04:19:43", "2026-01-03 04:19:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16097", "5419", "acción empezada vía WP Cron", "2026-01-03 04:19:43", "2026-01-03 04:19:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16098", "5419", "acción completa vía WP Cron", "2026-01-03 04:19:43", "2026-01-03 04:19:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16099", "5418", "acción empezada vía WP Cron", "2026-01-03 05:10:25", "2026-01-03 05:10:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16100", "5420", "acción creada", "2026-01-03 05:10:25", "2026-01-03 05:10:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16101", "5418", "acción completa vía WP Cron", "2026-01-03 05:10:25", "2026-01-03 05:10:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16102", "5407", "acción empezada vía WP Cron", "2026-01-03 05:28:00", "2026-01-03 05:28:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16103", "5407", "acción completa vía WP Cron", "2026-01-03 05:28:01", "2026-01-03 05:28:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16104", "5421", "acción creada", "2026-01-03 05:28:01", "2026-01-03 05:28:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16105", "5420", "acción empezada vía WP Cron", "2026-01-03 06:10:27", "2026-01-03 06:10:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16106", "5422", "acción creada", "2026-01-03 06:10:27", "2026-01-03 06:10:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16107", "5420", "acción completa vía WP Cron", "2026-01-03 06:10:27", "2026-01-03 06:10:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16108", "5422", "acción empezada vía WP Cron", "2026-01-03 07:12:28", "2026-01-03 07:12:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16109", "5423", "acción creada", "2026-01-03 07:12:28", "2026-01-03 07:12:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16110", "5422", "acción completa vía WP Cron", "2026-01-03 07:12:28", "2026-01-03 07:12:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16111", "5423", "acción empezada vía WP Cron", "2026-01-03 08:13:37", "2026-01-03 08:13:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16112", "5424", "acción creada", "2026-01-03 08:13:37", "2026-01-03 08:13:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16113", "5423", "acción completa vía WP Cron", "2026-01-03 08:13:37", "2026-01-03 08:13:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16114", "5424", "acción empezada vía WP Cron", "2026-01-03 09:14:34", "2026-01-03 09:14:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16115", "5425", "acción creada", "2026-01-03 09:14:34", "2026-01-03 09:14:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16116", "5424", "acción completa vía WP Cron", "2026-01-03 09:14:34", "2026-01-03 09:14:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16117", "5390", "acción empezada vía WP Cron", "2026-01-03 09:45:13", "2026-01-03 09:45:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16118", "5390", "acción completa vía WP Cron", "2026-01-03 09:45:14", "2026-01-03 09:45:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16119", "5426", "acción creada", "2026-01-03 09:45:14", "2026-01-03 09:45:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16120", "5391", "acción empezada vía WP Cron", "2026-01-03 09:45:14", "2026-01-03 09:45:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16121", "5391", "acción completa vía WP Cron", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16122", "5427", "acción creada", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16123", "5392", "acción empezada vía WP Cron", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16124", "5392", "acción completa vía WP Cron", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16125", "5428", "acción creada", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16126", "5393", "acción empezada vía WP Cron", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16127", "5393", "acción completa vía WP Cron", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16128", "5429", "acción creada", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16129", "5396", "acción empezada vía WP Cron", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16132", "5431", "acción creada", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16133", "5396", "acción completa vía WP Cron", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16134", "5432", "acción creada", "2026-01-03 09:45:15", "2026-01-03 09:45:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16135", "5431", "acción empezada vía WP Cron", "2026-01-03 09:45:57", "2026-01-03 09:45:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16136", "5431", "acción completa vía WP Cron", "2026-01-03 09:45:57", "2026-01-03 09:45:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16137", "5425", "acción empezada vía WP Cron", "2026-01-03 10:16:30", "2026-01-03 10:16:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16138", "5433", "acción creada", "2026-01-03 10:16:30", "2026-01-03 10:16:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16139", "5425", "acción completa vía WP Cron", "2026-01-03 10:16:30", "2026-01-03 10:16:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16140", "5433", "acción empezada vía WP Cron", "2026-01-03 11:17:54", "2026-01-03 11:17:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16141", "5434", "acción creada", "2026-01-03 11:17:54", "2026-01-03 11:17:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16142", "5433", "acción completa vía WP Cron", "2026-01-03 11:17:54", "2026-01-03 11:17:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16143", "5434", "acción empezada vía WP Cron", "2026-01-03 12:27:09", "2026-01-03 12:27:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16144", "5435", "acción creada", "2026-01-03 12:27:09", "2026-01-03 12:27:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16145", "5434", "acción completa vía WP Cron", "2026-01-03 12:27:09", "2026-01-03 12:27:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16146", "5435", "acción empezada vía WP Cron", "2026-01-03 13:31:51", "2026-01-03 13:31:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16147", "5436", "acción creada", "2026-01-03 13:31:51", "2026-01-03 13:31:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16148", "5435", "acción completa vía WP Cron", "2026-01-03 13:31:51", "2026-01-03 13:31:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16149", "4948", "acción empezada vía WP Cron", "2026-01-03 14:16:21", "2026-01-03 14:16:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16150", "4948", "acción completa vía WP Cron", "2026-01-03 14:16:21", "2026-01-03 14:16:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16151", "5437", "acción creada", "2026-01-03 14:16:21", "2026-01-03 14:16:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16152", "5436", "acción empezada vía WP Cron", "2026-01-03 14:36:53", "2026-01-03 14:36:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16153", "5438", "acción creada", "2026-01-03 14:36:53", "2026-01-03 14:36:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16154", "5436", "acción completa vía WP Cron", "2026-01-03 14:36:53", "2026-01-03 14:36:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16155", "5438", "acción empezada vía WP Cron", "2026-01-03 15:37:34", "2026-01-03 15:37:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16156", "5439", "acción creada", "2026-01-03 15:37:34", "2026-01-03 15:37:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16157", "5438", "acción completa vía WP Cron", "2026-01-03 15:37:34", "2026-01-03 15:37:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16158", "5440", "acción creada", "2026-01-03 16:11:11", "2026-01-03 16:11:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16159", "5440", "acción empezada vía WP Cron", "2026-01-03 16:18:51", "2026-01-03 16:18:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16160", "5440", "acción completa vía WP Cron", "2026-01-03 16:18:51", "2026-01-03 16:18:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16161", "5439", "acción empezada vía WP Cron", "2026-01-03 16:38:38", "2026-01-03 16:38:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16162", "5441", "acción creada", "2026-01-03 16:38:38", "2026-01-03 16:38:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16163", "5439", "acción completa vía WP Cron", "2026-01-03 16:38:38", "2026-01-03 16:38:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16164", "5405", "acción empezada vía WP Cron", "2026-01-03 17:18:15", "2026-01-03 17:18:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16165", "5405", "acción completa vía WP Cron", "2026-01-03 17:18:15", "2026-01-03 17:18:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16166", "5442", "acción creada", "2026-01-03 17:18:15", "2026-01-03 17:18:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16167", "5406", "acción empezada vía WP Cron", "2026-01-03 17:18:15", "2026-01-03 17:18:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16168", "5406", "acción completa vía WP Cron", "2026-01-03 17:18:15", "2026-01-03 17:18:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16169", "5443", "acción creada", "2026-01-03 17:18:15", "2026-01-03 17:18:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16170", "5421", "acción empezada vía WP Cron", "2026-01-03 17:28:44", "2026-01-03 17:28:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16171", "5421", "acción completa vía WP Cron", "2026-01-03 17:28:44", "2026-01-03 17:28:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16172", "5444", "acción creada", "2026-01-03 17:28:44", "2026-01-03 17:28:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16173", "5441", "acción empezada vía WP Cron", "2026-01-03 17:40:45", "2026-01-03 17:40:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16174", "5445", "acción creada", "2026-01-03 17:40:45", "2026-01-03 17:40:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16175", "5441", "acción completa vía WP Cron", "2026-01-03 17:40:45", "2026-01-03 17:40:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16176", "5445", "acción empezada vía WP Cron", "2026-01-03 18:46:21", "2026-01-03 18:46:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16177", "5446", "acción creada", "2026-01-03 18:46:21", "2026-01-03 18:46:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16178", "5445", "acción completa vía WP Cron", "2026-01-03 18:46:21", "2026-01-03 18:46:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16179", "5446", "acción empezada vía WP Cron", "2026-01-03 19:47:31", "2026-01-03 19:47:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16180", "5447", "acción creada", "2026-01-03 19:47:31", "2026-01-03 19:47:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16181", "5446", "acción completa vía WP Cron", "2026-01-03 19:47:31", "2026-01-03 19:47:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16182", "5447", "acción empezada vía WP Cron", "2026-01-03 20:49:44", "2026-01-03 20:49:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16183", "5448", "acción creada", "2026-01-03 20:49:44", "2026-01-03 20:49:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16184", "5447", "acción completa vía WP Cron", "2026-01-03 20:49:44", "2026-01-03 20:49:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16185", "5448", "acción empezada vía WP Cron", "2026-01-03 22:08:44", "2026-01-03 22:08:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16186", "5449", "acción creada", "2026-01-03 22:08:44", "2026-01-03 22:08:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16187", "5448", "acción completa vía WP Cron", "2026-01-03 22:08:44", "2026-01-03 22:08:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16188", "5449", "acción empezada vía WP Cron", "2026-01-03 23:11:00", "2026-01-03 23:11:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16189", "5450", "acción creada", "2026-01-03 23:11:00", "2026-01-03 23:11:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16190", "5449", "acción completa vía WP Cron", "2026-01-03 23:11:00", "2026-01-03 23:11:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16191", "5450", "acción empezada vía WP Cron", "2026-01-04 00:13:23", "2026-01-04 00:13:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16192", "5451", "acción creada", "2026-01-04 00:13:23", "2026-01-04 00:13:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16193", "5450", "acción completa vía WP Cron", "2026-01-04 00:13:23", "2026-01-04 00:13:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16194", "5451", "acción empezada vía WP Cron", "2026-01-04 01:16:20", "2026-01-04 01:16:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16195", "5452", "acción creada", "2026-01-04 01:16:20", "2026-01-04 01:16:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16196", "5451", "acción completa vía WP Cron", "2026-01-04 01:16:20", "2026-01-04 01:16:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16197", "5452", "acción empezada vía WP Cron", "2026-01-04 02:18:39", "2026-01-04 02:18:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16198", "5453", "acción creada", "2026-01-04 02:18:39", "2026-01-04 02:18:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16199", "5452", "acción completa vía WP Cron", "2026-01-04 02:18:39", "2026-01-04 02:18:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16200", "5453", "acción empezada vía WP Cron", "2026-01-04 03:20:51", "2026-01-04 03:20:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16201", "5454", "acción creada", "2026-01-04 03:20:51", "2026-01-04 03:20:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16202", "5453", "acción completa vía WP Cron", "2026-01-04 03:20:51", "2026-01-04 03:20:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16203", "5454", "acción empezada vía WP Cron", "2026-01-04 04:23:16", "2026-01-04 04:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16204", "5455", "acción creada", "2026-01-04 04:23:16", "2026-01-04 04:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16205", "5454", "acción completa vía WP Cron", "2026-01-04 04:23:16", "2026-01-04 04:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16206", "5456", "acción creada", "2026-01-04 04:23:16", "2026-01-04 04:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16207", "5456", "acción empezada vía WP Cron", "2026-01-04 04:54:06", "2026-01-04 04:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16208", "5456", "acción completa vía WP Cron", "2026-01-04 04:54:06", "2026-01-04 04:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16209", "5455", "acción empezada vía WP Cron", "2026-01-04 05:25:08", "2026-01-04 05:25:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16210", "5457", "acción creada", "2026-01-04 05:25:08", "2026-01-04 05:25:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16211", "5455", "acción completa vía WP Cron", "2026-01-04 05:25:08", "2026-01-04 05:25:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16212", "5444", "acción empezada vía WP Cron", "2026-01-04 05:37:36", "2026-01-04 05:37:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16213", "5444", "acción completa vía WP Cron", "2026-01-04 05:37:36", "2026-01-04 05:37:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16214", "5458", "acción creada", "2026-01-04 05:37:36", "2026-01-04 05:37:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16215", "5457", "acción empezada vía WP Cron", "2026-01-04 06:27:01", "2026-01-04 06:27:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16216", "5459", "acción creada", "2026-01-04 06:27:01", "2026-01-04 06:27:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16217", "5457", "acción completa vía WP Cron", "2026-01-04 06:27:01", "2026-01-04 06:27:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16218", "5459", "acción empezada vía WP Cron", "2026-01-04 07:29:05", "2026-01-04 07:29:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16219", "5460", "acción creada", "2026-01-04 07:29:05", "2026-01-04 07:29:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16220", "5459", "acción completa vía WP Cron", "2026-01-04 07:29:05", "2026-01-04 07:29:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16221", "5460", "acción empezada vía WP Cron", "2026-01-04 08:31:06", "2026-01-04 08:31:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16222", "5461", "acción creada", "2026-01-04 08:31:06", "2026-01-04 08:31:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16223", "5460", "acción completa vía WP Cron", "2026-01-04 08:31:06", "2026-01-04 08:31:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16224", "5461", "acción empezada vía WP Cron", "2026-01-04 09:32:53", "2026-01-04 09:32:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16225", "5462", "acción creada", "2026-01-04 09:32:53", "2026-01-04 09:32:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16226", "5461", "acción completa vía WP Cron", "2026-01-04 09:32:53", "2026-01-04 09:32:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16227", "5426", "acción empezada vía WP Cron", "2026-01-04 09:48:25", "2026-01-04 09:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16228", "5426", "acción completa vía WP Cron", "2026-01-04 09:48:26", "2026-01-04 09:48:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16229", "5463", "acción creada", "2026-01-04 09:48:26", "2026-01-04 09:48:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16230", "5427", "acción empezada vía WP Cron", "2026-01-04 09:48:26", "2026-01-04 09:48:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16231", "5427", "acción completa vía WP Cron", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16232", "5464", "acción creada", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16233", "5428", "acción empezada vía WP Cron", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16234", "5428", "acción completa vía WP Cron", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16235", "5465", "acción creada", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16236", "5429", "acción empezada vía WP Cron", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16237", "5429", "acción completa vía WP Cron", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16238", "5466", "acción creada", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16239", "5432", "acción empezada vía WP Cron", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16242", "5468", "acción creada", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16243", "5432", "acción completa vía WP Cron", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16244", "5469", "acción creada", "2026-01-04 09:48:27", "2026-01-04 09:48:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16245", "5468", "acción empezada vía WP Cron", "2026-01-04 09:57:59", "2026-01-04 09:57:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16246", "5468", "acción completa vía WP Cron", "2026-01-04 09:57:59", "2026-01-04 09:57:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16247", "5462", "acción empezada vía WP Cron", "2026-01-04 10:34:51", "2026-01-04 10:34:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16248", "5470", "acción creada", "2026-01-04 10:34:51", "2026-01-04 10:34:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16249", "5462", "acción completa vía WP Cron", "2026-01-04 10:34:51", "2026-01-04 10:34:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16250", "5470", "acción empezada vía Async Request", "2026-01-04 11:36:13", "2026-01-04 11:36:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16251", "5471", "acción creada", "2026-01-04 11:36:13", "2026-01-04 11:36:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16252", "5470", "acción completa vía Async Request", "2026-01-04 11:36:13", "2026-01-04 11:36:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16253", "5471", "acción empezada vía WP Cron", "2026-01-04 12:37:32", "2026-01-04 12:37:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16254", "5472", "acción creada", "2026-01-04 12:37:32", "2026-01-04 12:37:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16255", "5471", "acción completa vía WP Cron", "2026-01-04 12:37:32", "2026-01-04 12:37:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16256", "5472", "acción empezada vía WP Cron", "2026-01-04 13:39:19", "2026-01-04 13:39:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16257", "5473", "acción creada", "2026-01-04 13:39:19", "2026-01-04 13:39:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16258", "5472", "acción completa vía WP Cron", "2026-01-04 13:39:19", "2026-01-04 13:39:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16259", "5473", "acción empezada vía WP Cron", "2026-01-04 14:40:46", "2026-01-04 14:40:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16260", "5474", "acción creada", "2026-01-04 14:40:46", "2026-01-04 14:40:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16261", "5473", "acción completa vía WP Cron", "2026-01-04 14:40:46", "2026-01-04 14:40:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16262", "5474", "acción empezada vía WP Cron", "2026-01-04 15:42:34", "2026-01-04 15:42:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16263", "5475", "acción creada", "2026-01-04 15:42:34", "2026-01-04 15:42:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16264", "5474", "acción completa vía WP Cron", "2026-01-04 15:42:34", "2026-01-04 15:42:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16265", "5476", "acción creada", "2026-01-04 16:13:27", "2026-01-04 16:13:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16266", "5476", "acción empezada vía WP Cron", "2026-01-04 16:27:06", "2026-01-04 16:27:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16267", "5476", "acción completa vía WP Cron", "2026-01-04 16:27:06", "2026-01-04 16:27:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16268", "5475", "acción empezada vía WP Cron", "2026-01-04 16:44:22", "2026-01-04 16:44:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16269", "5477", "acción creada", "2026-01-04 16:44:22", "2026-01-04 16:44:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16270", "5475", "acción completa vía WP Cron", "2026-01-04 16:44:22", "2026-01-04 16:44:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16271", "5442", "acción empezada vía WP Cron", "2026-01-04 17:31:46", "2026-01-04 17:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16272", "5442", "acción completa vía WP Cron", "2026-01-04 17:31:46", "2026-01-04 17:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16273", "5478", "acción creada", "2026-01-04 17:31:46", "2026-01-04 17:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16274", "5443", "acción empezada vía WP Cron", "2026-01-04 17:31:46", "2026-01-04 17:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16275", "5443", "acción completa vía WP Cron", "2026-01-04 17:31:46", "2026-01-04 17:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16276", "5479", "acción creada", "2026-01-04 17:31:46", "2026-01-04 17:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16277", "5458", "acción empezada vía WP Cron", "2026-01-04 17:37:49", "2026-01-04 17:37:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16278", "5458", "acción completa vía WP Cron", "2026-01-04 17:37:49", "2026-01-04 17:37:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16279", "5480", "acción creada", "2026-01-04 17:37:49", "2026-01-04 17:37:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16280", "5477", "acción empezada vía WP Cron", "2026-01-04 17:45:54", "2026-01-04 17:45:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16281", "5481", "acción creada", "2026-01-04 17:45:54", "2026-01-04 17:45:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16282", "5477", "acción completa vía WP Cron", "2026-01-04 17:45:54", "2026-01-04 17:45:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16283", "5481", "acción empezada vía WP Cron", "2026-01-04 18:47:18", "2026-01-04 18:47:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16284", "5482", "acción creada", "2026-01-04 18:47:18", "2026-01-04 18:47:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16285", "5481", "acción completa vía WP Cron", "2026-01-04 18:47:18", "2026-01-04 18:47:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16286", "5482", "acción empezada vía WP Cron", "2026-01-04 19:49:09", "2026-01-04 19:49:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16287", "5483", "acción creada", "2026-01-04 19:49:09", "2026-01-04 19:49:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16288", "5482", "acción completa vía WP Cron", "2026-01-04 19:49:09", "2026-01-04 19:49:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16289", "5483", "acción empezada vía WP Cron", "2026-01-04 20:49:50", "2026-01-04 20:49:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16290", "5484", "acción creada", "2026-01-04 20:49:50", "2026-01-04 20:49:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16291", "5483", "acción completa vía WP Cron", "2026-01-04 20:49:50", "2026-01-04 20:49:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16292", "5484", "acción empezada vía WP Cron", "2026-01-04 21:50:14", "2026-01-04 21:50:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16293", "5485", "acción creada", "2026-01-04 21:50:14", "2026-01-04 21:50:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16294", "5484", "acción completa vía WP Cron", "2026-01-04 21:50:14", "2026-01-04 21:50:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16295", "5485", "acción empezada vía WP Cron", "2026-01-04 22:50:57", "2026-01-04 22:50:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16296", "5486", "acción creada", "2026-01-04 22:50:57", "2026-01-04 22:50:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16297", "5485", "acción completa vía WP Cron", "2026-01-04 22:50:57", "2026-01-04 22:50:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16298", "5486", "acción empezada vía WP Cron", "2026-01-04 23:54:58", "2026-01-04 23:54:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16299", "5487", "acción creada", "2026-01-04 23:54:59", "2026-01-04 23:54:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16300", "5486", "acción completa vía WP Cron", "2026-01-04 23:54:59", "2026-01-04 23:54:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16301", "5487", "acción empezada vía WP Cron", "2026-01-05 00:55:04", "2026-01-05 00:55:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16302", "5488", "acción creada", "2026-01-05 00:55:04", "2026-01-05 00:55:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16303", "5487", "acción completa vía WP Cron", "2026-01-05 00:55:04", "2026-01-05 00:55:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16304", "5488", "acción empezada vía WP Cron", "2026-01-05 01:57:46", "2026-01-05 01:57:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16305", "5489", "acción creada", "2026-01-05 01:57:46", "2026-01-05 01:57:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16306", "5488", "acción completa vía WP Cron", "2026-01-05 01:57:46", "2026-01-05 01:57:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16307", "5489", "acción empezada vía WP Cron", "2026-01-05 02:59:03", "2026-01-05 02:59:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16308", "5490", "acción creada", "2026-01-05 02:59:03", "2026-01-05 02:59:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16309", "5489", "acción completa vía WP Cron", "2026-01-05 02:59:03", "2026-01-05 02:59:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16310", "5490", "acción empezada vía WP Cron", "2026-01-05 03:59:28", "2026-01-05 03:59:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16311", "5491", "acción creada", "2026-01-05 03:59:28", "2026-01-05 03:59:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16312", "5490", "acción completa vía WP Cron", "2026-01-05 03:59:28", "2026-01-05 03:59:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16313", "5492", "acción creada", "2026-01-05 04:29:55", "2026-01-05 04:29:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16314", "5492", "acción empezada vía WP Cron", "2026-01-05 04:49:51", "2026-01-05 04:49:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16315", "5492", "acción completa vía WP Cron", "2026-01-05 04:49:51", "2026-01-05 04:49:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16316", "5491", "acción empezada vía WP Cron", "2026-01-05 05:00:06", "2026-01-05 05:00:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16317", "5493", "acción creada", "2026-01-05 05:00:06", "2026-01-05 05:00:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16318", "5491", "acción completa vía WP Cron", "2026-01-05 05:00:06", "2026-01-05 05:00:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16319", "5480", "acción empezada vía WP Cron", "2026-01-05 05:47:39", "2026-01-05 05:47:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16320", "5480", "acción completa vía WP Cron", "2026-01-05 05:47:39", "2026-01-05 05:47:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16321", "5494", "acción creada", "2026-01-05 05:47:39", "2026-01-05 05:47:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16322", "5493", "acción empezada vía WP Cron", "2026-01-05 06:00:43", "2026-01-05 06:00:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16323", "5495", "acción creada", "2026-01-05 06:00:43", "2026-01-05 06:00:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16324", "5493", "acción completa vía WP Cron", "2026-01-05 06:00:43", "2026-01-05 06:00:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16325", "5495", "acción empezada vía WP Cron", "2026-01-05 07:01:05", "2026-01-05 07:01:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16326", "5496", "acción creada", "2026-01-05 07:01:05", "2026-01-05 07:01:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16327", "5495", "acción completa vía WP Cron", "2026-01-05 07:01:05", "2026-01-05 07:01:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16328", "5496", "acción empezada vía WP Cron", "2026-01-05 08:01:31", "2026-01-05 08:01:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16329", "5497", "acción creada", "2026-01-05 08:01:31", "2026-01-05 08:01:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16330", "5496", "acción completa vía WP Cron", "2026-01-05 08:01:31", "2026-01-05 08:01:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16331", "5497", "acción empezada vía WP Cron", "2026-01-05 09:12:14", "2026-01-05 09:12:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16332", "5498", "acción creada", "2026-01-05 09:12:14", "2026-01-05 09:12:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16333", "5497", "acción completa vía WP Cron", "2026-01-05 09:12:14", "2026-01-05 09:12:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16334", "5463", "acción empezada vía WP Cron", "2026-01-05 09:53:51", "2026-01-05 09:53:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16335", "5463", "acción completa vía WP Cron", "2026-01-05 09:53:52", "2026-01-05 09:53:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16336", "5499", "acción creada", "2026-01-05 09:53:52", "2026-01-05 09:53:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16337", "5464", "acción empezada vía WP Cron", "2026-01-05 09:53:52", "2026-01-05 09:53:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16338", "5464", "acción completa vía WP Cron", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16339", "5500", "acción creada", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16340", "5465", "acción empezada vía WP Cron", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16341", "5465", "acción completa vía WP Cron", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16342", "5501", "acción creada", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16343", "5466", "acción empezada vía WP Cron", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16344", "5466", "acción completa vía WP Cron", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16345", "5502", "acción creada", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16346", "5469", "acción empezada vía WP Cron", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16349", "5504", "acción creada", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16350", "5469", "acción completa vía WP Cron", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16351", "5505", "acción creada", "2026-01-05 09:53:53", "2026-01-05 09:53:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16352", "5504", "acción empezada vía WP Cron", "2026-01-05 10:01:53", "2026-01-05 10:01:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16353", "5504", "acción completa vía WP Cron", "2026-01-05 10:01:53", "2026-01-05 10:01:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16354", "5498", "acción empezada vía WP Cron", "2026-01-05 10:14:25", "2026-01-05 10:14:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16355", "5506", "acción creada", "2026-01-05 10:14:25", "2026-01-05 10:14:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16356", "5498", "acción completa vía WP Cron", "2026-01-05 10:14:25", "2026-01-05 10:14:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16357", "5506", "acción empezada vía WP Cron", "2026-01-05 11:19:08", "2026-01-05 11:19:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16358", "5507", "acción creada", "2026-01-05 11:19:08", "2026-01-05 11:19:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16359", "5506", "acción completa vía WP Cron", "2026-01-05 11:19:08", "2026-01-05 11:19:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16360", "5507", "acción empezada vía WP Cron", "2026-01-05 12:23:06", "2026-01-05 12:23:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16361", "5508", "acción creada", "2026-01-05 12:23:06", "2026-01-05 12:23:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16362", "5507", "acción completa vía WP Cron", "2026-01-05 12:23:06", "2026-01-05 12:23:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16363", "5508", "acción empezada vía WP Cron", "2026-01-05 13:28:14", "2026-01-05 13:28:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16364", "5509", "acción creada", "2026-01-05 13:28:14", "2026-01-05 13:28:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16365", "5508", "acción completa vía WP Cron", "2026-01-05 13:28:14", "2026-01-05 13:28:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16366", "5509", "acción empezada vía WP Cron", "2026-01-05 14:35:28", "2026-01-05 14:35:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16367", "5510", "acción creada", "2026-01-05 14:35:28", "2026-01-05 14:35:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16368", "5509", "acción completa vía WP Cron", "2026-01-05 14:35:28", "2026-01-05 14:35:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16369", "5510", "acción empezada vía WP Cron", "2026-01-05 15:36:45", "2026-01-05 15:36:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16370", "5511", "acción creada", "2026-01-05 15:36:45", "2026-01-05 15:36:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16371", "5510", "acción completa vía WP Cron", "2026-01-05 15:36:45", "2026-01-05 15:36:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16372", "5512", "acción creada", "2026-01-05 16:09:46", "2026-01-05 16:09:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16373", "5512", "acción empezada vía WP Cron", "2026-01-05 16:09:51", "2026-01-05 16:09:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16374", "5512", "acción completa vía WP Cron", "2026-01-05 16:09:51", "2026-01-05 16:09:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16375", "5511", "acción empezada vía WP Cron", "2026-01-05 16:38:09", "2026-01-05 16:38:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16376", "5513", "acción creada", "2026-01-05 16:38:09", "2026-01-05 16:38:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16377", "5511", "acción completa vía WP Cron", "2026-01-05 16:38:09", "2026-01-05 16:38:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16378", "5478", "acción empezada vía WP Cron", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16379", "5478", "acción completa vía WP Cron", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16380", "5514", "acción creada", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16381", "5479", "acción empezada vía WP Cron", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16382", "5479", "acción completa vía WP Cron", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16383", "5515", "acción creada", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16384", "5513", "acción empezada vía WP Cron", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16385", "5516", "acción creada", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16386", "5513", "acción completa vía WP Cron", "2026-01-05 17:39:34", "2026-01-05 17:39:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16387", "5494", "acción empezada vía WP Cron", "2026-01-05 17:56:33", "2026-01-05 17:56:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16388", "5494", "acción completa vía WP Cron", "2026-01-05 17:56:33", "2026-01-05 17:56:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16389", "5517", "acción creada", "2026-01-05 17:56:33", "2026-01-05 17:56:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16390", "5516", "acción empezada vía WP Cron", "2026-01-05 18:40:49", "2026-01-05 18:40:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16391", "5518", "acción creada", "2026-01-05 18:40:49", "2026-01-05 18:40:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16392", "5516", "acción completa vía WP Cron", "2026-01-05 18:40:49", "2026-01-05 18:40:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16393", "5518", "acción empezada vía WP Cron", "2026-01-05 19:42:15", "2026-01-05 19:42:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16394", "5519", "acción creada", "2026-01-05 19:42:15", "2026-01-05 19:42:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16395", "5518", "acción completa vía WP Cron", "2026-01-05 19:42:15", "2026-01-05 19:42:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16396", "5519", "acción empezada vía WP Cron", "2026-01-05 20:44:19", "2026-01-05 20:44:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16397", "5520", "acción creada", "2026-01-05 20:44:19", "2026-01-05 20:44:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16398", "5519", "acción completa vía WP Cron", "2026-01-05 20:44:19", "2026-01-05 20:44:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16399", "5520", "acción empezada vía WP Cron", "2026-01-05 21:46:47", "2026-01-05 21:46:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16400", "5521", "acción creada", "2026-01-05 21:46:47", "2026-01-05 21:46:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16401", "5520", "acción completa vía WP Cron", "2026-01-05 21:46:47", "2026-01-05 21:46:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16402", "5521", "acción empezada vía WP Cron", "2026-01-05 22:48:32", "2026-01-05 22:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16403", "5522", "acción creada", "2026-01-05 22:48:32", "2026-01-05 22:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16404", "5521", "acción completa vía WP Cron", "2026-01-05 22:48:32", "2026-01-05 22:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16405", "5522", "acción empezada vía WP Cron", "2026-01-05 23:50:25", "2026-01-05 23:50:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16406", "5523", "acción creada", "2026-01-05 23:50:25", "2026-01-05 23:50:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16407", "5522", "acción completa vía WP Cron", "2026-01-05 23:50:25", "2026-01-05 23:50:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16408", "5523", "acción empezada vía WP Cron", "2026-01-06 00:50:41", "2026-01-06 00:50:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16409", "5524", "acción creada", "2026-01-06 00:50:41", "2026-01-06 00:50:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16410", "5523", "acción completa vía WP Cron", "2026-01-06 00:50:41", "2026-01-06 00:50:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16411", "5524", "acción empezada vía WP Cron", "2026-01-06 01:54:06", "2026-01-06 01:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16412", "5525", "acción creada", "2026-01-06 01:54:06", "2026-01-06 01:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16413", "5524", "acción completa vía WP Cron", "2026-01-06 01:54:06", "2026-01-06 01:54:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16414", "5525", "acción empezada vía WP Cron", "2026-01-06 02:54:12", "2026-01-06 02:54:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16415", "5526", "acción creada", "2026-01-06 02:54:12", "2026-01-06 02:54:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16416", "5525", "acción completa vía WP Cron", "2026-01-06 02:54:12", "2026-01-06 02:54:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16417", "5526", "acción empezada vía WP Cron", "2026-01-06 03:56:16", "2026-01-06 03:56:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16418", "5527", "acción creada", "2026-01-06 03:56:16", "2026-01-06 03:56:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16419", "5526", "acción completa vía WP Cron", "2026-01-06 03:56:16", "2026-01-06 03:56:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16420", "5528", "acción creada", "2026-01-06 04:10:17", "2026-01-06 04:10:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16421", "5528", "acción empezada vía WP Cron", "2026-01-06 04:11:18", "2026-01-06 04:11:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16422", "5528", "acción completa vía WP Cron", "2026-01-06 04:11:18", "2026-01-06 04:11:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16423", "5527", "acción empezada vía WP Cron", "2026-01-06 04:57:58", "2026-01-06 04:57:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16424", "5529", "acción creada", "2026-01-06 04:57:58", "2026-01-06 04:57:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16425", "5527", "acción completa vía WP Cron", "2026-01-06 04:57:58", "2026-01-06 04:57:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16426", "5517", "acción empezada vía WP Cron", "2026-01-06 06:19:44", "2026-01-06 06:19:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16427", "5517", "acción completa vía WP Cron", "2026-01-06 06:19:44", "2026-01-06 06:19:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16428", "5530", "acción creada", "2026-01-06 06:19:44", "2026-01-06 06:19:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16429", "5529", "acción empezada vía WP Cron", "2026-01-06 06:19:44", "2026-01-06 06:19:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16430", "5531", "acción creada", "2026-01-06 06:19:44", "2026-01-06 06:19:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16431", "5529", "acción completa vía WP Cron", "2026-01-06 06:19:44", "2026-01-06 06:19:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16432", "5531", "acción empezada vía WP Cron", "2026-01-06 07:37:51", "2026-01-06 07:37:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16433", "5532", "acción creada", "2026-01-06 07:37:51", "2026-01-06 07:37:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16434", "5531", "acción completa vía WP Cron", "2026-01-06 07:37:51", "2026-01-06 07:37:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16435", "5532", "acción empezada vía WP Cron", "2026-01-06 08:48:39", "2026-01-06 08:48:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16436", "5533", "acción creada", "2026-01-06 08:48:39", "2026-01-06 08:48:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16437", "5532", "acción completa vía WP Cron", "2026-01-06 08:48:39", "2026-01-06 08:48:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16438", "5533", "acción empezada vía WP Cron", "2026-01-06 09:49:43", "2026-01-06 09:49:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16439", "5534", "acción creada", "2026-01-06 09:49:43", "2026-01-06 09:49:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16440", "5533", "acción completa vía WP Cron", "2026-01-06 09:49:43", "2026-01-06 09:49:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16441", "5499", "acción empezada vía WP Cron", "2026-01-06 09:55:33", "2026-01-06 09:55:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16442", "5499", "acción completa vía WP Cron", "2026-01-06 09:55:34", "2026-01-06 09:55:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16443", "5535", "acción creada", "2026-01-06 09:55:34", "2026-01-06 09:55:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16444", "5500", "acción empezada vía WP Cron", "2026-01-06 09:55:34", "2026-01-06 09:55:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16445", "5500", "acción completa vía WP Cron", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16446", "5536", "acción creada", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16447", "5501", "acción empezada vía WP Cron", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16448", "5501", "acción completa vía WP Cron", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16449", "5537", "acción creada", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16450", "5502", "acción empezada vía WP Cron", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16451", "5502", "acción completa vía WP Cron", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16452", "5538", "acción creada", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16453", "5505", "acción empezada vía WP Cron", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16456", "5540", "acción creada", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16457", "5505", "acción completa vía WP Cron", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16458", "5541", "acción creada", "2026-01-06 09:55:35", "2026-01-06 09:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16459", "5540", "acción empezada vía WP Cron", "2026-01-06 09:56:10", "2026-01-06 09:56:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16460", "5540", "acción completa vía WP Cron", "2026-01-06 09:56:10", "2026-01-06 09:56:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16461", "5534", "acción empezada vía WP Cron", "2026-01-06 10:59:25", "2026-01-06 10:59:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16462", "5542", "acción creada", "2026-01-06 10:59:25", "2026-01-06 10:59:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16463", "5534", "acción completa vía WP Cron", "2026-01-06 10:59:25", "2026-01-06 10:59:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16464", "5542", "acción empezada vía WP Cron", "2026-01-06 12:20:47", "2026-01-06 12:20:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16465", "5543", "acción creada", "2026-01-06 12:20:47", "2026-01-06 12:20:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16466", "5542", "acción completa vía WP Cron", "2026-01-06 12:20:47", "2026-01-06 12:20:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16467", "5543", "acción empezada vía WP Cron", "2026-01-06 13:26:51", "2026-01-06 13:26:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16468", "5544", "acción creada", "2026-01-06 13:26:51", "2026-01-06 13:26:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16469", "5543", "acción completa vía WP Cron", "2026-01-06 13:26:51", "2026-01-06 13:26:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16470", "5544", "acción empezada vía WP Cron", "2026-01-06 14:28:35", "2026-01-06 14:28:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16471", "5545", "acción creada", "2026-01-06 14:28:35", "2026-01-06 14:28:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16472", "5544", "acción completa vía WP Cron", "2026-01-06 14:28:35", "2026-01-06 14:28:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16473", "5545", "acción empezada vía WP Cron", "2026-01-06 15:30:21", "2026-01-06 15:30:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16474", "5546", "acción creada", "2026-01-06 15:30:21", "2026-01-06 15:30:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16475", "5545", "acción completa vía WP Cron", "2026-01-06 15:30:21", "2026-01-06 15:30:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16476", "5547", "acción creada", "2026-01-06 16:15:01", "2026-01-06 16:15:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16477", "5547", "acción empezada vía WP Cron", "2026-01-06 16:21:16", "2026-01-06 16:21:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16478", "5547", "acción completa vía WP Cron", "2026-01-06 16:21:16", "2026-01-06 16:21:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16479", "5546", "acción empezada vía WP Cron", "2026-01-06 16:31:58", "2026-01-06 16:31:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16480", "5548", "acción creada", "2026-01-06 16:31:58", "2026-01-06 16:31:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16481", "5546", "acción completa vía WP Cron", "2026-01-06 16:31:58", "2026-01-06 16:31:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16482", "5548", "acción empezada vía WP Cron", "2026-01-06 17:33:42", "2026-01-06 17:33:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16483", "5549", "acción creada", "2026-01-06 17:33:42", "2026-01-06 17:33:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16484", "5548", "acción completa vía WP Cron", "2026-01-06 17:33:42", "2026-01-06 17:33:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16485", "5514", "acción empezada vía WP Cron", "2026-01-06 17:45:34", "2026-01-06 17:45:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16486", "5514", "acción completa vía WP Cron", "2026-01-06 17:45:34", "2026-01-06 17:45:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16487", "5550", "acción creada", "2026-01-06 17:45:34", "2026-01-06 17:45:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16488", "5515", "acción empezada vía WP Cron", "2026-01-06 17:45:34", "2026-01-06 17:45:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16489", "5515", "acción completa vía WP Cron", "2026-01-06 17:45:34", "2026-01-06 17:45:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16490", "5551", "acción creada", "2026-01-06 17:45:34", "2026-01-06 17:45:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16491", "5530", "acción empezada vía WP Cron", "2026-01-06 18:35:38", "2026-01-06 18:35:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16492", "5530", "acción completa vía WP Cron", "2026-01-06 18:35:38", "2026-01-06 18:35:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16493", "5552", "acción creada", "2026-01-06 18:35:38", "2026-01-06 18:35:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16494", "5549", "acción empezada vía WP Cron", "2026-01-06 18:35:38", "2026-01-06 18:35:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16495", "5553", "acción creada", "2026-01-06 18:35:38", "2026-01-06 18:35:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16496", "5549", "acción completa vía WP Cron", "2026-01-06 18:35:38", "2026-01-06 18:35:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16497", "5553", "acción empezada vía WP Cron", "2026-01-06 19:36:59", "2026-01-06 19:36:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16498", "5554", "acción creada", "2026-01-06 19:36:59", "2026-01-06 19:36:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16499", "5553", "acción completa vía WP Cron", "2026-01-06 19:36:59", "2026-01-06 19:36:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16500", "5554", "acción empezada vía WP Cron", "2026-01-06 20:38:24", "2026-01-06 20:38:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16501", "5555", "acción creada", "2026-01-06 20:38:24", "2026-01-06 20:38:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16502", "5554", "acción completa vía WP Cron", "2026-01-06 20:38:24", "2026-01-06 20:38:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16503", "5555", "acción empezada vía WP Cron", "2026-01-06 21:39:54", "2026-01-06 21:39:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16504", "5556", "acción creada", "2026-01-06 21:39:54", "2026-01-06 21:39:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16505", "5555", "acción completa vía WP Cron", "2026-01-06 21:39:54", "2026-01-06 21:39:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16506", "5556", "acción empezada vía WP Cron", "2026-01-06 22:40:53", "2026-01-06 22:40:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16507", "5557", "acción creada", "2026-01-06 22:40:53", "2026-01-06 22:40:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16508", "5556", "acción completa vía WP Cron", "2026-01-06 22:40:53", "2026-01-06 22:40:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16509", "5557", "acción empezada vía WP Cron", "2026-01-06 23:42:07", "2026-01-06 23:42:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16510", "5558", "acción creada", "2026-01-06 23:42:07", "2026-01-06 23:42:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16511", "5557", "acción completa vía WP Cron", "2026-01-06 23:42:07", "2026-01-06 23:42:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16512", "5558", "acción empezada vía WP Cron", "2026-01-07 00:44:02", "2026-01-07 00:44:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16513", "5559", "acción creada", "2026-01-07 00:44:02", "2026-01-07 00:44:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16514", "5558", "acción completa vía WP Cron", "2026-01-07 00:44:02", "2026-01-07 00:44:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16515", "5559", "acción empezada vía WP Cron", "2026-01-07 01:45:53", "2026-01-07 01:45:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16516", "5560", "acción creada", "2026-01-07 01:45:53", "2026-01-07 01:45:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16517", "5559", "acción completa vía WP Cron", "2026-01-07 01:45:53", "2026-01-07 01:45:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16518", "5560", "acción empezada vía WP Cron", "2026-01-07 02:48:16", "2026-01-07 02:48:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16519", "5561", "acción creada", "2026-01-07 02:48:16", "2026-01-07 02:48:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16520", "5560", "acción completa vía WP Cron", "2026-01-07 02:48:16", "2026-01-07 02:48:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16521", "5561", "acción empezada vía WP Cron", "2026-01-07 03:50:39", "2026-01-07 03:50:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16522", "5562", "acción creada", "2026-01-07 03:50:39", "2026-01-07 03:50:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16523", "5561", "acción completa vía WP Cron", "2026-01-07 03:50:39", "2026-01-07 03:50:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16524", "5563", "acción creada", "2026-01-07 04:21:19", "2026-01-07 04:21:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16525", "5563", "acción empezada vía WP Cron", "2026-01-07 04:51:55", "2026-01-07 04:51:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16526", "5563", "acción completa vía WP Cron", "2026-01-07 04:51:55", "2026-01-07 04:51:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16527", "5562", "acción empezada vía WP Cron", "2026-01-07 04:51:55", "2026-01-07 04:51:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16528", "5564", "acción creada", "2026-01-07 04:51:55", "2026-01-07 04:51:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16529", "5562", "acción completa vía WP Cron", "2026-01-07 04:51:55", "2026-01-07 04:51:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16530", "5564", "acción empezada vía WP Cron", "2026-01-07 05:53:19", "2026-01-07 05:53:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16531", "5565", "acción creada", "2026-01-07 05:53:19", "2026-01-07 05:53:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16532", "5564", "acción completa vía WP Cron", "2026-01-07 05:53:19", "2026-01-07 05:53:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16533", "5552", "acción empezada vía WP Cron", "2026-01-07 06:55:09", "2026-01-07 06:55:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16534", "5552", "acción completa vía WP Cron", "2026-01-07 06:55:09", "2026-01-07 06:55:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16535", "5566", "acción creada", "2026-01-07 06:55:09", "2026-01-07 06:55:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16536", "5565", "acción empezada vía WP Cron", "2026-01-07 06:55:09", "2026-01-07 06:55:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16537", "5567", "acción creada", "2026-01-07 06:55:09", "2026-01-07 06:55:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16538", "5565", "acción completa vía WP Cron", "2026-01-07 06:55:09", "2026-01-07 06:55:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16539", "5567", "acción empezada vía WP Cron", "2026-01-07 07:56:36", "2026-01-07 07:56:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16540", "5568", "acción creada", "2026-01-07 07:56:36", "2026-01-07 07:56:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16541", "5567", "acción completa vía WP Cron", "2026-01-07 07:56:36", "2026-01-07 07:56:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16542", "5568", "acción empezada vía WP Cron", "2026-01-07 08:58:05", "2026-01-07 08:58:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16543", "5569", "acción creada", "2026-01-07 08:58:05", "2026-01-07 08:58:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16544", "5568", "acción completa vía WP Cron", "2026-01-07 08:58:05", "2026-01-07 08:58:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16545", "5535", "acción empezada vía WP Cron", "2026-01-07 09:56:22", "2026-01-07 09:56:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16546", "5535", "acción completa vía WP Cron", "2026-01-07 09:56:23", "2026-01-07 09:56:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16547", "5570", "acción creada", "2026-01-07 09:56:23", "2026-01-07 09:56:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16548", "5536", "acción empezada vía WP Cron", "2026-01-07 09:56:23", "2026-01-07 09:56:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16549", "5536", "acción completa vía WP Cron", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16550", "5571", "acción creada", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16551", "5537", "acción empezada vía WP Cron", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16552", "5537", "acción completa vía WP Cron", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16553", "5572", "acción creada", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16554", "5538", "acción empezada vía WP Cron", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16555", "5538", "acción completa vía WP Cron", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16556", "5573", "acción creada", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16557", "5541", "acción empezada vía WP Cron", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16559", "5574", "acción creada", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16560", "5575", "acción creada", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16561", "5541", "acción completa vía WP Cron", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16562", "5576", "acción creada", "2026-01-07 09:56:24", "2026-01-07 09:56:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16563", "5575", "acción empezada vía WP Cron", "2026-01-07 10:00:35", "2026-01-07 10:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16564", "5575", "acción completa vía WP Cron", "2026-01-07 10:00:35", "2026-01-07 10:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16565", "5569", "acción empezada vía WP Cron", "2026-01-07 10:00:35", "2026-01-07 10:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16566", "5577", "acción creada", "2026-01-07 10:00:35", "2026-01-07 10:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16567", "5569", "acción completa vía WP Cron", "2026-01-07 10:00:35", "2026-01-07 10:00:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16568", "5577", "acción empezada vía WP Cron", "2026-01-07 11:02:33", "2026-01-07 11:02:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16569", "5578", "acción creada", "2026-01-07 11:02:33", "2026-01-07 11:02:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16570", "5577", "acción completa vía WP Cron", "2026-01-07 11:02:33", "2026-01-07 11:02:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16571", "5578", "acción empezada vía WP Cron", "2026-01-07 12:04:43", "2026-01-07 12:04:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16572", "5579", "acción creada", "2026-01-07 12:04:43", "2026-01-07 12:04:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16573", "5578", "acción completa vía WP Cron", "2026-01-07 12:04:43", "2026-01-07 12:04:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16574", "5579", "acción empezada vía WP Cron", "2026-01-07 13:06:30", "2026-01-07 13:06:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16575", "5580", "acción creada", "2026-01-07 13:06:30", "2026-01-07 13:06:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16576", "5579", "acción completa vía WP Cron", "2026-01-07 13:06:30", "2026-01-07 13:06:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16577", "5580", "acción empezada vía WP Cron", "2026-01-07 14:07:54", "2026-01-07 14:07:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16578", "5581", "acción creada", "2026-01-07 14:07:54", "2026-01-07 14:07:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16579", "5580", "acción completa vía WP Cron", "2026-01-07 14:07:54", "2026-01-07 14:07:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16580", "5581", "acción empezada vía WP Cron", "2026-01-07 15:09:24", "2026-01-07 15:09:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16581", "5582", "acción creada", "2026-01-07 15:09:24", "2026-01-07 15:09:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16582", "5581", "acción completa vía WP Cron", "2026-01-07 15:09:24", "2026-01-07 15:09:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16583", "5582", "acción empezada vía WP Cron", "2026-01-07 16:12:04", "2026-01-07 16:12:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16584", "5583", "acción creada", "2026-01-07 16:12:04", "2026-01-07 16:12:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16585", "5582", "acción completa vía WP Cron", "2026-01-07 16:12:04", "2026-01-07 16:12:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16586", "5584", "acción creada", "2026-01-07 16:12:04", "2026-01-07 16:12:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16587", "5584", "acción empezada vía WP Cron", "2026-01-07 16:42:51", "2026-01-07 16:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16588", "5584", "acción completa vía WP Cron", "2026-01-07 16:42:51", "2026-01-07 16:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16589", "5583", "acción empezada vía WP Cron", "2026-01-07 17:20:04", "2026-01-07 17:20:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16590", "5585", "acción creada", "2026-01-07 17:20:04", "2026-01-07 17:20:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16591", "5583", "acción completa vía WP Cron", "2026-01-07 17:20:04", "2026-01-07 17:20:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16592", "5550", "acción empezada vía WP Cron", "2026-01-07 17:53:26", "2026-01-07 17:53:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16593", "5550", "acción completa vía WP Cron", "2026-01-07 17:53:26", "2026-01-07 17:53:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16594", "5586", "acción creada", "2026-01-07 17:53:26", "2026-01-07 17:53:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16595", "5551", "acción empezada vía WP Cron", "2026-01-07 17:53:26", "2026-01-07 17:53:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16596", "5551", "acción completa vía WP Cron", "2026-01-07 17:53:26", "2026-01-07 17:53:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16597", "5587", "acción creada", "2026-01-07 17:53:26", "2026-01-07 17:53:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16598", "5585", "acción empezada vía WP Cron", "2026-01-07 18:28:04", "2026-01-07 18:28:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16599", "5588", "acción creada", "2026-01-07 18:28:04", "2026-01-07 18:28:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16600", "5585", "acción completa vía WP Cron", "2026-01-07 18:28:04", "2026-01-07 18:28:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16601", "5566", "acción empezada vía WP Cron", "2026-01-07 19:16:13", "2026-01-07 19:16:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16602", "5566", "acción completa vía WP Cron", "2026-01-07 19:16:13", "2026-01-07 19:16:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16603", "5589", "acción creada", "2026-01-07 19:16:13", "2026-01-07 19:16:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16604", "5588", "acción empezada vía WP Cron", "2026-01-07 19:44:35", "2026-01-07 19:44:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16605", "5590", "acción creada", "2026-01-07 19:44:35", "2026-01-07 19:44:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16606", "5588", "acción completa vía WP Cron", "2026-01-07 19:44:35", "2026-01-07 19:44:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16607", "5590", "acción empezada vía WP Cron", "2026-01-07 20:48:02", "2026-01-07 20:48:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16608", "5591", "acción creada", "2026-01-07 20:48:02", "2026-01-07 20:48:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16609", "5590", "acción completa vía WP Cron", "2026-01-07 20:48:02", "2026-01-07 20:48:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16610", "5591", "acción empezada vía WP Cron", "2026-01-07 21:48:46", "2026-01-07 21:48:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16611", "5592", "acción creada", "2026-01-07 21:48:46", "2026-01-07 21:48:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16612", "5591", "acción completa vía WP Cron", "2026-01-07 21:48:46", "2026-01-07 21:48:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16613", "5592", "acción empezada vía WP Cron", "2026-01-07 22:49:13", "2026-01-07 22:49:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16614", "5593", "acción creada", "2026-01-07 22:49:13", "2026-01-07 22:49:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16615", "5592", "acción completa vía WP Cron", "2026-01-07 22:49:13", "2026-01-07 22:49:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16616", "5593", "acción empezada vía WP Cron", "2026-01-07 23:50:40", "2026-01-07 23:50:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16617", "5594", "acción creada", "2026-01-07 23:50:40", "2026-01-07 23:50:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16618", "5593", "acción completa vía WP Cron", "2026-01-07 23:50:40", "2026-01-07 23:50:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16619", "5594", "acción empezada vía WP Cron", "2026-01-08 00:51:21", "2026-01-08 00:51:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16620", "5595", "acción creada", "2026-01-08 00:51:21", "2026-01-08 00:51:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16621", "5594", "acción completa vía WP Cron", "2026-01-08 00:51:21", "2026-01-08 00:51:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16622", "5595", "acción empezada vía WP Cron", "2026-01-08 01:52:38", "2026-01-08 01:52:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16623", "5596", "acción creada", "2026-01-08 01:52:38", "2026-01-08 01:52:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16624", "5595", "acción completa vía WP Cron", "2026-01-08 01:52:38", "2026-01-08 01:52:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16625", "5596", "acción empezada vía WP Cron", "2026-01-08 02:53:33", "2026-01-08 02:53:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16626", "5597", "acción creada", "2026-01-08 02:53:33", "2026-01-08 02:53:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16627", "5596", "acción completa vía WP Cron", "2026-01-08 02:53:33", "2026-01-08 02:53:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16628", "5597", "acción empezada vía WP Cron", "2026-01-08 03:54:14", "2026-01-08 03:54:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16629", "5598", "acción creada", "2026-01-08 03:54:14", "2026-01-08 03:54:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16630", "5597", "acción completa vía WP Cron", "2026-01-08 03:54:14", "2026-01-08 03:54:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16631", "5599", "acción creada", "2026-01-08 04:24:40", "2026-01-08 04:24:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16632", "5599", "acción empezada vía WP Cron", "2026-01-08 04:35:52", "2026-01-08 04:35:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16633", "5599", "acción completa vía WP Cron", "2026-01-08 04:35:52", "2026-01-08 04:35:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16634", "5598", "acción empezada vía WP Cron", "2026-01-08 04:55:10", "2026-01-08 04:55:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16635", "5600", "acción creada", "2026-01-08 04:55:10", "2026-01-08 04:55:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16636", "5598", "acción completa vía WP Cron", "2026-01-08 04:55:10", "2026-01-08 04:55:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16637", "5600", "acción empezada vía WP Cron", "2026-01-08 05:56:29", "2026-01-08 05:56:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16638", "5601", "acción creada", "2026-01-08 05:56:29", "2026-01-08 05:56:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16639", "5600", "acción completa vía WP Cron", "2026-01-08 05:56:29", "2026-01-08 05:56:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16640", "5601", "acción empezada vía WP Cron", "2026-01-08 06:57:50", "2026-01-08 06:57:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16641", "5602", "acción creada", "2026-01-08 06:57:50", "2026-01-08 06:57:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16642", "5601", "acción completa vía WP Cron", "2026-01-08 06:57:50", "2026-01-08 06:57:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16643", "5589", "acción empezada vía WP Cron", "2026-01-08 07:28:48", "2026-01-08 07:28:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16644", "5589", "acción completa vía WP Cron", "2026-01-08 07:28:49", "2026-01-08 07:28:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16645", "5603", "acción creada", "2026-01-08 07:28:49", "2026-01-08 07:28:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16646", "5602", "acción empezada vía WP Cron", "2026-01-08 07:59:30", "2026-01-08 07:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16647", "5604", "acción creada", "2026-01-08 07:59:30", "2026-01-08 07:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16648", "5602", "acción completa vía WP Cron", "2026-01-08 07:59:30", "2026-01-08 07:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16649", "5604", "acción empezada vía WP Cron", "2026-01-08 09:01:13", "2026-01-08 09:01:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16650", "5605", "acción creada", "2026-01-08 09:01:13", "2026-01-08 09:01:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16651", "5604", "acción completa vía WP Cron", "2026-01-08 09:01:13", "2026-01-08 09:01:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16652", "5570", "acción empezada vía WP Cron", "2026-01-08 10:03:05", "2026-01-08 10:03:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16653", "5570", "acción completa vía WP Cron", "2026-01-08 10:03:06", "2026-01-08 10:03:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16654", "5606", "acción creada", "2026-01-08 10:03:06", "2026-01-08 10:03:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16655", "5571", "acción empezada vía WP Cron", "2026-01-08 10:03:06", "2026-01-08 10:03:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16656", "5571", "acción completa vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16657", "5607", "acción creada", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16658", "5572", "acción empezada vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16659", "5572", "acción completa vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16660", "5608", "acción creada", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16661", "5573", "acción empezada vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16662", "5573", "acción completa vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16663", "5609", "acción creada", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16664", "5574", "acción empezada vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16665", "5574", "acción completa vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16667", "5605", "acción empezada vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16668", "5611", "acción creada", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16669", "5605", "acción completa vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16670", "5576", "acción empezada vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16672", "5612", "acción creada", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16673", "5613", "acción creada", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16674", "5576", "acción completa vía WP Cron", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16675", "5614", "acción creada", "2026-01-08 10:03:07", "2026-01-08 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16676", "5613", "acción empezada vía WP Cron", "2026-01-08 10:08:12", "2026-01-08 10:08:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16677", "5613", "acción completa vía WP Cron", "2026-01-08 10:08:12", "2026-01-08 10:08:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16678", "5611", "acción empezada vía WP Cron", "2026-01-08 11:04:22", "2026-01-08 11:04:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16679", "5615", "acción creada", "2026-01-08 11:04:22", "2026-01-08 11:04:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16680", "5611", "acción completa vía WP Cron", "2026-01-08 11:04:22", "2026-01-08 11:04:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16681", "5615", "acción empezada vía WP Cron", "2026-01-08 12:05:51", "2026-01-08 12:05:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16682", "5616", "acción creada", "2026-01-08 12:05:51", "2026-01-08 12:05:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16683", "5615", "acción completa vía WP Cron", "2026-01-08 12:05:51", "2026-01-08 12:05:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16684", "5616", "acción empezada vía WP Cron", "2026-01-08 13:07:14", "2026-01-08 13:07:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16685", "5617", "acción creada", "2026-01-08 13:07:14", "2026-01-08 13:07:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16686", "5616", "acción completa vía WP Cron", "2026-01-08 13:07:14", "2026-01-08 13:07:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16687", "5617", "acción empezada vía WP Cron", "2026-01-08 14:08:43", "2026-01-08 14:08:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16688", "5618", "acción creada", "2026-01-08 14:08:43", "2026-01-08 14:08:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16689", "5617", "acción completa vía WP Cron", "2026-01-08 14:08:43", "2026-01-08 14:08:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16690", "5618", "acción empezada vía WP Cron", "2026-01-08 15:10:22", "2026-01-08 15:10:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16691", "5619", "acción creada", "2026-01-08 15:10:22", "2026-01-08 15:10:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16692", "5618", "acción completa vía WP Cron", "2026-01-08 15:10:22", "2026-01-08 15:10:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16693", "5620", "acción creada", "2026-01-08 16:10:07", "2026-01-08 16:10:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16694", "5620", "acción empezada vía WP Cron", "2026-01-08 16:11:17", "2026-01-08 16:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16695", "5620", "acción completa vía WP Cron", "2026-01-08 16:11:17", "2026-01-08 16:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16696", "5619", "acción empezada vía WP Cron", "2026-01-08 16:11:17", "2026-01-08 16:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16697", "5621", "acción creada", "2026-01-08 16:11:17", "2026-01-08 16:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16698", "5619", "acción completa vía WP Cron", "2026-01-08 16:11:17", "2026-01-08 16:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16699", "5621", "acción empezada vía WP Cron", "2026-01-08 17:14:34", "2026-01-08 17:14:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16700", "5622", "acción creada", "2026-01-08 17:14:34", "2026-01-08 17:14:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16701", "5621", "acción completa vía WP Cron", "2026-01-08 17:14:34", "2026-01-08 17:14:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16702", "5586", "acción empezada vía WP Cron", "2026-01-08 18:02:05", "2026-01-08 18:02:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16703", "5586", "acción completa vía WP Cron", "2026-01-08 18:02:05", "2026-01-08 18:02:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16704", "5623", "acción creada", "2026-01-08 18:02:05", "2026-01-08 18:02:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16705", "5587", "acción empezada vía WP Cron", "2026-01-08 18:02:05", "2026-01-08 18:02:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16706", "5587", "acción completa vía WP Cron", "2026-01-08 18:02:06", "2026-01-08 18:02:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16707", "5624", "acción creada", "2026-01-08 18:02:06", "2026-01-08 18:02:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16708", "5622", "acción empezada vía WP Cron", "2026-01-08 18:15:58", "2026-01-08 18:15:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16709", "5625", "acción creada", "2026-01-08 18:15:58", "2026-01-08 18:15:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16710", "5622", "acción completa vía WP Cron", "2026-01-08 18:15:58", "2026-01-08 18:15:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16711", "5625", "acción empezada vía WP Cron", "2026-01-08 19:16:37", "2026-01-08 19:16:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16712", "5626", "acción creada", "2026-01-08 19:16:37", "2026-01-08 19:16:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16713", "5625", "acción completa vía WP Cron", "2026-01-08 19:16:37", "2026-01-08 19:16:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16714", "5603", "acción empezada vía WP Cron", "2026-01-08 19:48:41", "2026-01-08 19:48:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16715", "5603", "acción completa vía WP Cron", "2026-01-08 19:48:41", "2026-01-08 19:48:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16716", "5627", "acción creada", "2026-01-08 19:48:41", "2026-01-08 19:48:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16717", "5626", "acción empezada vía WP Cron", "2026-01-08 20:20:28", "2026-01-08 20:20:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16718", "5628", "acción creada", "2026-01-08 20:20:28", "2026-01-08 20:20:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16719", "5626", "acción completa vía WP Cron", "2026-01-08 20:20:28", "2026-01-08 20:20:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16720", "5628", "acción empezada vía WP Cron", "2026-01-08 21:22:25", "2026-01-08 21:22:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16721", "5629", "acción creada", "2026-01-08 21:22:25", "2026-01-08 21:22:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16722", "5628", "acción completa vía WP Cron", "2026-01-08 21:22:25", "2026-01-08 21:22:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16723", "5629", "acción empezada vía WP Cron", "2026-01-08 22:24:52", "2026-01-08 22:24:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16724", "5630", "acción creada", "2026-01-08 22:24:52", "2026-01-08 22:24:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16725", "5629", "acción completa vía WP Cron", "2026-01-08 22:24:52", "2026-01-08 22:24:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16726", "5630", "acción empezada vía WP Cron", "2026-01-08 23:26:00", "2026-01-08 23:26:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16727", "5631", "acción creada", "2026-01-08 23:26:00", "2026-01-08 23:26:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16728", "5630", "acción completa vía WP Cron", "2026-01-08 23:26:00", "2026-01-08 23:26:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16729", "5631", "acción empezada vía WP Cron", "2026-01-09 00:29:36", "2026-01-09 00:29:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16730", "5632", "acción creada", "2026-01-09 00:29:36", "2026-01-09 00:29:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16731", "5631", "acción completa vía WP Cron", "2026-01-09 00:29:36", "2026-01-09 00:29:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16732", "5632", "acción empezada vía WP Cron", "2026-01-09 01:31:10", "2026-01-09 01:31:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16733", "5633", "acción creada", "2026-01-09 01:31:10", "2026-01-09 01:31:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16734", "5632", "acción completa vía WP Cron", "2026-01-09 01:31:10", "2026-01-09 01:31:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16735", "5633", "acción empezada vía WP Cron", "2026-01-09 02:32:08", "2026-01-09 02:32:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16736", "5634", "acción creada", "2026-01-09 02:32:08", "2026-01-09 02:32:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16737", "5633", "acción completa vía WP Cron", "2026-01-09 02:32:08", "2026-01-09 02:32:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16738", "5634", "acción empezada vía WP Cron", "2026-01-09 03:33:06", "2026-01-09 03:33:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16739", "5635", "acción creada", "2026-01-09 03:33:06", "2026-01-09 03:33:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16740", "5634", "acción completa vía WP Cron", "2026-01-09 03:33:06", "2026-01-09 03:33:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16741", "5635", "acción empezada vía WP Cron", "2026-01-09 04:35:26", "2026-01-09 04:35:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16742", "5636", "acción creada", "2026-01-09 04:35:26", "2026-01-09 04:35:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16743", "5635", "acción completa vía WP Cron", "2026-01-09 04:35:26", "2026-01-09 04:35:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16744", "5637", "acción creada", "2026-01-09 04:35:26", "2026-01-09 04:35:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16745", "5637", "acción empezada vía WP Cron", "2026-01-09 04:49:32", "2026-01-09 04:49:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16746", "5637", "acción completa vía WP Cron", "2026-01-09 04:49:32", "2026-01-09 04:49:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16747", "5636", "acción empezada vía WP Cron", "2026-01-09 05:36:38", "2026-01-09 05:36:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16748", "5638", "acción creada", "2026-01-09 05:36:38", "2026-01-09 05:36:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16749", "5636", "acción completa vía WP Cron", "2026-01-09 05:36:38", "2026-01-09 05:36:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16750", "5638", "acción empezada vía WP Cron", "2026-01-09 06:36:45", "2026-01-09 06:36:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16751", "5639", "acción creada", "2026-01-09 06:36:45", "2026-01-09 06:36:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16752", "5638", "acción completa vía WP Cron", "2026-01-09 06:36:45", "2026-01-09 06:36:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16753", "5639", "acción empezada vía WP Cron", "2026-01-09 07:37:02", "2026-01-09 07:37:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16754", "5640", "acción creada", "2026-01-09 07:37:02", "2026-01-09 07:37:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16755", "5639", "acción completa vía WP Cron", "2026-01-09 07:37:02", "2026-01-09 07:37:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16756", "5627", "acción empezada vía WP Cron", "2026-01-09 08:07:18", "2026-01-09 08:07:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16757", "5627", "acción completa vía WP Cron", "2026-01-09 08:07:18", "2026-01-09 08:07:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16758", "5641", "acción creada", "2026-01-09 08:07:18", "2026-01-09 08:07:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16759", "5640", "acción empezada vía WP Cron", "2026-01-09 08:37:38", "2026-01-09 08:37:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16760", "5642", "acción creada", "2026-01-09 08:37:38", "2026-01-09 08:37:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16761", "5640", "acción completa vía WP Cron", "2026-01-09 08:37:38", "2026-01-09 08:37:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16762", "5642", "acción empezada vía WP Cron", "2026-01-09 09:38:58", "2026-01-09 09:38:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16763", "5643", "acción creada", "2026-01-09 09:38:58", "2026-01-09 09:38:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16764", "5642", "acción completa vía WP Cron", "2026-01-09 09:38:58", "2026-01-09 09:38:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16765", "5612", "acción empezada vía WP Cron", "2026-01-09 10:00:30", "2026-01-09 10:00:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16766", "5612", "acción completa vía WP Cron", "2026-01-09 10:00:30", "2026-01-09 10:00:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16768", "5606", "acción empezada vía WP Cron", "2026-01-09 10:10:01", "2026-01-09 10:10:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16769", "5606", "acción completa vía WP Cron", "2026-01-09 10:10:03", "2026-01-09 10:10:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16770", "5645", "acción creada", "2026-01-09 10:10:03", "2026-01-09 10:10:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16771", "5607", "acción empezada vía WP Cron", "2026-01-09 10:10:03", "2026-01-09 10:10:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16772", "5607", "acción completa vía WP Cron", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16773", "5646", "acción creada", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16774", "5608", "acción empezada vía WP Cron", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16775", "5608", "acción completa vía WP Cron", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16776", "5647", "acción creada", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16777", "5609", "acción empezada vía WP Cron", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16778", "5609", "acción completa vía WP Cron", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16779", "5648", "acción creada", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16780", "5614", "acción empezada vía WP Cron", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16782", "5649", "acción creada", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16783", "5650", "acción creada", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16784", "5614", "acción completa vía WP Cron", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16785", "5651", "acción creada", "2026-01-09 10:10:04", "2026-01-09 10:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16786", "5650", "acción empezada vía WP Cron", "2026-01-09 10:11:01", "2026-01-09 10:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16787", "5650", "acción completa vía WP Cron", "2026-01-09 10:11:02", "2026-01-09 10:11:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16788", "5643", "acción empezada vía WP Cron", "2026-01-09 10:41:11", "2026-01-09 10:41:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16789", "5652", "acción creada", "2026-01-09 10:41:11", "2026-01-09 10:41:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16790", "5643", "acción completa vía WP Cron", "2026-01-09 10:41:11", "2026-01-09 10:41:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16791", "5652", "acción empezada vía WP Cron", "2026-01-09 11:42:32", "2026-01-09 11:42:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16792", "5653", "acción creada", "2026-01-09 11:42:32", "2026-01-09 11:42:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16793", "5652", "acción completa vía WP Cron", "2026-01-09 11:42:32", "2026-01-09 11:42:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16794", "5653", "acción empezada vía WP Cron", "2026-01-09 12:44:08", "2026-01-09 12:44:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16795", "5654", "acción creada", "2026-01-09 12:44:08", "2026-01-09 12:44:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16796", "5653", "acción completa vía WP Cron", "2026-01-09 12:44:08", "2026-01-09 12:44:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16797", "5654", "acción empezada vía WP Cron", "2026-01-09 13:45:57", "2026-01-09 13:45:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16798", "5655", "acción creada", "2026-01-09 13:45:57", "2026-01-09 13:45:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16799", "5654", "acción completa vía WP Cron", "2026-01-09 13:45:57", "2026-01-09 13:45:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16800", "5655", "acción empezada vía WP Cron", "2026-01-09 14:47:57", "2026-01-09 14:47:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16801", "5656", "acción creada", "2026-01-09 14:47:57", "2026-01-09 14:47:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16802", "5655", "acción completa vía WP Cron", "2026-01-09 14:47:57", "2026-01-09 14:47:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16803", "5656", "acción empezada vía WP Cron", "2026-01-09 15:49:19", "2026-01-09 15:49:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16804", "5657", "acción creada", "2026-01-09 15:49:19", "2026-01-09 15:49:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16805", "5656", "acción completa vía WP Cron", "2026-01-09 15:49:19", "2026-01-09 15:49:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16806", "5658", "acción creada", "2026-01-09 16:10:56", "2026-01-09 16:10:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16807", "5658", "acción empezada vía WP Cron", "2026-01-09 16:12:33", "2026-01-09 16:12:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16808", "5658", "acción completa vía WP Cron", "2026-01-09 16:12:33", "2026-01-09 16:12:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16809", "5657", "acción empezada vía WP Cron", "2026-01-09 16:51:49", "2026-01-09 16:51:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16810", "5659", "acción creada", "2026-01-09 16:51:49", "2026-01-09 16:51:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16811", "5657", "acción completa vía WP Cron", "2026-01-09 16:51:49", "2026-01-09 16:51:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16812", "5659", "acción empezada vía WP Cron", "2026-01-09 17:53:10", "2026-01-09 17:53:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16813", "5660", "acción creada", "2026-01-09 17:53:10", "2026-01-09 17:53:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16814", "5659", "acción completa vía WP Cron", "2026-01-09 17:53:10", "2026-01-09 17:53:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16815", "5623", "acción empezada vía WP Cron", "2026-01-09 18:10:32", "2026-01-09 18:10:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16816", "5623", "acción completa vía WP Cron", "2026-01-09 18:10:32", "2026-01-09 18:10:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16817", "5661", "acción creada", "2026-01-09 18:10:32", "2026-01-09 18:10:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16818", "5624", "acción empezada vía WP Cron", "2026-01-09 18:10:32", "2026-01-09 18:10:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16819", "5624", "acción completa vía WP Cron", "2026-01-09 18:10:32", "2026-01-09 18:10:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16820", "5662", "acción creada", "2026-01-09 18:10:32", "2026-01-09 18:10:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16821", "5660", "acción empezada vía WP Cron", "2026-01-09 18:56:34", "2026-01-09 18:56:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16822", "5663", "acción creada", "2026-01-09 18:56:34", "2026-01-09 18:56:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16823", "5660", "acción completa vía WP Cron", "2026-01-09 18:56:34", "2026-01-09 18:56:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16824", "5663", "acción empezada vía WP Cron", "2026-01-09 19:58:55", "2026-01-09 19:58:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16825", "5664", "acción creada", "2026-01-09 19:58:55", "2026-01-09 19:58:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16826", "5663", "acción completa vía WP Cron", "2026-01-09 19:58:55", "2026-01-09 19:58:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16827", "5641", "acción empezada vía WP Cron", "2026-01-09 20:13:06", "2026-01-09 20:13:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16828", "5641", "acción completa vía WP Cron", "2026-01-09 20:13:06", "2026-01-09 20:13:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16829", "5665", "acción creada", "2026-01-09 20:13:06", "2026-01-09 20:13:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16830", "5664", "acción empezada vía WP Cron", "2026-01-09 21:01:16", "2026-01-09 21:01:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16831", "5666", "acción creada", "2026-01-09 21:01:16", "2026-01-09 21:01:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16832", "5664", "acción completa vía WP Cron", "2026-01-09 21:01:16", "2026-01-09 21:01:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16833", "5666", "acción empezada vía WP Cron", "2026-01-09 22:04:10", "2026-01-09 22:04:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16834", "5667", "acción creada", "2026-01-09 22:04:11", "2026-01-09 22:04:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16835", "5666", "acción completa vía WP Cron", "2026-01-09 22:04:11", "2026-01-09 22:04:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16836", "5667", "acción empezada vía WP Cron", "2026-01-09 23:06:09", "2026-01-09 23:06:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16837", "5668", "acción creada", "2026-01-09 23:06:09", "2026-01-09 23:06:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16838", "5667", "acción completa vía WP Cron", "2026-01-09 23:06:09", "2026-01-09 23:06:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16839", "5668", "acción empezada vía WP Cron", "2026-01-10 00:08:12", "2026-01-10 00:08:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16840", "5669", "acción creada", "2026-01-10 00:08:12", "2026-01-10 00:08:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16841", "5668", "acción completa vía WP Cron", "2026-01-10 00:08:12", "2026-01-10 00:08:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16842", "5669", "acción empezada vía WP Cron", "2026-01-10 01:10:39", "2026-01-10 01:10:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16843", "5670", "acción creada", "2026-01-10 01:10:39", "2026-01-10 01:10:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16844", "5669", "acción completa vía WP Cron", "2026-01-10 01:10:39", "2026-01-10 01:10:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16845", "5670", "acción empezada vía WP Cron", "2026-01-10 02:12:51", "2026-01-10 02:12:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16846", "5671", "acción creada", "2026-01-10 02:12:51", "2026-01-10 02:12:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16847", "5670", "acción completa vía WP Cron", "2026-01-10 02:12:51", "2026-01-10 02:12:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16848", "5671", "acción empezada vía WP Cron", "2026-01-10 03:14:41", "2026-01-10 03:14:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16849", "5672", "acción creada", "2026-01-10 03:14:41", "2026-01-10 03:14:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16850", "5671", "acción completa vía WP Cron", "2026-01-10 03:14:41", "2026-01-10 03:14:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16851", "5672", "acción empezada vía WP Cron", "2026-01-10 04:16:17", "2026-01-10 04:16:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16852", "5673", "acción creada", "2026-01-10 04:16:17", "2026-01-10 04:16:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16853", "5672", "acción completa vía WP Cron", "2026-01-10 04:16:17", "2026-01-10 04:16:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16854", "5674", "acción creada", "2026-01-10 04:16:17", "2026-01-10 04:16:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16855", "5674", "acción empezada vía WP Cron", "2026-01-10 04:21:47", "2026-01-10 04:21:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16856", "5674", "acción completa vía WP Cron", "2026-01-10 04:21:47", "2026-01-10 04:21:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16857", "5673", "acción empezada vía WP Cron", "2026-01-10 05:18:19", "2026-01-10 05:18:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16858", "5675", "acción creada", "2026-01-10 05:18:19", "2026-01-10 05:18:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16859", "5673", "acción completa vía WP Cron", "2026-01-10 05:18:19", "2026-01-10 05:18:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16860", "5675", "acción empezada vía WP Cron", "2026-01-10 06:20:22", "2026-01-10 06:20:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16861", "5676", "acción creada", "2026-01-10 06:20:22", "2026-01-10 06:20:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16862", "5675", "acción completa vía WP Cron", "2026-01-10 06:20:22", "2026-01-10 06:20:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16863", "5676", "acción empezada vía WP Cron", "2026-01-10 07:22:10", "2026-01-10 07:22:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16864", "5677", "acción creada", "2026-01-10 07:22:10", "2026-01-10 07:22:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16865", "5676", "acción completa vía WP Cron", "2026-01-10 07:22:10", "2026-01-10 07:22:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16866", "5665", "acción empezada vía WP Cron", "2026-01-10 08:24:03", "2026-01-10 08:24:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16867", "5665", "acción completa vía WP Cron", "2026-01-10 08:24:03", "2026-01-10 08:24:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16868", "5678", "acción creada", "2026-01-10 08:24:03", "2026-01-10 08:24:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16869", "5677", "acción empezada vía WP Cron", "2026-01-10 08:24:03", "2026-01-10 08:24:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16870", "5679", "acción creada", "2026-01-10 08:24:03", "2026-01-10 08:24:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16871", "5677", "acción completa vía WP Cron", "2026-01-10 08:24:03", "2026-01-10 08:24:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16872", "5679", "acción empezada vía WP Cron", "2026-01-10 09:25:53", "2026-01-10 09:25:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16873", "5680", "acción creada", "2026-01-10 09:25:53", "2026-01-10 09:25:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16874", "5679", "acción completa vía WP Cron", "2026-01-10 09:25:53", "2026-01-10 09:25:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16875", "5649", "acción empezada vía WP Cron", "2026-01-10 10:06:42", "2026-01-10 10:06:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16876", "5649", "acción completa vía WP Cron", "2026-01-10 10:06:42", "2026-01-10 10:06:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16878", "5645", "acción empezada vía WP Cron", "2026-01-10 10:12:51", "2026-01-10 10:12:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16879", "5645", "acción completa vía WP Cron", "2026-01-10 10:12:52", "2026-01-10 10:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16880", "5682", "acción creada", "2026-01-10 10:12:52", "2026-01-10 10:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16881", "5646", "acción empezada vía WP Cron", "2026-01-10 10:12:52", "2026-01-10 10:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16882", "5646", "acción completa vía WP Cron", "2026-01-10 10:12:53", "2026-01-10 10:12:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16883", "5683", "acción creada", "2026-01-10 10:12:53", "2026-01-10 10:12:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16884", "5647", "acción empezada vía WP Cron", "2026-01-10 10:12:53", "2026-01-10 10:12:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16885", "5647", "acción completa vía WP Cron", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16886", "5684", "acción creada", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16887", "5648", "acción empezada vía WP Cron", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16888", "5648", "acción completa vía WP Cron", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16889", "5685", "acción creada", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16890", "5651", "acción empezada vía WP Cron", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16892", "5686", "acción creada", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16893", "5687", "acción creada", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16894", "5651", "acción completa vía WP Cron", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16895", "5688", "acción creada", "2026-01-10 10:12:54", "2026-01-10 10:12:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16896", "5687", "acción empezada vía WP Cron", "2026-01-10 10:14:50", "2026-01-10 10:14:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16897", "5687", "acción completa vía WP Cron", "2026-01-10 10:14:50", "2026-01-10 10:14:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16898", "5680", "acción empezada vía WP Cron", "2026-01-10 10:28:36", "2026-01-10 10:28:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16899", "5689", "acción creada", "2026-01-10 10:28:36", "2026-01-10 10:28:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16900", "5680", "acción completa vía WP Cron", "2026-01-10 10:28:36", "2026-01-10 10:28:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16901", "5689", "acción empezada vía WP Cron", "2026-01-10 11:28:38", "2026-01-10 11:28:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16902", "5690", "acción creada", "2026-01-10 11:28:38", "2026-01-10 11:28:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16903", "5689", "acción completa vía WP Cron", "2026-01-10 11:28:38", "2026-01-10 11:28:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16904", "5690", "acción empezada vía WP Cron", "2026-01-10 12:33:05", "2026-01-10 12:33:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16905", "5691", "acción creada", "2026-01-10 12:33:05", "2026-01-10 12:33:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16906", "5690", "acción completa vía WP Cron", "2026-01-10 12:33:05", "2026-01-10 12:33:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16907", "5691", "acción empezada vía WP Cron", "2026-01-10 13:35:02", "2026-01-10 13:35:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16908", "5692", "acción creada", "2026-01-10 13:35:02", "2026-01-10 13:35:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16909", "5691", "acción completa vía WP Cron", "2026-01-10 13:35:02", "2026-01-10 13:35:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16910", "5692", "acción empezada vía WP Cron", "2026-01-10 14:37:24", "2026-01-10 14:37:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16911", "5693", "acción creada", "2026-01-10 14:37:24", "2026-01-10 14:37:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16912", "5692", "acción completa vía WP Cron", "2026-01-10 14:37:24", "2026-01-10 14:37:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16913", "5693", "acción empezada vía WP Cron", "2026-01-10 15:39:01", "2026-01-10 15:39:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16914", "5694", "acción creada", "2026-01-10 15:39:01", "2026-01-10 15:39:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16915", "5693", "acción completa vía WP Cron", "2026-01-10 15:39:01", "2026-01-10 15:39:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16916", "5695", "acción creada", "2026-01-10 16:30:56", "2026-01-10 16:30:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16917", "5695", "acción empezada vía WP Cron", "2026-01-10 16:30:56", "2026-01-10 16:30:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16918", "5695", "acción completa vía WP Cron", "2026-01-10 16:30:56", "2026-01-10 16:30:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16919", "5694", "acción empezada vía WP Cron", "2026-01-10 16:40:22", "2026-01-10 16:40:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16920", "5696", "acción creada", "2026-01-10 16:40:22", "2026-01-10 16:40:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16921", "5694", "acción completa vía WP Cron", "2026-01-10 16:40:22", "2026-01-10 16:40:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16922", "5696", "acción empezada vía WP Cron", "2026-01-10 17:42:06", "2026-01-10 17:42:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16923", "5697", "acción creada", "2026-01-10 17:42:06", "2026-01-10 17:42:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16924", "5696", "acción completa vía WP Cron", "2026-01-10 17:42:06", "2026-01-10 17:42:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16925", "5661", "acción empezada vía WP Cron", "2026-01-10 18:12:52", "2026-01-10 18:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16926", "5661", "acción completa vía WP Cron", "2026-01-10 18:12:52", "2026-01-10 18:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16927", "5698", "acción creada", "2026-01-10 18:12:52", "2026-01-10 18:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16928", "5662", "acción empezada vía WP Cron", "2026-01-10 18:12:52", "2026-01-10 18:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16929", "5662", "acción completa vía WP Cron", "2026-01-10 18:12:52", "2026-01-10 18:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16930", "5699", "acción creada", "2026-01-10 18:12:52", "2026-01-10 18:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16931", "5697", "acción empezada vía WP Cron", "2026-01-10 18:43:35", "2026-01-10 18:43:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16932", "5700", "acción creada", "2026-01-10 18:43:35", "2026-01-10 18:43:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16933", "5697", "acción completa vía WP Cron", "2026-01-10 18:43:35", "2026-01-10 18:43:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16934", "5700", "acción empezada vía WP Cron", "2026-01-10 19:45:13", "2026-01-10 19:45:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16935", "5701", "acción creada", "2026-01-10 19:45:13", "2026-01-10 19:45:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16936", "5700", "acción completa vía WP Cron", "2026-01-10 19:45:13", "2026-01-10 19:45:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16937", "5678", "acción empezada vía WP Cron", "2026-01-10 20:35:07", "2026-01-10 20:35:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16938", "5678", "acción completa vía WP Cron", "2026-01-10 20:35:07", "2026-01-10 20:35:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16939", "5702", "acción creada", "2026-01-10 20:35:07", "2026-01-10 20:35:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16940", "5701", "acción empezada vía WP Cron", "2026-01-10 20:47:02", "2026-01-10 20:47:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16941", "5703", "acción creada", "2026-01-10 20:47:02", "2026-01-10 20:47:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16942", "5701", "acción completa vía WP Cron", "2026-01-10 20:47:02", "2026-01-10 20:47:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16943", "5703", "acción empezada vía WP Cron", "2026-01-10 21:49:12", "2026-01-10 21:49:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16944", "5704", "acción creada", "2026-01-10 21:49:12", "2026-01-10 21:49:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16945", "5703", "acción completa vía WP Cron", "2026-01-10 21:49:12", "2026-01-10 21:49:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16946", "5704", "acción empezada vía WP Cron", "2026-01-10 22:50:42", "2026-01-10 22:50:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16947", "5705", "acción creada", "2026-01-10 22:50:42", "2026-01-10 22:50:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16948", "5704", "acción completa vía WP Cron", "2026-01-10 22:50:42", "2026-01-10 22:50:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16949", "5705", "acción empezada vía WP Cron", "2026-01-10 23:52:49", "2026-01-10 23:52:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16950", "5706", "acción creada", "2026-01-10 23:52:49", "2026-01-10 23:52:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16951", "5705", "acción completa vía WP Cron", "2026-01-10 23:52:49", "2026-01-10 23:52:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16952", "5706", "acción empezada vía WP Cron", "2026-01-11 00:52:49", "2026-01-11 00:52:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16953", "5707", "acción creada", "2026-01-11 00:52:49", "2026-01-11 00:52:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16954", "5706", "acción completa vía WP Cron", "2026-01-11 00:52:49", "2026-01-11 00:52:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16955", "5707", "acción empezada vía WP Cron", "2026-01-11 01:53:03", "2026-01-11 01:53:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16956", "5708", "acción creada", "2026-01-11 01:53:03", "2026-01-11 01:53:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16957", "5707", "acción completa vía WP Cron", "2026-01-11 01:53:03", "2026-01-11 01:53:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16958", "5708", "acción empezada vía WP Cron", "2026-01-11 02:56:45", "2026-01-11 02:56:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16959", "5709", "acción creada", "2026-01-11 02:56:45", "2026-01-11 02:56:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16960", "5708", "acción completa vía WP Cron", "2026-01-11 02:56:45", "2026-01-11 02:56:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16961", "5709", "acción empezada vía WP Cron", "2026-01-11 04:00:18", "2026-01-11 04:00:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16962", "5710", "acción creada", "2026-01-11 04:00:18", "2026-01-11 04:00:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16963", "5709", "acción completa vía WP Cron", "2026-01-11 04:00:18", "2026-01-11 04:00:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16964", "5711", "acción creada", "2026-01-11 04:14:13", "2026-01-11 04:14:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16965", "5711", "acción empezada vía WP Cron", "2026-01-11 04:24:04", "2026-01-11 04:24:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16966", "5711", "acción completa vía WP Cron", "2026-01-11 04:24:04", "2026-01-11 04:24:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16967", "5710", "acción empezada vía WP Cron", "2026-01-11 05:02:07", "2026-01-11 05:02:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16968", "5712", "acción creada", "2026-01-11 05:02:07", "2026-01-11 05:02:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16969", "5710", "acción completa vía WP Cron", "2026-01-11 05:02:07", "2026-01-11 05:02:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16970", "5712", "acción empezada vía WP Cron", "2026-01-11 06:04:12", "2026-01-11 06:04:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16971", "5713", "acción creada", "2026-01-11 06:04:12", "2026-01-11 06:04:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16972", "5712", "acción completa vía WP Cron", "2026-01-11 06:04:12", "2026-01-11 06:04:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16973", "5713", "acción empezada vía WP Cron", "2026-01-11 07:06:14", "2026-01-11 07:06:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16974", "5714", "acción creada", "2026-01-11 07:06:14", "2026-01-11 07:06:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16975", "5713", "acción completa vía WP Cron", "2026-01-11 07:06:14", "2026-01-11 07:06:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16976", "5714", "acción empezada vía WP Cron", "2026-01-11 08:08:18", "2026-01-11 08:08:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16977", "5715", "acción creada", "2026-01-11 08:08:18", "2026-01-11 08:08:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16978", "5714", "acción completa vía WP Cron", "2026-01-11 08:08:18", "2026-01-11 08:08:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16979", "5702", "acción empezada vía WP Cron", "2026-01-11 08:39:15", "2026-01-11 08:39:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16980", "5702", "acción completa vía WP Cron", "2026-01-11 08:39:15", "2026-01-11 08:39:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16981", "5716", "acción creada", "2026-01-11 08:39:15", "2026-01-11 08:39:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16982", "5715", "acción empezada vía WP Cron", "2026-01-11 09:10:04", "2026-01-11 09:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16983", "5717", "acción creada", "2026-01-11 09:10:04", "2026-01-11 09:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16984", "5715", "acción completa vía WP Cron", "2026-01-11 09:10:04", "2026-01-11 09:10:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16985", "5686", "acción empezada vía WP Cron", "2026-01-11 10:01:06", "2026-01-11 10:01:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16986", "5686", "acción completa vía WP Cron", "2026-01-11 10:01:06", "2026-01-11 10:01:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16988", "5717", "acción empezada vía WP Cron", "2026-01-11 10:11:58", "2026-01-11 10:11:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16989", "5719", "acción creada", "2026-01-11 10:11:58", "2026-01-11 10:11:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16990", "5717", "acción completa vía WP Cron", "2026-01-11 10:11:58", "2026-01-11 10:11:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16991", "5682", "acción empezada vía WP Cron", "2026-01-11 10:42:48", "2026-01-11 10:42:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16992", "5682", "acción completa vía WP Cron", "2026-01-11 10:42:49", "2026-01-11 10:42:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16993", "5720", "acción creada", "2026-01-11 10:42:49", "2026-01-11 10:42:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16994", "5683", "acción empezada vía WP Cron", "2026-01-11 10:42:49", "2026-01-11 10:42:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16995", "5683", "acción completa vía WP Cron", "2026-01-11 10:42:50", "2026-01-11 10:42:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16996", "5721", "acción creada", "2026-01-11 10:42:50", "2026-01-11 10:42:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16997", "5684", "acción empezada vía WP Cron", "2026-01-11 10:42:50", "2026-01-11 10:42:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16998", "5684", "acción completa vía WP Cron", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("16999", "5722", "acción creada", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17000", "5685", "acción empezada vía WP Cron", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17001", "5685", "acción completa vía WP Cron", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17002", "5723", "acción creada", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17003", "5688", "acción empezada vía WP Cron", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17005", "5724", "acción creada", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17006", "5725", "acción creada", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17007", "5688", "acción completa vía WP Cron", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17008", "5726", "acción creada", "2026-01-11 10:42:51", "2026-01-11 10:42:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17009", "5725", "acción empezada vía WP Cron", "2026-01-11 10:52:29", "2026-01-11 10:52:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17010", "5725", "acción completa vía WP Cron", "2026-01-11 10:52:29", "2026-01-11 10:52:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17011", "5719", "acción empezada vía WP Cron", "2026-01-11 11:13:59", "2026-01-11 11:13:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17012", "5727", "acción creada", "2026-01-11 11:13:59", "2026-01-11 11:13:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17013", "5719", "acción completa vía WP Cron", "2026-01-11 11:13:59", "2026-01-11 11:13:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17014", "5727", "acción empezada vía WP Cron", "2026-01-11 12:16:10", "2026-01-11 12:16:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17015", "5728", "acción creada", "2026-01-11 12:16:10", "2026-01-11 12:16:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17016", "5727", "acción completa vía WP Cron", "2026-01-11 12:16:10", "2026-01-11 12:16:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17017", "5728", "acción empezada vía WP Cron", "2026-01-11 13:17:49", "2026-01-11 13:17:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17018", "5729", "acción creada", "2026-01-11 13:17:49", "2026-01-11 13:17:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17019", "5728", "acción completa vía WP Cron", "2026-01-11 13:17:49", "2026-01-11 13:17:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17020", "5729", "acción empezada vía WP Cron", "2026-01-11 14:19:33", "2026-01-11 14:19:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17021", "5730", "acción creada", "2026-01-11 14:19:33", "2026-01-11 14:19:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17022", "5729", "acción completa vía WP Cron", "2026-01-11 14:19:33", "2026-01-11 14:19:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17023", "5730", "acción empezada vía WP Cron", "2026-01-11 15:21:31", "2026-01-11 15:21:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17024", "5731", "acción creada", "2026-01-11 15:21:31", "2026-01-11 15:21:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17025", "5730", "acción completa vía WP Cron", "2026-01-11 15:21:31", "2026-01-11 15:21:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17026", "5732", "acción creada", "2026-01-11 16:11:02", "2026-01-11 16:11:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17027", "5732", "acción empezada vía WP Cron", "2026-01-11 16:23:16", "2026-01-11 16:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17028", "5732", "acción completa vía WP Cron", "2026-01-11 16:23:16", "2026-01-11 16:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17029", "5731", "acción empezada vía WP Cron", "2026-01-11 16:23:16", "2026-01-11 16:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17030", "5733", "acción creada", "2026-01-11 16:23:16", "2026-01-11 16:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17031", "5731", "acción completa vía WP Cron", "2026-01-11 16:23:16", "2026-01-11 16:23:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17032", "5733", "acción empezada vía WP Cron", "2026-01-11 17:25:31", "2026-01-11 17:25:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17033", "5734", "acción creada", "2026-01-11 17:25:31", "2026-01-11 17:25:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17034", "5733", "acción completa vía WP Cron", "2026-01-11 17:25:31", "2026-01-11 17:25:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17035", "5698", "acción empezada vía WP Cron", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17036", "5698", "acción completa vía WP Cron", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17037", "5735", "acción creada", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17038", "5699", "acción empezada vía WP Cron", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17039", "5699", "acción completa vía WP Cron", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17040", "5736", "acción creada", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17041", "5734", "acción empezada vía WP Cron", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17042", "5737", "acción creada", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17043", "5734", "acción completa vía WP Cron", "2026-01-11 18:27:47", "2026-01-11 18:27:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17044", "5737", "acción empezada vía WP Cron", "2026-01-11 19:30:08", "2026-01-11 19:30:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17045", "5738", "acción creada", "2026-01-11 19:30:08", "2026-01-11 19:30:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17046", "5737", "acción completa vía WP Cron", "2026-01-11 19:30:08", "2026-01-11 19:30:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17047", "5738", "acción empezada vía WP Cron", "2026-01-11 20:32:43", "2026-01-11 20:32:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17048", "5739", "acción creada", "2026-01-11 20:32:43", "2026-01-11 20:32:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17049", "5738", "acción completa vía WP Cron", "2026-01-11 20:32:43", "2026-01-11 20:32:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17050", "5716", "acción empezada vía WP Cron", "2026-01-11 20:43:18", "2026-01-11 20:43:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17051", "5716", "acción completa vía WP Cron", "2026-01-11 20:43:18", "2026-01-11 20:43:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17052", "5740", "acción creada", "2026-01-11 20:43:18", "2026-01-11 20:43:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17053", "5739", "acción empezada vía WP Cron", "2026-01-11 21:35:05", "2026-01-11 21:35:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17054", "5741", "acción creada", "2026-01-11 21:35:05", "2026-01-11 21:35:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17055", "5739", "acción completa vía WP Cron", "2026-01-11 21:35:05", "2026-01-11 21:35:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17056", "5741", "acción empezada vía WP Cron", "2026-01-11 22:37:52", "2026-01-11 22:37:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17057", "5742", "acción creada", "2026-01-11 22:37:52", "2026-01-11 22:37:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17058", "5741", "acción completa vía WP Cron", "2026-01-11 22:37:52", "2026-01-11 22:37:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17059", "5742", "acción empezada vía WP Cron", "2026-01-11 23:40:08", "2026-01-11 23:40:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17060", "5743", "acción creada", "2026-01-11 23:40:08", "2026-01-11 23:40:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17061", "5742", "acción completa vía WP Cron", "2026-01-11 23:40:08", "2026-01-11 23:40:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17062", "5743", "acción empezada vía WP Cron", "2026-01-12 00:42:42", "2026-01-12 00:42:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17063", "5744", "acción creada", "2026-01-12 00:42:42", "2026-01-12 00:42:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17064", "5743", "acción completa vía WP Cron", "2026-01-12 00:42:42", "2026-01-12 00:42:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17065", "5744", "acción empezada vía WP Cron", "2026-01-12 01:45:16", "2026-01-12 01:45:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17066", "5745", "acción creada", "2026-01-12 01:45:16", "2026-01-12 01:45:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17067", "5744", "acción completa vía WP Cron", "2026-01-12 01:45:16", "2026-01-12 01:45:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17068", "5745", "acción empezada vía WP Cron", "2026-01-12 02:47:52", "2026-01-12 02:47:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17069", "5746", "acción creada", "2026-01-12 02:47:52", "2026-01-12 02:47:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17070", "5745", "acción completa vía WP Cron", "2026-01-12 02:47:52", "2026-01-12 02:47:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17071", "5746", "acción empezada vía WP Cron", "2026-01-12 03:50:11", "2026-01-12 03:50:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17072", "5747", "acción creada", "2026-01-12 03:50:11", "2026-01-12 03:50:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17073", "5746", "acción completa vía WP Cron", "2026-01-12 03:50:11", "2026-01-12 03:50:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17074", "5748", "acción creada", "2026-01-12 04:21:17", "2026-01-12 04:21:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17075", "5748", "acción empezada vía WP Cron", "2026-01-12 04:33:30", "2026-01-12 04:33:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17076", "5748", "acción completa vía WP Cron", "2026-01-12 04:33:30", "2026-01-12 04:33:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17077", "5747", "acción empezada vía WP Cron", "2026-01-12 04:52:25", "2026-01-12 04:52:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17078", "5749", "acción creada", "2026-01-12 04:52:25", "2026-01-12 04:52:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17079", "5747", "acción completa vía WP Cron", "2026-01-12 04:52:25", "2026-01-12 04:52:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17080", "5749", "acción empezada vía WP Cron", "2026-01-12 05:54:53", "2026-01-12 05:54:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17081", "5750", "acción creada", "2026-01-12 05:54:53", "2026-01-12 05:54:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17082", "5749", "acción completa vía WP Cron", "2026-01-12 05:54:53", "2026-01-12 05:54:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17083", "5750", "acción empezada vía WP Cron", "2026-01-12 06:57:35", "2026-01-12 06:57:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17084", "5751", "acción creada", "2026-01-12 06:57:35", "2026-01-12 06:57:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17085", "5750", "acción completa vía WP Cron", "2026-01-12 06:57:35", "2026-01-12 06:57:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17086", "5751", "acción empezada vía WP Cron", "2026-01-12 08:00:09", "2026-01-12 08:00:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17087", "5752", "acción creada", "2026-01-12 08:00:09", "2026-01-12 08:00:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17088", "5751", "acción completa vía WP Cron", "2026-01-12 08:00:09", "2026-01-12 08:00:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17089", "5740", "acción empezada vía WP Cron", "2026-01-12 08:47:01", "2026-01-12 08:47:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17090", "5740", "acción completa vía WP Cron", "2026-01-12 08:47:01", "2026-01-12 08:47:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17091", "5753", "acción creada", "2026-01-12 08:47:01", "2026-01-12 08:47:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17092", "5752", "acción empezada vía WP Cron", "2026-01-12 09:02:55", "2026-01-12 09:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17093", "5754", "acción creada", "2026-01-12 09:02:55", "2026-01-12 09:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17094", "5752", "acción completa vía WP Cron", "2026-01-12 09:02:55", "2026-01-12 09:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17095", "5724", "acción empezada vía WP Cron", "2026-01-12 10:06:03", "2026-01-12 10:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17096", "5724", "acción completa vía WP Cron", "2026-01-12 10:06:03", "2026-01-12 10:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17098", "5754", "acción empezada vía WP Cron", "2026-01-12 10:06:03", "2026-01-12 10:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17099", "5756", "acción creada", "2026-01-12 10:06:03", "2026-01-12 10:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17100", "5754", "acción completa vía WP Cron", "2026-01-12 10:06:03", "2026-01-12 10:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17101", "5720", "acción empezada vía WP Cron", "2026-01-12 10:44:25", "2026-01-12 10:44:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17102", "5720", "acción completa vía WP Cron", "2026-01-12 10:44:26", "2026-01-12 10:44:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17103", "5757", "acción creada", "2026-01-12 10:44:26", "2026-01-12 10:44:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17104", "5721", "acción empezada vía WP Cron", "2026-01-12 10:44:26", "2026-01-12 10:44:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17105", "5721", "acción completa vía WP Cron", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17106", "5758", "acción creada", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17107", "5722", "acción empezada vía WP Cron", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17108", "5722", "acción completa vía WP Cron", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17109", "5759", "acción creada", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17110", "5723", "acción empezada vía WP Cron", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17111", "5723", "acción completa vía WP Cron", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17112", "5760", "acción creada", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17113", "5726", "acción empezada vía WP Cron", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17115", "5761", "acción creada", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17116", "5762", "acción creada", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17117", "5726", "acción completa vía WP Cron", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17118", "5763", "acción creada", "2026-01-12 10:44:27", "2026-01-12 10:44:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17119", "5762", "acción empezada vía WP Cron", "2026-01-12 11:01:44", "2026-01-12 11:01:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17120", "5762", "acción completa vía WP Cron", "2026-01-12 11:01:44", "2026-01-12 11:01:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17121", "5756", "acción empezada vía WP Cron", "2026-01-12 11:09:28", "2026-01-12 11:09:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17122", "5764", "acción creada", "2026-01-12 11:09:28", "2026-01-12 11:09:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17123", "5756", "acción completa vía WP Cron", "2026-01-12 11:09:28", "2026-01-12 11:09:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17124", "5764", "acción empezada vía WP Cron", "2026-01-12 12:12:19", "2026-01-12 12:12:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17125", "5765", "acción creada", "2026-01-12 12:12:19", "2026-01-12 12:12:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17126", "5764", "acción completa vía WP Cron", "2026-01-12 12:12:19", "2026-01-12 12:12:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17127", "5765", "acción empezada vía WP Cron", "2026-01-12 13:12:52", "2026-01-12 13:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17128", "5766", "acción creada", "2026-01-12 13:12:52", "2026-01-12 13:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17129", "5765", "acción completa vía WP Cron", "2026-01-12 13:12:52", "2026-01-12 13:12:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17130", "5766", "acción empezada vía WP Cron", "2026-01-12 14:18:32", "2026-01-12 14:18:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17131", "5767", "acción creada", "2026-01-12 14:18:32", "2026-01-12 14:18:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17132", "5766", "acción completa vía WP Cron", "2026-01-12 14:18:32", "2026-01-12 14:18:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17133", "5767", "acción empezada vía WP Cron", "2026-01-12 15:22:29", "2026-01-12 15:22:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17134", "5768", "acción creada", "2026-01-12 15:22:29", "2026-01-12 15:22:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17135", "5767", "acción completa vía WP Cron", "2026-01-12 15:22:29", "2026-01-12 15:22:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17136", "5768", "acción empezada vía WP Cron", "2026-01-12 16:26:29", "2026-01-12 16:26:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17137", "5769", "acción creada", "2026-01-12 16:26:29", "2026-01-12 16:26:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17138", "5768", "acción completa vía WP Cron", "2026-01-12 16:26:29", "2026-01-12 16:26:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17139", "5770", "acción creada", "2026-01-12 16:26:29", "2026-01-12 16:26:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17140", "5770", "acción empezada vía WP Cron", "2026-01-12 16:58:05", "2026-01-12 16:58:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17141", "5770", "acción completa vía WP Cron", "2026-01-12 16:58:05", "2026-01-12 16:58:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17142", "5769", "acción empezada vía WP Cron", "2026-01-12 17:29:33", "2026-01-12 17:29:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17143", "5771", "acción creada", "2026-01-12 17:29:33", "2026-01-12 17:29:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17144", "5769", "acción completa vía WP Cron", "2026-01-12 17:29:33", "2026-01-12 17:29:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17145", "5735", "acción empezada vía WP Cron", "2026-01-12 18:29:02", "2026-01-12 18:29:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17146", "5735", "acción completa vía WP Cron", "2026-01-12 18:29:02", "2026-01-12 18:29:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17147", "5772", "acción creada", "2026-01-12 18:29:02", "2026-01-12 18:29:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17148", "5736", "acción empezada vía WP Cron", "2026-01-12 18:29:02", "2026-01-12 18:29:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17149", "5736", "acción completa vía WP Cron", "2026-01-12 18:29:02", "2026-01-12 18:29:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17150", "5773", "acción creada", "2026-01-12 18:29:02", "2026-01-12 18:29:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17151", "5771", "acción empezada vía WP Cron", "2026-01-12 18:32:39", "2026-01-12 18:32:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17152", "5774", "acción creada", "2026-01-12 18:32:39", "2026-01-12 18:32:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17153", "5771", "acción completa vía WP Cron", "2026-01-12 18:32:39", "2026-01-12 18:32:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17154", "5774", "acción empezada vía WP Cron", "2026-01-12 19:35:23", "2026-01-12 19:35:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17155", "5775", "acción creada", "2026-01-12 19:35:23", "2026-01-12 19:35:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17156", "5774", "acción completa vía WP Cron", "2026-01-12 19:35:23", "2026-01-12 19:35:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17157", "5775", "acción empezada vía WP Cron", "2026-01-12 20:37:55", "2026-01-12 20:37:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17158", "5776", "acción creada", "2026-01-12 20:37:55", "2026-01-12 20:37:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17159", "5775", "acción completa vía WP Cron", "2026-01-12 20:37:55", "2026-01-12 20:37:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17160", "5753", "acción empezada vía WP Cron", "2026-01-12 21:05:49", "2026-01-12 21:05:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17161", "5753", "acción completa vía WP Cron", "2026-01-12 21:05:49", "2026-01-12 21:05:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17162", "5777", "acción creada", "2026-01-12 21:05:49", "2026-01-12 21:05:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17163", "5776", "acción empezada vía WP Cron", "2026-01-12 21:40:31", "2026-01-12 21:40:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17164", "5778", "acción creada", "2026-01-12 21:40:31", "2026-01-12 21:40:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17165", "5776", "acción completa vía WP Cron", "2026-01-12 21:40:31", "2026-01-12 21:40:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17166", "5778", "acción empezada vía WP Cron", "2026-01-12 22:42:52", "2026-01-12 22:42:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17167", "5779", "acción creada", "2026-01-12 22:42:52", "2026-01-12 22:42:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17168", "5778", "acción completa vía WP Cron", "2026-01-12 22:42:52", "2026-01-12 22:42:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17169", "5779", "acción empezada vía WP Cron", "2026-01-12 23:43:07", "2026-01-12 23:43:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17170", "5780", "acción creada", "2026-01-12 23:43:08", "2026-01-12 23:43:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17171", "5779", "acción completa vía WP Cron", "2026-01-12 23:43:08", "2026-01-12 23:43:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17172", "5780", "acción empezada vía WP Cron", "2026-01-13 00:49:02", "2026-01-13 00:49:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17173", "5781", "acción creada", "2026-01-13 00:49:02", "2026-01-13 00:49:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17174", "5780", "acción completa vía WP Cron", "2026-01-13 00:49:02", "2026-01-13 00:49:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17175", "5781", "acción empezada vía WP Cron", "2026-01-13 01:52:17", "2026-01-13 01:52:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17176", "5782", "acción creada", "2026-01-13 01:52:17", "2026-01-13 01:52:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17177", "5781", "acción completa vía WP Cron", "2026-01-13 01:52:17", "2026-01-13 01:52:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17178", "5782", "acción empezada vía WP Cron", "2026-01-13 02:54:56", "2026-01-13 02:54:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17179", "5783", "acción creada", "2026-01-13 02:54:56", "2026-01-13 02:54:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17180", "5782", "acción completa vía WP Cron", "2026-01-13 02:54:56", "2026-01-13 02:54:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17181", "5783", "acción empezada vía WP Cron", "2026-01-13 03:56:52", "2026-01-13 03:56:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17182", "5784", "acción creada", "2026-01-13 03:56:52", "2026-01-13 03:56:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17183", "5783", "acción completa vía WP Cron", "2026-01-13 03:56:52", "2026-01-13 03:56:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17184", "5785", "acción creada", "2026-01-13 04:09:49", "2026-01-13 04:09:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17185", "5785", "acción empezada vía WP Cron", "2026-01-13 04:13:01", "2026-01-13 04:13:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17186", "5785", "acción completa vía WP Cron", "2026-01-13 04:13:01", "2026-01-13 04:13:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17187", "5784", "acción empezada vía WP Cron", "2026-01-13 04:56:54", "2026-01-13 04:56:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17188", "5786", "acción creada", "2026-01-13 04:56:54", "2026-01-13 04:56:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17189", "5784", "acción completa vía WP Cron", "2026-01-13 04:56:54", "2026-01-13 04:56:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17190", "5786", "acción empezada vía WP Cron", "2026-01-13 05:57:51", "2026-01-13 05:57:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17191", "5787", "acción creada", "2026-01-13 05:57:51", "2026-01-13 05:57:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17192", "5786", "acción completa vía WP Cron", "2026-01-13 05:57:51", "2026-01-13 05:57:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17193", "5787", "acción empezada vía WP Cron", "2026-01-13 07:03:38", "2026-01-13 07:03:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17194", "5788", "acción creada", "2026-01-13 07:03:38", "2026-01-13 07:03:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17195", "5787", "acción completa vía WP Cron", "2026-01-13 07:03:38", "2026-01-13 07:03:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17196", "5788", "acción empezada vía WP Cron", "2026-01-13 08:06:32", "2026-01-13 08:06:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17197", "5789", "acción creada", "2026-01-13 08:06:32", "2026-01-13 08:06:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17198", "5788", "acción completa vía WP Cron", "2026-01-13 08:06:32", "2026-01-13 08:06:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17199", "5777", "acción empezada vía WP Cron", "2026-01-13 09:31:27", "2026-01-13 09:31:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17200", "5777", "acción completa vía WP Cron", "2026-01-13 09:31:27", "2026-01-13 09:31:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17201", "5790", "acción creada", "2026-01-13 09:31:27", "2026-01-13 09:31:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17202", "5789", "acción empezada vía WP Cron", "2026-01-13 09:31:27", "2026-01-13 09:31:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17203", "5791", "acción creada", "2026-01-13 09:31:27", "2026-01-13 09:31:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17204", "5789", "acción completa vía WP Cron", "2026-01-13 09:31:27", "2026-01-13 09:31:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17205", "5761", "acción empezada vía WP Cron", "2026-01-13 10:00:34", "2026-01-13 10:00:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17206", "5761", "acción completa vía WP Cron", "2026-01-13 10:00:34", "2026-01-13 10:00:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17208", "5791", "acción empezada vía WP Cron", "2026-01-13 10:32:46", "2026-01-13 10:32:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17209", "5793", "acción creada", "2026-01-13 10:32:46", "2026-01-13 10:32:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17210", "5791", "acción completa vía WP Cron", "2026-01-13 10:32:46", "2026-01-13 10:32:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17211", "5757", "acción empezada vía WP Cron", "2026-01-13 10:48:22", "2026-01-13 10:48:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17212", "5757", "acción completa vía WP Cron", "2026-01-13 10:48:24", "2026-01-13 10:48:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17213", "5794", "acción creada", "2026-01-13 10:48:24", "2026-01-13 10:48:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17214", "5758", "acción empezada vía WP Cron", "2026-01-13 10:48:24", "2026-01-13 10:48:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17215", "5758", "acción completa vía WP Cron", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17216", "5795", "acción creada", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17217", "5759", "acción empezada vía WP Cron", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17218", "5759", "acción completa vía WP Cron", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17219", "5796", "acción creada", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17220", "5760", "acción empezada vía WP Cron", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17221", "5760", "acción completa vía WP Cron", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17222", "5797", "acción creada", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17223", "5763", "acción empezada vía WP Cron", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17225", "5798", "acción creada", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17226", "5799", "acción creada", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17227", "5763", "acción completa vía WP Cron", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17228", "5800", "acción creada", "2026-01-13 10:48:25", "2026-01-13 10:48:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17229", "5799", "acción empezada vía WP Cron", "2026-01-13 10:55:44", "2026-01-13 10:55:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17230", "5799", "acción completa vía WP Cron", "2026-01-13 10:55:44", "2026-01-13 10:55:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17231", "5793", "acción empezada vía WP Cron", "2026-01-13 11:36:51", "2026-01-13 11:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17232", "5801", "acción creada", "2026-01-13 11:36:51", "2026-01-13 11:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17233", "5793", "acción completa vía WP Cron", "2026-01-13 11:36:51", "2026-01-13 11:36:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17234", "5801", "acción empezada vía WP Cron", "2026-01-13 12:38:31", "2026-01-13 12:38:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17235", "5802", "acción creada", "2026-01-13 12:38:31", "2026-01-13 12:38:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17236", "5801", "acción completa vía WP Cron", "2026-01-13 12:38:31", "2026-01-13 12:38:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17237", "5802", "acción empezada vía WP Cron", "2026-01-13 13:41:01", "2026-01-13 13:41:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17238", "5803", "acción creada", "2026-01-13 13:41:01", "2026-01-13 13:41:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17239", "5802", "acción completa vía WP Cron", "2026-01-13 13:41:01", "2026-01-13 13:41:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17240", "5803", "acción empezada vía WP Cron", "2026-01-13 14:44:25", "2026-01-13 14:44:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17241", "5804", "acción creada", "2026-01-13 14:44:25", "2026-01-13 14:44:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17242", "5803", "acción completa vía WP Cron", "2026-01-13 14:44:25", "2026-01-13 14:44:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17243", "5804", "acción empezada vía WP Cron", "2026-01-13 15:46:26", "2026-01-13 15:46:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17244", "5805", "acción creada", "2026-01-13 15:46:26", "2026-01-13 15:46:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17245", "5804", "acción completa vía WP Cron", "2026-01-13 15:46:26", "2026-01-13 15:46:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17246", "5806", "acción creada", "2026-01-13 16:17:20", "2026-01-13 16:17:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17247", "5806", "acción empezada vía WP Cron", "2026-01-13 16:21:31", "2026-01-13 16:21:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17248", "5806", "acción completa vía WP Cron", "2026-01-13 16:21:31", "2026-01-13 16:21:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17249", "5805", "acción empezada vía WP Cron", "2026-01-13 16:48:34", "2026-01-13 16:48:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17250", "5807", "acción creada", "2026-01-13 16:48:34", "2026-01-13 16:48:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17251", "5805", "acción completa vía WP Cron", "2026-01-13 16:48:34", "2026-01-13 16:48:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17252", "5807", "acción empezada vía WP Cron", "2026-01-13 17:51:10", "2026-01-13 17:51:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17253", "5808", "acción creada", "2026-01-13 17:51:10", "2026-01-13 17:51:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17254", "5807", "acción completa vía WP Cron", "2026-01-13 17:51:10", "2026-01-13 17:51:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17255", "5772", "acción empezada vía WP Cron", "2026-01-13 18:45:18", "2026-01-13 18:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17256", "5772", "acción completa vía WP Cron", "2026-01-13 18:45:18", "2026-01-13 18:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17257", "5809", "acción creada", "2026-01-13 18:45:18", "2026-01-13 18:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17258", "5773", "acción empezada vía WP Cron", "2026-01-13 18:45:18", "2026-01-13 18:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17259", "5773", "acción completa vía WP Cron", "2026-01-13 18:45:18", "2026-01-13 18:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17260", "5810", "acción creada", "2026-01-13 18:45:18", "2026-01-13 18:45:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17261", "5808", "acción empezada vía WP Cron", "2026-01-13 18:53:49", "2026-01-13 18:53:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17262", "5811", "acción creada", "2026-01-13 18:53:49", "2026-01-13 18:53:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17263", "5808", "acción completa vía WP Cron", "2026-01-13 18:53:49", "2026-01-13 18:53:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17264", "5811", "acción empezada vía WP Cron", "2026-01-13 19:56:33", "2026-01-13 19:56:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17265", "5812", "acción creada", "2026-01-13 19:56:33", "2026-01-13 19:56:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17266", "5811", "acción completa vía WP Cron", "2026-01-13 19:56:33", "2026-01-13 19:56:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17267", "5812", "acción empezada vía WP Cron", "2026-01-13 20:59:14", "2026-01-13 20:59:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17268", "5813", "acción creada", "2026-01-13 20:59:14", "2026-01-13 20:59:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17269", "5812", "acción completa vía WP Cron", "2026-01-13 20:59:14", "2026-01-13 20:59:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17270", "5790", "acción empezada vía WP Cron", "2026-01-13 21:59:30", "2026-01-13 21:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17271", "5790", "acción completa vía WP Cron", "2026-01-13 21:59:30", "2026-01-13 21:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17272", "5814", "acción creada", "2026-01-13 21:59:30", "2026-01-13 21:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17273", "5813", "acción empezada vía WP Cron", "2026-01-13 21:59:30", "2026-01-13 21:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17274", "5815", "acción creada", "2026-01-13 21:59:30", "2026-01-13 21:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17275", "5813", "acción completa vía WP Cron", "2026-01-13 21:59:30", "2026-01-13 21:59:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17276", "5815", "acción empezada vía WP Cron", "2026-01-13 23:01:13", "2026-01-13 23:01:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17277", "5816", "acción creada", "2026-01-13 23:01:13", "2026-01-13 23:01:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17278", "5815", "acción completa vía WP Cron", "2026-01-13 23:01:13", "2026-01-13 23:01:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17279", "5816", "acción empezada vía WP Cron", "2026-01-14 00:08:43", "2026-01-14 00:08:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17280", "5817", "acción creada", "2026-01-14 00:08:43", "2026-01-14 00:08:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17281", "5816", "acción completa vía WP Cron", "2026-01-14 00:08:43", "2026-01-14 00:08:43");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17282", "5817", "acción empezada vía WP Cron", "2026-01-14 01:08:44", "2026-01-14 01:08:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17283", "5818", "acción creada", "2026-01-14 01:08:44", "2026-01-14 01:08:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17284", "5817", "acción completa vía WP Cron", "2026-01-14 01:08:44", "2026-01-14 01:08:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17285", "5818", "acción empezada vía WP Cron", "2026-01-14 02:22:09", "2026-01-14 02:22:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17286", "5819", "acción creada", "2026-01-14 02:22:09", "2026-01-14 02:22:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17287", "5818", "acción completa vía WP Cron", "2026-01-14 02:22:09", "2026-01-14 02:22:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17288", "5819", "acción empezada vía WP Cron", "2026-01-14 03:33:49", "2026-01-14 03:33:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17289", "5820", "acción creada", "2026-01-14 03:33:49", "2026-01-14 03:33:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17290", "5819", "acción completa vía WP Cron", "2026-01-14 03:33:49", "2026-01-14 03:33:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17291", "5821", "acción creada", "2026-01-14 04:12:01", "2026-01-14 04:12:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17292", "5821", "acción empezada vía WP Cron", "2026-01-14 04:21:03", "2026-01-14 04:21:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17293", "5821", "acción completa vía WP Cron", "2026-01-14 04:21:03", "2026-01-14 04:21:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17294", "5820", "acción empezada vía WP Cron", "2026-01-14 04:47:08", "2026-01-14 04:47:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17295", "5822", "acción creada", "2026-01-14 04:47:08", "2026-01-14 04:47:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17296", "5820", "acción completa vía WP Cron", "2026-01-14 04:47:08", "2026-01-14 04:47:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17297", "5822", "acción empezada vía WP Cron", "2026-01-14 05:47:32", "2026-01-14 05:47:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17298", "5823", "acción creada", "2026-01-14 05:47:32", "2026-01-14 05:47:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17299", "5822", "acción completa vía WP Cron", "2026-01-14 05:47:32", "2026-01-14 05:47:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17300", "5823", "acción empezada vía WP Cron", "2026-01-14 06:49:24", "2026-01-14 06:49:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17301", "5824", "acción creada", "2026-01-14 06:49:24", "2026-01-14 06:49:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17302", "5823", "acción completa vía WP Cron", "2026-01-14 06:49:24", "2026-01-14 06:49:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17303", "5824", "acción empezada vía WP Cron", "2026-01-14 07:50:16", "2026-01-14 07:50:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17304", "5825", "acción creada", "2026-01-14 07:50:16", "2026-01-14 07:50:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17305", "5824", "acción completa vía WP Cron", "2026-01-14 07:50:16", "2026-01-14 07:50:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17306", "5825", "acción empezada vía WP Cron", "2026-01-14 09:10:21", "2026-01-14 09:10:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17307", "5826", "acción creada", "2026-01-14 09:10:21", "2026-01-14 09:10:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17308", "5825", "acción completa vía WP Cron", "2026-01-14 09:10:21", "2026-01-14 09:10:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17309", "5814", "acción empezada vía WP Cron", "2026-01-14 10:06:10", "2026-01-14 10:06:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17310", "5814", "acción completa vía WP Cron", "2026-01-14 10:06:10", "2026-01-14 10:06:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17311", "5827", "acción creada", "2026-01-14 10:06:10", "2026-01-14 10:06:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17312", "5798", "acción empezada vía WP Cron", "2026-01-14 10:06:10", "2026-01-14 10:06:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17313", "5798", "acción completa vía WP Cron", "2026-01-14 10:06:10", "2026-01-14 10:06:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17315", "5826", "acción empezada vía WP Cron", "2026-01-14 10:28:55", "2026-01-14 10:28:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17316", "5829", "acción creada", "2026-01-14 10:28:55", "2026-01-14 10:28:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17317", "5826", "acción completa vía WP Cron", "2026-01-14 10:28:55", "2026-01-14 10:28:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17318", "5794", "acción empezada vía WP Cron", "2026-01-14 11:02:26", "2026-01-14 11:02:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17319", "5794", "acción completa vía WP Cron", "2026-01-14 11:02:27", "2026-01-14 11:02:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17320", "5830", "acción creada", "2026-01-14 11:02:27", "2026-01-14 11:02:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17321", "5795", "acción empezada vía WP Cron", "2026-01-14 11:02:27", "2026-01-14 11:02:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17322", "5795", "acción completa vía WP Cron", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17323", "5831", "acción creada", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17324", "5796", "acción empezada vía WP Cron", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17325", "5796", "acción completa vía WP Cron", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17326", "5832", "acción creada", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17327", "5797", "acción empezada vía WP Cron", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17328", "5797", "acción completa vía WP Cron", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17329", "5833", "acción creada", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17330", "5800", "acción empezada vía WP Cron", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17332", "5834", "acción creada", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17333", "5835", "acción creada", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17334", "5800", "acción completa vía WP Cron", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17335", "5836", "acción creada", "2026-01-14 11:02:28", "2026-01-14 11:02:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17336", "5835", "acción empezada vía WP Cron", "2026-01-14 11:15:04", "2026-01-14 11:15:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17337", "5835", "acción completa vía WP Cron", "2026-01-14 11:15:04", "2026-01-14 11:15:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17338", "5829", "acción empezada vía WP Cron", "2026-01-14 11:30:47", "2026-01-14 11:30:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17339", "5837", "acción creada", "2026-01-14 11:30:47", "2026-01-14 11:30:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17340", "5829", "acción completa vía WP Cron", "2026-01-14 11:30:47", "2026-01-14 11:30:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17341", "5837", "acción empezada vía WP Cron", "2026-01-14 12:55:42", "2026-01-14 12:55:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17342", "5838", "acción creada", "2026-01-14 12:55:42", "2026-01-14 12:55:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17343", "5837", "acción completa vía WP Cron", "2026-01-14 12:55:42", "2026-01-14 12:55:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17344", "5838", "acción empezada vía WP Cron", "2026-01-14 14:12:44", "2026-01-14 14:12:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17345", "5839", "acción creada", "2026-01-14 14:12:44", "2026-01-14 14:12:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17346", "5838", "acción completa vía WP Cron", "2026-01-14 14:12:44", "2026-01-14 14:12:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17347", "5839", "acción empezada vía WP Cron", "2026-01-14 15:15:34", "2026-01-14 15:15:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17348", "5840", "acción creada", "2026-01-14 15:15:34", "2026-01-14 15:15:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17349", "5839", "acción completa vía WP Cron", "2026-01-14 15:15:34", "2026-01-14 15:15:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17350", "5841", "acción creada", "2026-01-14 16:14:13", "2026-01-14 16:14:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17351", "5841", "acción empezada vía WP Cron", "2026-01-14 16:14:13", "2026-01-14 16:14:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17352", "5841", "acción completa vía WP Cron", "2026-01-14 16:14:13", "2026-01-14 16:14:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17353", "5840", "acción empezada vía WP Cron", "2026-01-14 16:37:47", "2026-01-14 16:37:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17354", "5842", "acción creada", "2026-01-14 16:37:47", "2026-01-14 16:37:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17355", "5840", "acción completa vía WP Cron", "2026-01-14 16:37:47", "2026-01-14 16:37:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17356", "5842", "acción empezada vía WP Cron", "2026-01-14 17:39:22", "2026-01-14 17:39:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17357", "5843", "acción creada", "2026-01-14 17:39:22", "2026-01-14 17:39:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17358", "5842", "acción completa vía WP Cron", "2026-01-14 17:39:22", "2026-01-14 17:39:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17359", "5843", "acción empezada vía WP Cron", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17360", "5844", "acción creada", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17361", "5843", "acción completa vía WP Cron", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17362", "5809", "acción empezada vía WP Cron", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17363", "5809", "acción completa vía WP Cron", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17364", "5845", "acción creada", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17365", "5810", "acción empezada vía WP Cron", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17366", "5810", "acción completa vía WP Cron", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17367", "5846", "acción creada", "2026-01-14 18:50:22", "2026-01-14 18:50:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17368", "5844", "acción empezada vía WP Cron", "2026-01-14 19:56:40", "2026-01-14 19:56:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17369", "5847", "acción creada", "2026-01-14 19:56:40", "2026-01-14 19:56:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17370", "5844", "acción completa vía WP Cron", "2026-01-14 19:56:40", "2026-01-14 19:56:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17371", "5847", "acción empezada vía WP Cron", "2026-01-14 20:58:22", "2026-01-14 20:58:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17372", "5848", "acción creada", "2026-01-14 20:58:22", "2026-01-14 20:58:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17373", "5847", "acción completa vía WP Cron", "2026-01-14 20:58:22", "2026-01-14 20:58:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17374", "5848", "acción empezada vía WP Cron", "2026-01-14 22:23:51", "2026-01-14 22:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17375", "5849", "acción creada", "2026-01-14 22:23:51", "2026-01-14 22:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17376", "5848", "acción completa vía WP Cron", "2026-01-14 22:23:51", "2026-01-14 22:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17377", "5827", "acción empezada vía WP Cron", "2026-01-14 22:23:51", "2026-01-14 22:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17378", "5827", "acción completa vía WP Cron", "2026-01-14 22:23:51", "2026-01-14 22:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17379", "5850", "acción creada", "2026-01-14 22:23:51", "2026-01-14 22:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17380", "5849", "acción empezada vía WP Cron", "2026-01-14 23:49:53", "2026-01-14 23:49:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17381", "5851", "acción creada", "2026-01-14 23:49:53", "2026-01-14 23:49:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17382", "5849", "acción completa vía WP Cron", "2026-01-14 23:49:53", "2026-01-14 23:49:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17383", "5851", "acción empezada vía WP Cron", "2026-01-15 01:16:30", "2026-01-15 01:16:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17384", "5852", "acción creada", "2026-01-15 01:16:30", "2026-01-15 01:16:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17385", "5851", "acción completa vía WP Cron", "2026-01-15 01:16:30", "2026-01-15 01:16:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17386", "5852", "acción empezada vía WP Cron", "2026-01-15 02:38:25", "2026-01-15 02:38:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17387", "5853", "acción creada", "2026-01-15 02:38:25", "2026-01-15 02:38:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17388", "5852", "acción completa vía WP Cron", "2026-01-15 02:38:25", "2026-01-15 02:38:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17389", "5853", "acción empezada vía WP Cron", "2026-01-15 03:38:48", "2026-01-15 03:38:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17390", "5854", "acción creada", "2026-01-15 03:38:48", "2026-01-15 03:38:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17391", "5853", "acción completa vía WP Cron", "2026-01-15 03:38:48", "2026-01-15 03:38:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17392", "5855", "acción creada", "2026-01-15 04:09:59", "2026-01-15 04:09:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17393", "5855", "acción empezada vía WP Cron", "2026-01-15 04:09:59", "2026-01-15 04:09:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17394", "5855", "acción completa vía WP Cron", "2026-01-15 04:09:59", "2026-01-15 04:09:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17395", "5854", "acción empezada vía WP Cron", "2026-01-15 04:40:09", "2026-01-15 04:40:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17396", "5856", "acción creada", "2026-01-15 04:40:09", "2026-01-15 04:40:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17397", "5854", "acción completa vía WP Cron", "2026-01-15 04:40:09", "2026-01-15 04:40:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17398", "5856", "acción empezada vía WP Cron", "2026-01-15 05:53:09", "2026-01-15 05:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17399", "5857", "acción creada", "2026-01-15 05:53:09", "2026-01-15 05:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17400", "5856", "acción completa vía WP Cron", "2026-01-15 05:53:09", "2026-01-15 05:53:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17401", "5857", "acción empezada vía WP Cron", "2026-01-15 07:00:42", "2026-01-15 07:00:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17402", "5858", "acción creada", "2026-01-15 07:00:42", "2026-01-15 07:00:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17403", "5857", "acción completa vía WP Cron", "2026-01-15 07:00:42", "2026-01-15 07:00:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17404", "5858", "acción empezada vía WP Cron", "2026-01-15 08:08:42", "2026-01-15 08:08:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17405", "5859", "acción creada", "2026-01-15 08:08:42", "2026-01-15 08:08:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17406", "5858", "acción completa vía WP Cron", "2026-01-15 08:08:42", "2026-01-15 08:08:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17407", "5859", "acción empezada vía WP Cron", "2026-01-15 09:23:54", "2026-01-15 09:23:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17408", "5860", "acción creada", "2026-01-15 09:23:54", "2026-01-15 09:23:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17409", "5859", "acción completa vía WP Cron", "2026-01-15 09:23:54", "2026-01-15 09:23:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17410", "5834", "acción empezada vía WP Cron", "2026-01-15 10:01:35", "2026-01-15 10:01:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17411", "5834", "acción completa vía WP Cron", "2026-01-15 10:01:35", "2026-01-15 10:01:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17413", "5850", "acción empezada vía WP Cron", "2026-01-15 10:23:51", "2026-01-15 10:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17414", "5850", "acción completa vía WP Cron", "2026-01-15 10:23:51", "2026-01-15 10:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17415", "5862", "acción creada", "2026-01-15 10:23:51", "2026-01-15 10:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17416", "5860", "acción empezada vía WP Cron", "2026-01-15 10:24:50", "2026-01-15 10:24:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17417", "5863", "acción creada", "2026-01-15 10:24:50", "2026-01-15 10:24:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17418", "5860", "acción completa vía WP Cron", "2026-01-15 10:24:50", "2026-01-15 10:24:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17419", "5830", "acción empezada vía WP Cron", "2026-01-15 11:02:53", "2026-01-15 11:02:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17420", "5830", "acción completa vía WP Cron", "2026-01-15 11:02:54", "2026-01-15 11:02:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17421", "5864", "acción creada", "2026-01-15 11:02:54", "2026-01-15 11:02:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17422", "5831", "acción empezada vía WP Cron", "2026-01-15 11:02:54", "2026-01-15 11:02:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17423", "5831", "acción completa vía WP Cron", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17424", "5865", "acción creada", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17425", "5832", "acción empezada vía WP Cron", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17426", "5832", "acción completa vía WP Cron", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17427", "5866", "acción creada", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17428", "5833", "acción empezada vía WP Cron", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17429", "5833", "acción completa vía WP Cron", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17430", "5867", "acción creada", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17431", "5836", "acción empezada vía WP Cron", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17433", "5868", "acción creada", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17434", "5869", "acción creada", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17435", "5836", "acción completa vía WP Cron", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17436", "5870", "acción creada", "2026-01-15 11:02:55", "2026-01-15 11:02:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17437", "5869", "acción empezada vía WP Cron", "2026-01-15 11:03:50", "2026-01-15 11:03:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17438", "5869", "acción completa vía WP Cron", "2026-01-15 11:03:50", "2026-01-15 11:03:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17439", "5863", "acción empezada vía WP Cron", "2026-01-15 11:24:50", "2026-01-15 11:24:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17440", "5871", "acción creada", "2026-01-15 11:24:50", "2026-01-15 11:24:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17441", "5863", "acción completa vía WP Cron", "2026-01-15 11:24:50", "2026-01-15 11:24:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17442", "5871", "acción empezada vía WP Cron", "2026-01-15 12:27:28", "2026-01-15 12:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17443", "5872", "acción creada", "2026-01-15 12:27:28", "2026-01-15 12:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17444", "5871", "acción completa vía WP Cron", "2026-01-15 12:27:28", "2026-01-15 12:27:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17445", "5872", "acción empezada vía WP Cron", "2026-01-15 13:37:44", "2026-01-15 13:37:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17446", "5873", "acción creada", "2026-01-15 13:37:44", "2026-01-15 13:37:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17447", "5872", "acción completa vía WP Cron", "2026-01-15 13:37:44", "2026-01-15 13:37:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17448", "5873", "acción empezada vía WP Cron", "2026-01-15 14:46:51", "2026-01-15 14:46:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17449", "5874", "acción creada", "2026-01-15 14:46:51", "2026-01-15 14:46:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17450", "5873", "acción completa vía WP Cron", "2026-01-15 14:46:51", "2026-01-15 14:46:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17451", "5874", "acción empezada vía WP Cron", "2026-01-15 16:00:53", "2026-01-15 16:00:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17452", "5875", "acción creada", "2026-01-15 16:00:53", "2026-01-15 16:00:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17453", "5874", "acción completa vía WP Cron", "2026-01-15 16:00:53", "2026-01-15 16:00:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17454", "5876", "acción creada", "2026-01-15 16:13:33", "2026-01-15 16:13:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17455", "5876", "acción empezada vía WP Cron", "2026-01-15 16:27:12", "2026-01-15 16:27:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17456", "5876", "acción completa vía WP Cron", "2026-01-15 16:27:12", "2026-01-15 16:27:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17457", "5875", "acción empezada vía WP Cron", "2026-01-15 17:27:08", "2026-01-15 17:27:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17458", "5877", "acción creada", "2026-01-15 17:27:08", "2026-01-15 17:27:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17459", "5875", "acción completa vía WP Cron", "2026-01-15 17:27:08", "2026-01-15 17:27:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17460", "5877", "acción empezada vía WP Cron", "2026-01-15 18:39:32", "2026-01-15 18:39:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17461", "5878", "acción creada", "2026-01-15 18:39:32", "2026-01-15 18:39:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17462", "5877", "acción completa vía WP Cron", "2026-01-15 18:39:32", "2026-01-15 18:39:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17463", "5845", "acción empezada vía WP Cron", "2026-01-15 18:50:28", "2026-01-15 18:50:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17464", "5845", "acción completa vía WP Cron", "2026-01-15 18:50:28", "2026-01-15 18:50:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17465", "5879", "acción creada", "2026-01-15 18:50:28", "2026-01-15 18:50:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17466", "5846", "acción empezada vía WP Cron", "2026-01-15 18:50:28", "2026-01-15 18:50:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17467", "5846", "acción completa vía WP Cron", "2026-01-15 18:50:28", "2026-01-15 18:50:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17468", "5880", "acción creada", "2026-01-15 18:50:28", "2026-01-15 18:50:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17469", "5878", "acción empezada vía WP Cron", "2026-01-15 19:47:02", "2026-01-15 19:47:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17470", "5881", "acción creada", "2026-01-15 19:47:02", "2026-01-15 19:47:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17471", "5878", "acción completa vía WP Cron", "2026-01-15 19:47:02", "2026-01-15 19:47:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17472", "5881", "acción empezada vía WP Cron", "2026-01-15 21:03:04", "2026-01-15 21:03:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17473", "5882", "acción creada", "2026-01-15 21:03:04", "2026-01-15 21:03:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17474", "5881", "acción completa vía WP Cron", "2026-01-15 21:03:04", "2026-01-15 21:03:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17475", "5882", "acción empezada vía WP Cron", "2026-01-15 22:11:45", "2026-01-15 22:11:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17476", "5883", "acción creada", "2026-01-15 22:11:45", "2026-01-15 22:11:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17477", "5882", "acción completa vía WP Cron", "2026-01-15 22:11:45", "2026-01-15 22:11:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17478", "5862", "acción empezada vía WP Cron", "2026-01-15 22:38:08", "2026-01-15 22:38:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17479", "5862", "acción completa vía WP Cron", "2026-01-15 22:38:08", "2026-01-15 22:38:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17480", "5884", "acción creada", "2026-01-15 22:38:08", "2026-01-15 22:38:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17481", "5883", "acción empezada vía WP Cron", "2026-01-15 23:37:54", "2026-01-15 23:37:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17482", "5885", "acción creada", "2026-01-15 23:37:54", "2026-01-15 23:37:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17483", "5883", "acción completa vía WP Cron", "2026-01-15 23:37:54", "2026-01-15 23:37:54");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17484", "5885", "acción empezada vía WP Cron", "2026-01-16 00:51:40", "2026-01-16 00:51:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17485", "5886", "acción creada", "2026-01-16 00:51:40", "2026-01-16 00:51:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17486", "5885", "acción completa vía WP Cron", "2026-01-16 00:51:40", "2026-01-16 00:51:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17487", "5886", "acción empezada vía WP Cron", "2026-01-16 01:58:15", "2026-01-16 01:58:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17488", "5887", "acción creada", "2026-01-16 01:58:15", "2026-01-16 01:58:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17489", "5886", "acción completa vía WP Cron", "2026-01-16 01:58:15", "2026-01-16 01:58:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17490", "5887", "acción empezada vía WP Cron", "2026-01-16 03:23:35", "2026-01-16 03:23:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17491", "5888", "acción creada", "2026-01-16 03:23:35", "2026-01-16 03:23:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17492", "5887", "acción completa vía WP Cron", "2026-01-16 03:23:35", "2026-01-16 03:23:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17493", "5889", "acción creada", "2026-01-16 04:14:39", "2026-01-16 04:14:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17494", "5889", "acción empezada vía WP Cron", "2026-01-16 04:21:05", "2026-01-16 04:21:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17495", "5889", "acción completa vía WP Cron", "2026-01-16 04:21:05", "2026-01-16 04:21:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17496", "5888", "acción empezada vía WP Cron", "2026-01-16 04:26:14", "2026-01-16 04:26:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17497", "5890", "acción creada", "2026-01-16 04:26:14", "2026-01-16 04:26:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17498", "5888", "acción completa vía WP Cron", "2026-01-16 04:26:14", "2026-01-16 04:26:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17499", "5890", "acción empezada vía WP Cron", "2026-01-16 05:35:10", "2026-01-16 05:35:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17500", "5891", "acción creada", "2026-01-16 05:35:10", "2026-01-16 05:35:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17501", "5890", "acción completa vía WP Cron", "2026-01-16 05:35:10", "2026-01-16 05:35:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17502", "5891", "acción empezada vía WP Cron", "2026-01-16 06:40:14", "2026-01-16 06:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17503", "5892", "acción creada", "2026-01-16 06:40:14", "2026-01-16 06:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17504", "5891", "acción completa vía WP Cron", "2026-01-16 06:40:14", "2026-01-16 06:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17505", "5892", "acción empezada vía WP Cron", "2026-01-16 07:40:49", "2026-01-16 07:40:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17506", "5893", "acción creada", "2026-01-16 07:40:49", "2026-01-16 07:40:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17507", "5892", "acción completa vía WP Cron", "2026-01-16 07:40:49", "2026-01-16 07:40:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17508", "5893", "acción empezada vía WP Cron", "2026-01-16 08:44:39", "2026-01-16 08:44:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17509", "5894", "acción creada", "2026-01-16 08:44:39", "2026-01-16 08:44:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17510", "5893", "acción completa vía WP Cron", "2026-01-16 08:44:39", "2026-01-16 08:44:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17511", "5894", "acción empezada vía WP Cron", "2026-01-16 09:49:32", "2026-01-16 09:49:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17512", "5895", "acción creada", "2026-01-16 09:49:32", "2026-01-16 09:49:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17513", "5894", "acción completa vía WP Cron", "2026-01-16 09:49:32", "2026-01-16 09:49:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17514", "5868", "acción empezada vía WP Cron", "2026-01-16 10:11:02", "2026-01-16 10:11:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17515", "5868", "acción completa vía WP Cron", "2026-01-16 10:11:03", "2026-01-16 10:11:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17517", "5884", "acción empezada vía WP Cron", "2026-01-16 10:39:18", "2026-01-16 10:39:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17518", "5884", "acción completa vía WP Cron", "2026-01-16 10:39:18", "2026-01-16 10:39:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17519", "5897", "acción creada", "2026-01-16 10:39:18", "2026-01-16 10:39:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17520", "5895", "acción empezada vía WP Cron", "2026-01-16 10:49:58", "2026-01-16 10:49:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17521", "5898", "acción creada", "2026-01-16 10:49:58", "2026-01-16 10:49:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17522", "5895", "acción completa vía WP Cron", "2026-01-16 10:49:58", "2026-01-16 10:49:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17523", "5864", "acción empezada vía WP Cron", "2026-01-16 11:10:49", "2026-01-16 11:10:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17524", "5864", "acción completa vía WP Cron", "2026-01-16 11:10:51", "2026-01-16 11:10:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17525", "5899", "acción creada", "2026-01-16 11:10:51", "2026-01-16 11:10:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17526", "5865", "acción empezada vía WP Cron", "2026-01-16 11:10:51", "2026-01-16 11:10:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17527", "5865", "acción completa vía WP Cron", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17528", "5900", "acción creada", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17529", "5866", "acción empezada vía WP Cron", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17530", "5866", "acción completa vía WP Cron", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17531", "5901", "acción creada", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17532", "5867", "acción empezada vía WP Cron", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17533", "5867", "acción completa vía WP Cron", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17534", "5902", "acción creada", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17535", "5870", "acción empezada vía WP Cron", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17537", "5903", "acción creada", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17538", "5904", "acción creada", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17539", "5870", "acción completa vía WP Cron", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17540", "5905", "acción creada", "2026-01-16 11:10:52", "2026-01-16 11:10:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17541", "5904", "acción empezada vía WP Cron", "2026-01-16 11:17:38", "2026-01-16 11:17:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17542", "5904", "acción completa vía WP Cron", "2026-01-16 11:17:38", "2026-01-16 11:17:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17543", "5898", "acción empezada vía WP Cron", "2026-01-16 11:50:17", "2026-01-16 11:50:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17544", "5906", "acción creada", "2026-01-16 11:50:17", "2026-01-16 11:50:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17545", "5898", "acción completa vía WP Cron", "2026-01-16 11:50:17", "2026-01-16 11:50:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17546", "5906", "acción empezada vía WP Cron", "2026-01-16 12:50:39", "2026-01-16 12:50:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17547", "5907", "acción creada", "2026-01-16 12:50:39", "2026-01-16 12:50:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17548", "5906", "acción completa vía WP Cron", "2026-01-16 12:50:39", "2026-01-16 12:50:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17549", "5907", "acción empezada vía WP Cron", "2026-01-16 13:52:27", "2026-01-16 13:52:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17550", "5908", "acción creada", "2026-01-16 13:52:27", "2026-01-16 13:52:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17551", "5907", "acción completa vía WP Cron", "2026-01-16 13:52:27", "2026-01-16 13:52:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17552", "5908", "acción empezada vía WP Cron", "2026-01-16 15:00:14", "2026-01-16 15:00:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17553", "5909", "acción creada", "2026-01-16 15:00:14", "2026-01-16 15:00:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17554", "5908", "acción completa vía WP Cron", "2026-01-16 15:00:14", "2026-01-16 15:00:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17555", "5909", "acción empezada vía WP Cron", "2026-01-16 16:18:50", "2026-01-16 16:18:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17556", "5910", "acción creada", "2026-01-16 16:18:50", "2026-01-16 16:18:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17557", "5909", "acción completa vía WP Cron", "2026-01-16 16:18:50", "2026-01-16 16:18:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17558", "5911", "acción creada", "2026-01-16 16:18:50", "2026-01-16 16:18:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17559", "5911", "acción empezada vía WP Cron", "2026-01-16 16:23:49", "2026-01-16 16:23:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17560", "5911", "acción completa vía WP Cron", "2026-01-16 16:23:49", "2026-01-16 16:23:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17561", "5910", "acción empezada vía WP Cron", "2026-01-16 17:20:03", "2026-01-16 17:20:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17562", "5912", "acción creada", "2026-01-16 17:20:03", "2026-01-16 17:20:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17563", "5910", "acción completa vía WP Cron", "2026-01-16 17:20:03", "2026-01-16 17:20:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17564", "5912", "acción empezada vía WP Cron", "2026-01-16 18:34:19", "2026-01-16 18:34:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17565", "5913", "acción creada", "2026-01-16 18:34:19", "2026-01-16 18:34:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17566", "5912", "acción completa vía WP Cron", "2026-01-16 18:34:19", "2026-01-16 18:34:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17567", "5879", "acción empezada vía WP Cron", "2026-01-16 19:12:37", "2026-01-16 19:12:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17568", "5879", "acción completa vía WP Cron", "2026-01-16 19:12:37", "2026-01-16 19:12:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17569", "5914", "acción creada", "2026-01-16 19:12:37", "2026-01-16 19:12:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17570", "5880", "acción empezada vía WP Cron", "2026-01-16 19:12:37", "2026-01-16 19:12:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17571", "5880", "acción completa vía WP Cron", "2026-01-16 19:12:37", "2026-01-16 19:12:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17572", "5915", "acción creada", "2026-01-16 19:12:37", "2026-01-16 19:12:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17573", "5913", "acción empezada vía WP Cron", "2026-01-16 19:40:53", "2026-01-16 19:40:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17574", "5916", "acción creada", "2026-01-16 19:40:53", "2026-01-16 19:40:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17575", "5913", "acción completa vía WP Cron", "2026-01-16 19:40:53", "2026-01-16 19:40:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17576", "5916", "acción empezada vía WP Cron", "2026-01-16 20:48:03", "2026-01-16 20:48:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17577", "5917", "acción creada", "2026-01-16 20:48:03", "2026-01-16 20:48:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17578", "5916", "acción completa vía WP Cron", "2026-01-16 20:48:03", "2026-01-16 20:48:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17579", "5917", "acción empezada vía WP Cron", "2026-01-16 21:53:16", "2026-01-16 21:53:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17580", "5918", "acción creada", "2026-01-16 21:53:16", "2026-01-16 21:53:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17581", "5917", "acción completa vía WP Cron", "2026-01-16 21:53:16", "2026-01-16 21:53:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17582", "5897", "acción empezada vía WP Cron", "2026-01-16 22:39:19", "2026-01-16 22:39:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17583", "5897", "acción completa vía WP Cron", "2026-01-16 22:39:19", "2026-01-16 22:39:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17584", "5919", "acción creada", "2026-01-16 22:39:19", "2026-01-16 22:39:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17585", "5918", "acción empezada vía WP Cron", "2026-01-16 22:58:15", "2026-01-16 22:58:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17586", "5920", "acción creada", "2026-01-16 22:58:15", "2026-01-16 22:58:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17587", "5918", "acción completa vía WP Cron", "2026-01-16 22:58:15", "2026-01-16 22:58:15");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17588", "5920", "acción empezada vía WP Cron", "2026-01-16 23:58:59", "2026-01-16 23:58:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17589", "5921", "acción creada", "2026-01-16 23:58:59", "2026-01-16 23:58:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17590", "5920", "acción completa vía WP Cron", "2026-01-16 23:58:59", "2026-01-16 23:58:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17591", "5921", "acción empezada vía WP Cron", "2026-01-17 01:10:48", "2026-01-17 01:10:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17592", "5922", "acción creada", "2026-01-17 01:10:48", "2026-01-17 01:10:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17593", "5921", "acción completa vía WP Cron", "2026-01-17 01:10:48", "2026-01-17 01:10:48");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17594", "5922", "acción empezada vía WP Cron", "2026-01-17 02:19:27", "2026-01-17 02:19:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17595", "5923", "acción creada", "2026-01-17 02:19:27", "2026-01-17 02:19:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17596", "5922", "acción completa vía WP Cron", "2026-01-17 02:19:27", "2026-01-17 02:19:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17597", "5923", "acción empezada vía WP Cron", "2026-01-17 03:45:25", "2026-01-17 03:45:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17598", "5924", "acción creada", "2026-01-17 03:45:25", "2026-01-17 03:45:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17599", "5923", "acción completa vía WP Cron", "2026-01-17 03:45:25", "2026-01-17 03:45:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17600", "5925", "acción creada", "2026-01-17 04:10:17", "2026-01-17 04:10:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17601", "5925", "acción empezada vía WP Cron", "2026-01-17 04:13:40", "2026-01-17 04:13:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17602", "5925", "acción completa vía WP Cron", "2026-01-17 04:13:40", "2026-01-17 04:13:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17603", "5924", "acción empezada vía WP Cron", "2026-01-17 04:55:22", "2026-01-17 04:55:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17604", "5926", "acción creada", "2026-01-17 04:55:22", "2026-01-17 04:55:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17605", "5924", "acción completa vía WP Cron", "2026-01-17 04:55:22", "2026-01-17 04:55:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17606", "5926", "acción empezada vía WP Cron", "2026-01-17 05:55:44", "2026-01-17 05:55:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17607", "5927", "acción creada", "2026-01-17 05:55:44", "2026-01-17 05:55:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17608", "5926", "acción completa vía WP Cron", "2026-01-17 05:55:44", "2026-01-17 05:55:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17609", "5927", "acción empezada vía WP Cron", "2026-01-17 06:59:31", "2026-01-17 06:59:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17610", "5928", "acción creada", "2026-01-17 06:59:31", "2026-01-17 06:59:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17611", "5927", "acción completa vía WP Cron", "2026-01-17 06:59:31", "2026-01-17 06:59:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17612", "5928", "acción empezada vía WP Cron", "2026-01-17 08:00:41", "2026-01-17 08:00:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17613", "5929", "acción creada", "2026-01-17 08:00:41", "2026-01-17 08:00:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17614", "5928", "acción completa vía WP Cron", "2026-01-17 08:00:41", "2026-01-17 08:00:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17615", "5929", "acción empezada vía WP Cron", "2026-01-17 09:18:52", "2026-01-17 09:18:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17616", "5930", "acción creada", "2026-01-17 09:18:52", "2026-01-17 09:18:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17617", "5929", "acción completa vía WP Cron", "2026-01-17 09:18:52", "2026-01-17 09:18:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17618", "5903", "acción empezada vía WP Cron", "2026-01-17 10:12:45", "2026-01-17 10:12:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17619", "5903", "acción completa vía WP Cron", "2026-01-17 10:12:45", "2026-01-17 10:12:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17621", "5930", "acción empezada vía WP Cron", "2026-01-17 10:23:04", "2026-01-17 10:23:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17622", "5932", "acción creada", "2026-01-17 10:23:04", "2026-01-17 10:23:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17623", "5930", "acción completa vía WP Cron", "2026-01-17 10:23:04", "2026-01-17 10:23:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17624", "5919", "acción empezada vía WP Cron", "2026-01-17 10:41:57", "2026-01-17 10:41:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17625", "5919", "acción completa vía WP Cron", "2026-01-17 10:41:57", "2026-01-17 10:41:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17626", "5933", "acción creada", "2026-01-17 10:41:57", "2026-01-17 10:41:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17627", "5899", "acción empezada vía WP Cron", "2026-01-17 11:10:59", "2026-01-17 11:10:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17628", "5899", "acción completa vía WP Cron", "2026-01-17 11:11:00", "2026-01-17 11:11:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17629", "5934", "acción creada", "2026-01-17 11:11:00", "2026-01-17 11:11:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17630", "5900", "acción empezada vía WP Cron", "2026-01-17 11:11:00", "2026-01-17 11:11:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17631", "5900", "acción completa vía WP Cron", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17632", "5935", "acción creada", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17633", "5901", "acción empezada vía WP Cron", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17634", "5901", "acción completa vía WP Cron", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17635", "5936", "acción creada", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17636", "5902", "acción empezada vía WP Cron", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17637", "5902", "acción completa vía WP Cron", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17638", "5937", "acción creada", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17639", "5905", "acción empezada vía WP Cron", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17641", "5938", "acción creada", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17642", "5939", "acción creada", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17643", "5905", "acción completa vía WP Cron", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17644", "5940", "acción creada", "2026-01-17 11:11:01", "2026-01-17 11:11:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17645", "5939", "acción empezada vía WP Cron", "2026-01-17 11:12:47", "2026-01-17 11:12:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17646", "5939", "acción completa vía WP Cron", "2026-01-17 11:12:47", "2026-01-17 11:12:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17647", "5932", "acción empezada vía WP Cron", "2026-01-17 11:38:22", "2026-01-17 11:38:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17648", "5941", "acción creada", "2026-01-17 11:38:23", "2026-01-17 11:38:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17649", "5932", "acción completa vía WP Cron", "2026-01-17 11:38:23", "2026-01-17 11:38:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17650", "5941", "acción empezada vía WP Cron", "2026-01-17 12:42:58", "2026-01-17 12:42:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17651", "5942", "acción creada", "2026-01-17 12:42:58", "2026-01-17 12:42:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17652", "5941", "acción completa vía WP Cron", "2026-01-17 12:42:58", "2026-01-17 12:42:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17653", "5942", "acción empezada vía WP Cron", "2026-01-17 13:44:31", "2026-01-17 13:44:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17654", "5943", "acción creada", "2026-01-17 13:44:31", "2026-01-17 13:44:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17655", "5942", "acción completa vía WP Cron", "2026-01-17 13:44:31", "2026-01-17 13:44:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17656", "5943", "acción empezada vía WP Cron", "2026-01-17 15:03:26", "2026-01-17 15:03:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17657", "5944", "acción creada", "2026-01-17 15:03:26", "2026-01-17 15:03:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17658", "5943", "acción completa vía WP Cron", "2026-01-17 15:03:26", "2026-01-17 15:03:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17659", "5944", "acción empezada vía WP Cron", "2026-01-17 16:09:22", "2026-01-17 16:09:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17660", "5945", "acción creada", "2026-01-17 16:09:22", "2026-01-17 16:09:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17661", "5944", "acción completa vía WP Cron", "2026-01-17 16:09:22", "2026-01-17 16:09:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17662", "5946", "acción creada", "2026-01-17 16:13:03", "2026-01-17 16:13:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17663", "5946", "acción empezada vía WP Cron", "2026-01-17 16:13:03", "2026-01-17 16:13:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17664", "5946", "acción completa vía WP Cron", "2026-01-17 16:13:03", "2026-01-17 16:13:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17665", "5945", "acción empezada vía WP Cron", "2026-01-17 17:16:03", "2026-01-17 17:16:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17666", "5947", "acción creada", "2026-01-17 17:16:03", "2026-01-17 17:16:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17667", "5945", "acción completa vía WP Cron", "2026-01-17 17:16:03", "2026-01-17 17:16:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17668", "5947", "acción empezada vía WP Cron", "2026-01-17 18:17:08", "2026-01-17 18:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17669", "5948", "acción creada", "2026-01-17 18:17:08", "2026-01-17 18:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17670", "5947", "acción completa vía WP Cron", "2026-01-17 18:17:08", "2026-01-17 18:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17671", "5914", "acción empezada vía WP Cron", "2026-01-17 19:15:38", "2026-01-17 19:15:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17672", "5914", "acción completa vía WP Cron", "2026-01-17 19:15:38", "2026-01-17 19:15:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17673", "5949", "acción creada", "2026-01-17 19:15:38", "2026-01-17 19:15:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17674", "5915", "acción empezada vía WP Cron", "2026-01-17 19:15:38", "2026-01-17 19:15:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17675", "5915", "acción completa vía WP Cron", "2026-01-17 19:15:38", "2026-01-17 19:15:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17676", "5950", "acción creada", "2026-01-17 19:15:38", "2026-01-17 19:15:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17677", "5948", "acción empezada vía WP Cron", "2026-01-17 19:22:01", "2026-01-17 19:22:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17678", "5951", "acción creada", "2026-01-17 19:22:01", "2026-01-17 19:22:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17679", "5948", "acción completa vía WP Cron", "2026-01-17 19:22:01", "2026-01-17 19:22:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17680", "5951", "acción empezada vía WP Cron", "2026-01-17 20:36:28", "2026-01-17 20:36:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17681", "5952", "acción creada", "2026-01-17 20:36:28", "2026-01-17 20:36:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17682", "5951", "acción completa vía WP Cron", "2026-01-17 20:36:28", "2026-01-17 20:36:28");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17683", "5952", "acción empezada vía WP Cron", "2026-01-17 21:46:37", "2026-01-17 21:46:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17684", "5953", "acción creada", "2026-01-17 21:46:37", "2026-01-17 21:46:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17685", "5952", "acción completa vía WP Cron", "2026-01-17 21:46:37", "2026-01-17 21:46:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17686", "5933", "acción empezada vía WP Cron", "2026-01-17 22:45:00", "2026-01-17 22:45:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17687", "5933", "acción completa vía WP Cron", "2026-01-17 22:45:00", "2026-01-17 22:45:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17688", "5954", "acción creada", "2026-01-17 22:45:00", "2026-01-17 22:45:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17689", "5953", "acción empezada vía WP Cron", "2026-01-17 22:57:24", "2026-01-17 22:57:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17690", "5955", "acción creada", "2026-01-17 22:57:24", "2026-01-17 22:57:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17691", "5953", "acción completa vía WP Cron", "2026-01-17 22:57:24", "2026-01-17 22:57:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17692", "5955", "acción empezada vía WP Cron", "2026-01-18 00:14:03", "2026-01-18 00:14:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17693", "5956", "acción creada", "2026-01-18 00:14:03", "2026-01-18 00:14:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17694", "5955", "acción completa vía WP Cron", "2026-01-18 00:14:03", "2026-01-18 00:14:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17695", "5956", "acción empezada vía WP Cron", "2026-01-18 01:15:00", "2026-01-18 01:15:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17696", "5957", "acción creada", "2026-01-18 01:15:00", "2026-01-18 01:15:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17697", "5956", "acción completa vía WP Cron", "2026-01-18 01:15:00", "2026-01-18 01:15:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17698", "5957", "acción empezada vía WP Cron", "2026-01-18 02:19:21", "2026-01-18 02:19:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17699", "5958", "acción creada", "2026-01-18 02:19:21", "2026-01-18 02:19:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17700", "5957", "acción completa vía WP Cron", "2026-01-18 02:19:21", "2026-01-18 02:19:21");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17701", "5958", "acción empezada vía WP Cron", "2026-01-18 03:38:16", "2026-01-18 03:38:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17702", "5959", "acción creada", "2026-01-18 03:38:16", "2026-01-18 03:38:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17703", "5958", "acción completa vía WP Cron", "2026-01-18 03:38:16", "2026-01-18 03:38:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17704", "5960", "acción creada", "2026-01-18 04:21:22", "2026-01-18 04:21:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17705", "5960", "acción empezada vía WP Cron", "2026-01-18 04:21:49", "2026-01-18 04:21:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17706", "5960", "acción completa vía WP Cron", "2026-01-18 04:21:49", "2026-01-18 04:21:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17707", "5959", "acción empezada vía WP Cron", "2026-01-18 04:46:00", "2026-01-18 04:46:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17708", "5961", "acción creada", "2026-01-18 04:46:00", "2026-01-18 04:46:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17709", "5959", "acción completa vía WP Cron", "2026-01-18 04:46:00", "2026-01-18 04:46:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17710", "5961", "acción empezada vía WP Cron", "2026-01-18 05:55:34", "2026-01-18 05:55:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17711", "5962", "acción creada", "2026-01-18 05:55:35", "2026-01-18 05:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17712", "5961", "acción completa vía WP Cron", "2026-01-18 05:55:35", "2026-01-18 05:55:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17713", "5962", "acción empezada vía WP Cron", "2026-01-18 07:07:18", "2026-01-18 07:07:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17714", "5963", "acción creada", "2026-01-18 07:07:18", "2026-01-18 07:07:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17715", "5962", "acción completa vía WP Cron", "2026-01-18 07:07:18", "2026-01-18 07:07:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17716", "5963", "acción empezada vía WP Cron", "2026-01-18 08:10:01", "2026-01-18 08:10:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17717", "5964", "acción creada", "2026-01-18 08:10:01", "2026-01-18 08:10:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17718", "5963", "acción completa vía WP Cron", "2026-01-18 08:10:01", "2026-01-18 08:10:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17719", "5964", "acción empezada vía WP Cron", "2026-01-18 09:12:22", "2026-01-18 09:12:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17720", "5965", "acción creada", "2026-01-18 09:12:22", "2026-01-18 09:12:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17721", "5964", "acción completa vía WP Cron", "2026-01-18 09:12:22", "2026-01-18 09:12:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17722", "5938", "acción empezada vía WP Cron", "2026-01-18 10:04:05", "2026-01-18 10:04:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17723", "5938", "acción completa vía WP Cron", "2026-01-18 10:04:05", "2026-01-18 10:04:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17725", "5965", "acción empezada vía WP Cron", "2026-01-18 10:17:33", "2026-01-18 10:17:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17726", "5967", "acción creada", "2026-01-18 10:17:33", "2026-01-18 10:17:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17727", "5965", "acción completa vía WP Cron", "2026-01-18 10:17:33", "2026-01-18 10:17:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17728", "5954", "acción empezada vía WP Cron", "2026-01-18 11:31:31", "2026-01-18 11:31:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17729", "5954", "acción completa vía WP Cron", "2026-01-18 11:31:31", "2026-01-18 11:31:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17730", "5968", "acción creada", "2026-01-18 11:31:31", "2026-01-18 11:31:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17731", "5934", "acción empezada vía WP Cron", "2026-01-18 11:31:31", "2026-01-18 11:31:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17732", "5934", "acción completa vía WP Cron", "2026-01-18 11:31:32", "2026-01-18 11:31:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17733", "5969", "acción creada", "2026-01-18 11:31:32", "2026-01-18 11:31:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17734", "5935", "acción empezada vía WP Cron", "2026-01-18 11:31:32", "2026-01-18 11:31:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17735", "5935", "acción completa vía WP Cron", "2026-01-18 11:31:33", "2026-01-18 11:31:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17736", "5970", "acción creada", "2026-01-18 11:31:33", "2026-01-18 11:31:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17737", "5936", "acción empezada vía WP Cron", "2026-01-18 11:31:33", "2026-01-18 11:31:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17738", "5936", "acción completa vía WP Cron", "2026-01-18 11:31:33", "2026-01-18 11:31:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17739", "5971", "acción creada", "2026-01-18 11:31:33", "2026-01-18 11:31:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17740", "5937", "acción empezada vía WP Cron", "2026-01-18 11:31:33", "2026-01-18 11:31:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17741", "5937", "acción completa vía WP Cron", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17742", "5972", "acción creada", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17743", "5967", "acción empezada vía WP Cron", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17744", "5973", "acción creada", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17745", "5967", "acción completa vía WP Cron", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17746", "5940", "acción empezada vía WP Cron", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17748", "5974", "acción creada", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17749", "5975", "acción creada", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17750", "5940", "acción completa vía WP Cron", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17751", "5976", "acción creada", "2026-01-18 11:31:34", "2026-01-18 11:31:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17752", "5975", "acción empezada vía WP Cron", "2026-01-18 11:54:49", "2026-01-18 11:54:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17753", "5975", "acción completa vía WP Cron", "2026-01-18 11:54:49", "2026-01-18 11:54:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17754", "5973", "acción empezada vía WP Cron", "2026-01-18 13:01:09", "2026-01-18 13:01:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17755", "5977", "acción creada", "2026-01-18 13:01:09", "2026-01-18 13:01:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17756", "5973", "acción completa vía WP Cron", "2026-01-18 13:01:09", "2026-01-18 13:01:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17757", "5977", "acción empezada vía WP Cron", "2026-01-18 14:12:03", "2026-01-18 14:12:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17758", "5978", "acción creada", "2026-01-18 14:12:03", "2026-01-18 14:12:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17759", "5977", "acción completa vía WP Cron", "2026-01-18 14:12:03", "2026-01-18 14:12:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17760", "5437", "acción empezada vía WP Cron", "2026-01-18 14:17:32", "2026-01-18 14:17:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17761", "5437", "acción completa vía WP Cron", "2026-01-18 14:17:32", "2026-01-18 14:17:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17762", "5979", "acción creada", "2026-01-18 14:17:32", "2026-01-18 14:17:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17763", "5978", "acción empezada vía WP Cron", "2026-01-18 15:44:01", "2026-01-18 15:44:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17764", "5980", "acción creada", "2026-01-18 15:44:01", "2026-01-18 15:44:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17765", "5978", "acción completa vía WP Cron", "2026-01-18 15:44:01", "2026-01-18 15:44:01");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17766", "5981", "acción creada", "2026-01-18 16:09:58", "2026-01-18 16:09:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17767", "5981", "acción empezada vía WP Cron", "2026-01-18 16:14:32", "2026-01-18 16:14:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17768", "5981", "acción completa vía WP Cron", "2026-01-18 16:14:32", "2026-01-18 16:14:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17769", "5980", "acción empezada vía WP Cron", "2026-01-18 17:03:58", "2026-01-18 17:03:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17770", "5982", "acción creada", "2026-01-18 17:03:59", "2026-01-18 17:03:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17771", "5980", "acción completa vía WP Cron", "2026-01-18 17:03:59", "2026-01-18 17:03:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17772", "5982", "acción empezada vía WP Cron", "2026-01-18 18:06:58", "2026-01-18 18:06:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17773", "5983", "acción creada", "2026-01-18 18:06:58", "2026-01-18 18:06:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17774", "5982", "acción completa vía WP Cron", "2026-01-18 18:06:58", "2026-01-18 18:06:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17775", "5983", "acción empezada vía WP Cron", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17776", "5984", "acción creada", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17777", "5983", "acción completa vía WP Cron", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17778", "5949", "acción empezada vía WP Cron", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17779", "5949", "acción completa vía WP Cron", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17780", "5985", "acción creada", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17781", "5950", "acción empezada vía WP Cron", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17782", "5950", "acción completa vía WP Cron", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17783", "5986", "acción creada", "2026-01-18 19:31:46", "2026-01-18 19:31:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17784", "5984", "acción empezada vía WP Cron", "2026-01-18 20:35:40", "2026-01-18 20:35:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17785", "5987", "acción creada", "2026-01-18 20:35:40", "2026-01-18 20:35:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17786", "5984", "acción completa vía WP Cron", "2026-01-18 20:35:40", "2026-01-18 20:35:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17787", "5987", "acción empezada vía WP Cron", "2026-01-18 21:50:25", "2026-01-18 21:50:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17788", "5988", "acción creada", "2026-01-18 21:50:25", "2026-01-18 21:50:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17789", "5987", "acción completa vía WP Cron", "2026-01-18 21:50:25", "2026-01-18 21:50:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17790", "5988", "acción empezada vía WP Cron", "2026-01-18 23:21:58", "2026-01-18 23:21:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17791", "5989", "acción creada", "2026-01-18 23:21:58", "2026-01-18 23:21:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17792", "5988", "acción completa vía WP Cron", "2026-01-18 23:21:58", "2026-01-18 23:21:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17793", "5968", "acción empezada vía WP Cron", "2026-01-18 23:36:38", "2026-01-18 23:36:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17794", "5968", "acción completa vía WP Cron", "2026-01-18 23:36:38", "2026-01-18 23:36:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17795", "5990", "acción creada", "2026-01-18 23:36:38", "2026-01-18 23:36:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17796", "5989", "acción empezada vía WP Cron", "2026-01-19 00:32:22", "2026-01-19 00:32:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17797", "5991", "acción creada", "2026-01-19 00:32:22", "2026-01-19 00:32:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17798", "5989", "acción completa vía WP Cron", "2026-01-19 00:32:22", "2026-01-19 00:32:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17799", "5991", "acción empezada vía WP Cron", "2026-01-19 02:17:36", "2026-01-19 02:17:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17800", "5992", "acción creada", "2026-01-19 02:17:36", "2026-01-19 02:17:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17801", "5991", "acción completa vía WP Cron", "2026-01-19 02:17:36", "2026-01-19 02:17:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17802", "5992", "acción empezada vía WP Cron", "2026-01-19 03:32:52", "2026-01-19 03:32:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17803", "5993", "acción creada", "2026-01-19 03:32:52", "2026-01-19 03:32:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17804", "5992", "acción completa vía WP Cron", "2026-01-19 03:32:52", "2026-01-19 03:32:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17805", "5994", "acción creada", "2026-01-19 04:20:37", "2026-01-19 04:20:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17806", "5994", "acción empezada vía WP Cron", "2026-01-19 04:39:06", "2026-01-19 04:39:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17807", "5994", "acción completa vía WP Cron", "2026-01-19 04:39:06", "2026-01-19 04:39:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17808", "5993", "acción empezada vía WP Cron", "2026-01-19 04:39:06", "2026-01-19 04:39:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17809", "5995", "acción creada", "2026-01-19 04:39:06", "2026-01-19 04:39:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17810", "5993", "acción completa vía WP Cron", "2026-01-19 04:39:06", "2026-01-19 04:39:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17811", "5995", "acción empezada vía WP Cron", "2026-01-19 05:46:31", "2026-01-19 05:46:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17812", "5996", "acción creada", "2026-01-19 05:46:31", "2026-01-19 05:46:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17813", "5995", "acción completa vía WP Cron", "2026-01-19 05:46:31", "2026-01-19 05:46:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17814", "5996", "acción empezada vía WP Cron", "2026-01-19 06:51:35", "2026-01-19 06:51:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17815", "5997", "acción creada", "2026-01-19 06:51:35", "2026-01-19 06:51:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17816", "5996", "acción completa vía WP Cron", "2026-01-19 06:51:35", "2026-01-19 06:51:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17817", "5997", "acción empezada vía WP Cron", "2026-01-19 08:19:55", "2026-01-19 08:19:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17818", "5998", "acción creada", "2026-01-19 08:19:55", "2026-01-19 08:19:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17819", "5997", "acción completa vía WP Cron", "2026-01-19 08:19:55", "2026-01-19 08:19:55");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17820", "5998", "acción empezada vía WP Cron", "2026-01-19 09:57:19", "2026-01-19 09:57:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17821", "5999", "acción creada", "2026-01-19 09:57:19", "2026-01-19 09:57:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17822", "5998", "acción completa vía WP Cron", "2026-01-19 09:57:19", "2026-01-19 09:57:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17823", "5974", "acción empezada vía WP Cron", "2026-01-19 10:41:31", "2026-01-19 10:41:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17824", "5974", "acción completa vía WP Cron", "2026-01-19 10:41:31", "2026-01-19 10:41:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17826", "5999", "acción empezada vía WP Cron", "2026-01-19 11:22:45", "2026-01-19 11:22:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17827", "6001", "acción creada", "2026-01-19 11:22:45", "2026-01-19 11:22:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17828", "5999", "acción completa vía WP Cron", "2026-01-19 11:22:45", "2026-01-19 11:22:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17829", "5969", "acción empezada vía WP Cron", "2026-01-19 11:44:03", "2026-01-19 11:44:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17830", "5969", "acción completa vía WP Cron", "2026-01-19 11:44:04", "2026-01-19 11:44:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17831", "6002", "acción creada", "2026-01-19 11:44:04", "2026-01-19 11:44:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17832", "5970", "acción empezada vía WP Cron", "2026-01-19 11:44:04", "2026-01-19 11:44:04");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17833", "5970", "acción completa vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17834", "6003", "acción creada", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17835", "5971", "acción empezada vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17836", "5971", "acción completa vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17837", "6004", "acción creada", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17838", "5972", "acción empezada vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17839", "5972", "acción completa vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17840", "6005", "acción creada", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17841", "5990", "acción empezada vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17842", "5990", "acción completa vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17843", "6006", "acción creada", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17844", "5976", "acción empezada vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17846", "6007", "acción creada", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17847", "6008", "acción creada", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17848", "5976", "acción completa vía WP Cron", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17849", "6009", "acción creada", "2026-01-19 11:44:05", "2026-01-19 11:44:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17850", "6008", "acción empezada vía WP Cron", "2026-01-19 12:16:10", "2026-01-19 12:16:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17851", "6008", "acción completa vía WP Cron", "2026-01-19 12:16:10", "2026-01-19 12:16:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17852", "6001", "acción empezada vía WP Cron", "2026-01-19 12:51:49", "2026-01-19 12:51:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17853", "6010", "acción creada", "2026-01-19 12:51:49", "2026-01-19 12:51:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17854", "6001", "acción completa vía WP Cron", "2026-01-19 12:51:49", "2026-01-19 12:51:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17855", "6010", "acción empezada vía WP Cron", "2026-01-19 13:57:57", "2026-01-19 13:57:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17856", "6011", "acción creada", "2026-01-19 13:57:57", "2026-01-19 13:57:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17857", "6010", "acción completa vía WP Cron", "2026-01-19 13:57:57", "2026-01-19 13:57:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17858", "6011", "acción empezada vía WP Cron", "2026-01-19 15:03:52", "2026-01-19 15:03:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17859", "6012", "acción creada", "2026-01-19 15:03:52", "2026-01-19 15:03:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17860", "6011", "acción completa vía WP Cron", "2026-01-19 15:03:52", "2026-01-19 15:03:52");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17861", "6012", "acción empezada vía WP Cron", "2026-01-19 16:09:12", "2026-01-19 16:09:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17862", "6013", "acción creada", "2026-01-19 16:09:12", "2026-01-19 16:09:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17863", "6012", "acción completa vía WP Cron", "2026-01-19 16:09:12", "2026-01-19 16:09:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17864", "6014", "acción creada", "2026-01-19 16:18:30", "2026-01-19 16:18:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17865", "6014", "acción empezada vía WP Cron", "2026-01-19 16:18:30", "2026-01-19 16:18:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17866", "6014", "acción completa vía WP Cron", "2026-01-19 16:18:30", "2026-01-19 16:18:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17867", "6013", "acción empezada vía WP Cron", "2026-01-19 17:28:41", "2026-01-19 17:28:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17868", "6015", "acción creada", "2026-01-19 17:28:41", "2026-01-19 17:28:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17869", "6013", "acción completa vía WP Cron", "2026-01-19 17:28:41", "2026-01-19 17:28:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17870", "6015", "acción empezada vía WP Cron", "2026-01-19 18:48:09", "2026-01-19 18:48:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17871", "6016", "acción creada", "2026-01-19 18:48:09", "2026-01-19 18:48:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17872", "6015", "acción completa vía WP Cron", "2026-01-19 18:48:10", "2026-01-19 18:48:10");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17873", "5985", "acción empezada vía WP Cron", "2026-01-19 19:47:06", "2026-01-19 19:47:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17874", "5985", "acción completa vía WP Cron", "2026-01-19 19:47:06", "2026-01-19 19:47:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17875", "6017", "acción creada", "2026-01-19 19:47:06", "2026-01-19 19:47:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17876", "5986", "acción empezada vía WP Cron", "2026-01-19 19:47:06", "2026-01-19 19:47:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17877", "5986", "acción completa vía WP Cron", "2026-01-19 19:47:06", "2026-01-19 19:47:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17878", "6018", "acción creada", "2026-01-19 19:47:06", "2026-01-19 19:47:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17879", "6016", "acción empezada vía WP Cron", "2026-01-19 19:52:56", "2026-01-19 19:52:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17880", "6019", "acción creada", "2026-01-19 19:52:56", "2026-01-19 19:52:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17881", "6016", "acción completa vía WP Cron", "2026-01-19 19:52:56", "2026-01-19 19:52:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17882", "6019", "acción empezada vía WP Cron", "2026-01-19 21:04:56", "2026-01-19 21:04:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17883", "6020", "acción creada", "2026-01-19 21:04:56", "2026-01-19 21:04:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17884", "6019", "acción completa vía WP Cron", "2026-01-19 21:04:56", "2026-01-19 21:04:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17885", "6020", "acción empezada vía WP Cron", "2026-01-19 22:28:39", "2026-01-19 22:28:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17886", "6021", "acción creada", "2026-01-19 22:28:39", "2026-01-19 22:28:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17887", "6020", "acción completa vía WP Cron", "2026-01-19 22:28:39", "2026-01-19 22:28:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17888", "6021", "acción empezada vía WP Cron", "2026-01-19 23:29:40", "2026-01-19 23:29:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17889", "6022", "acción creada", "2026-01-19 23:29:40", "2026-01-19 23:29:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17890", "6021", "acción completa vía WP Cron", "2026-01-19 23:29:40", "2026-01-19 23:29:40");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17891", "6006", "acción empezada vía WP Cron", "2026-01-19 23:44:26", "2026-01-19 23:44:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17892", "6006", "acción completa vía WP Cron", "2026-01-19 23:44:26", "2026-01-19 23:44:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17893", "6023", "acción creada", "2026-01-19 23:44:26", "2026-01-19 23:44:26");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17894", "6022", "acción empezada vía WP Cron", "2026-01-20 00:50:23", "2026-01-20 00:50:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17895", "6024", "acción creada", "2026-01-20 00:50:23", "2026-01-20 00:50:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17896", "6022", "acción completa vía WP Cron", "2026-01-20 00:50:23", "2026-01-20 00:50:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17897", "6024", "acción empezada vía WP Cron", "2026-01-20 02:43:49", "2026-01-20 02:43:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17898", "6025", "acción creada", "2026-01-20 02:43:49", "2026-01-20 02:43:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17899", "6024", "acción completa vía WP Cron", "2026-01-20 02:43:49", "2026-01-20 02:43:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17900", "6025", "acción empezada vía WP Cron", "2026-01-20 03:57:29", "2026-01-20 03:57:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17901", "6026", "acción creada", "2026-01-20 03:57:29", "2026-01-20 03:57:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17902", "6025", "acción completa vía WP Cron", "2026-01-20 03:57:29", "2026-01-20 03:57:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17903", "6027", "acción creada", "2026-01-20 04:22:32", "2026-01-20 04:22:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17904", "6027", "acción empezada vía WP Cron", "2026-01-20 04:22:32", "2026-01-20 04:22:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17905", "6027", "acción completa vía WP Cron", "2026-01-20 04:22:32", "2026-01-20 04:22:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17906", "6026", "acción empezada vía WP Cron", "2026-01-20 05:13:16", "2026-01-20 05:13:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17907", "6028", "acción creada", "2026-01-20 05:13:16", "2026-01-20 05:13:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17908", "6026", "acción completa vía WP Cron", "2026-01-20 05:13:16", "2026-01-20 05:13:16");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17909", "6028", "acción empezada vía WP Cron", "2026-01-20 06:16:56", "2026-01-20 06:16:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17910", "6029", "acción creada", "2026-01-20 06:16:56", "2026-01-20 06:16:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17911", "6028", "acción completa vía WP Cron", "2026-01-20 06:16:56", "2026-01-20 06:16:56");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17912", "6029", "acción empezada vía WP Cron", "2026-01-20 07:40:22", "2026-01-20 07:40:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17913", "6030", "acción creada", "2026-01-20 07:40:22", "2026-01-20 07:40:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17914", "6029", "acción completa vía WP Cron", "2026-01-20 07:40:22", "2026-01-20 07:40:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17915", "6030", "acción empezada vía WP Cron", "2026-01-20 08:44:06", "2026-01-20 08:44:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17916", "6031", "acción creada", "2026-01-20 08:44:06", "2026-01-20 08:44:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17917", "6030", "acción completa vía WP Cron", "2026-01-20 08:44:06", "2026-01-20 08:44:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17918", "6031", "acción empezada vía WP Cron", "2026-01-20 10:03:37", "2026-01-20 10:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17919", "6032", "acción creada", "2026-01-20 10:03:37", "2026-01-20 10:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17920", "6031", "acción completa vía WP Cron", "2026-01-20 10:03:37", "2026-01-20 10:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17921", "6007", "acción empezada vía WP Cron", "2026-01-20 10:03:37", "2026-01-20 10:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17922", "6007", "acción completa vía WP Cron", "2026-01-20 10:03:37", "2026-01-20 10:03:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17924", "6032", "acción empezada vía WP Cron", "2026-01-20 11:14:13", "2026-01-20 11:14:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17925", "6034", "acción creada", "2026-01-20 11:14:13", "2026-01-20 11:14:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17926", "6032", "acción completa vía WP Cron", "2026-01-20 11:14:13", "2026-01-20 11:14:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17927", "6002", "acción empezada vía WP Cron", "2026-01-20 12:29:44", "2026-01-20 12:29:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17928", "6002", "acción completa vía WP Cron", "2026-01-20 12:29:45", "2026-01-20 12:29:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17929", "6035", "acción creada", "2026-01-20 12:29:45", "2026-01-20 12:29:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17930", "6003", "acción empezada vía WP Cron", "2026-01-20 12:29:45", "2026-01-20 12:29:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17931", "6003", "acción completa vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17932", "6036", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17933", "6004", "acción empezada vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17934", "6004", "acción completa vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17935", "6037", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17936", "6005", "acción empezada vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17937", "6005", "acción completa vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17938", "6038", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17939", "6023", "acción empezada vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17940", "6023", "acción completa vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17941", "6039", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17942", "6034", "acción empezada vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17943", "6040", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17944", "6034", "acción completa vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17945", "6009", "acción empezada vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17947", "6041", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17948", "6042", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17949", "6009", "acción completa vía WP Cron", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17950", "6043", "acción creada", "2026-01-20 12:29:46", "2026-01-20 12:29:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17951", "6042", "acción empezada vía WP Cron", "2026-01-20 13:06:41", "2026-01-20 13:06:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17952", "6042", "acción completa vía WP Cron", "2026-01-20 13:06:41", "2026-01-20 13:06:41");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17953", "6040", "acción empezada vía WP Cron", "2026-01-20 13:41:25", "2026-01-20 13:41:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17954", "6044", "acción creada", "2026-01-20 13:41:25", "2026-01-20 13:41:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17955", "6040", "acción completa vía WP Cron", "2026-01-20 13:41:25", "2026-01-20 13:41:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17956", "6044", "acción empezada vía WP Cron", "2026-01-20 15:04:31", "2026-01-20 15:04:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17957", "6045", "acción creada", "2026-01-20 15:04:31", "2026-01-20 15:04:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17958", "6044", "acción completa vía WP Cron", "2026-01-20 15:04:31", "2026-01-20 15:04:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17959", "6045", "acción empezada vía WP Cron", "2026-01-20 16:18:05", "2026-01-20 16:18:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17960", "6046", "acción creada", "2026-01-20 16:18:05", "2026-01-20 16:18:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17961", "6045", "acción completa vía WP Cron", "2026-01-20 16:18:05", "2026-01-20 16:18:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17962", "6047", "acción creada", "2026-01-20 16:18:05", "2026-01-20 16:18:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17963", "6047", "acción empezada vía WP Cron", "2026-01-20 16:24:12", "2026-01-20 16:24:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17964", "6047", "acción completa vía WP Cron", "2026-01-20 16:24:12", "2026-01-20 16:24:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17965", "6046", "acción empezada vía WP Cron", "2026-01-20 17:23:44", "2026-01-20 17:23:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17966", "6048", "acción creada", "2026-01-20 17:23:44", "2026-01-20 17:23:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17967", "6046", "acción completa vía WP Cron", "2026-01-20 17:23:44", "2026-01-20 17:23:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17968", "6048", "acción empezada vía WP Cron", "2026-01-20 18:31:36", "2026-01-20 18:31:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17969", "6049", "acción creada", "2026-01-20 18:31:36", "2026-01-20 18:31:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17970", "6048", "acción completa vía WP Cron", "2026-01-20 18:31:36", "2026-01-20 18:31:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17971", "6049", "acción empezada vía WP Cron", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17972", "6050", "acción creada", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17973", "6049", "acción completa vía WP Cron", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17974", "6017", "acción empezada vía WP Cron", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17975", "6017", "acción completa vía WP Cron", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17976", "6051", "acción creada", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17977", "6018", "acción empezada vía WP Cron", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17978", "6018", "acción completa vía WP Cron", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17979", "6052", "acción creada", "2026-01-20 19:48:07", "2026-01-20 19:48:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17980", "6050", "acción empezada vía WP Cron", "2026-01-20 21:06:03", "2026-01-20 21:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17981", "6053", "acción creada", "2026-01-20 21:06:03", "2026-01-20 21:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17982", "6050", "acción completa vía WP Cron", "2026-01-20 21:06:03", "2026-01-20 21:06:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17983", "6053", "acción empezada vía WP Cron", "2026-01-20 22:15:25", "2026-01-20 22:15:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17984", "6054", "acción creada", "2026-01-20 22:15:25", "2026-01-20 22:15:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17985", "6053", "acción completa vía WP Cron", "2026-01-20 22:15:25", "2026-01-20 22:15:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17986", "6054", "acción empezada vía WP Cron", "2026-01-20 23:21:33", "2026-01-20 23:21:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17987", "6055", "acción creada", "2026-01-20 23:21:33", "2026-01-20 23:21:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17988", "6054", "acción completa vía WP Cron", "2026-01-20 23:21:33", "2026-01-20 23:21:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17989", "6055", "acción empezada vía WP Cron", "2026-01-21 00:48:32", "2026-01-21 00:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17990", "6056", "acción creada", "2026-01-21 00:48:32", "2026-01-21 00:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17991", "6055", "acción completa vía WP Cron", "2026-01-21 00:48:32", "2026-01-21 00:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17992", "6039", "acción empezada vía WP Cron", "2026-01-21 00:48:32", "2026-01-21 00:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17993", "6039", "acción completa vía WP Cron", "2026-01-21 00:48:32", "2026-01-21 00:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17994", "6057", "acción creada", "2026-01-21 00:48:32", "2026-01-21 00:48:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17995", "6056", "acción empezada vía WP Cron", "2026-01-21 02:22:27", "2026-01-21 02:22:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17996", "6058", "acción creada", "2026-01-21 02:22:27", "2026-01-21 02:22:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17997", "6056", "acción completa vía WP Cron", "2026-01-21 02:22:27", "2026-01-21 02:22:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17998", "6058", "acción empezada vía WP Cron", "2026-01-21 03:24:34", "2026-01-21 03:24:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("17999", "6059", "acción creada", "2026-01-21 03:24:34", "2026-01-21 03:24:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18000", "6058", "acción completa vía WP Cron", "2026-01-21 03:24:34", "2026-01-21 03:24:34");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18001", "6059", "acción empezada vía WP Cron", "2026-01-21 04:31:07", "2026-01-21 04:31:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18002", "6060", "acción creada", "2026-01-21 04:31:07", "2026-01-21 04:31:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18003", "6059", "acción completa vía WP Cron", "2026-01-21 04:31:07", "2026-01-21 04:31:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18004", "6061", "acción creada", "2026-01-21 04:31:07", "2026-01-21 04:31:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18005", "6061", "acción empezada vía WP Cron", "2026-01-21 04:36:31", "2026-01-21 04:36:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18006", "6061", "acción completa vía WP Cron", "2026-01-21 04:36:31", "2026-01-21 04:36:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18007", "6060", "acción empezada vía WP Cron", "2026-01-21 05:50:07", "2026-01-21 05:50:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18008", "6062", "acción creada", "2026-01-21 05:50:07", "2026-01-21 05:50:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18009", "6060", "acción completa vía WP Cron", "2026-01-21 05:50:07", "2026-01-21 05:50:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18010", "6062", "acción empezada vía WP Cron", "2026-01-21 06:59:23", "2026-01-21 06:59:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18011", "6063", "acción creada", "2026-01-21 06:59:23", "2026-01-21 06:59:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18012", "6062", "acción completa vía WP Cron", "2026-01-21 06:59:23", "2026-01-21 06:59:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18013", "6063", "acción empezada vía WP Cron", "2026-01-21 08:05:58", "2026-01-21 08:05:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18014", "6064", "acción creada", "2026-01-21 08:05:58", "2026-01-21 08:05:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18015", "6063", "acción completa vía WP Cron", "2026-01-21 08:05:58", "2026-01-21 08:05:58");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18016", "6064", "acción empezada vía WP Cron", "2026-01-21 09:22:37", "2026-01-21 09:22:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18017", "6065", "acción creada", "2026-01-21 09:22:37", "2026-01-21 09:22:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18018", "6064", "acción completa vía WP Cron", "2026-01-21 09:22:37", "2026-01-21 09:22:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18019", "6041", "acción empezada vía WP Cron", "2026-01-21 10:39:25", "2026-01-21 10:39:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18020", "6041", "acción completa vía WP Cron", "2026-01-21 10:39:25", "2026-01-21 10:39:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18022", "6065", "acción empezada vía WP Cron", "2026-01-21 10:39:25", "2026-01-21 10:39:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18023", "6067", "acción creada", "2026-01-21 10:39:25", "2026-01-21 10:39:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18024", "6065", "acción completa vía WP Cron", "2026-01-21 10:39:25", "2026-01-21 10:39:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18025", "6067", "acción empezada vía WP Cron", "2026-01-21 11:46:32", "2026-01-21 11:46:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18026", "6068", "acción creada", "2026-01-21 11:46:32", "2026-01-21 11:46:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18027", "6067", "acción completa vía WP Cron", "2026-01-21 11:46:32", "2026-01-21 11:46:32");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18028", "6035", "acción empezada vía WP Cron", "2026-01-21 12:40:11", "2026-01-21 12:40:11");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18029", "6035", "acción completa vía WP Cron", "2026-01-21 12:40:12", "2026-01-21 12:40:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18030", "6069", "acción creada", "2026-01-21 12:40:13", "2026-01-21 12:40:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18031", "6036", "acción empezada vía WP Cron", "2026-01-21 12:40:13", "2026-01-21 12:40:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18032", "6036", "acción completa vía WP Cron", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18033", "6070", "acción creada", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18034", "6037", "acción empezada vía WP Cron", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18035", "6037", "acción completa vía WP Cron", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18036", "6071", "acción creada", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18037", "6038", "acción empezada vía WP Cron", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18038", "6038", "acción completa vía WP Cron", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18039", "6072", "acción creada", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18040", "6043", "acción empezada vía WP Cron", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18042", "6073", "acción creada", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18043", "6074", "acción creada", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18044", "6043", "acción completa vía WP Cron", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18045", "6075", "acción creada", "2026-01-21 12:40:14", "2026-01-21 12:40:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18046", "6074", "acción empezada vía WP Cron", "2026-01-21 12:41:47", "2026-01-21 12:41:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18047", "6074", "acción completa vía WP Cron", "2026-01-21 12:41:47", "2026-01-21 12:41:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18048", "6068", "acción empezada vía WP Cron", "2026-01-21 13:02:35", "2026-01-21 13:02:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18049", "6076", "acción creada", "2026-01-21 13:02:35", "2026-01-21 13:02:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18050", "6068", "acción completa vía WP Cron", "2026-01-21 13:02:35", "2026-01-21 13:02:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18051", "6057", "acción empezada vía WP Cron", "2026-01-21 13:02:35", "2026-01-21 13:02:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18052", "6057", "acción completa vía WP Cron", "2026-01-21 13:02:35", "2026-01-21 13:02:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18053", "6077", "acción creada", "2026-01-21 13:02:35", "2026-01-21 13:02:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18054", "6076", "acción empezada vía WP Cron", "2026-01-21 14:20:13", "2026-01-21 14:20:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18055", "6078", "acción creada", "2026-01-21 14:20:13", "2026-01-21 14:20:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18056", "6076", "acción completa vía WP Cron", "2026-01-21 14:20:13", "2026-01-21 14:20:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18057", "6078", "acción empezada vía WP Cron", "2026-01-21 15:21:03", "2026-01-21 15:21:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18058", "6079", "acción creada", "2026-01-21 15:21:03", "2026-01-21 15:21:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18059", "6078", "acción completa vía WP Cron", "2026-01-21 15:21:03", "2026-01-21 15:21:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18060", "6080", "acción creada", "2026-01-21 16:20:39", "2026-01-21 16:20:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18061", "6080", "acción empezada vía WP Cron", "2026-01-21 16:20:53", "2026-01-21 16:20:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18062", "6080", "acción completa vía WP Cron", "2026-01-21 16:20:53", "2026-01-21 16:20:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18063", "6079", "acción empezada vía WP Cron", "2026-01-21 16:29:00", "2026-01-21 16:29:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18064", "6081", "acción creada", "2026-01-21 16:29:00", "2026-01-21 16:29:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18065", "6079", "acción completa vía WP Cron", "2026-01-21 16:29:00", "2026-01-21 16:29:00");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18066", "6081", "acción empezada vía WP Cron", "2026-01-21 17:42:46", "2026-01-21 17:42:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18067", "6082", "acción creada", "2026-01-21 17:42:46", "2026-01-21 17:42:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18068", "6081", "acción completa vía WP Cron", "2026-01-21 17:42:46", "2026-01-21 17:42:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18069", "6082", "acción empezada vía WP Cron", "2026-01-21 18:55:18", "2026-01-21 18:55:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18070", "6083", "acción creada", "2026-01-21 18:55:18", "2026-01-21 18:55:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18071", "6082", "acción completa vía WP Cron", "2026-01-21 18:55:18", "2026-01-21 18:55:18");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18072", "6051", "acción empezada vía WP Cron", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18073", "6051", "acción completa vía WP Cron", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18074", "6084", "acción creada", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18075", "6052", "acción empezada vía WP Cron", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18076", "6052", "acción completa vía WP Cron", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18077", "6085", "acción creada", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18078", "6083", "acción empezada vía WP Cron", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18079", "6086", "acción creada", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18080", "6083", "acción completa vía WP Cron", "2026-01-21 19:57:03", "2026-01-21 19:57:03");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18081", "6086", "acción empezada vía WP Cron", "2026-01-21 21:20:53", "2026-01-21 21:20:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18082", "6087", "acción creada", "2026-01-21 21:20:53", "2026-01-21 21:20:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18083", "6086", "acción completa vía WP Cron", "2026-01-21 21:20:53", "2026-01-21 21:20:53");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18084", "6087", "acción empezada vía WP Cron", "2026-01-21 22:25:13", "2026-01-21 22:25:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18085", "6088", "acción creada", "2026-01-21 22:25:13", "2026-01-21 22:25:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18086", "6087", "acción completa vía WP Cron", "2026-01-21 22:25:13", "2026-01-21 22:25:13");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18087", "6088", "acción empezada vía WP Cron", "2026-01-21 23:33:31", "2026-01-21 23:33:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18088", "6089", "acción creada", "2026-01-21 23:33:31", "2026-01-21 23:33:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18089", "6088", "acción completa vía WP Cron", "2026-01-21 23:33:31", "2026-01-21 23:33:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18090", "6089", "acción empezada vía WP Cron", "2026-01-22 00:36:08", "2026-01-22 00:36:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18091", "6090", "acción creada", "2026-01-22 00:36:08", "2026-01-22 00:36:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18092", "6089", "acción completa vía WP Cron", "2026-01-22 00:36:08", "2026-01-22 00:36:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18093", "6077", "acción empezada vía WP Cron", "2026-01-22 01:04:06", "2026-01-22 01:04:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18094", "6077", "acción completa vía WP Cron", "2026-01-22 01:04:06", "2026-01-22 01:04:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18095", "6091", "acción creada", "2026-01-22 01:04:06", "2026-01-22 01:04:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18096", "6090", "acción empezada vía WP Cron", "2026-01-22 01:38:22", "2026-01-22 01:38:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18097", "6092", "acción creada", "2026-01-22 01:38:22", "2026-01-22 01:38:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18098", "6090", "acción completa vía WP Cron", "2026-01-22 01:38:22", "2026-01-22 01:38:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18099", "6092", "acción empezada vía WP Cron", "2026-01-22 02:43:31", "2026-01-22 02:43:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18100", "6093", "acción creada", "2026-01-22 02:43:31", "2026-01-22 02:43:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18101", "6092", "acción completa vía WP Cron", "2026-01-22 02:43:31", "2026-01-22 02:43:31");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18102", "6093", "acción empezada vía WP Cron", "2026-01-22 03:49:47", "2026-01-22 03:49:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18103", "6094", "acción creada", "2026-01-22 03:49:47", "2026-01-22 03:49:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18104", "6093", "acción completa vía WP Cron", "2026-01-22 03:49:47", "2026-01-22 03:49:47");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18105", "6095", "acción creada", "2026-01-22 04:09:59", "2026-01-22 04:09:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18106", "6095", "acción empezada vía WP Cron", "2026-01-22 04:12:09", "2026-01-22 04:12:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18107", "6095", "acción completa vía WP Cron", "2026-01-22 04:12:09", "2026-01-22 04:12:09");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18108", "6094", "acción empezada vía WP Cron", "2026-01-22 04:58:50", "2026-01-22 04:58:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18109", "6096", "acción creada", "2026-01-22 04:58:50", "2026-01-22 04:58:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18110", "6094", "acción completa vía WP Cron", "2026-01-22 04:58:50", "2026-01-22 04:58:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18111", "6096", "acción empezada vía WP Cron", "2026-01-22 06:04:49", "2026-01-22 06:04:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18112", "6097", "acción creada", "2026-01-22 06:04:49", "2026-01-22 06:04:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18113", "6096", "acción completa vía WP Cron", "2026-01-22 06:04:49", "2026-01-22 06:04:49");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18114", "6097", "acción empezada vía WP Cron", "2026-01-22 07:06:22", "2026-01-22 07:06:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18115", "6098", "acción creada", "2026-01-22 07:06:22", "2026-01-22 07:06:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18116", "6097", "acción completa vía WP Cron", "2026-01-22 07:06:22", "2026-01-22 07:06:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18117", "6098", "acción empezada vía WP Cron", "2026-01-22 08:32:30", "2026-01-22 08:32:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18118", "6099", "acción creada", "2026-01-22 08:32:30", "2026-01-22 08:32:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18119", "6098", "acción completa vía WP Cron", "2026-01-22 08:32:30", "2026-01-22 08:32:30");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18120", "6099", "acción empezada vía WP Cron", "2026-01-22 09:35:24", "2026-01-22 09:35:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18121", "6100", "acción creada", "2026-01-22 09:35:24", "2026-01-22 09:35:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18122", "6099", "acción completa vía WP Cron", "2026-01-22 09:35:24", "2026-01-22 09:35:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18123", "6073", "acción empezada vía WP Cron", "2026-01-22 10:22:45", "2026-01-22 10:22:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18124", "6073", "acción completa vía WP Cron", "2026-01-22 10:22:45", "2026-01-22 10:22:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18126", "6100", "acción empezada vía WP Cron", "2026-01-22 10:48:22", "2026-01-22 10:48:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18127", "6102", "acción creada", "2026-01-22 10:48:22", "2026-01-22 10:48:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18128", "6100", "acción completa vía WP Cron", "2026-01-22 10:48:22", "2026-01-22 10:48:22");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18129", "6102", "acción empezada vía WP Cron", "2026-01-22 11:48:46", "2026-01-22 11:48:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18130", "6103", "acción creada", "2026-01-22 11:48:46", "2026-01-22 11:48:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18131", "6102", "acción completa vía WP Cron", "2026-01-22 11:48:46", "2026-01-22 11:48:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18132", "6069", "acción empezada vía WP Cron", "2026-01-22 12:42:23", "2026-01-22 12:42:23");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18133", "6069", "acción completa vía WP Cron", "2026-01-22 12:42:24", "2026-01-22 12:42:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18134", "6104", "acción creada", "2026-01-22 12:42:24", "2026-01-22 12:42:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18135", "6070", "acción empezada vía WP Cron", "2026-01-22 12:42:24", "2026-01-22 12:42:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18136", "6070", "acción completa vía WP Cron", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18137", "6105", "acción creada", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18138", "6071", "acción empezada vía WP Cron", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18139", "6071", "acción completa vía WP Cron", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18140", "6106", "acción creada", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18141", "6072", "acción empezada vía WP Cron", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18142", "6072", "acción completa vía WP Cron", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18143", "6107", "acción creada", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18144", "6075", "acción empezada vía WP Cron", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18146", "6108", "acción creada", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18147", "6109", "acción creada", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18148", "6075", "acción completa vía WP Cron", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18149", "6110", "acción creada", "2026-01-22 12:42:25", "2026-01-22 12:42:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18150", "6109", "acción empezada vía WP Cron", "2026-01-22 12:45:38", "2026-01-22 12:45:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18151", "6109", "acción completa vía WP Cron", "2026-01-22 12:45:38", "2026-01-22 12:45:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18152", "6103", "acción empezada vía WP Cron", "2026-01-22 12:52:29", "2026-01-22 12:52:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18153", "6111", "acción creada", "2026-01-22 12:52:29", "2026-01-22 12:52:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18154", "6103", "acción completa vía WP Cron", "2026-01-22 12:52:29", "2026-01-22 12:52:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18155", "6091", "acción empezada vía WP Cron", "2026-01-22 13:05:42", "2026-01-22 13:05:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18156", "6091", "acción completa vía WP Cron", "2026-01-22 13:05:42", "2026-01-22 13:05:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18157", "6112", "acción creada", "2026-01-22 13:05:42", "2026-01-22 13:05:42");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18158", "6111", "acción empezada vía WP Cron", "2026-01-22 14:12:05", "2026-01-22 14:12:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18159", "6113", "acción creada", "2026-01-22 14:12:05", "2026-01-22 14:12:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18160", "6111", "acción completa vía WP Cron", "2026-01-22 14:12:05", "2026-01-22 14:12:05");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18161", "6113", "acción empezada vía WP Cron", "2026-01-22 15:13:38", "2026-01-22 15:13:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18162", "6114", "acción creada", "2026-01-22 15:13:38", "2026-01-22 15:13:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18163", "6113", "acción completa vía WP Cron", "2026-01-22 15:13:38", "2026-01-22 15:13:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18164", "6114", "acción empezada vía WP Cron", "2026-01-22 16:23:51", "2026-01-22 16:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18165", "6115", "acción creada", "2026-01-22 16:23:51", "2026-01-22 16:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18166", "6114", "acción completa vía WP Cron", "2026-01-22 16:23:51", "2026-01-22 16:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18167", "6116", "acción creada", "2026-01-22 16:23:51", "2026-01-22 16:23:51");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18168", "6116", "acción empezada vía WP Cron", "2026-01-22 16:34:12", "2026-01-22 16:34:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18169", "6116", "acción completa vía WP Cron", "2026-01-22 16:34:12", "2026-01-22 16:34:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18170", "6115", "acción empezada vía WP Cron", "2026-01-22 17:45:12", "2026-01-22 17:45:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18171", "6117", "acción creada", "2026-01-22 17:45:12", "2026-01-22 17:45:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18172", "6115", "acción completa vía WP Cron", "2026-01-22 17:45:12", "2026-01-22 17:45:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18173", "6117", "acción empezada vía WP Cron", "2026-01-22 19:11:17", "2026-01-22 19:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18174", "6118", "acción creada", "2026-01-22 19:11:17", "2026-01-22 19:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18175", "6117", "acción completa vía WP Cron", "2026-01-22 19:11:17", "2026-01-22 19:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18176", "6084", "acción empezada vía WP Cron", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18177", "6084", "acción completa vía WP Cron", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18178", "6119", "acción creada", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18179", "6085", "acción empezada vía WP Cron", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18180", "6085", "acción completa vía WP Cron", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18181", "6120", "acción creada", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18182", "6118", "acción empezada vía WP Cron", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18183", "6121", "acción creada", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18184", "6118", "acción completa vía WP Cron", "2026-01-22 20:17:08", "2026-01-22 20:17:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18185", "6121", "acción empezada vía WP Cron", "2026-01-22 21:27:06", "2026-01-22 21:27:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18186", "6122", "acción creada", "2026-01-22 21:27:06", "2026-01-22 21:27:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18187", "6121", "acción completa vía WP Cron", "2026-01-22 21:27:06", "2026-01-22 21:27:06");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18188", "6122", "acción empezada vía WP Cron", "2026-01-22 22:43:37", "2026-01-22 22:43:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18189", "6123", "acción creada", "2026-01-22 22:43:37", "2026-01-22 22:43:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18190", "6122", "acción completa vía WP Cron", "2026-01-22 22:43:37", "2026-01-22 22:43:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18191", "6123", "acción empezada vía WP Cron", "2026-01-23 00:19:46", "2026-01-23 00:19:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18192", "6124", "acción creada", "2026-01-23 00:19:46", "2026-01-23 00:19:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18193", "6123", "acción completa vía WP Cron", "2026-01-23 00:19:46", "2026-01-23 00:19:46");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18194", "6112", "acción empezada vía WP Cron", "2026-01-23 01:09:08", "2026-01-23 01:09:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18195", "6112", "acción completa vía WP Cron", "2026-01-23 01:09:08", "2026-01-23 01:09:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18196", "6125", "acción creada", "2026-01-23 01:09:08", "2026-01-23 01:09:08");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18197", "6124", "acción empezada vía WP Cron", "2026-01-23 01:35:24", "2026-01-23 01:35:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18198", "6126", "acción creada", "2026-01-23 01:35:24", "2026-01-23 01:35:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18199", "6124", "acción completa vía WP Cron", "2026-01-23 01:35:24", "2026-01-23 01:35:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18200", "6126", "acción empezada vía WP Cron", "2026-01-23 02:57:24", "2026-01-23 02:57:24");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18201", "6127", "acción creada", "2026-01-23 02:57:25", "2026-01-23 02:57:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18202", "6126", "acción completa vía WP Cron", "2026-01-23 02:57:25", "2026-01-23 02:57:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18203", "6127", "acción empezada vía WP Cron", "2026-01-23 04:00:02", "2026-01-23 04:00:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18204", "6128", "acción creada", "2026-01-23 04:00:02", "2026-01-23 04:00:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18205", "6127", "acción completa vía WP Cron", "2026-01-23 04:00:02", "2026-01-23 04:00:02");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18206", "6129", "acción creada", "2026-01-23 04:16:50", "2026-01-23 04:16:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18207", "6129", "acción empezada vía WP Cron", "2026-01-23 04:17:50", "2026-01-23 04:17:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18208", "6129", "acción completa vía WP Cron", "2026-01-23 04:17:50", "2026-01-23 04:17:50");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18209", "6128", "acción empezada vía WP Cron", "2026-01-23 05:18:45", "2026-01-23 05:18:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18210", "6130", "acción creada", "2026-01-23 05:18:45", "2026-01-23 05:18:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18211", "6128", "acción completa vía WP Cron", "2026-01-23 05:18:45", "2026-01-23 05:18:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18212", "6130", "acción empezada vía WP Cron", "2026-01-23 06:24:39", "2026-01-23 06:24:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18213", "6131", "acción creada", "2026-01-23 06:24:39", "2026-01-23 06:24:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18214", "6130", "acción completa vía WP Cron", "2026-01-23 06:24:39", "2026-01-23 06:24:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18215", "6131", "acción empezada vía WP Cron", "2026-01-23 07:25:27", "2026-01-23 07:25:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18216", "6132", "acción creada", "2026-01-23 07:25:27", "2026-01-23 07:25:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18217", "6131", "acción completa vía WP Cron", "2026-01-23 07:25:27", "2026-01-23 07:25:27");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18218", "6132", "acción empezada vía WP Cron", "2026-01-23 08:34:14", "2026-01-23 08:34:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18219", "6133", "acción creada", "2026-01-23 08:34:14", "2026-01-23 08:34:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18220", "6132", "acción completa vía WP Cron", "2026-01-23 08:34:14", "2026-01-23 08:34:14");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18221", "6133", "acción empezada vía WP Cron", "2026-01-23 09:36:25", "2026-01-23 09:36:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18222", "6134", "acción creada", "2026-01-23 09:36:25", "2026-01-23 09:36:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18223", "6133", "acción completa vía WP Cron", "2026-01-23 09:36:25", "2026-01-23 09:36:25");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18224", "6108", "acción empezada vía WP Cron", "2026-01-23 10:03:07", "2026-01-23 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18225", "6108", "acción completa vía WP Cron", "2026-01-23 10:03:07", "2026-01-23 10:03:07");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18227", "6134", "acción empezada vía WP Cron", "2026-01-23 10:36:35", "2026-01-23 10:36:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18228", "6136", "acción creada", "2026-01-23 10:36:35", "2026-01-23 10:36:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18229", "6134", "acción completa vía WP Cron", "2026-01-23 10:36:35", "2026-01-23 10:36:35");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18230", "6136", "acción empezada vía WP Cron", "2026-01-23 11:47:45", "2026-01-23 11:47:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18231", "6137", "acción creada", "2026-01-23 11:47:45", "2026-01-23 11:47:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18232", "6136", "acción completa vía WP Cron", "2026-01-23 11:47:45", "2026-01-23 11:47:45");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18233", "6104", "acción empezada vía WP Cron", "2026-01-23 12:43:37", "2026-01-23 12:43:37");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18234", "6104", "acción completa vía WP Cron", "2026-01-23 12:43:38", "2026-01-23 12:43:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18235", "6138", "acción creada", "2026-01-23 12:43:38", "2026-01-23 12:43:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18236", "6105", "acción empezada vía WP Cron", "2026-01-23 12:43:38", "2026-01-23 12:43:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18237", "6105", "acción completa vía WP Cron", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18238", "6139", "acción creada", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18239", "6106", "acción empezada vía WP Cron", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18240", "6106", "acción completa vía WP Cron", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18241", "6140", "acción creada", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18242", "6107", "acción empezada vía WP Cron", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18243", "6107", "acción completa vía WP Cron", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18244", "6141", "acción creada", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18245", "6110", "acción empezada vía WP Cron", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18247", "6142", "acción creada", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18248", "6143", "acción creada", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18249", "6110", "acción completa vía WP Cron", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18250", "6144", "acción creada", "2026-01-23 12:43:39", "2026-01-23 12:43:39");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18251", "6143", "acción empezada vía WP Cron", "2026-01-23 12:44:44", "2026-01-23 12:44:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18252", "6143", "acción completa vía WP Cron", "2026-01-23 12:44:44", "2026-01-23 12:44:44");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18253", "6137", "acción empezada vía WP Cron", "2026-01-23 12:49:57", "2026-01-23 12:49:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18254", "6145", "acción creada", "2026-01-23 12:49:57", "2026-01-23 12:49:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18255", "6137", "acción completa vía WP Cron", "2026-01-23 12:49:57", "2026-01-23 12:49:57");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18256", "6125", "acción empezada vía WP Cron", "2026-01-23 13:11:17", "2026-01-23 13:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18257", "6125", "acción completa vía WP Cron", "2026-01-23 13:11:17", "2026-01-23 13:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18258", "6146", "acción creada", "2026-01-23 13:11:17", "2026-01-23 13:11:17");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18259", "6145", "acción empezada vía WP Cron", "2026-01-23 13:50:12", "2026-01-23 13:50:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18260", "6147", "acción creada", "2026-01-23 13:50:12", "2026-01-23 13:50:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18261", "6145", "acción completa vía WP Cron", "2026-01-23 13:50:12", "2026-01-23 13:50:12");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18262", "6148", "acción creada", "2026-01-23 14:18:29", "2026-01-23 14:18:29");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18263", "6149", "acción creada", "2026-01-23 14:18:33", "2026-01-23 14:18:33");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18264", "6150", "acción creada", "2026-01-23 14:18:36", "2026-01-23 14:18:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18265", "6148", "acción empezada vía Async Request", "2026-01-23 14:18:36", "2026-01-23 14:18:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18266", "6148", "acción completa vía Async Request", "2026-01-23 14:18:36", "2026-01-23 14:18:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18267", "6149", "acción empezada vía Async Request", "2026-01-23 14:18:36", "2026-01-23 14:18:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18268", "6149", "acción completa vía Async Request", "2026-01-23 14:18:36", "2026-01-23 14:18:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18269", "6150", "acción empezada vía Async Request", "2026-01-23 14:18:36", "2026-01-23 14:18:36");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18270", "6150", "acción completa vía Async Request", "2026-01-23 14:18:38", "2026-01-23 14:18:38");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18271", "6151", "acción creada", "2026-01-23 14:31:59", "2026-01-23 14:31:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18272", "6152", "acción creada", "2026-01-23 14:31:59", "2026-01-23 14:31:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18273", "6153", "acción creada", "2026-01-23 14:31:59", "2026-01-23 14:31:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18274", "6154", "acción creada", "2026-01-23 14:31:59", "2026-01-23 14:31:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18275", "6155", "acción creada", "2026-01-23 14:31:59", "2026-01-23 14:31:59");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18276", "6156", "acción creada", "2026-01-23 14:32:19", "2026-01-23 14:32:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18277", "6151", "acción empezada vía Async Request", "2026-01-23 14:32:19", "2026-01-23 14:32:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18278", "6151", "acción completa vía Async Request", "2026-01-23 14:32:19", "2026-01-23 14:32:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18279", "6155", "acción empezada vía Async Request", "2026-01-23 14:32:19", "2026-01-23 14:32:19");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18280", "6155", "acción completa vía Async Request", "2026-01-23 14:32:20", "2026-01-23 14:32:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18281", "6152", "acción empezada vía Async Request", "2026-01-23 14:32:20", "2026-01-23 14:32:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18282", "6152", "acción completa vía Async Request", "2026-01-23 14:32:20", "2026-01-23 14:32:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18283", "6154", "acción empezada vía Async Request", "2026-01-23 14:32:20", "2026-01-23 14:32:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18284", "6154", "acción completa vía Async Request", "2026-01-23 14:32:20", "2026-01-23 14:32:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18285", "6153", "acción empezada vía Async Request", "2026-01-23 14:32:20", "2026-01-23 14:32:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18286", "6153", "acción completa vía Async Request", "2026-01-23 14:32:20", "2026-01-23 14:32:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18287", "6156", "acción empezada vía Async Request", "2026-01-23 14:33:20", "2026-01-23 14:33:20");
INSERT INTO `CWP_actionscheduler_logs` VALUES("18288", "6156", "acción completa vía Async Request", "2026-01-23 14:33:20", "2026-01-23 14:33:20");

/* INSERT TABLE DATA: CWP_commentmeta */
INSERT INTO `CWP_commentmeta` VALUES("22", "30", "tutor_rating", "5");
INSERT INTO `CWP_commentmeta` VALUES("23", "30", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("24", "31", "tutor_rating", "5");
INSERT INTO `CWP_commentmeta` VALUES("25", "31", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("26", "32", "tutor_rating", "5");
INSERT INTO `CWP_commentmeta` VALUES("27", "32", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("28", "33", "tutor_rating", "4");
INSERT INTO `CWP_commentmeta` VALUES("29", "33", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("30", "34", "tutor_rating", "5");
INSERT INTO `CWP_commentmeta` VALUES("31", "34", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("32", "35", "tutor_rating", "4");
INSERT INTO `CWP_commentmeta` VALUES("33", "35", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("34", "36", "tutor_rating", "4");
INSERT INTO `CWP_commentmeta` VALUES("35", "36", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("36", "37", "tutor_rating", "5");
INSERT INTO `CWP_commentmeta` VALUES("37", "37", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("38", "38", "tutor_rating", "4");
INSERT INTO `CWP_commentmeta` VALUES("39", "38", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("40", "39", "tutor_rating", "4");
INSERT INTO `CWP_commentmeta` VALUES("41", "39", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("42", "40", "tutor_rating", "5");
INSERT INTO `CWP_commentmeta` VALUES("43", "40", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("44", "41", "tutor_rating", "4");
INSERT INTO `CWP_commentmeta` VALUES("45", "41", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("46", "42", "tutor_rating", "5");
INSERT INTO `CWP_commentmeta` VALUES("47", "42", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("48", "43", "tutor_rating", "3");
INSERT INTO `CWP_commentmeta` VALUES("49", "43", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("50", "44", "tutor_rating", "4");
INSERT INTO `CWP_commentmeta` VALUES("51", "44", "_wxr_import_user", "4");
INSERT INTO `CWP_commentmeta` VALUES("52", "45", "_wxr_import_user", "1");
INSERT INTO `CWP_commentmeta` VALUES("53", "46", "_wxr_import_user", "1");
INSERT INTO `CWP_commentmeta` VALUES("54", "47", "_wxr_import_user", "1");
INSERT INTO `CWP_commentmeta` VALUES("61", "50", "_wxr_import_user", "1");
INSERT INTO `CWP_commentmeta` VALUES("62", "51", "_wxr_import_user", "1");
INSERT INTO `CWP_commentmeta` VALUES("63", "52", "_wxr_import_user", "1");
INSERT INTO `CWP_commentmeta` VALUES("84", "71", "tutor_rating", "5");

/* INSERT TABLE DATA: CWP_comments */
INSERT INTO `CWP_comments` VALUES("30", "4326", "robertfox", "", "", "", "2022-09-05 03:28:50", "2022-09-05 03:28:50", "At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `CWP_comments` VALUES("31", "4337", "robertfox", "", "", "", "2022-09-05 03:28:55", "2022-09-05 03:28:55", "At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `CWP_comments` VALUES("32", "4341", "robertfox", "", "", "", "2022-09-05 03:28:59", "2022-09-05 03:28:59", "At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `CWP_comments` VALUES("33", "4352", "robertfox", "", "", "", "2022-09-05 03:27:56", "2022-09-05 03:27:56", "At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `CWP_comments` VALUES("34", "4362", "robertfox", "", "", "", "2022-09-05 03:17:31", "2022-09-05 03:17:31", "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `CWP_comments` VALUES("35", "4373", "robertfox", "", "", "", "2022-09-05 03:27:41", "2022-09-05 03:27:41", "At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `CWP_comments` VALUES("36", "4377", "robertfox", "", "", "", "2022-09-05 03:26:49", "2022-09-05 03:26:49", "At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint.", "0", "approved", "", "tutor_course_rating", "0", "0");
INSERT INTO `CWP_comments` VALUES("37", "4387", "robertfox", "", "", "", "2022-09-05 03:26:44", "2022-09-05 03:26:44", "At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint.", "0", "approved", "", "tutor_course_rating", "0"